/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.jms.AsyncMessageListener;
import com.ibm.ws.websvcs.transport.jms.JMSConnectionFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;

public class AsyncTransportListener
implements TransportListener {
    private static final TraceComponent _tc = Tr.register(AsyncTransportListener.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static AsyncTransportListener myself = null;
    private static Boolean started = false;
    private static String destination = null;
    private static String connectionFactory = null;
    private static JMSConnectionFactory jmsConFactory = null;

    public AsyncTransportListener() {
        myself = this;
    }

    public static AsyncTransportListener getInstance() {
        return myself;
    }

    public boolean isStarted() {
        return started;
    }

    public void init(ConfigurationContext arg0, TransportInDescription arg1) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncTransportListener.init(ConfigurationContex,TransportInDescription)...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncTransportListener.init(ConfigurationContex,TransportInDescription)");
        }
    }

    private JMSConnectionFactory getConnectionFactory() {
        return jmsConFactory;
    }

    public void start() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncTransportListener.start()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncTransportListener.start()");
        }
    }

    public void stop() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncTransportListener.stop()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncTransportListener.stop()");
        }
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncTransportListener.getEPRsForService()...");
        }
        EndpointReference epr = null;
        epr = this.getEPRForService(serviceName, ip);
        EndpointReference[] eprs = new EndpointReference[]{epr};
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncTransportListener.getEPRsForService() : " + eprs[0].toString());
        }
        return eprs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncTransportListener.getEPRForService()... serviceName : " + serviceName + " ip : " + ip);
        }
        Boolean bl = started;
        synchronized (bl) {
            if (!this.isStarted()) {
                connectionFactory = System.getProperty("com.ibm.websphere.webservices.jms.AsyncReplyCFName");
                if (JavaUtils.hasValue(connectionFactory)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using connection factory as defined in env variable: " + connectionFactory);
                    }
                } else {
                    connectionFactory = "jms/DefaultAsyncReplyCF";
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using default connection factory: " + connectionFactory);
                    }
                }
                if (JavaUtils.hasValue(destination = System.getProperty("com.ibm.websphere.webservices.jms.AsyncReplyQueueName"))) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using destination as defined in env variable: " + destination);
                    }
                } else {
                    destination = "jms/DefaultAsyncReplyQueue";
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using default destination: " + destination);
                    }
                }
                jmsConFactory = new JMSConnectionFactory(connectionFactory, destination);
                try {
                    jmsConFactory.connect();
                }
                catch (Exception e) {
                    Object[] inserts = new Object[]{jmsConFactory.getDestinationName(), JavaUtils.stackToString(e)};
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsAsyncError01", inserts, "The following exception is encountered : {1} during a JNDI 'lookup' operation for connection factory : {0}");
                    Tr.error(_tc, msg);
                    throw AxisFault.makeFault(e);
                }
                final AsyncMessageListener msgListener = new AsyncMessageListener();
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return jmsConFactory.listen(msgListener);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Object[] inserts = new Object[]{e.toString()};
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsAsyncError02", inserts, "The following Exception {0} occured while starting the AsyncTransportListener");
                    Tr.error(_tc, msg);
                    throw AxisFault.makeFault(e.getException());
                }
                started = true;
            }
        }
        EndpointReference epr = null;
        StringBuffer sb = new StringBuffer();
        sb.append("jms:jndi");
        sb.append(':');
        sb.append(jmsConFactory.getJndiDestination());
        sb.append('?');
        sb.append("jndiConnectionFactoryName");
        sb.append("=");
        sb.append(jmsConFactory.getJndiCF());
        sb.append('&');
        sb.append("targetService");
        sb.append("=");
        sb.append(serviceName);
        AsyncEPRSet.addEPRtoSet(sb.toString());
        epr = new EndpointReference(sb.toString());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AsyncTransportListener.getEPRForService()... : " + epr.toString());
        }
        return epr;
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncTransportListener.destroy()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncTransportListener.destroy().");
        }
    }

    public SessionContext getSessionContext(MessageContext mc) {
        return null;
    }
}

