/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.LogFilterInputStream;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.jms.JMSUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.UUIDGenerator;

public class AsyncMessageListener
implements MessageListener {
    private static final TraceComponent _tc = Tr.register(AsyncMessageListener.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AsyncResponseContextMap asrcMap = null;
    private static AsyncMessageListener myself = null;
    private String contentType = null;
    private String soapAction = null;
    private ByteArrayOutputStream responseOstrm = null;
    private static final int VERSION_SOAP11 = 1;

    public AsyncMessageListener() {
        myself = this;
    }

    public static AsyncMessageListener getInstance() {
        return myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message jmsMessage) {
        block38: {
            block37: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "AsyncMessageListener.onMessage()...");
                }
                MessageContext msgContext = null;
                ByteArrayOutputStream ostrm = null;
                boolean specProtocol = false;
                try {
                    try {
                        String version;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Received JMS message to destination : " + jmsMessage.getJMSDestination() + " Message ID : " + jmsMessage.getJMSMessageID() + " Correlation ID : " + jmsMessage.getJMSCorrelationID() + " ReplyTo ID : " + jmsMessage.getJMSReplyTo());
                        }
                        if ((version = jmsMessage.getStringProperty("SOAPJMS_bindingVersion")) != null && version.length() != 0) {
                            if (version.compareTo("1.0") != 0) {
                                Object[] inserts = new Object[]{"1.0"};
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsunrecognizedBindingVersion", inserts, "The version {0} should be 1.0");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            specProtocol = true;
                        }
                        if (specProtocol) {
                            this.extractSPECProperties(jmsMessage);
                        } else {
                            this.extractIBMProperties(jmsMessage);
                        }
                        String string = this.contentType = this.contentType == null ? null : this.contentType.trim();
                        if (jmsMessage instanceof BytesMessage) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Got BytesMessage, contentType=" + this.contentType);
                            }
                            BytesMessage bmsg = (BytesMessage)jmsMessage;
                            ostrm = new ByteArrayOutputStream();
                            byte[] chunk = new byte[4096];
                            int numBytes = 1;
                            while (numBytes > 0) {
                                numBytes = bmsg.readBytes(chunk);
                                if (numBytes <= 0) continue;
                                ostrm.write(chunk, 0, numBytes);
                            }
                            if (MessageTrace.isTraceEnabled() && ostrm != null) {
                                try {
                                    ByteArrayInputStream in = new ByteArrayInputStream(ostrm.toByteArray());
                                    String str = new String("INBOUND_JMS_RESPONSE");
                                    new LogFilterInputStream(in, _tc, 100000, str, this.contentType);
                                }
                                catch (Throwable t) {
                                    Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                                }
                            }
                        } else {
                            if (!(jmsMessage instanceof TextMessage)) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidReplyMsgType", new Object[0], "The reply message has invalid type of message type.");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Got TextMessage, contentType=" + this.contentType);
                            }
                            String strMessage = ((TextMessage)jmsMessage).getText();
                            ostrm = new ByteArrayOutputStream();
                            ostrm.write(strMessage.getBytes());
                            if (MessageTrace.isTraceEnabled() && ostrm != null) {
                                try {
                                    ByteArrayInputStream in = new ByteArrayInputStream(ostrm.toByteArray());
                                    String str = new String("INBOUND_JMS_RESPONSE");
                                    new LogFilterInputStream(in, _tc, 100000, str, this.contentType);
                                }
                                catch (Throwable t) {
                                    Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                                }
                            }
                        }
                        if (ostrm == null) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsInputStreamNull", new Object[0], "The input stream of the reply message is NULL.");
                            throw new AxisFault(msg);
                        }
                        msgContext = this.createMessageContext(jmsMessage, ostrm);
                        if (msgContext == null) {
                            if (_tc.isEntryEnabled()) {
                                Tr.exit(_tc, "...AsyncMessageListener.onMessage()");
                            }
                            Object var12_24 = null;
                            if (!_tc.isEntryEnabled()) return;
                            break block37;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Calling AxisEngine.receive()...");
                        }
                        AxisEngine.receive(msgContext);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Returned from AxisEngine.receive()...");
                        }
                        break block38;
                    }
                    catch (Exception ex) {
                        AxisFault e = AxisFault.makeFault(ex);
                        FFDCFilter.processException((Throwable)e, this.getClass().getName(), "244", this);
                        Object[] inserts = new Object[]{e.toString()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsError03", inserts, "The specified exception occurred while a request was being processed {0} ");
                        Tr.error(_tc, msg);
                        if (e != null) {
                            try {
                                if (msgContext.getEnvelope() == null && JMSUtils.getSoapVersion(msgContext, this.contentType) != 1) {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Setting envelope...");
                                    }
                                    msgContext.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
                                }
                                msgContext.setProperty("TRANSPORT_OUT", ostrm);
                                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, e);
                                AxisService service = msgContext.getAxisService();
                                if (service != null) {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Axis Service set on fault context.");
                                    }
                                    faultContext.setAxisService(service);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Calling AxisEngine.sendFault()...");
                                }
                                AxisEngine.sendFault(faultContext);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Returned from AxisEngine.fault()...");
                                }
                            }
                            catch (Exception ex1) {
                                ex1.printStackTrace();
                            }
                        }
                        Object var12_26 = null;
                        if (!_tc.isEntryEnabled()) return;
                        Tr.exit(_tc, "...AsyncMessageListener.onMessage()");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_27 = null;
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "...AsyncMessageListener.onMessage()");
                    throw throwable;
                }
            }
            Tr.exit(_tc, "...AsyncMessageListener.onMessage()");
            return;
        }
        Object var12_25 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "...AsyncMessageListener.onMessage()");
    }

    private MessageContext createMessageContext(Message message, ByteArrayOutputStream out) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncMessageListener.createMessageContext()...");
        }
        MessageContext respMC = null;
        try {
            String messageID = message.getJMSCorrelationID();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Correlation ID : " + messageID);
            }
            if (messageID != null) {
                AsyncResponseContext rctxt;
                RelatesTo relatesTo = null;
                String id = null;
                AxisOperation operation = null;
                AxisService service = null;
                Object cl = null;
                ConfigurationContext configCtxt = null;
                if (this.asrcMap == null) {
                    this.asrcMap = AsyncResponseContextMap.getInstance();
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Using async response context map: " + this.asrcMap);
                }
                if ((rctxt = this.asrcMap.getContext(messageID)) == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "response is not for this listener...");
                    }
                    return null;
                }
                configCtxt = rctxt.getConfCtxt();
                service = rctxt.getAxisService();
                operation = rctxt.getAxisOperation();
                id = rctxt.getMessageID();
                relatesTo = new RelatesTo(id);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Config Context: " + configCtxt + ", " + "Axis Service: " + service + ", " + "Axis Operation: " + operation + ", " + "RelatesTo: " + relatesTo + ", " + "ClassLoader: " + cl);
                }
                if (configCtxt != null && (cl != null || service != null)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Handling response...");
                    }
                    respMC = new MessageContext();
                    respMC.setConfigurationContext(configCtxt);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Set configContext : " + configCtxt.toString());
                    }
                    respMC.setIncomingTransportName("jms");
                    AxisConfiguration axisConfiguration = configCtxt.getAxisConfiguration();
                    respMC.setTransportIn(axisConfiguration.getTransportIn("jms"));
                    respMC.setTransportOut(axisConfiguration.getTransportOut("jms"));
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "TransportIn and TransportOut are set");
                    }
                    respMC.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "charset encoding : UTF-8");
                    }
                    respMC.setServerSide(true);
                    this.responseOstrm = new ByteArrayOutputStream();
                    respMC.setProperty("TRANSPORT_OUT", this.responseOstrm);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "MessageContext TRANSPORT_OUT is set.");
                    }
                    respMC.setProperty("ContentType", this.contentType);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting contentType : " + this.contentType + " in MessageContext");
                    }
                    this.handleSoapAction(message, respMC, this.soapAction);
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    respMC.setEnvelope(TransportUtils.createSOAPMessage(respMC, in, this.contentType));
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "SOAP envelope is set");
                    }
                    respMC.setProperty("transport.jms.requestMessage", message);
                    if (service != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Axis Service set on message context.");
                        }
                        respMC.setAxisService(service);
                    }
                    if (operation != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Axis operation set on message context.");
                        }
                        respMC.setAxisOperation(operation);
                    }
                    if (relatesTo != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "RetlatesTo set on message context.");
                        }
                        respMC.addRelatesTo(relatesTo);
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "RetlatesTo null.");
                    }
                    respMC.setProperty("OutTransportInfo", message.getJMSReplyTo());
                    respMC.setMessageID(message.getJMSMessageID());
                    respMC.setServiceGroupContextId(UUIDGenerator.getUUID());
                }
                this.asrcMap.removeContext(messageID);
            }
        }
        catch (AxisFault e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName(), "471", this);
            Tr.error(_tc, JavaUtils.stackToString(e));
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, this.getClass().getName(), "475", this);
            Tr.error(_tc, JavaUtils.stackToString(t));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncMessageListener.createMessageContext()");
        }
        return respMC;
    }

    private void extractIBMProperties(Message jmsMessage) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractIBMProperties");
        }
        this.contentType = jmsMessage.getStringProperty("contentType");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve contentType property from JMS message: " + (this.contentType == null ? "<null>" : this.contentType));
        }
        this.soapAction = jmsMessage.getStringProperty("soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve soapAction property from JMS message: " + (this.soapAction == null ? "<null>" : this.soapAction));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractIBMProperties");
        }
    }

    private void extractSPECProperties(Message jmsMessage) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractSPECProperties");
        }
        this.contentType = jmsMessage.getStringProperty("SOAPJMS_contentType");
        if (this.contentType == null || this.contentType.length() == 0) {
            Object[] inserts = new Object[]{"SOAPJMS_contentType"};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsmissingContentType", inserts, "The JMSSender did not set {0} on the JMS request message prior to sending the message to the destination queue or topic");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve SOAPJMS_contentType property from JMS message : " + (this.contentType == null ? "<null>" : this.contentType));
        }
        this.soapAction = jmsMessage.getStringProperty("SOAPJMS_soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve SOAPJMS_soapAction property from JMS message : " + (this.soapAction == null ? "<null>" : this.soapAction));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractSPECProperties");
        }
    }

    private void handleSoapAction(Message jmsMessage, MessageContext msgContext, String soapAction) throws JMSException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve soapAction property from JMS message: " + (soapAction == null ? "<null>" : soapAction));
        }
        if (soapAction == null || soapAction.length() == 0) {
            msgContext.setSoapAction(null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling soapAction on MessageContext...");
            }
        } else {
            if (soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            msgContext.setSoapAction(soapAction);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting soapAction on MessageContext to: " + soapAction);
            }
        }
    }

    public void removeCCFromRspMap(ConfigurationContext cc) {
        this.asrcMap.removeConfigCtxt(cc);
    }

    public SessionContext getSessionContext(MessageContext mc) {
        return null;
    }
}

