/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http.in;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache;
import com.ibm.ws.websvcs.transport.common.InvocationPatternHelper;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;

public class HttpOutResponseInputStream
extends InputStream {
    private static TraceComponent tc = Tr.register(HttpOutResponseInputStream.class, "HttpOutResponseInputStream", "com.ibm.ws.websvcs.transport.http.in");
    private HttpOutboundServiceContext osc;
    private WsByteBuffer curBuffer;
    private HTTPConnection conn;
    private OutboundConnectionCache oCache;
    private boolean isConnReset = false;
    private MessageContext msgContext = null;
    private String contentType = null;

    public HttpOutResponseInputStream(HttpOutboundServiceContext _osc, HTTPConnection _conn, OutboundConnectionCache _oCache, MessageContext _msgContext, String content) {
        this.osc = _osc;
        this.curBuffer = null;
        this.conn = _conn;
        this.oCache = _oCache;
        this.msgContext = _msgContext;
        this.contentType = content;
    }

    public void finish() {
        this.releaseBuffer();
    }

    public int available() throws IOException {
        if (!this.readNext()) {
            return -1;
        }
        return this.curBuffer.remaining();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read()");
        }
        if (!this.readNext()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "read()");
            }
            return -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read()");
        }
        return this.curBuffer.get();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read(byte[], int, int) off : " + off + " len : " + len);
        }
        if (!this.readNext()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "read(byte[], int, int)");
            }
            return -1;
        }
        if (len > this.curBuffer.remaining()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset requested len --> " + len + " to size remaining in current buffer --> " + this.curBuffer.remaining());
            }
            len = this.curBuffer.remaining();
        }
        this.curBuffer.get(b, off, len);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read(byte[], int, int)");
        }
        return len;
    }

    public void releaseBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseCurBuffer()");
        }
        if (this.curBuffer != null) {
            this.curBuffer.release();
            this.curBuffer = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseCurBuffer()");
        }
    }

    private boolean readNext() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readNext() HTTPConnection : " + this.conn);
        }
        if (this.isConnReset || this.conn != null && this.conn.isConnReset()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readNext(). connection already reset. Nothing to read.");
            }
            return false;
        }
        if (this.curBuffer == null || !this.curBuffer.hasRemaining()) {
            this.releaseBuffer();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reading Next Response Body Buffer");
                }
                this.curBuffer = this.osc.getResponseBodyBuffer();
                if (this.curBuffer != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Buffer Value After Reading Response Body=" + new String(WsByteBufferUtils.asByteArray(this.curBuffer)));
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.in.HttpOutResponseInputStream", "92", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to get next body buffer");
                }
                throw e;
            }
        }
        if (this.curBuffer == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Next body buffer was null");
            }
            try {
                if (this.osc.isIncomingMessageFullyRead()) {
                    this.resetConnection();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.in.HttpOutResponseInputStream", "92", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Connection Reset Failed");
                }
                throw new IOException(e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "remaining buffer : null");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remaining buffer : " + this.curBuffer.remaining());
        }
        return true;
    }

    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "HttpOutResponseInputStream.close()");
        }
        super.close();
        try {
            if (!this.isConnReset && this.conn != null && !this.conn.isConnReset()) {
                this.conn.reset();
                this.oCache.findGroupAndReturnConnection(this.conn);
                this.isConnReset = true;
                this.conn = null;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.in.HttpOutResponseInputStream", "249", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Connection Reset Failed");
            }
            throw new IOException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "HttpOutResponseInputStream.close()");
        }
    }

    private void resetConnection() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetConnection() HTTPConnection : " + this.conn);
        }
        try {
            if (this.is200() && !this.isConnReset && this.conn != null && !this.conn.isConnReset()) {
                this.conn.reset();
                this.oCache.findGroupAndReturnConnection(this.conn);
                this.isConnReset = true;
                this.conn = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resetConnection()");
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.in.HttpOutResponseInputStream", "277", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Connection Reset Failed");
            }
            throw new IOException(e);
        }
    }

    private boolean is200() {
        int rcInt = this.httpStatusCode();
        return rcInt == HttpConstants.STATUS_OK.getIntCode();
    }

    private boolean is202() {
        int rcInt = this.httpStatusCode();
        return InvocationPatternHelper.isTwoWayInvocation(this.msgContext) && rcInt == HttpConstants.STATUS_ACCEPTED.getIntCode();
    }

    private int httpStatusCode() {
        Integer rc = (Integer)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        int rcInt = 0;
        if (rc != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "httpStatusInResponse00 " + rc.toString());
            }
            rcInt = rc;
        }
        return rcInt;
    }

    private boolean isOneWay() {
        if (InvocationPatternHelper.isOneWayInvocation(this.msgContext)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isOneWay: true");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isOneWay: false");
        }
        return false;
    }
}

