/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.channel.impl.SSLChannelFactory;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.TransportShutdownPluginMgr;
import com.ibm.ws.websvcs.transport.WASTransportListener;
import com.ibm.ws.websvcs.transport.channel.AsyncInRespChannelFactory;
import com.ibm.ws.websvcs.transport.channel.WSChannelConstants;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.http.server.HttpFactory;

public class WAShttpsAsyncResponseListener
implements WASTransportListener {
    private static final TraceComponent _tc = Tr.register(WAShttpsAsyncResponseListener.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static String chanChainName = null;
    private static String[] CHAIN_ARRAY = new String[]{"WS-tcp-inbound", "WS-ssl-inbound", "WS-http-inbound", "async-inResponse-channel"};
    private int runtimeHash = Runtime.getRuntime().hashCode();
    protected static String COLON = ":";
    protected static AsyncResponseContextMap asyncRCMap = null;
    protected static ChannelFramework cf = null;
    protected static boolean chainStarted = false;
    private static String tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    int port = -1;
    public static int DEFAULT_PORT = 0;
    protected String hostAddress = null;
    protected String contextPath;
    protected ConfigurationContext configContext;
    protected HttpFactory httpFactory;
    private int STOPCHAIN_TIMEOUT;
    private int SLEEP_TIME;

    public static void printUsage() {
        System.out.println("Usage: WAShttpsAsyncResponseListener [options] <repository>");
        System.out.println(" Opts: -? this message");
        System.out.println();
        System.out.println("       -p port to listen on (default is randomly assigned)");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        int port = DEFAULT_PORT;
        try {
            ConfigurationContext configctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            WAShttpsAsyncResponseListener receiver = new WAShttpsAsyncResponseListener(configctx, port);
            receiver.delayStart(null);
            ListenerManager listenerManager = configctx.getListenerManager();
            TransportInDescription trsIn = new TransportInDescription("http");
            trsIn.setReceiver(receiver);
            if (listenerManager == null) {
                listenerManager = new ListenerManager();
                listenerManager.init(configctx);
            }
            listenerManager.addListener(trsIn, true);
            Thread.sleep(3600000L);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.http.client.WAShttpsAsyncResponseListener.main", "204");
            t.printStackTrace();
            System.out.println("[WAShttpsAsyncResponseListener] Shutting down");
        }
    }

    public WAShttpsAsyncResponseListener() {
        final WAShttpsAsyncResponseListener listener = this;
        final TransportShutdownPluginMgr pluginMgr = TransportShutdownPluginMgr.getInstance();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().addShutdownHook(new ShutdownThread(listener, pluginMgr));
                return null;
            }
        });
    }

    public WAShttpsAsyncResponseListener(ConfigurationContext cfgCntxt, int port) throws AxisFault {
        this(new HttpFactory(cfgCntxt, port));
        this.configContext = cfgCntxt;
    }

    public WAShttpsAsyncResponseListener(HttpFactory httpFactory) throws AxisFault {
        this.httpFactory = httpFactory;
        this.configContext = httpFactory.getConfigurationContext();
        this.port = httpFactory.getPort();
        TransportInDescription httpDescription = new TransportInDescription("http");
        httpDescription.setReceiver(this);
        httpFactory.getListenerManager().addListener(httpDescription, true);
        this.contextPath = this.configContext.getServiceContextPath();
        final WAShttpsAsyncResponseListener listener = this;
        final TransportShutdownPluginMgr pluginMgr = TransportShutdownPluginMgr.getInstance();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().addShutdownHook(new ShutdownThread(listener, pluginMgr));
                return null;
            }
        });
    }

    protected void setListeningHost(TransportInDescription in_TD) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.setListeningHost()...");
        }
        try {
            if (in_TD != null) {
                Parameter param = in_TD.getParameter("port");
                param = in_TD.getParameter("hostname");
                this.hostAddress = param != null ? ((String)param.getValue()).trim() : this.httpFactory.getHostAddress();
            }
            if (this.hostAddress == null) {
                this.hostAddress = InetAddress.getLocalHost().getCanonicalHostName();
                if (this.hostAddress == null) {
                    this.hostAddress = "localhost";
                }
            }
        }
        catch (UnknownHostException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.setListeningHost", "300", this);
            if (_tc.isWarningEnabled()) {
                Tr.warning(_tc, JavaUtils.stackToString(ex));
            }
            this.hostAddress = "localhost";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.setListeningHost()");
        }
    }

    protected void setListeningPort(TransportInDescription in_TD) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.setListeningPort()...");
        }
        if (in_TD != null) {
            Parameter param = in_TD.getParameter("port");
            if (param != null) {
                this.port = Integer.parseInt((String)param.getValue());
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Port from TransportIn description: " + this.port);
            }
        }
        if (this.port == -1) {
            this.port = 80;
        }
        if (this.port < 0) {
            Object[] inserts = new Object[]{this.port};
            String msg = NLSProvider.getNLS().getFormattedMessage("invalidPort00", inserts, "The port {0} is not valid.");
            throw new AxisFault(msg);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.setListeningPort()");
        }
    }

    public String chainName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.chainName()...");
        }
        if (chanChainName == null) {
            chanChainName = "WS-tcp-inbound" + COLON + "WS-ssl-inbound" + COLON + "async-inResponse-channel" + COLON + this.runtimeHash;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.chainName()...");
        }
        return chanChainName;
    }

    public synchronized void establishChain(Map chanFrmwkProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.establishChain()...");
        }
        HashMap tcpMap = new HashMap(chanFrmwkProps);
        tcpMap.remove("alias");
        if (cf.getChannel("WS-tcp-inbound") == null) {
            Class<?> tcpChannFactory = null;
            try {
                tcpChannFactory = Class.forName(tcpChannelFactoryName);
            }
            catch (ClassNotFoundException cEx) {
                FFDCFilter.processException((Throwable)cEx, "com.ibm.ws.websvcs.transport.http.client.WAShttpsAsyncResponseListener.establishChain", "405", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "exception01 " + cEx.getLocalizedMessage());
                }
                tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.TCPChannelFactory";
                tcpChannFactory = Class.forName(tcpChannelFactoryName);
            }
            if (tcpChannFactory != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using: " + tcpChannFactory.toString());
                }
                cf.addChannel("WS-tcp-inbound", tcpChannFactory, tcpMap);
            }
            if (this.port > 0) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Adding TCP inbound channel - WS-tcp-inbound at port " + chanFrmwkProps.get("port"));
                }
            } else if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding TCP inbound channel - WS-tcp-inbound");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WS-tcp-inbound channel exists.");
        }
        if (cf.getChannel("WS-ssl-inbound") == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding SSL inbound channel - WS-ssl-inbound");
            }
            cf.addChannel("WS-ssl-inbound", SSLChannelFactory.class, chanFrmwkProps);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WS-ssl-inbound channel exists.");
        }
        if (cf.getChannel("WS-http-inbound") == null) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("MaxKeepAliveRequests", "-1");
            int persistTimeout = WSChannelConstants.DEFAULT_PERSIST_TIMEOUT;
            String timeout = System.getProperty("HttpInboundPersistReadTimeout");
            if (JavaUtils.hasValue(timeout)) {
                persistTimeout = Integer.parseInt(timeout);
            }
            if (persistTimeout < WSChannelConstants.DEFAULT_PERSIST_TIMEOUT) {
                persistTimeout = WSChannelConstants.DEFAULT_PERSIST_TIMEOUT;
            }
            this.STOPCHAIN_TIMEOUT = (persistTimeout + 3) * 1000;
            this.SLEEP_TIME = this.STOPCHAIN_TIMEOUT + 5000;
            String myString = Integer.toString(persistTimeout);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "persist_timeout (secs) : " + myString + " stop chain timeout : " + this.STOPCHAIN_TIMEOUT / 1000 + " sleep time : " + this.SLEEP_TIME / 1000);
            }
            hm.put("persistTimeout", myString);
            Class<?> clazz = Class.forName("com.ibm.ws.http.channel.inbound.impl.HttpInboundChannelFactory");
            if (clazz != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Adding HTTP inbound channel - WS-http-inbound");
                }
                cf.addChannel("WS-http-inbound", clazz, hm);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WS-http-inbound channel exists.");
        }
        if (cf.getChannel("async-inResponse-channel") == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding AsyncInResponseChannel inbound channel - async-inResponse-channel");
            }
            cf.addChannel("async-inResponse-channel", AsyncInRespChannelFactory.class, null);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "async-inResponse-channel channel exists.");
        }
        if (cf.getChain(this.chainName()) == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding Channel Chain - " + this.chainName());
            }
            cf.addChain(this.chainName(), FlowType.INBOUND, CHAIN_ARRAY);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, this.chainName() + " chain exists.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.establishChain()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void init(ConfigurationContext in_CC, TransportInDescription in_TD) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.init()...");
        }
        try {
            block10: {
                try {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Received ConfigurationContext: " + in_CC);
                    }
                    this.configContext = in_CC;
                    this.contextPath = this.configContext.getServiceContextPath();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Context path from ConfigurationContext: " + this.contextPath);
                    }
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Creating HttpFactory.");
                    }
                    this.httpFactory = new HttpFactory(this.configContext, this.port);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "Setting up ChannelFramework service.");
                    }
                    this.setListeningPort(in_TD);
                    this.setListeningHost(in_TD);
                    if (asyncRCMap == null) {
                        asyncRCMap = AsyncResponseContextMap.getInstance();
                    }
                    if (!_tc.isEventEnabled()) break block10;
                    Tr.event(_tc, "Obtained the Async In Response Context Map : " + asyncRCMap);
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.init", "590", this);
                    Tr.error(_tc, "caughtException", ex);
                    throw AxisFault.makeFault(ex);
                }
            }
            Object var5_3 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.init()");
            return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.init()");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delayStart(AxisService service) throws AxisFault {
        block20: {
            block19: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "WAShttpsAsyncResponseListener.delayStart()...");
                }
                try {
                    try {
                        if (chainStarted) {
                            Object var7_2 = null;
                            if (!_tc.isEntryEnabled()) return;
                            break block19;
                        }
                        String listenerPort = String.valueOf(this.port);
                        if (System.getProperty("com.ibm.websphere.webservices.https.listenerPort") != null) {
                            listenerPort = System.getProperty("com.ibm.websphere.webservices.https.listenerPort");
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Using port as defined in system props: " + listenerPort);
                            }
                        }
                        if (PolicySetUtils.getSecureListeningPort(service) != null) {
                            listenerPort = PolicySetUtils.getSecureListeningPort(service);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Using port as defined in policy set: " + listenerPort);
                            }
                        }
                        HashMap<String, String> hm = new HashMap<String, String>();
                        hm.put("port", listenerPort);
                        hm.put("hostname", this.hostAddress);
                        if (service != null) {
                            String configAlias;
                            String sslFile = PolicySetUtils.getInAsyncRspWithSSLFile(service);
                            if (JavaUtils.hasValue(sslFile)) {
                                System.setProperty("com.ibm.SSL.ConfigURL", sslFile);
                            }
                            if (JavaUtils.hasValue(configAlias = PolicySetUtils.getInAsyncRspWithSSLConfigAlias(service))) {
                                hm.put("alias", configAlias);
                            }
                        }
                        if (cf == null) {
                            cf = WSChannelManager.getInstance().getChannelFramework();
                        }
                        this.establishChain(hm);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Completed setting up ChannelFramework service.");
                        }
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Starting channel chain: " + this.chainName());
                        }
                        cf.startChain(this.chainName());
                        String cName = this.chainName();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Started channel chain: " + this.chainName());
                        }
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Associated listening host: " + cf.getListeningHost(cName) + " and port: " + cf.getListeningPort(cName));
                        }
                        chainStarted = true;
                        this.port = cf.getListeningPort(cName);
                        System.out.println("[WAShttpsAsyncResponseListener] listening on port " + this.port);
                        break block20;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.start", "641", this);
                        Tr.error(_tc, "caughtException", e);
                        throw AxisFault.makeFault(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_4 = null;
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "...WAShttpsAsyncResponseListener.delayStart().");
                    throw throwable;
                }
            }
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.delayStart().");
            return;
        }
        Object var7_3 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "...WAShttpsAsyncResponseListener.delayStart().");
    }

    public synchronized void start() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.start()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.start().");
        }
    }

    public synchronized void stop() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.stop()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.stop().");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        AxisService service;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.getEPRForService()...");
        }
        String shortServiceName = serviceName;
        int index = serviceName.indexOf("/");
        if (index > 0) {
            shortServiceName = serviceName.substring(0, index);
        }
        if (PolicySetUtils.getSSLPolicy(service = this.configContext.getAxisConfiguration().getService(shortServiceName)) != null && !PolicySetUtils.isInAsyncRspSSLenabled(service)) {
            throw new AxisFault("In Async SSL response is disabled in policy set.");
        }
        if (!chainStarted) {
            this.delayStart(service);
        }
        String localAddress = null;
        EndpointReference epr = null;
        try {
            try {
                if (ip != null) {
                    localAddress = ip;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "localAddress passed in: " + localAddress);
                    }
                } else {
                    boolean result = false;
                    String transportEPRInIPAddr = System.getProperty("com.ibm.websphere.webservices.transportEPRInIPAddr");
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "com.ibm.websphere.webservices.transportEPRInIPAddr: " + transportEPRInIPAddr);
                    }
                    if (JavaUtils.hasValue(transportEPRInIPAddr) && transportEPRInIPAddr.equalsIgnoreCase("yes")) {
                        result = true;
                    }
                    if (result) {
                        InetAddress localHost = InetAddress.getLocalHost();
                        localAddress = localHost.getHostAddress();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "localAddress from getLocalHost(): " + localAddress);
                        }
                        if (localAddress == null) {
                            localAddress = "127.0.0.1";
                        }
                    } else if (chainStarted) {
                        localAddress = cf.getListeningHost(this.chainName());
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "localAddress from getListeningHost: " + localAddress);
                        }
                    }
                }
                if (localAddress != null) {
                    localAddress = localAddress.toLowerCase();
                    epr = new EndpointReference("https://" + localAddress + ":" + cf.getListeningPort(this.chainName()) + "/" + this.contextPath + "/" + serviceName);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "establishedEPR00", epr.getAddress());
                    }
                } else {
                    Object[] inserts = new Object[]{localAddress};
                    String msg = NLSProvider.getNLS().getFormattedMessage("hostAddrNotEst00", inserts, "The host address {0} has not been established yet. An endpoint reference (EPR) cannot be generated.");
                    throw new AxisFault(msg);
                }
                AsyncEPRSet.addEPRtoSet(epr.getAddress());
            }
            catch (ChainException ex2) {
                FFDCFilter.processException((Throwable)ex2, "com.ibm.ws.websvcs.transport.http.client.WAShttpsAsyncResponseListener.getEPRForService", "878", this);
                Tr.error(_tc, "caughtException", ex2);
                throw AxisFault.makeFault(ex2);
            }
            catch (UnknownHostException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.getEPRForService", "887", this);
                Tr.error(_tc, "caughtException", e);
                throw AxisFault.makeFault(e);
            }
            Object var12_14 = null;
            if (!_tc.isEntryEnabled()) return epr;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.getEPRForService().");
            throw throwable;
        }
        Tr.exit(_tc, "...WAShttpsAsyncResponseListener.getEPRForService().");
        return epr;
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.getEPRsForService()...");
        }
        EndpointReference epr = null;
        epr = this.getEPRForService(serviceName, ip);
        EndpointReference[] eprs = new EndpointReference[]{epr};
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.getEPRsForService().");
        }
        return eprs;
    }

    public synchronized void destroyChannel() throws ChannelException, ChainException, ChainGroupException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WAShttpsAsyncResponseListener.destroyChannel()...");
        }
        if (cf != null && cf.getChain(this.chainName()) != null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Destroying Channel Chain: " + this.chainName());
            }
            cf.stopChain(this.chainName(), this.STOPCHAIN_TIMEOUT);
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException iEx) {
                FFDCFilter.processException((Throwable)iEx, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener. destroyChannel", "952", this);
            }
            cf.destroyChain(this.chainName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.destroyChannel().");
        }
    }

    public void destroy() {
        block4: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WAShttpsAsyncResponseListener.destroy()...");
            }
            try {
                this.destroyChannel();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.client.WAShttpsAsyncResponseListener.destroy", "896", this);
                if (!_tc.isErrorEnabled()) break block4;
                Tr.error(_tc, "caughtException", ex);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WAShttpsAsyncResponseListener.destroy().");
        }
    }

    public SessionContext getSessionContext(MessageContext mc) {
        return null;
    }

    static class ShutdownThread
    extends Thread {
        private WAShttpsAsyncResponseListener listener = null;
        private TransportShutdownPluginMgr pluginMgr = null;

        public ShutdownThread(WAShttpsAsyncResponseListener listen, TransportShutdownPluginMgr pluginMgr) {
            this.listener = listen;
            this.pluginMgr = pluginMgr;
        }

        public void run() {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "WAShttpsAsyncResponseListener.ShutdownThread.run()...");
            }
            this.pluginMgr.drivePreShutdown();
            try {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Shutting down listener: " + this.listener);
                }
                this.listener.destroy();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.client.WAShttpAsyncResponseListener.run", "1014", this);
                Tr.error(_tc, "caughtException", ex);
            }
            this.pluginMgr.drivePostShutdown();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "...WAShttpsAsyncResponseListener.ShutdownThread.run()");
            }
        }
    }
}

