/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.utils.DetachableInputStream;
import com.ibm.wsspi.webcontainer.servlet.IServletRequest;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class WASAxis2HttpServletRequestImpl
implements HttpServletRequest {
    private static final TraceComponent _tc = Tr.register(WASAxis2HttpServletRequestImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String String = null;
    private HttpServletRequest request;
    private DetachableInputStream detachableIS;
    private Enumeration headerNames;
    private HashMap headerMap = new HashMap();
    private HashMap headersMap = new HashMap();
    private static ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal();
    private static String formatStr = "EEE, dd MMM yyyy HH:mm:ss z";
    private static TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public long getDate(String timeStamp) {
        long date;
        block3: {
            date = 0L;
            SimpleDateFormat tmpDateFmt = dateFormat.get();
            if (tmpDateFmt == null) {
                tmpDateFmt = new SimpleDateFormat(formatStr);
                tmpDateFmt.setTimeZone(gmtTimeZone);
                dateFormat.set(tmpDateFmt);
            }
            try {
                date = tmpDateFmt.parse(timeStamp).getTime();
            }
            catch (ParseException ex) {
                if (!_tc.isDebugEnabled()) break block3;
                Tr.debug(_tc, "Received the following ParseException while getting date Format : ");
                Tr.debug(_tc, ex.toString());
            }
        }
        return date;
    }

    WASAxis2HttpServletRequestImpl(HttpServletRequest req) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2HttpServletRequestImpl ctor");
        }
        this.request = req;
        this.headerNames = this.request.getHeaderNames();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "saved headerNames : " + this.headerNames.toString());
        }
        while (this.headerNames.hasMoreElements()) {
            Enumeration values;
            String name = (String)this.headerNames.nextElement();
            String value = this.request.getHeader(name);
            if (value != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "saved header : " + name + " value : " + value);
                }
                this.headerMap.put(name, value);
            }
            if ((values = req.getHeaders(name)) == null) continue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "saved headers : " + name + " value : " + values.toString());
            }
            this.headersMap.put(name, values);
        }
        this.detachableIS = new DetachableInputStream(this.request.getInputStream());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "WASAxis2HttpServletRequestImpl ctor");
        }
    }

    public void detach() throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.entry(_tc, "WASAxis2HttpServletRequestImpl.detach()");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Calling DetachableInputStream.detach()");
        }
        this.detachableIS.detach();
        IServletRequest iReq = (IServletRequest)ServletUtil.unwrapRequest(this.request, IServletRequest.class, true);
        try {
            this.request = (HttpServletRequest)iReq.clone();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting the cloned request");
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        if (_tc.isDebugEnabled()) {
            Tr.exit(_tc, "WASAxis2HttpServletRequestImpl.detach()");
        }
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String arg) {
        long date = this.getDate((String)this.headerMap.get(arg));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getDateHeader : " + arg + " value returned : " + date);
        }
        return date;
    }

    public String getHeader(String arg) {
        String header = (String)this.headerMap.get(arg);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getHeader : " + arg + " value returned : " + header);
        }
        return header;
    }

    public Enumeration getHeaders(String arg) {
        Enumeration headers = (Enumeration)this.headersMap.get(arg);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getHeaders : " + arg + " value returned : " + headers.toString());
        }
        return headers;
    }

    public Enumeration getHeaderNames() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getHeaderNames value returned : " + this.headerNames.toString());
        }
        return this.headerNames;
    }

    public int getIntHeader(String arg) {
        int value = Integer.valueOf((String)this.headerMap.get(arg));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getIntHeader : " + arg + " value returned : " + value);
        }
        return value;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String arg) {
        return this.request.isUserInRole(arg);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean arg) {
        return this.request.getSession(arg);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }

    public Object getAttribute(String arg0) {
        return this.request.getAttribute(arg0);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "WASAxis2HttpServletRequestImpl.getInputStream() called");
        }
        return this.detachableIS;
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public String getParameter(String arg0) {
        return this.request.getParameter(arg0);
    }

    public Map getParameterMap() {
        return this.request.getParameterMap();
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String arg0) {
        return this.request.getParameterValues(arg0);
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public BufferedReader getReader() throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Unexpected call to getReader()!");
        }
        return this.request.getReader();
    }

    public String getRealPath(String arg0) {
        return this.request.getRealPath(arg0);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.request.getRequestDispatcher(arg0);
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public void removeAttribute(String arg0) {
        this.request.removeAttribute(arg0);
    }

    public void setAttribute(String arg0, Object arg1) {
        this.request.setAttribute(arg0, arg1);
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(arg0);
    }
}

