/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.PluginUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.UnknownEPRResolverPlugin;
import java.util.ArrayList;
import java.util.List;

public class UnknownEPRResolverPluginMgr {
    private static final TraceComponent _tc = Tr.register(UnknownEPRResolverPluginMgr.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private List<UnknownEPRResolverPlugin> implementationList = new ArrayList<UnknownEPRResolverPlugin>();

    public void discoverUnknownEPRResolverPlugins() {
        if (Axis2Utils.isThinClientEnv()) {
            PluginUtils.discoverExtensions(UnknownEPRResolverPlugin.class.getName(), "com.ibm.wsfp.thinclient.ibmaxis2-unknown-epr-resolver-plugin", this.implementationList);
        } else {
            PluginUtils.discoverExtensions(UnknownEPRResolverPlugin.class.getName(), "com.ibm.wsfp.main.ibmaxis2-unknown-epr-resolver-plugin", this.implementationList);
        }
    }

    public boolean isMsgForUnknownEndpointProcessable(String unknownEndpoint) {
        boolean isProcessable = true;
        for (UnknownEPRResolverPlugin plugin : this.implementationList) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Calling UnknownEPRResolverPlugin: " + plugin);
            }
            try {
                isProcessable &= plugin.isMsgForUnknownEndpointProcessable(unknownEndpoint);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.UnknownEPRResolverPluginMgr.isMsgForUnknownEndpointProcessable", "72", this);
                Object[] inserts = new Object[]{plugin.getClass().getName(), e};
                Tr.error(_tc, "runUnkwnEPRResolverFail00", inserts);
            }
        }
        return isProcessable;
    }
}

