/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.Config;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.security.ConfigSSL;
import com.ibm.ws.websvcs.transport.security.ConfigSSLProvider;
import com.ibm.ws.websvcs.transport.security.WSConfigSSLChangeListener;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class SetupSSLConfiguration {
    private static final TraceComponent _tc = Tr.register(SetupSSLConfiguration.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private MessageContext localmsgContext;

    public SetupSSLConfiguration(MessageContext msgContext) {
        this.localmsgContext = msgContext;
    }

    public void setupEffectiveSSLConfiguration(final WSAddress connaddr, final DefaultHTTPSTransportClientProperties tcp) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setupEffectiveSSLConfiguration");
        }
        Config cfg = null;
        try {
            cfg = (Config)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AxisFault {
                    return ConfigSSLProvider.getInstance(tcp).getConfig(SetupSSLConfiguration.this.localmsgContext, connaddr, tcp);
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", "%C", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(e));
            }
            throw (AxisFault)e.getException();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Effective SSL configuration: " + (cfg == null ? null : cfg.toString()));
        }
        if (cfg == null) {
            Object[] inserts = new Object[]{connaddr.toString()};
            String msg = NLSProvider.getNLS().getFormattedMessage("sslConfigResolveFailed01", inserts, "No Secure Sockets Layer (SSL) configuration is available for the {0} endpoint.");
            throw new AxisFault(msg);
        }
        connaddr.setTransportConfiguration(cfg);
        cfg.addTargetAddress(connaddr);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setupEffectiveSSLConfiguration");
        }
    }

    public void restoreSSLConfiguration(WSAddress addrToConnect) throws AxisFault, PrivilegedActionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "restoreSSLConfiguration");
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AxisFault, PrivilegedActionException {
                    JSSEHelper jhlpr = JSSEHelper.getInstance();
                    Properties obj = jhlpr.getSSLPropertiesOnThread();
                    ConfigSSL cfg = null;
                    if (obj instanceof ConfigSSL) {
                        cfg = (ConfigSSL)obj;
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "JSSEHelper returned: " + obj);
                    }
                    if (cfg != null) {
                        Properties p;
                        WSConfigSSLChangeListener sslListener = cfg.getlistener();
                        if (sslListener != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "De-registering WSConfigSSLChangeListener: " + sslListener);
                            }
                            sslListener.deRegister();
                        }
                        if ((p = cfg.getPreCfg()) != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Restoring previously saved SSL configuration: " + p);
                            }
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "No previously saved SSL configuration to be restored.");
                        }
                        jhlpr.setSSLPropertiesOnThread(p);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.engine.transport.http.setupSSL.restoreSSLConfiguration", "1059", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(e));
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "restoreSSLConfiguration");
        }
    }
}

