/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.transport.http.HTTPCookieManager;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.LogFilterInputStream;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.AsyncResponseConnectionMap;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.TransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.channel.WSOutboundCFCallbackImpl;
import com.ibm.ws.websvcs.transport.channel.WSOutboundConnection;
import com.ibm.ws.websvcs.transport.common.Base64;
import com.ibm.ws.websvcs.transport.common.InvocationPatternHelper;
import com.ibm.ws.websvcs.transport.http.CookieMap;
import com.ibm.ws.websvcs.transport.http.HTTPClientUtils;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.ws.websvcs.transport.http.HttpAsyncResponseConnection;
import com.ibm.ws.websvcs.transport.http.HttpAsyncResponseContext;
import com.ibm.ws.websvcs.transport.http.HttpChannelAddress;
import com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig;
import com.ibm.ws.websvcs.transport.http.OutboundURLTargetResolver;
import com.ibm.ws.websvcs.transport.http.SetupSSLConfiguration;
import com.ibm.ws.websvcs.transport.http.WSHTTPConstants;
import com.ibm.ws.websvcs.transport.http.in.HttpOutResponseInputStream;
import com.ibm.ws.websvcs.transport.http.out.ByteBufferOutputStreamFactory;
import com.ibm.ws.websvcs.transport.http.out.HttpOutByteBufferOutputStream;
import com.ibm.ws.websvcs.transport.http.out.HttpOutWriter;
import com.ibm.ws.websvcs.transport.security.SecurityDataPrompt;
import com.ibm.ws.websvcs.transport.security.SecurityDataPromptFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;

public class SOAPOverHTTPSender
implements WSOutboundConnection {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc = Tr.register(SOAPOverHTTPSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected String chainname = null;
    protected OutboundVirtualConnection oConn = null;
    protected HttpOutboundServiceContext httpOutSC = null;
    private WSAddress addrToConnect = null;
    private HttpResponseMessage httpRspMsg = null;
    private HTTPConnection connection = null;
    private OutboundConnectionCache oCache = null;
    private SetupSSLConfiguration setSSLConfig = null;
    private MessageContext msgContext = null;
    private TransportClientProperties tcp = null;
    private WSChannelManager wMgr = null;
    private HttpEffectiveConfig hConfig = null;
    private WsByteBuffer[] wbufArrayAsync = null;
    protected OMOutputFormat format = null;
    private String soapActionString = null;
    private boolean is302or401 = false;
    private boolean maintainSession = false;
    private static boolean RESTOREOLD202BEHAVIOR = false;
    private String keyFromWASSERVLET = null;
    private String resetConnection = null;
    private String headerClose = null;
    private StringBuffer hashKeyCode = null;

    public String saveContextToMap(MessageContext mc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverHTTPSender.saveContextToMap()...");
        }
        String hashKey = null;
        EndpointReference epr = mc.getReplyTo();
        if (epr == null) {
            epr = mc.getFaultTo();
        }
        if (epr != null) {
            hashKey = epr.getAddress();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Extracted EPR address: " + hashKey);
            }
            if (hashKey != null) {
                AxisService as = mc.getAxisService();
                ConfigurationContext cc = mc.getConfigurationContext();
                AsyncResponseContextMap aRCMap = AsyncResponseContextMap.getInstance();
                AsyncResponseContext aRC = aRCMap.getContext(hashKey);
                if (aRC == null) {
                    aRC = new HttpAsyncResponseContext(as, cc, hashKey);
                    aRCMap.putContext(hashKey, aRC);
                    if (_tc.isEventEnabled()) {
                        Tr.debug(_tc, "Creating and adding async response context " + aRC + " to cache with key: " + hashKey);
                    }
                } else if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Already cached async response context " + aRC + " with key: " + hashKey);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SOAPOverHTTPSender.saveContextToMap()");
        }
        return hashKey;
    }

    public void saveConnectionToMap(MessageContext mc, String key) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverHTTPSender.saveConnectionToMap()...");
        }
        AsyncResponseConnectionMap aRConnMap = AsyncResponseConnectionMap.getInstance();
        HttpAsyncResponseConnection aRConn = new HttpAsyncResponseConnection(this.connection, key);
        aRConnMap.putConnection(key, aRConn);
        if (_tc.isEventEnabled()) {
            Tr.debug(_tc, "Creating and adding async response connection " + aRConn + " to cache with key: " + key);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SOAPOverHTTPSender.saveConnectionToMap()");
        }
    }

    public boolean isMessageSent() {
        boolean retvalue = false;
        if (this.httpOutSC != null) {
            retvalue = this.httpOutSC.isMessageSent();
        }
        return retvalue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(MessageContext msgContext) throws Exception {
        block63: {
            int rcInt;
            block65: {
                block66: {
                    block64: {
                        rcInt = 0;
                        Integer rc = null;
                        boolean async = false;
                        if (_tc.isEntryEnabled()) {
                            Tr.entry(_tc, "send(): " + this);
                        }
                        try {
                            try {
                                Object TransportNonBlocking;
                                int schemaType = ((HttpChannelAddress)this.addrToConnect).getSchema();
                                if (schemaType == 2) {
                                    boolean alreadyClient;
                                    SSLConnectionContext sslConnCntxt = this.httpOutSC.getSSLContext();
                                    if (sslConnCntxt == null) throw new AxisFault("No SSLConnectionContext from HTTP outbound service context.");
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "sslConnCntxt " + sslConnCntxt.toString());
                                    }
                                    if (!(alreadyClient = sslConnCntxt.getUseClientMode())) {
                                        sslConnCntxt.setUseClientMode(true);
                                    }
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Client mode for ssl connection context: " + sslConnCntxt.getUseClientMode());
                                    }
                                }
                                if ((TransportNonBlocking = msgContext.getProperty("transportNonBlocking")) != null && ((Boolean)TransportNonBlocking).booleanValue()) {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "ASYNC CALL ");
                                    }
                                    async = true;
                                    msgContext.setProperty("com.ibm.ws.websvcs.transport.http.asyncRequestConnection", this.connection);
                                    this.sendSOAPRequestAsync(msgContext);
                                } else {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "SYNC CALL ");
                                    }
                                    boolean notcompleted = true;
                                    while (notcompleted) {
                                        this.sendSOAPRequest();
                                        this.receiveSOAPResponse();
                                        notcompleted = this.is302or401set(msgContext);
                                    }
                                    rc = (Integer)msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                                    if (rc != null) {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "httpStatusInResponse00 " + rc.toString());
                                        }
                                        rcInt = rc;
                                    }
                                    if (rcInt == 0) {
                                        String msg = NLSProvider.getNLS().getFormattedMessage("httpStatusInResponse01", new Object[0], "No HTTP status has been received for the current HTTP response.");
                                        this.connection.disconnect(new AxisFault(msg));
                                        throw new AxisFault(msg);
                                    }
                                    String contentType = null;
                                    if (this.httpRspMsg != null) {
                                        contentType = this.httpRspMsg.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE);
                                    }
                                    this.processStatusCode(rcInt, contentType);
                                }
                                Object var10_11 = null;
                            }
                            catch (Exception ex) {
                                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.send", "409", this);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
                                }
                                if (this.connection == null) throw ex;
                                if (!this.connection.isConnReset()) {
                                    this.connection.disconnect(ex);
                                    this.oCache.findGroupAndReturnConnection(this.connection);
                                }
                                this.connection = null;
                                throw ex;
                            }
                        }
                        catch (Throwable throwable) {
                            block62: {
                                Object var10_12 = null;
                                try {
                                    if (async) break block62;
                                    if (this.setSSLConfig != null) {
                                        this.setSSLConfig.restoreSSLConfiguration(this.addrToConnect);
                                        this.setSSLConfig = null;
                                    }
                                    if (this.connection == null || this.connection.isConnReset()) break block62;
                                    boolean oneWay = InvocationPatternHelper.isOneWayInvocation(msgContext);
                                    boolean twoWay = InvocationPatternHelper.isTwoWayInvocation(msgContext);
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "http rc : " + rcInt + " Two way : " + twoWay + " One way : " + oneWay);
                                    }
                                    if (oneWay && rcInt != HttpConstants.STATUS_OK.getIntCode()) {
                                        if (this.resetConnection != null) {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "One way. Connection Reset invoked");
                                            }
                                            this.connection.reset();
                                            this.oCache.findGroupAndReturnConnection(this.connection);
                                            this.connection = null;
                                            break block62;
                                        } else {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "One way. Connection Disconnect invoked");
                                            }
                                            this.connection.disconnect(null);
                                            this.oCache.findGroupAndReturnConnection(this.connection);
                                            this.connection = null;
                                        }
                                        break block62;
                                    }
                                    if (rcInt == HttpConstants.STATUS_ACCEPTED.getIntCode()) {
                                        if (RESTOREOLD202BEHAVIOR) {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "202 received. Connection Disconnect invoked");
                                            }
                                            this.connection.disconnect(null);
                                            this.oCache.findGroupAndReturnConnection(this.connection);
                                            this.connection = null;
                                            break block62;
                                        }
                                        if (this.resetConnection != null) {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "202 received. Connection Reset invoked");
                                            }
                                            this.connection.reset();
                                            this.oCache.findGroupAndReturnConnection(this.connection);
                                            this.connection = null;
                                            break block62;
                                        }
                                        if (this.keyFromWASSERVLET != null) {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Two way and 202 received. Saving Connection to be reset by Async Servlet");
                                            }
                                            this.saveConnectionToMap(msgContext, this.keyFromWASSERVLET);
                                            break block62;
                                        } else {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "202 received. Response side disconnecting the connection");
                                            }
                                            this.connection.disconnect(null);
                                            this.oCache.findGroupAndReturnConnection(this.connection);
                                            this.connection = null;
                                        }
                                        break block62;
                                    }
                                    if (rcInt > HttpConstants.STATUS_ACCEPTED.getIntCode() && rcInt < HttpConstants.STATUS_MULT_CHOICE.getIntCode()) {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, rcInt + " received. Connection Reset invoked");
                                        }
                                        this.connection.reset();
                                        this.oCache.findGroupAndReturnConnection(this.connection);
                                        this.connection = null;
                                        break block62;
                                    }
                                    if (!this.hConfig.chunkedEncodingEnabled(msgContext)) {
                                        this.connection.reset();
                                        this.oCache.findGroupAndReturnConnection(this.connection);
                                        this.connection = null;
                                    }
                                }
                                catch (Exception ex) {
                                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.send", "451", this);
                                    if (!_tc.isDebugEnabled()) throw ex;
                                    Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
                                    throw ex;
                                }
                            }
                            if (!_tc.isEntryEnabled()) throw throwable;
                            Tr.exit(_tc, "send()");
                            throw throwable;
                        }
                        try {}
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.send", "451", this);
                            if (!_tc.isDebugEnabled()) throw ex;
                            Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
                            throw ex;
                        }
                        if (async) break block63;
                        if (this.setSSLConfig != null) {
                            this.setSSLConfig.restoreSSLConfiguration(this.addrToConnect);
                            this.setSSLConfig = null;
                        }
                        if (this.connection == null || this.connection.isConnReset()) break block63;
                        boolean oneWay = InvocationPatternHelper.isOneWayInvocation(msgContext);
                        boolean twoWay = InvocationPatternHelper.isTwoWayInvocation(msgContext);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "http rc : " + rcInt + " Two way : " + twoWay + " One way : " + oneWay);
                        }
                        if (!oneWay || rcInt == HttpConstants.STATUS_OK.getIntCode()) break block64;
                        if (this.resetConnection != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "One way. Connection Reset invoked");
                            }
                            this.connection.reset();
                            this.oCache.findGroupAndReturnConnection(this.connection);
                            this.connection = null;
                            break block63;
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "One way. Connection Disconnect invoked");
                            }
                            this.connection.disconnect(null);
                            this.oCache.findGroupAndReturnConnection(this.connection);
                            this.connection = null;
                        }
                        break block63;
                    }
                    if (rcInt != HttpConstants.STATUS_ACCEPTED.getIntCode()) break block65;
                    if (!RESTOREOLD202BEHAVIOR) break block66;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "202 received. Connection Disconnect invoked");
                    }
                    this.connection.disconnect(null);
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                    break block63;
                }
                if (this.resetConnection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "202 received. Connection Reset invoked");
                    }
                    this.connection.reset();
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                    break block63;
                } else if (this.keyFromWASSERVLET != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Two way and 202 received. Saving Connection to be reset by Async Servlet");
                    }
                    this.saveConnectionToMap(msgContext, this.keyFromWASSERVLET);
                    break block63;
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "202 received. Response side disconnecting the connection");
                    }
                    this.connection.disconnect(null);
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                }
                break block63;
            }
            if (rcInt > HttpConstants.STATUS_ACCEPTED.getIntCode() && rcInt < HttpConstants.STATUS_MULT_CHOICE.getIntCode()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, rcInt + " received. Connection Reset invoked");
                }
                this.connection.reset();
                this.oCache.findGroupAndReturnConnection(this.connection);
                this.connection = null;
            } else if (!this.hConfig.chunkedEncodingEnabled(msgContext)) {
                this.connection.reset();
                this.oCache.findGroupAndReturnConnection(this.connection);
                this.connection = null;
            }
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "send()");
    }

    public void sendSOAPRequest() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendSOAPRequest(): " + this);
        }
        if (this.hConfig.chunkedEncodingEnabled(this.msgContext)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Chunking Request");
            }
            HttpOutByteBufferOutputStream outputStream = ByteBufferOutputStreamFactory.getHttpByteBufferOutputStream(this.httpOutSC, this.connection.getConnection(), false);
            this.sendChunkedRequest(outputStream);
            HttpOutWriter outWriter = outputStream.getOutWriter();
            Exception writeException = outWriter.getCloseException();
            if (writeException != null) {
                throw writeException;
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Buffered Request");
            }
            this.sendBufferedRequest();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendSOAPRequest()");
        }
    }

    public WSOutboundCFCallbackImpl sendSOAPRequestAsync(MessageContext mc) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendSOAPRequestAsync(): " + this);
        }
        if (this.hConfig.chunkedEncodingEnabled(this.msgContext)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Chunking Request");
            }
            WSOutboundCFCallbackImpl cback = new WSOutboundCFCallbackImpl(this, this.addrToConnect);
            HttpOutByteBufferOutputStream outputStream = ByteBufferOutputStreamFactory.getHttpByteBufferOutputStream(this.httpOutSC, cback, this.connection.getConnection());
            this.sendChunkedRequest(outputStream);
            HttpOutWriter outWriter = outputStream.getOutWriter();
            Exception writeException = outWriter.getCloseException();
            if (writeException != null) {
                throw writeException;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "sendSOAPRequestAsync()");
            }
            return cback;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Buffered Request");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendSOAPRequestAsync()");
        }
        return this.sendBufferedRequestAsync(mc);
    }

    private void sendChunkedRequest(HttpOutByteBufferOutputStream outputStream) throws Exception {
        if (outputStream == null) {
            String msg = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Unable to send Chunked Request, HttpOutByteBufferStream is null.");
            throw new AxisFault(msg);
        }
        try {
            try {
                this.prepareHttpRequestHeaders(this.msgContext);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "sendChunkedRequest() writing Headers to outputStream");
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "sendChunkedRequest() done Writing Headers to outputStream");
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "sendChunkedRequest() writing body to outputStream");
                }
                this.writeMessage(outputStream);
                outputStream.flush();
                outputStream.finish();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "sendChunkedRequest() done writing body to outputStream");
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Set Connection Used.");
                }
                this.connection.setUsedAlready();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.sendChunkedRequest", "552", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
                }
                throw ex;
            }
            Object var4_4 = null;
            this.connection.setLastAccessTime();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.connection.setLastAccessTime();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendBufferedRequest() throws Exception {
        block17: {
            WsByteBuffer[] wbufArray;
            block18: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "sendBufferedRequest(): " + this);
                }
                wbufArray = null;
                try {
                    try {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Preparing HTTP Request Headers");
                        }
                        String contentType = this.prepareHttpRequestHeaders(this.msgContext);
                        wbufArray = this.readBuffer(this.msgContext, contentType);
                        if (this.httpOutSC.getRequest().isExpect100Continue()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "httpExpect100SC " + String.valueOf(this.addrToConnect));
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Sending Request Headers");
                            }
                            this.httpOutSC.sendRequestHeaders();
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "wsbytebufferarray : " + wbufArray.toString());
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Sending and Finalizing Request");
                        }
                        this.httpOutSC.finishRequestMessage(wbufArray);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Message sent");
                        }
                        this.connection.setUsedAlready();
                        if (_tc.isEntryEnabled()) {
                            Tr.exit(_tc, "sendBufferedRequest(): " + this);
                        }
                        Object var4_4 = null;
                        this.connection.setLastAccessTime();
                        if (wbufArray == null) break block17;
                        if (!_tc.isDebugEnabled()) break block18;
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.sendBufferedRequest", "512", this);
                        if (!_tc.isDebugEnabled()) throw ex;
                        Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.connection.setLastAccessTime();
                    if (wbufArray != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "releasing wsbytebufferarray");
                        }
                        for (int i = 0; i < wbufArray.length; ++i) {
                            if (wbufArray[i] == null) continue;
                            wbufArray[i].release();
                            wbufArray[i] = null;
                        }
                    }
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "sendSOAPRequest(): " + this);
                    throw throwable;
                }
                Tr.debug(_tc, "releasing wsbytebufferarray");
            }
            for (int i = 0; i < wbufArray.length; ++i) {
                if (wbufArray[i] == null) continue;
                wbufArray[i].release();
                wbufArray[i] = null;
            }
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "sendSOAPRequest(): " + this);
    }

    private WSOutboundCFCallbackImpl sendBufferedRequestAsync(MessageContext mc) throws Exception {
        WSOutboundCFCallbackImpl wSOutboundCFCallbackImpl;
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "sendBufferedRequestAsync(): " + this);
            }
            try {
                String contentType = this.prepareHttpRequestHeaders(this.msgContext);
                this.wbufArrayAsync = this.readBuffer(mc, contentType);
                HttpRequestMessage httpReqMsg = this.httpOutSC.getRequest();
                WSOutboundCFCallbackImpl cback = new WSOutboundCFCallbackImpl(this, this.addrToConnect);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created " + cback + " with " + this.oConn);
                }
                this.httpOutSC.finishRequestMessage(this.wbufArrayAsync, cback, true);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Message sent");
                }
                this.connection.setUsedAlready();
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "sendSOAPRequestAsync(): " + this);
                }
                wSOutboundCFCallbackImpl = cback;
                Object var7_7 = null;
                this.connection.setLastAccessTime();
                if (!_tc.isEntryEnabled()) break block9;
            }
            catch (Exception ex) {
                try {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.sendSOAPRequestAsync", "576", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "exception01" + JavaUtils.stackToString(ex));
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    block10: {
                        Object var7_8 = null;
                        this.connection.setLastAccessTime();
                        if (!_tc.isEntryEnabled()) break block10;
                        Tr.exit(_tc, "sendSOAPRequestAsync(): " + this);
                    }
                    throw throwable;
                }
            }
            Tr.exit(_tc, "sendSOAPRequestAsync(): " + this);
        }
        return wSOutboundCFCallbackImpl;
    }

    private WsByteBuffer[] readBuffer(MessageContext mc, String contentType) throws AxisFault, UnsupportedMethodException, UnsupportedProtocolVersionException, MalformedURLException, XMLStreamException, IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "readBuffer(): " + this);
        }
        BAOS baos = new BAOS();
        this.writeMessage(baos);
        baos.flush();
        byte[] byteArray = baos.getBytes();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "readBuffer(): ");
        }
        return this.getRequestBuffer(this.msgContext, byteArray, baos.getByteCount());
    }

    public void releaseBuffer() {
        if (this.wbufArrayAsync != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "releasing wsbytebufferarray");
            }
            for (int i = 0; i < this.wbufArrayAsync.length; ++i) {
                if (this.wbufArrayAsync[i] == null) continue;
                this.wbufArrayAsync[i].release();
                this.wbufArrayAsync[i] = null;
            }
        }
    }

    public void receiveSOAPResponse() throws Exception {
        try {
            block71: {
                try {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "receiveSOAPResponse(): " + this);
                    }
                    this.httpRspMsg = this.httpOutSC.getResponse();
                    if (this.httpRspMsg.isIncoming()) {
                        StatusCodes stcodes;
                        AxisOperation axisOperation;
                        String MEP2;
                        String hdrValue = null;
                        byte[] hdrBytes = null;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "receiveSOAPResponse message incoming");
                        }
                        if (this.msgContext.getAxisOperation() != null && (MEP2 = (axisOperation = this.msgContext.getAxisOperation()).getMessageExchangePattern()) != null && _tc.isDebugEnabled()) {
                            Tr.debug(_tc, "MEP : " + MEP2);
                        }
                        String DEF_ENCODE = "iso-8859-1";
                        hdrBytes = this.httpRspMsg.getHeaderAsByteArray("SAVECONNECTION");
                        if (hdrBytes != null && (hdrValue = new String(hdrBytes, DEF_ENCODE)) != null) {
                            this.keyFromWASSERVLET = hdrValue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Received the key SAVECONNECTION from AxisServlet : " + this.keyFromWASSERVLET);
                            }
                        }
                        if ((hdrBytes = this.httpRspMsg.getHeaderAsByteArray("IBM-WAS-Reset-Connection")) != null && (hdrValue = new String(hdrBytes, DEF_ENCODE)) != null) {
                            this.resetConnection = hdrValue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Received the key IBM-WAS-Reset-Connection from AxisServlet : " + this.resetConnection);
                            }
                        }
                        if ((hdrBytes = this.httpRspMsg.getHeaderAsByteArray("Connection")) != null && (hdrValue = new String(hdrBytes, DEF_ENCODE)) != null) {
                            this.headerClose = hdrValue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Received the key Connection from AxisServlet : " + this.headerClose);
                            }
                        }
                        if ((hdrBytes = this.httpRspMsg.getReasonPhraseBytes()) != null) {
                            hdrValue = new String(hdrBytes, DEF_ENCODE);
                            this.msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, hdrValue);
                        }
                        if ((stcodes = this.httpRspMsg.getStatusCode()) != null) {
                            this.msgContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(stcodes.getIntCode()));
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "receiveSOAPResponse HTTPmesssage status code : " + stcodes.toString());
                            }
                            if (stcodes.equals(HttpConstants.STATUS_FOUND)) {
                                if (this.isHttpRedirectEnabled(this.msgContext) && (hdrBytes = this.httpRspMsg.getHeaderAsByteArray(HttpConstants.HDR_LOCATION)) != null && JavaUtils.hasValue(hdrValue = new String(hdrBytes, DEF_ENCODE))) {
                                    String targetURL = this.addrToConnect.toString();
                                    if (!JavaUtils.hasValue(targetURL)) {
                                        EndpointReference epr = this.msgContext.getTo();
                                        targetURL = epr.getAddress();
                                    }
                                    if (!hdrValue.equals(targetURL)) {
                                        this.msgContext.setProperty(WSHTTPConstants.TRANS_URL_HTTP_REDIRECTED, hdrValue);
                                    }
                                }
                            } else if (stcodes.equals(HttpConstants.STATUS_UNAUTHORIZED) && (hdrBytes = this.httpRspMsg.getHeaderAsByteArray(HttpConstants.HDR_WWW_AUTHENTICATE)) != null) {
                                StringBuffer tmpbuf = new StringBuffer(new String(hdrBytes, DEF_ENCODE));
                                int begin = tmpbuf.indexOf("\"") + 1;
                                int end = tmpbuf.lastIndexOf("\"");
                                if (end < 0) {
                                    end = tmpbuf.length();
                                }
                                hdrValue = tmpbuf.substring(begin, end);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "WWW-Authenticate Value : " + hdrValue);
                                }
                                this.msgContext.setProperty("WWW-Authenticate", hdrValue);
                            }
                        }
                        this.processResponseHeader();
                        if (this.hConfig.chunkedEncodingEnabled(this.msgContext)) {
                            InputStream is;
                            String contentType = this.httpRspMsg.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Creating HttpOutboundServiceContext backed InputStream");
                            }
                            if (((InputStream)(is = new HttpOutResponseInputStream(this.httpOutSC, this.connection, this.oCache, this.msgContext, contentType))).available() > 0) {
                                if (MessageTrace.isTraceEnabled()) {
                                    try {
                                        String str = new String("INBOUND_HTTP_RESPONSE");
                                        is = new LogFilterInputStream(is, _tc, 100000, str, contentType);
                                    }
                                    catch (Throwable t) {
                                        Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                                    }
                                }
                                if (this.msgContext.getOperationContext() != null) {
                                    this.msgContext.getOperationContext().setProperty("TRANSPORT_IN", is);
                                }
                            } else if (!InvocationPatternHelper.isOneWayInvocation(this.msgContext) && _tc.isDebugEnabled()) {
                                Tr.debug(_tc, "This is not oneway : " + String.valueOf(this.addrToConnect));
                            }
                        } else {
                            WsByteBuffer[] wsbytebufferarray = this.httpOutSC.getResponseBodyBuffers();
                            byte[] wsbufArrayInBytes = null;
                            if (wsbytebufferarray != null) {
                                wsbufArrayInBytes = WsByteBufferUtils.asByteArray(wsbytebufferarray);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Received message : " + wsbytebufferarray.toString() + " Value : " + this.printBytes(wsbufArrayInBytes));
                                }
                            }
                            ByteArrayInputStream byteInpS = null;
                            if (wsbufArrayInBytes != null && wsbufArrayInBytes.length != 0) {
                                byteInpS = new ByteArrayInputStream(wsbufArrayInBytes);
                                if (byteInpS == null) {
                                    throw new AxisFault("canNotBeNull", "InputStream");
                                }
                                if (MessageTrace.isTraceEnabled()) {
                                    String contentType;
                                    String string = contentType = this.format != null ? this.format.getContentType() : null;
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Using this contentType for MessageTrace: " + contentType);
                                    }
                                    try {
                                        String str = new String("INBOUND_HTTP_RESPONSE");
                                        new LogFilterInputStream(byteInpS, _tc, 100000, str, contentType);
                                    }
                                    catch (Throwable t) {
                                        Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                                    }
                                }
                                if (this.msgContext.getOperationContext() != null) {
                                    this.msgContext.getOperationContext().setProperty("TRANSPORT_IN", byteInpS);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "receiveSOAPResponse received message : " + byteInpS.toString());
                                }
                            } else if (!InvocationPatternHelper.isOneWayInvocation(this.msgContext) && _tc.isDebugEnabled()) {
                                Tr.debug(_tc, "This is not oneway : " + String.valueOf(this.addrToConnect));
                            }
                            if (wsbytebufferarray != null) {
                                for (int i = 0; i < wsbytebufferarray.length; ++i) {
                                    if (wsbytebufferarray[i] == null) continue;
                                    wsbytebufferarray[i].release();
                                }
                                wsbufArrayInBytes = null;
                            }
                        }
                        HashMap<String, String> responseTransportHeaders = (HashMap<String, String>)this.msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                        if (responseTransportHeaders == null) {
                            responseTransportHeaders = new HashMap<String, String>();
                        }
                        if (responseTransportHeaders != null) {
                            Iterator<Object> headerIterator = null;
                            if (responseTransportHeaders.isEmpty()) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "receiveSOAPResponse(): Empty response header hasmap - returning ALL headers!");
                                }
                                headerIterator = this.httpRspMsg.getAllHeaders().iterator();
                            } else {
                                headerIterator = responseTransportHeaders.keySet().iterator();
                            }
                            String headerKey = null;
                            String responseHeader = null;
                            while (headerIterator.hasNext()) {
                                StringBuffer sbuff;
                                Vector vtor;
                                headerKey = (String)headerIterator.next();
                                if (headerKey == "Location") {
                                    vtor = this.httpRspMsg.getHeaderByteArrayValues(headerKey);
                                    sbuff = new StringBuffer();
                                    if (vtor != null && !vtor.isEmpty()) {
                                        for (byte[] b : vtor) {
                                            sbuff.append(new String(b, DEF_ENCODE));
                                        }
                                        responseHeader = sbuff.toString();
                                    }
                                    if (this.maintainSession && this.msgContext.getServiceContext() != null && JavaUtils.hasValue(responseHeader)) {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Setting HTTPConstants.HEADER_LOCATION : " + responseHeader.toString() + " in servicecontext");
                                        }
                                        this.msgContext.getServiceContext().setProperty("Location", responseHeader);
                                    }
                                } else if (headerKey == "Cookie" || headerKey == "Cookie2") {
                                    vtor = this.httpRspMsg.getHeaderByteArrayValues(headerKey);
                                    sbuff = new StringBuffer();
                                    if (vtor != null && !vtor.isEmpty()) {
                                        Iterator it = vtor.iterator();
                                        while (it.hasNext()) {
                                            byte[] b;
                                            b = (byte[])it.next();
                                            if (it.hasNext()) {
                                                sbuff.append(new String(b, DEF_ENCODE)).append(WSHTTPConstants.HEADER_TOKEN_SEPARATOR);
                                                continue;
                                            }
                                            sbuff.append(new String(b, DEF_ENCODE));
                                        }
                                        responseHeader = sbuff.toString();
                                    }
                                } else {
                                    responseHeader = this.httpRspMsg.getHeaderAsString(headerKey);
                                }
                                if (JavaUtils.hasValue(responseHeader)) {
                                    responseTransportHeaders.put(headerKey, responseHeader);
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "receiveSOAPResponse(): Rsp headerKey = " + headerKey + ", responseHeader = " + responseHeader);
                                    }
                                }
                                responseHeader = null;
                            }
                        }
                        this.msgContext.setProperty("com.ibm.websphere.webservices.responseTransportProperties", responseTransportHeaders);
                        this.msgContext.setProperty("TRANSPORT_HEADERS", responseTransportHeaders);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "responseTransportHeaders is set");
                        }
                        break block71;
                    }
                    if (!_tc.isDebugEnabled()) break block71;
                    Tr.debug(_tc, "invalidHttpResponse " + String.valueOf(this.addrToConnect));
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.receiveSOAPResponse", "873", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
                    }
                    throw ex;
                }
            }
            Object var14_22 = null;
            this.connection.setLastAccessTime();
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            this.connection.setLastAccessTime();
            throw throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "receiveSOAPResponse(): " + this);
        }
    }

    public String printBytes(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < array.length; ++k) {
            sb.append((char)array[k]);
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean is302or401set(MessageContext mc) throws AxisFault {
        boolean set;
        block26: {
            block24: {
                block27: {
                    int rcInt;
                    block25: {
                        rcInt = 0;
                        Integer rc = null;
                        String propValue = null;
                        set = true;
                        if (_tc.isEntryEnabled()) {
                            Tr.entry(_tc, "is302or401set: " + this);
                        }
                        rc = (Integer)mc.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                        propValue = (String)mc.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                        if (rc == null) break block24;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "httpStatusInResponse00 " + rc.toString() + "  " + propValue);
                        }
                        if ((rcInt = rc.intValue()) != HttpConstants.STATUS_FOUND.getIntCode()) break block25;
                        if (!this.isHttpRedirectEnabled(mc)) {
                            set = false;
                            Object[] inserts = new Object[]{this.addrToConnect.toString()};
                            String msg = NLSProvider.getNLS().getFormattedMessage("http302StatusCode", inserts, "The HTTP response redirected the target resource to a new location: {0}");
                            throw new AxisFault(msg);
                        }
                        propValue = (String)mc.getProperty(WSHTTPConstants.TRANS_URL_HTTP_REDIRECTED);
                        if (JavaUtils.hasValue(propValue)) {
                            URL newTargetURL = null;
                            try {
                                if (this.addrToConnect.getSchema() == 2) {
                                    this.setSSLConfig.restoreSSLConfiguration(this.addrToConnect);
                                }
                                if (this.connection != null) {
                                    if (!this.connection.isConnReset()) {
                                        this.connection.disconnect(null);
                                        this.oCache.findGroupAndReturnConnection(this.connection);
                                    }
                                    this.connection = null;
                                }
                                this.tcp = null;
                                newTargetURL = new URL(propValue);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Redirected URL " + newTargetURL.toString());
                                }
                                this.addrToConnect = new HttpChannelAddress(newTargetURL);
                                this.tcp = this.setupTransportClientProperties(newTargetURL, true);
                                this.setupHTTPConnection();
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.is302or401set", "963", this);
                                throw AxisFault.makeFault(e);
                            }
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, WSHTTPConstants.TRANS_URL_HTTP_REDIRECTED + " is not set");
                            }
                            set = false;
                        }
                        break block26;
                    }
                    if (rcInt != HttpConstants.STATUS_UNAUTHORIZED.getIntCode()) break block27;
                    if (this.wMgr.getRuntime() != 1) {
                        if (this.receivedHTTPBasicAuth()) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "challengeStatus01");
                            }
                            try {
                                if (this.connection != null) {
                                    if (!this.connection.isConnReset()) {
                                        this.connection.reset();
                                        this.oCache.findGroupAndReturnConnection(this.connection);
                                    }
                                    this.connection = null;
                                }
                                this.setupHTTPConnection();
                            }
                            catch (Exception ex) {
                                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.is302or401set", "1034", this);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
                                }
                                throw AxisFault.makeFault(ex);
                            }
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "challengeStatus02");
                            }
                            set = false;
                        }
                        break block26;
                    } else {
                        set = false;
                    }
                    break block26;
                }
                set = false;
                break block26;
            }
            set = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "is302or401set(): " + set);
        }
        this.is302or401 = set;
        return set;
    }

    private boolean receivedHTTPBasicAuth() {
        boolean success;
        block12: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "receiveHTTPBasicAuth");
            }
            success = false;
            if (!JavaUtils.hasValue(this.hConfig.getOutRequestUserID(this.msgContext)) && !JavaUtils.hasValue(this.hConfig.getOutRequestPassword(this.msgContext)) || !JavaUtils.hasValue(this.hConfig.getOutAsyncRespUserID(this.msgContext)) && !JavaUtils.hasValue(this.hConfig.getOutAsyncRespPassword(this.msgContext))) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "basicAuthData is NULL");
                }
                String flag = System.getProperty("com.ibm.ws.webservices.loginSource");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "com.ibm.ws.webservices.loginSource: " + flag);
                }
                try {
                    if (!JavaUtils.hasValue(flag) || "prompt".compareToIgnoreCase(flag) != 0 && "stdin".compareToIgnoreCase(flag) != 0) break block12;
                    SecurityDataPrompt sPrompt = SecurityDataPromptFactory.getPrompt(flag);
                    String[] httpBA = null;
                    try {
                        final String targetRealm = (String)this.msgContext.getProperty("WWW-Authenticate");
                        final SecurityDataPrompt finalPrompt = sPrompt;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "challengeRealmInfo", targetRealm);
                        }
                        httpBA = (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return finalPrompt.launch(targetRealm == null ? "" : targetRealm);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.receivedHTTPBasicAuth", "1147", this);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Stack " + e.toString());
                        }
                        throw e.getException();
                    }
                    if (httpBA != null && JavaUtils.hasValue(httpBA[0]) && JavaUtils.hasValue(httpBA[1])) {
                        this.msgContext.setProperty("javax.xml.ws.security.auth.username", httpBA[0]);
                        this.msgContext.setProperty("javax.xml.ws.security.auth.password", httpBA[1]);
                        success = true;
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.receivedHTTPBasicAuth", "1175", this);
                    Object[] inserts = new Object[]{ex};
                    Tr.error(_tc, "caughtException", inserts);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "receiveHTTPBasicAuth : " + success);
        }
        return success;
    }

    public boolean isHttpRedirectEnabled(MessageContext mc) {
        boolean result = false;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isHttpRedirectEnabled() ");
        }
        result = this.hConfig.redirectURLEnabled(mc);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isHttpRedirectEnabled() : " + result);
        }
        return result;
    }

    public String getChannelChainName() {
        return this.chainname;
    }

    public WSAddress getTargetAddress() {
        return this.addrToConnect;
    }

    public void setFormat(OMOutputFormat format) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Setting the format" + format);
        }
        this.format = format;
    }

    public OMOutputFormat getFormat() {
        return this.format;
    }

    public void setSoapAction(String soapAction) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Setting the Soap Action" + soapAction);
        }
        this.soapActionString = soapAction;
    }

    public SetupSSLConfiguration getSSLConfig() {
        return this.setSSLConfig;
    }

    public HTTPConnection getHTTPConnection() {
        return this.connection;
    }

    public OutboundConnectionCache getOutboundConnectionCache() {
        return this.oCache;
    }

    public MessageContext getMessageContext() {
        return this.msgContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TransportClientProperties setupTransportClientProperties(URL targetURL, boolean redirect) throws AxisFault {
        DefaultHTTPTransportClientProperties localTCP = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setupTransportClientProperties : " + targetURL.toString() + ", redirect = " + redirect);
        }
        try {
            if (targetURL.getProtocol().compareToIgnoreCase("http") == 0) {
                this.hConfig = new HttpEffectiveConfig(false, this.msgContext);
                if (this.hConfig.isPolicySetDefined()) {
                    if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext)) {
                        if (this.hConfig.getOutAsyncResponseSSLEnabled(this.msgContext)) {
                            throw new AxisFault("OutAsyncResponseSSL is set to yes in policyset for the URL : " + targetURL.getProtocol());
                        }
                    } else if (this.hConfig.getOutReqSSLEnabled(this.msgContext) && !redirect) {
                        throw new AxisFault("Out request Policy Set for SSL is set to true for protocol: " + targetURL.getProtocol());
                    }
                }
                localTCP = new DefaultHTTPTransportClientProperties(this.msgContext);
            } else if (targetURL.getProtocol().compareToIgnoreCase("https") == 0) {
                this.hConfig = new HttpEffectiveConfig(true, this.msgContext);
                localTCP = new DefaultHTTPSTransportClientProperties(this.msgContext);
                if (this.msgContext.getReplyTo() != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "replyTo : " + this.msgContext.getReplyTo() + " hasAnonymous : " + this.msgContext.getReplyTo().hasAnonymousAddress());
                }
                if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext)) {
                    if (this.hConfig.isPolicySetDefined()) {
                        if (!this.hConfig.getOutAsyncResponseSSLEnabled(this.msgContext)) throw new AxisFault("Out Async Response Policyset for SSL is set to false. " + targetURL.getProtocol());
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Setting SSL for Asynchronous Response flow...");
                        }
                        String sslFile = this.hConfig.getOutAsyncResponseSSLFile(this.msgContext);
                        if (WSChannelManager.getInstance().getRuntime() == 1) {
                            if (_tc.isDebugEnabled() && JavaUtils.hasValue(sslFile)) {
                                Tr.debug(_tc, "Running in server. getOutAsyncResponseSSLFile should not be set in Policyset.");
                            }
                            localTCP.setSSLConfigurationName(null);
                            localTCP.setSSLClientPropsName(null);
                        } else {
                            localTCP.setSSLConfigurationName(this.hConfig.getOutAsyncResponseSSLAlias(this.msgContext));
                            localTCP.setSSLClientPropsName(this.hConfig.getOutAsyncResponseSSLFile(this.msgContext));
                        }
                    }
                } else if (this.hConfig.isPolicySetDefined()) {
                    if (!this.hConfig.getOutReqSSLEnabled(this.msgContext) && !redirect) throw new AxisFault("Out request Policy Set for SSL is set to false for protocol: " + targetURL.getProtocol());
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting SSL for out request flow...");
                    }
                    String sslFile = this.hConfig.getOutReqSSLFile(this.msgContext);
                    if (WSChannelManager.getInstance().getRuntime() == 1) {
                        if (_tc.isDebugEnabled() && JavaUtils.hasValue(sslFile)) {
                            Tr.debug(_tc, "Running in server. getOutReqSSLFile should not be set in Policyset.");
                        }
                        localTCP.setSSLConfigurationName(null);
                        localTCP.setSSLClientPropsName(null);
                    } else {
                        localTCP.setSSLConfigurationName(this.hConfig.getOutReqSSLAlias(this.msgContext));
                        localTCP.setSSLClientPropsName(this.hConfig.getOutReqSSLFile(this.msgContext));
                    }
                }
            } else {
                Object[] inserts = new Object[]{targetURL.getProtocol()};
                String msg = NLSProvider.getNLS().getFormattedMessage("httpUnsupportedSchema", inserts, "The following schema for HTTP is not supported: {0}");
                throw new AxisFault(msg);
            }
            if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting proxy settings for Asynchronous Response flow...");
                }
                localTCP.setProxyHost(this.hConfig.getOutAsyncRespProxyHost(this.msgContext));
                localTCP.setProxyPort(this.hConfig.getOutAsyncRespProxyPort(this.msgContext));
                localTCP.setProxyUser(this.hConfig.getOutAsyncRespProxyUserID(this.msgContext));
                localTCP.setProxyPassword(this.hConfig.getOutAsyncRespProxyPassword(this.msgContext));
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting proxy settings for out request flow...");
                }
                localTCP.setProxyHost(this.hConfig.getOutRequestProxyHost(this.msgContext));
                localTCP.setProxyPort(this.hConfig.getOutRequestProxyPort(this.msgContext));
                localTCP.setProxyUser(this.hConfig.getOutRequestProxyUserID(this.msgContext));
                localTCP.setProxyPassword(this.hConfig.getOutRequestProxyPassword(this.msgContext));
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.setupTransportClientProperties", "1415", this);
            throw AxisFault.makeFault(e);
        }
        if (!_tc.isEntryEnabled()) return localTCP;
        Tr.exit(_tc, "setupTransportClientProperties");
        return localTCP;
    }

    public boolean getChunkingEnabled() {
        return this.hConfig != null && this.hConfig.chunkedEncodingEnabled(this.msgContext);
    }

    public SOAPOverHTTPSender(MessageContext mc) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverHTTPSender: " + mc);
        }
        try {
            this.wMgr = WSChannelManager.getInstance();
            this.msgContext = mc;
            EndpointReference epr = this.msgContext.getTo();
            URL targetURL = new URL(epr.getAddress());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Target URL " + targetURL.toString());
            }
            this.tcp = this.setupTransportClientProperties(targetURL, false);
            this.maintainSession = this.hConfig.maintainSessionEnabled(this.msgContext);
            OutboundURLTargetResolver outboundTargetting = new OutboundURLTargetResolver();
            this.addrToConnect = outboundTargetting.getOutboundTarget(this.tcp, this.msgContext, this.maintainSession);
            if (this.addrToConnect.getSchema() == 2) {
                this.setSSLConfig = new SetupSSLConfiguration(this.msgContext);
            }
            this.setupHTTPConnection();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.SOAPOverHTTPSender", "1459", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "exception01 " + e.toString());
            }
            throw AxisFault.makeFault(e);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverHTTPSender");
        }
    }

    public void setupHTTPConnection() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setupHTTPConnection " + this.addrToConnect);
        }
        try {
            this.connection = null;
            int connTimeout = this.hConfig.getConnectionTimeout(this.msgContext);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Connection timeout: " + connTimeout + " ms");
            }
            this.addrToConnect.setConnectTimeout(connTimeout);
            if (this.addrToConnect.getSchema() == 2) {
                if (this.setSSLConfig == null) {
                    this.setSSLConfig = new SetupSSLConfiguration(this.msgContext);
                }
                this.setSSLConfig.setupEffectiveSSLConfiguration(this.addrToConnect, (DefaultHTTPSTransportClientProperties)this.tcp);
            }
            this.chainname = this.addrToConnect.keyValueforPool();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "chainname " + this.chainname);
            }
            this.oCache = (OutboundConnectionCache)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return OutboundConnectionCache.getInstance();
                }
            });
            this.connection = this.oCache.findGroupAndGetConnection(this.addrToConnect);
            if (this.connection == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("noHttpObjReturnFromPool00", new Object[0], "No HTTPConnection object was returned from the outbound connection pool.");
                throw new AxisFault(msg);
            }
            this.connection.connect();
            this.oConn = this.connection.getConnection();
            this.httpOutSC = (HttpOutboundServiceContext)this.oConn.getChannelAccessor();
        }
        catch (Exception e) {
            block14: {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.setupHTTPConnection", "1518", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "exception01 " + e.toString());
                }
                try {
                    block15: {
                        if (this.oCache == null || this.connection == null) break block14;
                        try {
                            this.connection.disconnect(null);
                        }
                        catch (Throwable t) {
                            if (!_tc.isDebugEnabled()) break block15;
                            Tr.debug(_tc, "Error occurred while disconnecting.  The connection will be invalidated.  Exception= " + t.toString());
                        }
                    }
                    this.oCache.findGroupAndReturnInvalidConnection(this.connection);
                }
                catch (Throwable t) {
                    if (!_tc.isDebugEnabled()) break block14;
                    Tr.debug(_tc, "Could not return connection object after failed attempt to connect: " + this.addrToConnect);
                }
            }
            throw AxisFault.makeFault(e);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setupHTTPConnection");
        }
    }

    private static void addValueToOutboundHeader(String transportHeaderKey, String transportHeaderValue, HttpRequestMessage httpReqMsg) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg): transportHeaderKey = " + transportHeaderKey + ", transportHeaderValue = " + transportHeaderValue + ", httpReqMsg" + httpReqMsg);
        }
        if (transportHeaderKey == null || transportHeaderKey.length() <= 0) {
            Tr.error(_tc, "invalidTransHeadKey00");
            return;
        }
        if (transportHeaderValue == null || transportHeaderValue.length() <= 0) {
            Tr.error(_tc, "invalidTransHeadValue00", transportHeaderKey);
            return;
        }
        if (httpReqMsg == null) {
            Tr.error(_tc, "internal.error", "HTTP Request message is null");
        }
        String TOKEN_SEPERATOR = ";";
        String currentHeader = httpReqMsg.getHeaderAsString(transportHeaderKey);
        StringTokenizer currentHeaderTokens = null;
        if (currentHeader != null) {
            Tr.debug(_tc, "addValueToOutboundHeader() currentHeader " + currentHeader);
            currentHeaderTokens = new StringTokenizer(currentHeader, ";");
        }
        if (currentHeaderTokens != null && currentHeaderTokens.countTokens() > 0) {
            int nameValueSeperatorIndex;
            String NAME_VALUE_SEPERATOR = "=";
            StringTokenizer newHeaderTokens = new StringTokenizer(transportHeaderValue, ";");
            HashMap<String, String> newNameValuePairs = new HashMap<String, String>();
            while (newHeaderTokens != null && newHeaderTokens.countTokens() > 0) {
                String processToken = newHeaderTokens.nextToken();
                nameValueSeperatorIndex = processToken.indexOf("=");
                String tokenName = null;
                String tokenValue = null;
                if (nameValueSeperatorIndex > -1) {
                    tokenName = processToken.substring(0, nameValueSeperatorIndex);
                    tokenValue = processToken.substring(nameValueSeperatorIndex + 1);
                } else {
                    tokenName = new String(processToken);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "addValueToOutboundHeader() New tokenName = " + tokenName + " , tokenValue = " + tokenValue);
                }
                newNameValuePairs.put(tokenName, tokenValue);
            }
            while (currentHeaderTokens.countTokens() > 0) {
                String processCurrentToken = currentHeaderTokens.nextToken();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "addValueToOutboundHeader() processCurrentToken " + processCurrentToken);
                }
                nameValueSeperatorIndex = processCurrentToken.indexOf("=");
                String currentTokenName = null;
                currentTokenName = nameValueSeperatorIndex > -1 ? processCurrentToken.substring(0, nameValueSeperatorIndex) : new String(processCurrentToken);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "addValueToOutboundHeader() removing " + currentTokenName + " from new header values if it exists = " + newNameValuePairs.containsKey(currentTokenName));
                }
                newNameValuePairs.remove(currentTokenName);
            }
            StringBuffer requestHeaders = new StringBuffer(httpReqMsg.getHeaderAsString(transportHeaderKey));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "addValueToOutboundHeader() request header : " + transportHeaderKey + " value : " + requestHeaders.toString());
            }
            for (Map.Entry addHeader : newNameValuePairs.entrySet()) {
                requestHeaders.append(";");
                requestHeaders.append((String)addHeader.getKey());
                if ((String)addHeader.getValue() != null) {
                    requestHeaders.append("=");
                    requestHeaders.append((String)addHeader.getValue());
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "addValueToOutboundHeader() adding request header ;" + (String)addHeader.getKey() + "=" + (String)addHeader.getValue());
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "addValueToOutboundHeader() adding request header ;" + (String)addHeader.getKey());
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "addValueToOutboundHeader() setting request header : " + transportHeaderKey + " to value : " + requestHeaders.toString());
            }
            httpReqMsg.setHeader(transportHeaderKey, new String(requestHeaders));
        } else {
            httpReqMsg.setHeader(transportHeaderKey, transportHeaderValue);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "addValueToOutboundHeader(): Header did not already exist. Adding " + transportHeaderKey + " value " + transportHeaderValue);
            }
        }
    }

    private String prepareHttpRequestHeaders(MessageContext msgcontext) throws AxisFault, UnsupportedMethodException, UnsupportedProtocolVersionException, MalformedURLException, XMLStreamException {
        MessageContext msgCtx;
        boolean enabled;
        String Password2;
        String Userid;
        String urlHost;
        String contentType = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "prepareHttpRequestHeaders(): " + this);
        }
        Map requestTransportHeaders = SOAPOverHTTPSender.getConfiguredTransportHeaders(msgcontext);
        HttpRequestMessage httpReqMsg = this.httpOutSC.getRequest();
        String propValue = null;
        int synctimeout = this.hConfig.getReadTimeout(this.msgContext);
        this.httpOutSC.setReadTimeout(synctimeout);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "syncTimeoutValue " + String.valueOf(synctimeout) + " ms for " + this.addrToConnect.getSchemaInString());
        }
        int writeTimeout = this.hConfig.getWriteTimeout(this.msgContext);
        this.httpOutSC.setWriteTimeout(writeTimeout);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Write timeout value " + String.valueOf(writeTimeout) + " ms for " + this.addrToConnect.getSchemaInString());
        }
        boolean postmethod = true;
        if (!this.msgContext.isSOAP11()) {
            propValue = (String)this.msgContext.getProperty("soap12.webmethod");
        }
        if (propValue == null) {
            propValue = "POST";
        } else {
            postmethod = propValue.equals("POST");
        }
        httpReqMsg.setMethod(propValue);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() setMethod : " + propValue);
        }
        propValue = ((HttpChannelAddress)this.addrToConnect).getTargetEndPoint();
        httpReqMsg.setRequestURL(propValue);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() setRequestURL : " + propValue);
        }
        if ((urlHost = httpReqMsg.getURLHost()) == null || urlHost != null && urlHost.equals("")) {
            Object[] inserts = new Object[]{urlHost, propValue};
            String msg = NLSProvider.getNLS().getFormattedMessage("invalidHttpHost", inserts, "An incorrect {0} HTTP host value was specified within the URL {1}");
            throw new AxisFault(msg);
        }
        int urlPort = httpReqMsg.getURLPort();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() urlPort : " + urlPort);
        }
        if (urlPort <= 0) {
            Object[] inserts = new Object[]{urlPort, propValue};
            String msg = NLSProvider.getNLS().getFormattedMessage("invalidHttpPort", inserts, "An incorrect {0} HTTP port value was specified within the URL {1}");
            throw new AxisFault(msg);
        }
        String hostHeaderValue = urlHost + ":" + urlPort;
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_HOST, hostHeaderValue);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() hostHeaderValue : " + hostHeaderValue);
        }
        propValue = this.hConfig.getProtocolVer(this.msgContext) != null ? this.hConfig.getProtocolVer(this.msgContext) : "HTTP/1.1";
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "httpVersion " + propValue);
        }
        boolean use1_1 = true;
        if (propValue != null) {
            if (propValue.equalsIgnoreCase("HTTP/1.1") || propValue.equalsIgnoreCase("HTTP/1.0")) {
                httpReqMsg.setVersion(propValue);
                if (propValue.equalsIgnoreCase("HTTP/1.0")) {
                    use1_1 = false;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "prepareHttpRequestHeaders() setVersion " + propValue);
                }
            } else {
                Object[] inserts = new Object[]{propValue};
                String msg = NLSProvider.getNLS().getFormattedMessage("unsupportedHttpVersion", inserts, "An unsupported HTTP version is found: {0}");
                throw new AxisFault(msg);
            }
        }
        httpReqMsg.setVersion(propValue);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "addrToConnect " + String.valueOf(this.addrToConnect) + "  httpVersion : " + httpReqMsg.getVersion());
        }
        String acceptheaders = "application/soap+xml,multipart/related,text/*";
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT, acceptheaders);
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_USER_AGENT, "IBM WebServices/1.0");
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_CACHE_CONTROL, "no-cache");
        httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_PRAGMA, "no-cache");
        String soapAction = null;
        if (this.soapActionString == null) {
            soapAction = "\"\"";
        } else if (this.soapActionString.startsWith("\"") && this.soapActionString.endsWith("\"")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "soapAction already contains double quotes");
            }
            soapAction = this.soapActionString;
        } else {
            soapAction = "\"" + this.soapActionString + "\"";
        }
        if ("".equals(soapAction)) {
            httpReqMsg.setHeader("SOAPAction", "");
        } else {
            httpReqMsg.setHeader("SOAPAction", soapAction);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() SOAP Action : " + soapAction);
        }
        StringBuffer basicAuthData = null;
        if (this.addrToConnect.toString().contains("/IBM_WS_SYS_RESPONSESERVLET/") && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "prepareHttpRequestHeaders() epr has Async Servlet so trying to add basic auth info");
        }
        if (InvocationPatternHelper.isAsyncRespSeparateChannel(this.msgContext) || this.addrToConnect.toString().contains("/IBM_WS_SYS_RESPONSESERVLET/")) {
            Userid = this.hConfig.getOutAsyncRespUserID(this.msgContext);
            Password2 = this.hConfig.getOutAsyncRespPassword(this.msgContext);
            if (Userid != null && Password2 != null) {
                basicAuthData = new StringBuffer(Userid);
                basicAuthData.append(":").append(Password2);
            }
        } else {
            Userid = this.hConfig.getOutRequestUserID(this.msgContext);
            Password2 = this.hConfig.getOutRequestPassword(this.msgContext);
            if (Userid != null && Password2 != null) {
                basicAuthData = new StringBuffer(Userid);
                basicAuthData.append(":").append(Password2);
            }
        }
        if (basicAuthData != null && JavaUtils.hasValue(basicAuthData.toString())) {
            int lastindex = basicAuthData.length();
            basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes()));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "basicAuthData : " + basicAuthData.toString());
            }
            httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_AUTHORIZATION, basicAuthData.insert(0, "Basic ").toString());
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "basicAuthData is NULL");
        }
        this.maintainSession = this.hConfig.maintainSessionEnabled(this.msgContext);
        if (this.maintainSession) {
            String altCookie;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "prepareHttpRequestHeaders(): maintain session TRUE");
            }
            if (this.msgContext.getServiceContext() != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting javax.xml.ws.session.maintain to " + Boolean.TRUE);
                }
                this.msgContext.getServiceContext().setProperty("javax.xml.ws.session.maintain", Boolean.TRUE);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServiceContext is null. Not setting the session enabled");
            }
            Object cookieObj = this.msgContext.getProperty("Cookie");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "prepareHttpRequestHeaders(): Cookie property value : " + cookieObj);
            }
            if ((altCookie = (String)requestTransportHeaders.get("Cookie")) != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "prepareHttpRequestHeaders(): Cookie from configured transport headers = " + altCookie);
            }
            if ((cookieObj == null || cookieObj instanceof String) && altCookie != null) {
                Tr.debug(_tc, "The Cookie from the configured transport header is used: " + altCookie);
                cookieObj = altCookie;
                this.msgContext.setProperty("Cookie", altCookie);
            }
            if (cookieObj != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Got cookie object : " + cookieObj);
                }
                String cookie = null;
                Object key = this.msgContext.getProperty("org.apache.axis2.jaxws.BindingProvider");
                if (cookieObj instanceof String) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Cookie is of type String");
                    }
                    cookie = (String)cookieObj;
                    ServiceContext sc = this.msgContext.getServiceContext();
                    if (sc != null) {
                        HTTPCookieManager cm = null;
                        Object temp = sc.getProperty("Cookie");
                        CookieMap cookieMap = null;
                        if (temp instanceof CookieMap) {
                            cookieMap = (CookieMap)temp;
                            cm = cookieMap.get(key);
                        } else {
                            cookieMap = new CookieMap();
                        }
                        try {
                            if (cm == null) {
                                cm = new HTTPCookieManager();
                            }
                            EndpointReference epr = this.msgContext.getTo();
                            URL targetURL = new URL(epr.getAddress());
                            String path = targetURL.getPath();
                            cm.setCookies(cookie, null, path);
                        }
                        catch (Exception ex) {
                            throw AxisFault.makeFault(ex);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "msgContext = " + this.msgContext.toString() + " SessionContext = " + cm);
                        }
                        cookieMap.put(key, cm);
                        sc.setProperty("Cookie", cookieMap);
                    }
                } else if (cookieObj instanceof Map && ((Map)cookieObj).get(key) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Cookie is of type Map");
                    }
                    HTTPCookieManager cm = (HTTPCookieManager)((Map)cookieObj).get(key);
                    EndpointReference epr = this.msgContext.getTo();
                    URL targetURL = new URL(epr.getAddress());
                    String path = targetURL.getPath();
                    String domain = targetURL.getHost();
                    int port = targetURL.getPort();
                    boolean secure = false;
                    if (this.addrToConnect.getSchema() == 2) {
                        secure = true;
                    }
                    if (altCookie != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "prepareHttpRequestHeaders(): Using cookie from configured transport headers");
                        }
                        if (cm == null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Creating a new cookie manager");
                            }
                            cm = new HTTPCookieManager();
                        }
                        cm.setCookies(altCookie, null, path);
                        ((Map)cookieObj).put(key, cm);
                    }
                    if (cm == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "There is no HTTPCookieManager for the BindingProvider " + key);
                        }
                    } else {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "HTTPCookieManager is " + cm + " for the BindingProvider " + key);
                        }
                        cookie = cm.getCookie(path, domain, port, secure);
                    }
                }
                if (cookie != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "prepareHttpRequestHeaders(): Setting Cookie for maintain session = " + cookie);
                    }
                    httpReqMsg.setHeader("Cookie", cookie);
                }
            }
        }
        if (((HttpChannelAddress)this.addrToConnect).isProxy() && this.addrToConnect.getSchema() == 1) {
            String proxyUser = this.tcp.getProxyUser();
            String proxyPassword = this.tcp.getProxyPassword();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "httpProxyConfiguration00 Proxy Host : " + this.tcp.getProxyHost() + " Proxy Port : " + this.tcp.getProxyPort() + " Proxy User : " + proxyUser);
            }
            if (JavaUtils.hasValue(proxyUser) && JavaUtils.hasValue(proxyPassword)) {
                basicAuthData = new StringBuffer(proxyUser);
                basicAuthData.append(":").append(proxyPassword);
                int lastindex = basicAuthData.length();
                basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes()));
                httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_PROXY_AUTHORIZATION, basicAuthData.insert(0, "Basic ").toString());
            }
        }
        if (!(enabled = this.hConfig.msgResendOnceEnabled(this.msgContext))) {
            this.httpOutSC.disallowRewrites();
        } else {
            this.httpOutSC.allowRewrites();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HTTPConstants.HTTP_REQUEST_RESEND : " + enabled);
        }
        enabled = this.hConfig.persistConnEnabled(this.msgContext);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Persistent Connection : " + enabled);
        }
        if (enabled) {
            httpReqMsg.setConnection(HttpConstants.CONN_KEEPALIVE);
        } else {
            httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
        }
        boolean found = false;
        OperationContext opCtx = this.msgContext.getOperationContext();
        if (opCtx != null && (msgCtx = opCtx.getMessageContext("In")) != null) {
            String id = (String)msgCtx.getProperty("SAVECONNECTION");
            if (id != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Got key " + id + " from request MessageContext");
                    Tr.debug(_tc, "setting SAVECONNECTION header to : " + id);
                }
                found = true;
                httpReqMsg.setHeader("SAVECONNECTION", id);
                this.hashKeyCode = new StringBuffer(id);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "SAVECONNECTION id is null in request MessageContext");
            }
        }
        if (!found) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating new key");
            }
            this.hashKeyCode = new StringBuffer(String.valueOf(httpReqMsg.hashCode()));
            this.hashKeyCode.append(String.valueOf(System.currentTimeMillis()));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting SAVECONNECTION to httpReqMsg : " + this.hashKeyCode.toString());
            }
            httpReqMsg.setHeader("SAVECONNECTION", this.hashKeyCode.toString());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Setting IBM-WAS-CLIENT to httpReqMsg : TRUE");
        }
        httpReqMsg.setHeader("IBM-WAS-CLIENT", "TRUE");
        EndpointReference epr = this.msgContext.getReplyTo();
        propValue = null;
        Boolean nonBlockTransport = (Boolean)this.msgContext.getProperty("transportNonBlocking");
        if (epr != null) {
            if (this.msgContext.getTo() != null && !this.msgContext.getTo().hasAnonymousAddress()) {
                if (nonBlockTransport != null && nonBlockTransport.booleanValue()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "In Send Asynchronous Request flow...");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "In Send Synchronous Request flow...");
                }
                if (AsyncEPRSet.isEPRinSet(epr.getAddress())) {
                    propValue = this.saveContextToMap(this.msgContext);
                }
            }
        } else {
            epr = this.msgContext.getFaultTo();
            if (epr != null) {
                if (this.msgContext.getTo() != null && !this.msgContext.getTo().hasAnonymousAddress()) {
                    if (nonBlockTransport != null && nonBlockTransport.booleanValue()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "In Send Asynchronous Fault flow...");
                        }
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "In Send Synchronous Fault flow...");
                    }
                    propValue = this.saveContextToMap(this.msgContext);
                }
            } else if (!this.msgContext.getAxisService().isClientSide()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "In Send Asynchronous Resoponse flow...");
                }
                httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
            }
        }
        propValue = null;
        if (nonBlockTransport != null && nonBlockTransport.booleanValue()) {
            if (this.msgContext.getReplyTo() == null) {
                propValue = this.hConfig.responseCompressEnabled(this.msgContext);
            }
        } else {
            propValue = this.hConfig.requestCompressEnabled(this.msgContext);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.requestContentEncoding = " + propValue);
        }
        if (JavaUtils.hasValue(propValue)) {
            if (this.httpOutSC.isGZipEncodingSupported() && propValue.equalsIgnoreCase(WSHTTPConstants.HEADER_C_ENC_GZIP)) {
                this.httpOutSC.setGZipEncoded(true);
                if (this.httpOutSC.isGZipEncoded()) {
                    httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, WSHTTPConstants.HEADER_C_ENC_GZIP);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "gzipCompressionEnabled : ", String.valueOf(this.httpOutSC.isGZipEncoded()));
                }
            } else if (this.httpOutSC.isXGZipEncodingSupported() && propValue.equalsIgnoreCase(WSHTTPConstants.HEADER_C_ENC_XGZIP)) {
                this.httpOutSC.setXGZipEncoded(true);
                if (this.httpOutSC.isXGZipEncoded()) {
                    httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, WSHTTPConstants.HEADER_C_ENC_XGZIP);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "xgzipCompressionEnabled : ", String.valueOf(this.httpOutSC.isGZipEncoded()));
                }
            } else if (this.httpOutSC.isZlibEncodingSupported() && propValue.equalsIgnoreCase(WSHTTPConstants.HEADER_C_ENC_DEFLATE)) {
                this.httpOutSC.setZlibEncoded(true);
                if (this.httpOutSC.isZlibEncoded()) {
                    httpReqMsg.setHeader((HeaderKeys)HttpConstants.HDR_ACCEPT_ENCODING, WSHTTPConstants.HEADER_C_ENC_DEFLATE);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "deflateCompressionEnabled : ", String.valueOf(this.httpOutSC.isZlibEncoded()));
                }
            }
        }
        if (!this.httpOutSC.isGZipEncoded() && !this.httpOutSC.isZlibEncoded() && !this.httpOutSC.isXGZipEncoded() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "noCompression");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "checkIfChunkedEncodingEnabled");
        }
        boolean useChunkEncoding = this.hConfig.chunkedEncodingEnabled(this.msgContext);
        boolean expect100Continue = this.hConfig.sendExpectHeaderEnabled(this.msgContext);
        if (requestTransportHeaders != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "prepareHttpRequestHeaders(): REQUEST_TRANSPORT_PROPERTIES used = " + requestTransportHeaders);
            }
            for (Map.Entry headerMapEntry : requestTransportHeaders.entrySet()) {
                String transportHeaderKey = (String)headerMapEntry.getKey();
                if (transportHeaderKey != null) {
                    transportHeaderKey = transportHeaderKey.trim();
                    transportHeaderKey.intern();
                }
                if (transportHeaderKey == null || transportHeaderKey.length() <= 0) {
                    Tr.warning(_tc, "invalidTransHeadKey00");
                    continue;
                }
                String transportHeaderValue = (String)headerMapEntry.getValue();
                if (transportHeaderValue != null) {
                    transportHeaderValue = transportHeaderValue.trim();
                }
                if (transportHeaderValue == null || transportHeaderValue.length() <= 0) {
                    Tr.warning(_tc, "invalidTransHeadValue00", transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == HTTPConstants.HEADER_TRANSFER_ENCODING) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "transportHeaderKey == HTTPConstants.HEADER_TRANSFER_ENCODING");
                    }
                    if (!use1_1 || !transportHeaderValue.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "useChunkEncoding");
                    }
                    useChunkEncoding = true;
                    continue;
                }
                if (transportHeaderKey == "Connection") {
                    if (use1_1) {
                        if (transportHeaderValue.equals(HTTPConstants.HEADER_CONNECTION_CLOSE)) {
                            httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
                            continue;
                        }
                        if (!transportHeaderValue.equals(HTTPConstants.HEADER_CONNECTION_KEEPALIVE)) continue;
                        httpReqMsg.setConnection(HttpConstants.CONN_KEEPALIVE);
                        continue;
                    }
                    httpReqMsg.setConnection(HttpConstants.CONN_CLOSE);
                    continue;
                }
                if (transportHeaderKey == "Expect") {
                    Integer stcodes;
                    if (!use1_1 || !transportHeaderValue.equalsIgnoreCase("100-continue") || (stcodes = (Integer)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE)) != null && stcodes == 100) continue;
                    httpReqMsg.setExpect(HttpConstants.EXPECT_100CONTINUE);
                    expect100Continue = true;
                    continue;
                }
                if (transportHeaderKey == "Host") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "Content-Type") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "SOAPAction") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "Content-Length") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "SAVECONNECTION") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "IBM-WAS-CLIENT") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "IBM-WAS-Reset-Connection") {
                    if (!_tc.isDebugEnabled()) continue;
                    Tr.debug(_tc, "prepareHttpRequestHeaders(): Processing REQUEST_TRANSPORT_PROPERTIES.  Ignoring header " + transportHeaderKey);
                    continue;
                }
                if (transportHeaderKey == "Cookie") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                if (transportHeaderKey == "Cookie2") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                if (transportHeaderKey == "Authorization") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                if (transportHeaderKey == "Proxy-Authorization") {
                    SOAPOverHTTPSender.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
                    continue;
                }
                SOAPOverHTTPSender.addValueToOutboundHeader(transportHeaderKey, transportHeaderValue, httpReqMsg);
            }
        }
        if (postmethod) {
            if (contentType == null) {
                MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(this.msgContext);
                if (messageFormatter == null) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
                    throw new AxisFault(msg);
                }
                String charSetEncoding = null;
                charSetEncoding = (String)this.msgContext.getProperty("message.character-set-encoding");
                if (charSetEncoding != null) {
                    this.format.setCharSetEncoding(charSetEncoding);
                }
                contentType = messageFormatter.getContentType(this.msgContext, this.format, this.soapActionString);
            }
            httpReqMsg.setHeader("Content-Type", contentType);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HTTP Content-Type: " + contentType);
            }
            if (useChunkEncoding) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...useChunkEncoding: " + useChunkEncoding);
                }
                httpReqMsg.setTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "prepareHttpRequestHeaders(): " + this);
        }
        return contentType;
    }

    private void writeMessage(OutputStream os) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeMessage(): " + this);
        }
        if (this.is302or401) {
            if (this.msgContext.getEnvelope() != null) {
                try {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Writing redirected message to ouput stream: " + os.hashCode());
                    }
                    this.msgContext.getEnvelope().serializeAndConsume(os);
                }
                catch (XMLStreamException e) {
                    throw AxisFault.makeFault(e);
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "writeMessage()");
            }
            return;
        }
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(this.msgContext);
        if (messageFormatter == null) {
            String msg = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
            throw new AxisFault(msg);
        }
        String charSetEncoding = (String)this.msgContext.getProperty("message.character-set-encoding");
        if (charSetEncoding != null) {
            this.format.setCharSetEncoding(charSetEncoding);
        }
        String contentType = messageFormatter.getContentType(this.msgContext, this.format, this.soapActionString);
        this.format.setIgnoreXMLDeclaration(true);
        this.format.setContentType(contentType);
        this.format.setAutoCloseWriter(true);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Writing to MessagEFormatter with following fromat options " + this.format.toString());
        }
        messageFormatter.writeTo(this.msgContext, this.format, os, false);
        if (os instanceof HttpOutByteBufferOutputStream) {
            HttpOutByteBufferOutputStream outputStream = (HttpOutByteBufferOutputStream)os;
            long responseLength = outputStream.size();
            this.setPMIResponseLength(this.msgContext, responseLength);
            if (MessageTrace.isTraceEnabled() && outputStream.getByteBuffer() != null) {
                this.traceResponse(this.msgContext, contentType, outputStream.getByteBuffer().array());
            }
        } else if (os instanceof BAOS) {
            BAOS outputStream = (BAOS)os;
            long responseLength = outputStream.size();
            this.setPMIResponseLength(this.msgContext, responseLength);
            if (MessageTrace.isTraceEnabled() && outputStream.getBytes() != null) {
                this.traceResponse(this.msgContext, contentType, outputStream.getBytes());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeMessage()");
        }
    }

    void setPMIResponseLength(MessageContext msgContext, long responseLength) {
        MessagePMIContext pmiContext = (MessagePMIContext)msgContext.getProperty("com.ibm.ws.websvcs.MESSAGE_PMI_CONTEXT");
        if (pmiContext != null) {
            pmiContext.setResponseSize(responseLength);
        }
    }

    private byte[] getMessageBytes() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getMessageBytes(): " + this);
        }
        if (!this.is302or401) {
            MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(this.msgContext);
            if (messageFormatter == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
                throw new AxisFault(msg);
            }
            String charSetEncoding = (String)this.msgContext.getProperty("message.character-set-encoding");
            if (charSetEncoding != null) {
                this.format.setCharSetEncoding(charSetEncoding);
            }
            String contentType = messageFormatter.getContentType(this.msgContext, this.format, this.soapActionString);
            this.format.setIgnoreXMLDeclaration(true);
            this.format.setContentType(contentType);
            this.format.setAutoCloseWriter(true);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Writing to MessagEFormatter with following fromat options " + this.format.toString());
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getMessageBytes()");
            }
            return messageFormatter.getBytes(this.msgContext, this.format);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getMessageBytes()");
        }
        return null;
    }

    private WsByteBuffer[] getRequestBuffer(MessageContext mc, byte[] os, int byteCount) throws AxisFault, UnsupportedMethodException, UnsupportedProtocolVersionException, MalformedURLException, XMLStreamException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRequestBuffer(): " + this);
        }
        WsByteBufferPoolManager wbufPoolMgr = null;
        try {
            wbufPoolMgr = WSChannelManager.getInstance().getWsByteBufferPoolManager();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.prepareHttpRequestHeaders", "2395", this);
            throw AxisFault.makeFault(ex);
        }
        WsByteBuffer[] wbufArray = new WsByteBuffer[]{wbufPoolMgr.allocateDirect(byteCount)};
        wbufArray[0].put(os, 0, byteCount);
        wbufArray[0] = wbufArray[0].flip();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRequestBuffer()");
        }
        return wbufArray;
    }

    public void processResponseHeader() {
        block30: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "processResponseHeader()");
            }
            try {
                String DEF_ENCODE = "iso-8859-1";
                byte[] hdrBytes = null;
                StringBuffer sb = new StringBuffer();
                byte[] hdrValbyte = this.httpRspMsg.getHeaderAsByteArray("Content-Type");
                if (hdrValbyte != null) {
                    sb.append(new String(hdrValbyte, DEF_ENCODE));
                }
                if (this.httpRspMsg.getNumberOfHeaderInstances("Content-Type") > 0 && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content-Type has more values. Ignoring them.");
                }
                String contentType = sb.toString();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content-Type : " + contentType);
                }
                String charsetEnc = null;
                if (contentType != null) {
                    String tempStr = new String(contentType);
                    StringTokenizer st = new StringTokenizer(tempStr, ";");
                    OperationContext opContext = this.msgContext.getOperationContext();
                    if (opContext != null) {
                        opContext.setProperty("ContentType", contentType);
                    }
                    while (st.hasMoreTokens()) {
                        String name = st.nextToken();
                        if (name.equalsIgnoreCase("multipart/related") && opContext != null) {
                            opContext.setProperty("MTOM_RECEIVED", contentType);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "MTOM_RECEIVED : " + contentType);
                            }
                        }
                        if (!name.contains(HTTPConstants.CHAR_SET_ENCODING)) continue;
                        StringTokenizer st1 = new StringTokenizer(name, "=");
                        String charsetName = st1.nextToken();
                        String responseCharsetEnc = st1.nextToken();
                        if (responseCharsetEnc == null) continue;
                        charsetEnc = HTTPClientUtils.getActualCharSet(responseCharsetEnc);
                        if (opContext == null) continue;
                        opContext.setProperty("CHARACTER_SET_ENCODING", charsetEnc);
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "CHARACTER_SET_ENCODING : " + charsetEnc);
                    }
                }
                hdrBytes = this.httpRspMsg.getHeaderAsByteArray("Content-Location");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content-Location: " + (hdrBytes == null ? "" : new String(hdrBytes, DEF_ENCODE)));
                }
                hdrBytes = this.httpRspMsg.getHeaderAsByteArray(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, HTTPConstants.HEADER_TRANSFER_ENCODING + ": " + (hdrBytes == null ? "" : new String(hdrBytes, DEF_ENCODE)));
                }
                if (this.maintainSession) {
                    sb = new StringBuffer();
                    String cookie = null;
                    Vector hdrValvector = this.httpRspMsg.getHeaderByteArrayValues("Set-Cookie");
                    if (hdrValvector != null && !hdrValvector.isEmpty()) {
                        Iterator it = hdrValvector.iterator();
                        while (it.hasNext()) {
                            byte[] b = (byte[])it.next();
                            if (it.hasNext()) {
                                sb.append(new String(b, DEF_ENCODE)).append(WSHTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            sb.append(new String(b, DEF_ENCODE));
                        }
                        cookie = sb.toString();
                        if (_tc.isEventEnabled()) {
                            Object[] inserts = new Object[]{"Set-Cookie", cookie};
                            Tr.event(_tc, "cookieReceived", inserts);
                        }
                    }
                    String cookie2 = null;
                    sb = new StringBuffer();
                    hdrValvector = this.httpRspMsg.getHeaderByteArrayValues("Set-Cookie2");
                    if (hdrValvector != null && !hdrValvector.isEmpty()) {
                        Iterator it = hdrValvector.iterator();
                        while (it.hasNext()) {
                            byte[] b = (byte[])it.next();
                            if (it.hasNext()) {
                                sb.append(new String(b, DEF_ENCODE)).append(WSHTTPConstants.HEADER_TOKEN_SEPARATOR);
                                continue;
                            }
                            sb.append(new String(b, DEF_ENCODE));
                        }
                        cookie2 = sb.toString();
                        if (_tc.isEventEnabled()) {
                            Object[] inserts = new Object[]{"Set-Cookie", cookie2};
                            Tr.event(_tc, "cookieReceived : ", inserts);
                        }
                    }
                    if (this.msgContext.getServiceContext() != null && (cookie != null || cookie2 != null)) {
                        ServiceContext sc = this.msgContext.getServiceContext();
                        HTTPCookieManager cm = null;
                        Object key = this.msgContext.getProperty("org.apache.axis2.jaxws.BindingProvider");
                        CookieMap cookieMap = (CookieMap)sc.getProperty("Cookie");
                        HTTPCookieManager hTTPCookieManager = cm = cookieMap != null ? cookieMap.get(key) : null;
                        if (cm == null) {
                            cm = new HTTPCookieManager();
                        }
                        EndpointReference epr = this.msgContext.getTo();
                        URL targetURL = new URL(epr.getAddress());
                        String path = targetURL.getPath();
                        cm.setCookies(cookie, cookie2, path);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "receiveSOAPResponse(): msgContext = " + this.msgContext.toString() + " SessionContext = " + cm);
                        }
                        if (cookieMap == null) {
                            cookieMap = new CookieMap();
                            sc.setProperty("Cookie", cookieMap);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Inserting HTTPCookieManager instance: " + cm + " with key: " + key);
                        }
                        cookieMap.put(key, cm);
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "ServiceContext is null. Not setting the cookies");
                    }
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender.processResponseHeader", "2577", this);
                if (!_tc.isDebugEnabled()) break block30;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processResponseHeader()");
        }
    }

    private void processStatusCode(int returnSC, String contentType) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "processStatusCode");
        }
        String string = contentType = null == contentType ? null : contentType.trim();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "returnSC : " + returnSC + " contentType : " + contentType + " soap 11 : " + (this.msgContext.isSOAP11() ? "true" : "false"));
        }
        if (returnSC <= 199 || returnSC >= 300) {
            if (contentType != null && !contentType.startsWith("text/html") && returnSC > 399 && returnSC < 600 && !this.msgContext.isSOAP11()) {
                if (InvocationPatternHelper.isOneWayInvocation(this.msgContext)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Encountered an error on one-way invocation");
                    }
                    String statusMessage = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    AxisFault fault = new AxisFault("HTTP ( " + returnSC + " ) " + statusMessage + " address : " + this.addrToConnect.toString());
                    throw fault;
                }
            } else if (contentType != null && !contentType.startsWith("text/html") && returnSC > 499 && returnSC < 600 && this.msgContext.isSOAP11()) {
                if (InvocationPatternHelper.isOneWayInvocation(this.msgContext)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Encountered an error on one-way invocation");
                    }
                    String statusMessage = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    AxisFault fault = new AxisFault("HTTP ( " + returnSC + " ) " + statusMessage + " address : " + this.addrToConnect.toString());
                    throw fault;
                }
            } else {
                if (returnSC == 404) {
                    String statusMessage = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    throw new ConnectException("HTTP ( " + returnSC + " ) " + statusMessage + " address : " + this.addrToConnect.toString());
                }
                String statusMessage = (String)this.msgContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                AxisFault fault = new AxisFault("HTTP ( " + returnSC + " ) " + statusMessage + " address : " + this.addrToConnect.toString());
                throw fault;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "processStatusCode");
        }
    }

    private static Map getConfiguredTransportHeaders(MessageContext mc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConfiguredTransportHeaders");
        }
        Map configuredMap = null;
        Map axis2TransportHeaders = (Map)mc.getProperty("TRANSPORT_HEADERS");
        Map jaxrpcTransportHeaders = (Map)mc.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
        boolean hasAxis2TransportHeaders = false;
        boolean hasJAXRPCTransportHeaders = false;
        if (axis2TransportHeaders != null && axis2TransportHeaders.size() > 0) {
            hasAxis2TransportHeaders = true;
            if (_tc.isDebugEnabled()) {
                for (Map.Entry entry : axis2TransportHeaders.entrySet()) {
                    Tr.debug(_tc, "  Engine TransportHeaderEntry: key=" + entry.getKey() + " value=" + entry.getValue());
                }
            }
        }
        if (jaxrpcTransportHeaders != null && jaxrpcTransportHeaders.size() > 0) {
            hasJAXRPCTransportHeaders = true;
            if (_tc.isDebugEnabled()) {
                for (Map.Entry entry : jaxrpcTransportHeaders.entrySet()) {
                    Tr.debug(_tc, "  JAX-RPC TransportHeaderEntry: key=" + entry.getKey() + " value=" + entry.getValue());
                }
            }
        }
        if (!hasAxis2TransportHeaders && !hasJAXRPCTransportHeaders) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "There are no configured transport headers.  An empty map is returned.");
            }
            configuredMap = new HashMap();
        } else if (hasAxis2TransportHeaders && !hasJAXRPCTransportHeaders) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Engine configured transport headers are detected.  The engine map is returned.");
            }
            configuredMap = axis2TransportHeaders;
        } else if (!hasAxis2TransportHeaders && hasJAXRPCTransportHeaders) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "JAX-RPC configured transport headers are detected.  The JAX-RPC map is returned");
            }
            configuredMap = jaxrpcTransportHeaders;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Engine and JAX-RPC configured transport headers are detected.  A map with the combined headers is returned.If a header exists in both maps, the one in the engine is used.The customer should be using JAX-WS transport headers for JAX-WS applications.");
            }
            configuredMap = new HashMap();
            configuredMap.putAll(jaxrpcTransportHeaders);
            configuredMap.putAll(axis2TransportHeaders);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConfiguredTransportHeaders");
        }
        return configuredMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traceResponse(MessageContext msgContext, String contentType, byte[] messageBytes) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceResponse");
        }
        String str = null;
        String mep = msgContext.getAxisOperation() != null ? msgContext.getAxisOperation().getMessageExchangePattern() : null;
        str = "http://www.w3.org/2006/01/wsdl/out-in".equals(mep) || "http://www.w3.org/2004/08/wsdl/out-in".equals(mep) || "http://www.w3.org/2006/01/wsdl/out-only".equals(mep) || "http://www.w3.org/2004/08/wsdl/out-only".equals(mep) || "http://www.w3.org/ns/wsdl/out-in".equals(mep) || "http://www.w3.org/ns/wsdl/out-only".equals(mep) ? new String("OUTBOUND_HTTP_REQUEST") : new String("OUTBOUND_HTTP_RESPONSE");
        try {
            try {
                String bytes = new String(messageBytes);
                bytes = bytes.trim();
                if (bytes != null) {
                    messageBytes = bytes.getBytes();
                }
                MessageTrace.log(str, contentType, messageBytes);
            }
            catch (Throwable t) {
                Tr.debug(_tc, "Response message could not be traced because of the following error: " + t.toString());
                Object var8_9 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit(_tc, "traceResponse");
                return;
            }
            Object var8_8 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "traceResponse");
            throw throwable;
        }
        Tr.exit(_tc, "traceResponse");
    }

    static {
        RESTOREOLD202BEHAVIOR = Boolean.valueOf(System.getProperty("com.ibm.websphere.webservices.http.disable202Handling", "false"));
    }

    class BAOS
    extends ByteArrayOutputStream {
        public BAOS() {
        }

        public BAOS(int size) {
            super(size);
        }

        public byte[] getBytes() {
            return this.buf;
        }

        public int getByteCount() {
            return this.count;
        }

        public InputStream getInputStream() {
            ByteArrayInputStream in = new ByteArrayInputStream(this.buf);
            return in;
        }
    }
}

