/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.ws.websvcs.transport.http.HttpResponseImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.ArrayList;

public class HttpWriteCallback
implements InterChannelCallback {
    private static final TraceComponent _tc = Tr.register(HttpWriteCallback.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AsyncInResponseConnLink link = null;
    private HttpInboundServiceContext httpInSC = null;
    private HttpResponseImpl response = null;
    private ArrayList writeQueue = new ArrayList();
    private boolean writing = false;
    private boolean doClose = false;

    public void init(AsyncInResponseConnLink _link, HttpInboundServiceContext _httpInSC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        this.link = _link;
        this.httpInSC = _httpInSC;
        this.response = this.link.getResponse();
        this.doClose = false;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    public int getBufferSize() {
        return this.link.getChannel().getBufferSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection vc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "complete");
        }
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            if (!this.writeQueue.isEmpty()) {
                WsByteBuffer[] oldBuffer = (WsByteBuffer[])this.writeQueue.remove(0);
                this.releaseByteBuffers(oldBuffer);
            }
            if (this.writeQueue.isEmpty()) {
                this.writing = false;
                if (this.doClose) {
                    this.link.close(vc, null);
                }
            } else {
                WsByteBuffer[] buffer = (WsByteBuffer[])this.writeQueue.get(0);
                if (this.doClose && this.writeQueue.isEmpty()) {
                    this.finishBufferAsynch(buffer);
                } else {
                    this.writeBufferAsynch(buffer);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "complete");
        }
    }

    public void error(VirtualConnection vc, Throwable t) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "error");
        }
        Tr.error(_tc, "caughtException7", t);
        this.link.close(vc, null);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishResponse() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "finishResponse");
        }
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            this.doClose = true;
            if (this.writeQueue.isEmpty() && !this.response.hasContentBuffered()) {
                this.finishBufferAsynch(null);
            } else if (this.response.hasContentBuffered()) {
                this.response.flushBufferedContent();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "finishResponse");
        }
    }

    private void releaseByteBuffers(WsByteBuffer[] buffers) {
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i].release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffer(WsByteBuffer[] buffer) {
        if (buffer != null) {
            ArrayList arrayList = this.writeQueue;
            synchronized (arrayList) {
                if (this.writeQueue.isEmpty() && !this.writing) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Direct write");
                    }
                    this.writeQueue.add(buffer);
                    if (this.doClose) {
                        this.finishBufferAsynch(buffer);
                    } else {
                        this.writeBufferAsynch(buffer);
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding to queue");
                    }
                    this.writeQueue.add(buffer);
                }
            }
        }
    }

    private void writeBufferAsynch(WsByteBuffer[] buffer) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Write");
        }
        this.writing = true;
        try {
            VirtualConnection vc = this.httpInSC.sendResponseBody(buffer, this, false);
            if (vc != null) {
                this.complete(vc);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.HttpWriteCallback.writeBufferAsynch", "233", this);
            e.printStackTrace();
        }
    }

    private void finishBufferAsynch(WsByteBuffer[] buffer) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Finish");
        }
        this.writing = true;
        try {
            VirtualConnection vc = null;
            vc = this.httpInSC.finishResponseMessage(buffer, this, false);
            if (vc != null) {
                this.complete(vc);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.HttpWriteCallback.finishBufferAsynch", "258", this);
            e.printStackTrace();
        }
    }
}

