/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.ws.websvcs.transport.TransportResponse;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.ws.websvcs.transport.http.HttpByteBufferOutputStream;
import com.ibm.ws.websvcs.transport.http.HttpRequestImpl;
import com.ibm.ws.websvcs.transport.http.HttpWriteCallback;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.Cookie;

public class HttpResponseImpl
implements TransportResponse {
    private HttpResponseMessage response = null;
    private HttpRequestImpl request = null;
    private HttpByteBufferOutputStream bbOS = null;
    private HttpWriteCallback writeCB = null;
    private boolean statusSet = false;

    public void init(AsyncInResponseConnLink _link, HttpInboundServiceContext _isc, HttpWriteCallback _writeCB) {
        this.writeCB = _writeCB;
        this.request = _link.getRequest();
        this.response = _isc.getResponse();
        this.bbOS = new HttpByteBufferOutputStream(_isc, _writeCB);
    }

    public void setStatusCode(int code) {
        try {
            if (!this.statusSet) {
                this.response.setStatusCode(code);
                this.statusSet = true;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.HttpResponseImpl.setStatusCode", "94", this);
            e.printStackTrace();
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.bbOS;
    }

    public boolean isCommitted() {
        return false;
    }

    public boolean hasContentBuffered() {
        return this.bbOS.hasContentBuffered();
    }

    public void flushBufferedContent() {
        this.bbOS.flushWriteBuffer();
    }

    public void addHeader(String name, String value) {
        this.response.appendHeader(name, value);
    }

    public void addHeader(byte[] name, byte[] value) {
        this.response.appendHeader(name, value);
    }

    public void addDateHeader(String name, long t) {
        this.addHeader(name, Long.toString(t));
    }

    public void addIntHeader(String name, int i) {
        this.addHeader(name, Integer.toString(i));
    }

    public void setDateHeader(String name, long t) {
        HttpDate d = new HttpDate(t);
        this.setHeader(name, d.toString());
    }

    public void setIntHeader(String name, int i) {
        this.setHeader(name, Integer.toString(i));
    }

    public String getHeader(String name) {
        return this.response.getHeaderAsString(name);
    }

    public String getHeader(byte[] name) {
        return this.response.getHeaderAsString(name);
    }

    public boolean containsHeader(String name) {
        return this.response.containsHeader(name);
    }

    public boolean containsHeader(byte[] name) {
        return this.response.containsHeader(name);
    }

    public void removeHeader(String name) {
        this.response.removeHeader(name);
    }

    public void removeHeader(byte[] name) {
        this.response.removeHeader(name);
    }

    public HttpRequestImpl getRequest() {
        return this.request;
    }

    public void setFlushMode(boolean flushToWire) {
        this.bbOS.setFlushMode(flushToWire);
    }

    public void setReason(String reason) {
        this.response.setReasonPhrase(reason);
    }

    public void setReason(byte[] reason) {
        this.response.setReasonPhrase(reason);
    }

    public void addCookie(Cookie cookie) {
        if (cookie.getVersion() == 1) {
            this.response.setCookie(cookie, HttpConstants.HDR_SET_COOKIE2);
        }
        this.response.setCookie(cookie, HttpConstants.HDR_SET_COOKIE);
    }

    public Cookie[] getCookies() {
        List<Cookie> l = this.response.getAllCookies();
        if (l == null || l.isEmpty()) {
            return null;
        }
        Cookie[] cookies = new Cookie[l.size()];
        l.toArray(cookies);
        return cookies;
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setHeader(byte[] name, byte[] value) {
        this.response.setHeader(name, value);
    }

    public void setContentType(String value) {
        this.response.setHeader((HeaderKeys)HttpConstants.HDR_CONTENT_TYPE, value);
    }

    public void setContentLength(int value) {
        this.response.setContentLength(value);
    }

    public void finishResponse() {
        this.flushBufferedContent();
        this.writeCB.finishResponse();
    }

    public void clearStatusCode() {
        this.statusSet = false;
    }
}

