/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ws.webcontainer.srt.http.HttpDate;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.ws.websvcs.transport.TransportRequest;
import com.ibm.ws.websvcs.transport.http.HttpResponseImpl;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class HttpRequestImpl
implements TransportRequest {
    private HttpInboundServiceContext isc = null;
    private HttpRequestMessage httpChannelrequest = null;
    private HttpResponseImpl response = null;
    private String serverName = null;
    private int serverPort = -1;
    private InputStream bbIS = null;

    public void init(HttpInboundServiceContext _isc, InputStream in, HttpResponseImpl _response) {
        this.isc = _isc;
        this.response = _response;
        this.httpChannelrequest = this.isc.getRequest();
        this.bbIS = in;
    }

    public String getMethod() {
        return this.httpChannelrequest.getMethod();
    }

    public String getRequestURI() {
        return this.httpChannelrequest.getRequestURI();
    }

    public String getRequestPathInfo() {
        String requestURI = this.httpChannelrequest.getRequestURI();
        String pathInfo = requestURI.substring(requestURI.indexOf("/", 1));
        return pathInfo;
    }

    public String getRequestURLAsString() {
        return this.httpChannelrequest.getRequestURLAsString();
    }

    public String getRemoteUser() {
        return this.httpChannelrequest.getHeaderAsString(HttpConstants.HDR_$WSRU);
    }

    public String getAuthType() {
        return this.httpChannelrequest.getHeaderAsString(HttpConstants.HDR_$WSAT);
    }

    public String getHeader(String headerName) {
        return this.httpChannelrequest.getHeaderAsString(headerName);
    }

    public Enumeration getHeaders(String headerName) {
        Vector v = this.httpChannelrequest.getHeaderStringValues(headerName);
        if (v == null || v.isEmpty()) {
            return new ArrayEnumeration(null);
        }
        return v.elements();
    }

    public long getDateHeader(String name) {
        HttpDate date = new HttpDate();
        String dateString = this.httpChannelrequest.getHeaderAsString(name);
        if (dateString == null) {
            return -1L;
        }
        date.parse(dateString);
        return date.getTime();
    }

    public int getIntHeader(String name) {
        String intString = this.httpChannelrequest.getHeaderAsString(name);
        if (intString == null) {
            return -1;
        }
        return Integer.parseInt(intString);
    }

    public void clearHeaders() {
    }

    public Enumeration getHeaderNames() {
        return this.httpChannelrequest.getAllHeaders().elements();
    }

    public int getContentLength() {
        return this.httpChannelrequest.getContentLength();
    }

    public String getContentType() {
        return this.httpChannelrequest.getHeaderAsString(HttpConstants.HDR_CONTENT_TYPE);
    }

    public String getProtocol() {
        return this.httpChannelrequest.getVersion();
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.httpChannelrequest.getVirtualHost();
            if (this.serverName == null) {
                this.serverName = new String("localhost");
            }
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == -1) {
            this.serverPort = this.httpChannelrequest.getVirtualPort();
            if (this.serverPort == -1) {
                this.serverPort = 80;
            }
        }
        return this.serverPort;
    }

    public String getRemoteHost() {
        return this.isc.getRemoteAddr().getCanonicalHostName();
    }

    public String getRemoteAddr() {
        return this.isc.getRemoteAddr().getHostAddress();
    }

    public int getRemotePort() {
        return this.isc.getRemotePort();
    }

    public String getScheme() {
        return this.httpChannelrequest.getScheme();
    }

    public InputStream getInputStream() throws IOException {
        return this.bbIS;
    }

    public String getLocalAddr() {
        return this.isc.getLocalAddr().getCanonicalHostName();
    }

    public String getLocalName() {
        return this.isc.getLocalAddr().getHostAddress();
    }

    public int getLocalPort() {
        return this.isc.getLocalPort();
    }

    public boolean isSSL() {
        return this.isc.isSecure();
    }

    public byte[] getSSLSessionID() {
        return null;
    }

    public String getSessionID() {
        return null;
    }

    public HttpResponseImpl getResponse() {
        return this.response;
    }

    public String getCipherSuite() {
        return null;
    }

    public Cookie[] getCookies() {
        List<Cookie> l = this.httpChannelrequest.getAllCookies();
        if (l == null || l.isEmpty()) {
            return null;
        }
        Cookie[] cookies = new Cookie[l.size()];
        Cookie[] toArray = l.toArray(cookies);
        return cookies;
    }
}

