/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.transport.AsyncResponseConnection;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import java.security.PrivilegedAction;

public class HttpOneWayConnection
extends AsyncResponseConnection {
    private static final TraceComponent _tc = Tr.register(HttpOneWayConnection.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public HttpOneWayConnection(HTTPConnection conn, String key, long time) {
        this.connection = conn;
        this.hashKey = key;
        this.recycleTime = time;
        this.oCache = (OutboundConnectionCache)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return OutboundConnectionCache.getInstance();
            }
        });
    }

    public void resetConnection() {
        block6: {
            try {
                if (this.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "HttpOneWayConnection.resetConnection(). Connection Reset invoked for connection : " + this.connection);
                    }
                    this.connection.reset();
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOneWayConnection.resetConnection(). Connection is null");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.HttpOneWayConnection.resetConnection", "90", this);
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
    }

    public void disconnectConnection() {
        block6: {
            try {
                if (this.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "HttpOneWayConnection.disconnectConnection(). Connection Disconnect invoked for connection : " + this.connection);
                    }
                    this.connection.disconnect(null);
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpOneWayConnection.disconnectConnection(). Connection is null");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.HttpOneWayConnection.disconnectConnection", "126", this);
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
    }
}

