/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.Axis2ServiceConfigPluginBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

public class HttpConfigPlugin
extends Axis2ServiceConfigPluginBase {
    private static final TraceComponent _tc = Tr.register(HttpConfigPlugin.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void config(HashMap hm) throws AxisFault {
        AxisService service;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpConfigPlugin.config()...", hm);
        }
        if ((service = (AxisService)hm.get("com.ibm.wsspi.websvcs.AxisServiceKey")) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AxisService found: " + service);
            }
            QName serviceQName = Axis2Utils.getServiceQName(service);
            String serviceQNameString = "";
            if (serviceQName != null) {
                serviceQNameString = serviceQName.toString();
            }
            String resourceKey = "WebService:/" + serviceQNameString;
            String portName = Axis2Utils.getPortName(service);
            resourceKey = resourceKey + "/" + portName + "/";
            Iterator operIter = service.getOperations();
            PolicySetConfiguration policySet = null;
            while (operIter.hasNext()) {
                AxisOperation operation = (AxisOperation)operIter.next();
                QName operationName = operation.getName();
                String operResourceKey = resourceKey + operationName.getLocalPart();
                policySet = (PolicySetConfiguration)Axis2Utils.getPolicySet(operation);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "    Policy Set found for operation " + operationName + " using key '" + operResourceKey + "'.");
                }
                if (policySet == null) continue;
                Properties type = (Properties)policySet.getPolicyTypeConfiguration("HTTP_POLICY");
                Properties bind = (Properties)policySet.getPolicyTypeBinding("HTTP_BINDING");
                if (type != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "    Policy Type found for operation " + operationName + " using key '" + operResourceKey + "'.");
                }
                if (bind == null || !_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "    Policy Binding found for operation " + operationName + " using key '" + operResourceKey + "'.");
            }
            Parameter configParam = service.getParameter("WASAxis2PolicySet");
            if (configParam != null && configParam.getValue() != null && (policySet = (PolicySetConfiguration)configParam.getValue()) != null) {
                Properties type = (Properties)policySet.getPolicyTypeConfiguration("HTTP_POLICY");
                Properties bind = (Properties)policySet.getPolicyTypeBinding("HTTP_BINDING");
                if (type != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "    Policy Type found for service " + service + "'.");
                }
                if (bind != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "    Policy Binding found for service " + service + "'.");
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpConfigPlugin.config()");
        }
    }
}

