/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.transport.AsyncResponseConnection;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import java.security.PrivilegedAction;

public class HttpAsyncResponseConnection
extends AsyncResponseConnection {
    private static final TraceComponent _tc = Tr.register(HttpAsyncResponseConnection.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public HttpAsyncResponseConnection(HTTPConnection conn, String key) {
        this.connection = conn;
        this.hashKey = key;
        this.oCache = (OutboundConnectionCache)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return OutboundConnectionCache.getInstance();
            }
        });
    }

    public void resetConnection() {
        block6: {
            try {
                if (this.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "HttpAsyncResponseConnection.resetConnection(). Connection Reset invoked for connection : " + this.connection);
                    }
                    this.connection.reset();
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpAsyncResponseConnection.resetConnection(). Connection is null");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.HttpAsyncResponseConnection.resetConnection", "90", this);
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
    }

    public void disconnectConnection() {
        block6: {
            try {
                if (this.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "HttpAsyncResponseConnection.disconnectConnection(). Connection Disconnect invoked for connection : " + this.connection);
                    }
                    this.connection.disconnect(null);
                    this.oCache.findGroupAndReturnConnection(this.connection);
                    this.connection = null;
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpAsyncResponseConnection.disconnectConnection(). Connection is null");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.HttpAsyncResponseConnection.disconnectConnection", "119", this);
                if (!_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
    }
}

