/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.metadata.WASAxis2MetaDataImpl;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.LogFilterInputStream;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.AsyncResponseConnection;
import com.ibm.ws.websvcs.transport.AsyncResponseConnectionMap;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.http.HttpAsyncResponseContext;
import com.ibm.ws.websvcs.transport.http.UnknownEPRConfigCtxtLoaderPluginMgr;
import com.ibm.ws.websvcs.transport.http.UnknownEPRResolverPluginMgr;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.UUIDGenerator;

public class AsyncResponseServlet
extends HttpServlet
implements Constants {
    private static final TraceComponent _tc = Tr.register(AsyncResponseServlet.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected transient ServletConfig servletConfig;
    private transient String contextPath = null;
    private String SERVICE_PATH = "services";
    private AsyncResponseContextMap asrcMap = null;
    private AsyncResponseConnectionMap aRConnMap = null;
    private UnknownEPRResolverPluginMgr resolverPlugin = null;
    private UnknownEPRConfigCtxtLoaderPluginMgr ccLoaderPlugin = null;
    private static AsyncResponseServlet myself = null;
    private static boolean started = false;
    private static Map configuredHttpHostAndPorts = null;
    private static Map configuredHttpsHostAndPorts = null;
    private static Vector virtualHostsAssociated = null;
    private static String virtualHostName = null;
    private static String associatedHttpPort = "9080";
    private static String associatedHttpsPort = "9443";

    public static void setHttpHostandPorts(Map in_Arr) {
        if (configuredHttpHostAndPorts == null) {
            configuredHttpHostAndPorts = in_Arr;
        }
    }

    public static void setHttpsHostandPorts(Map in_Arr) {
        if (configuredHttpsHostAndPorts == null) {
            configuredHttpsHostAndPorts = in_Arr;
        }
    }

    public static void setVirtualHostAssociated(List theList) {
        Tr.debug(_tc, "virtual host list: " + theList);
        if (virtualHostsAssociated == null) {
            virtualHostsAssociated = new Vector();
            for (int i = 0; i < theList.size(); ++i) {
                String value = (String)theList.get(i);
                virtualHostsAssociated.add(value.substring(value.indexOf(":") + 1, value.length()));
            }
        }
    }

    public static void setVirtualHostName(String vName) {
        virtualHostName = vName;
    }

    public AsyncResponseServlet() {
        myself = this;
        this.resolverPlugin = new UnknownEPRResolverPluginMgr();
        this.ccLoaderPlugin = new UnknownEPRConfigCtxtLoaderPluginMgr();
    }

    public void init() throws ServletException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.init()...");
        }
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        } else if (_tc.isEntryEnabled()) {
            Tr.event(_tc, "servletConfig is: " + this.servletConfig);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.init()");
        }
    }

    public static AsyncResponseServlet getInstance() {
        return myself;
    }

    public boolean isStarted() {
        return started;
    }

    public void init(ServletConfig config2) throws ServletException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.init(ServletConfig)...");
        }
        try {
            Object key;
            Integer element;
            Iterator it;
            int i;
            Integer portvalue;
            boolean found;
            this.contextPath = config2.getServletContext().getServletContextName();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Current context path: " + this.contextPath);
            }
            if (this.asrcMap == null) {
                this.asrcMap = AsyncResponseContextMap.getInstance();
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Using async response context map: " + this.asrcMap);
            }
            if (this.aRConnMap == null) {
                this.aRConnMap = AsyncResponseConnectionMap.getInstance();
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Using async response connection map: " + this.aRConnMap);
            }
            this.servletConfig = config2;
            if (configuredHttpHostAndPorts != null && !configuredHttpHostAndPorts.isEmpty() && JavaUtils.hasValue(virtualHostName)) {
                Tr.event(_tc, "virtualHostName: " + virtualHostName);
                found = false;
                portvalue = (Integer)configuredHttpHostAndPorts.get(virtualHostName);
                if (portvalue == null) {
                    for (i = 0; i < virtualHostsAssociated.size(); ++i) {
                        Tr.event(_tc, "virtualHostsAssociated: " + virtualHostsAssociated.get(i));
                        Tr.event(_tc, "configuredHttpHostAndPorts: " + configuredHttpHostAndPorts);
                        it = configuredHttpHostAndPorts.keySet().iterator();
                        element = null;
                        while (it.hasNext()) {
                            key = it.next();
                            element = (Integer)configuredHttpHostAndPorts.get(key);
                            Tr.event(_tc, "\n element: " + element);
                            if (!element.toString().equals(virtualHostsAssociated.get(i))) continue;
                            associatedHttpPort = (String)virtualHostsAssociated.get(i);
                            Tr.event(_tc, "associatedHttpPort: " + associatedHttpPort);
                            found = true;
                            break;
                        }
                        if (!found) {
                            continue;
                        }
                        break;
                    }
                } else {
                    associatedHttpPort = portvalue.toString();
                    Tr.event(_tc, "associatedHttpPort: " + associatedHttpPort);
                }
            }
            if (configuredHttpsHostAndPorts != null && !configuredHttpsHostAndPorts.isEmpty() && JavaUtils.hasValue(virtualHostName)) {
                Tr.event(_tc, "virtualHostName: " + virtualHostName);
                found = false;
                portvalue = (Integer)configuredHttpsHostAndPorts.get(virtualHostName);
                if (portvalue == null) {
                    for (i = 0; i < virtualHostsAssociated.size(); ++i) {
                        Tr.event(_tc, "virtualHostsAssociated: " + virtualHostsAssociated.get(i));
                        Tr.event(_tc, "configuredHttpsHostAndPorts: " + configuredHttpsHostAndPorts);
                        it = configuredHttpsHostAndPorts.keySet().iterator();
                        element = null;
                        while (it.hasNext()) {
                            key = it.next();
                            element = (Integer)configuredHttpsHostAndPorts.get(key);
                            Tr.event(_tc, "\n element: " + element);
                            if (!element.toString().equals(virtualHostsAssociated.get(i))) continue;
                            associatedHttpsPort = (String)virtualHostsAssociated.get(i);
                            Tr.event(_tc, "associatedHttpsPort: " + associatedHttpsPort);
                            found = true;
                            break;
                        }
                        if (!found) {
                            continue;
                        }
                        break;
                    }
                } else {
                    associatedHttpsPort = portvalue.toString();
                    Tr.event(_tc, "associatedHttpsPort: " + associatedHttpsPort);
                }
            }
            this.resolverPlugin.discoverUnknownEPRResolverPlugins();
            this.ccLoaderPlugin.discoverUnknownEPRConfigCtxtLoaderPlugins();
            started = true;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass().getName(), "361", this);
            Tr.error(_tc, "initServletFail00", e);
            throw new ServletException(e);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.init(ServletConfig)");
        }
    }

    public void init(ConfigurationContext arg0, TransportInDescription arg1) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.init(ConfigurationContex,TransportInDescription)...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.init(ConfigurationContex,TransportInDescription)");
        }
    }

    public void start() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.start()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.start()");
        }
    }

    public void stop() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.stop()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.stop()");
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip, boolean forSSL) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.getEPRForService()... serviceName : " + serviceName + " ip : " + ip + " SSL : " + forSSL);
        }
        Object epr = null;
        String appName = "";
        String moduleName = "";
        try {
            J2EEName jName;
            WASAxis2MetaDataImpl mdi;
            if (!Axis2Utils.isThinClientEnv() && (mdi = new WASAxis2MetaDataImpl(null)).getComponentMetaData() != null && (jName = mdi.getComponentMetaData().getJ2EEName()) != null) {
                appName = jName.getApplication();
                moduleName = jName.getModule();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AppName: " + appName + ", ModuleName: " + moduleName);
            }
        }
        catch (Throwable t) {
            appName = "";
            moduleName = "";
            Object[] inserts = new Object[]{t};
            Tr.error(_tc, "caughtException", inserts);
        }
        try {
            if (ip == null) {
                boolean result = false;
                String transportEPRInIPAddr = System.getProperty("com.ibm.websphere.webservices.transportEPRInIPAddr");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "com.ibm.websphere.webservices.transportEPRInIPAddr: " + transportEPRInIPAddr);
                }
                if (JavaUtils.hasValue(transportEPRInIPAddr) && transportEPRInIPAddr.equalsIgnoreCase("yes")) {
                    result = true;
                }
                if (result) {
                    InetAddress localHost = InetAddress.getLocalHost();
                    ip = localHost.getHostAddress();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "localAddress from getLocalHost(): " + ip);
                    }
                }
                if (ip == null && (ip = InetAddress.getLocalHost().getCanonicalHostName()) == null) {
                    ip = "localhost";
                }
                if (ip != null) {
                    ip = ip.toLowerCase();
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "ip : " + ip);
                }
            }
        }
        catch (UnknownHostException ex) {
            FFDCFilter.processException((Throwable)ex, this.getClass().getName(), "511", this);
            if (_tc.isWarningEnabled()) {
                Tr.warning(_tc, JavaUtils.stackToString(ex));
            }
            ip = "localhost";
        }
        String port = associatedHttpPort;
        if (forSSL) {
            port = associatedHttpsPort;
        }
        this.contextPath = "/IBM_WS_SYS_RESPONSESERVLET";
        if (this.contextPath == null) {
            try {
                String[] array = this.servletConfig.getServletContext().getResource("/").toString().split("/");
                this.contextPath = array[array.length - 1];
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName(), "532", this);
            }
            if (this.contextPath == null) {
                this.contextPath = "/IBM_WS_SYS_RESPONSESERVLET";
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "contextPath: " + this.contextPath);
        }
        String eprString = null;
        if (ip != null) {
            eprString = forSSL ? "https://" + ip + ":" + port + this.contextPath + "/" + appName + ":" + moduleName + "/" + this.SERVICE_PATH + "/" + serviceName : "http://" + ip + ":" + port + this.contextPath + "/" + appName + ":" + moduleName + "/" + this.SERVICE_PATH + "/" + serviceName;
        } else {
            throw new AxisFault("Host address: " + ip + " has not been established yet. Cannot generate EPR.");
        }
        AsyncEPRSet.addEPRtoSet(eprString);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Returning EPR with URI: " + eprString);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.getEPRForService()");
        }
        return new EndpointReference(eprString);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip, boolean forSSL) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.getEPRsForService()... serviceName : " + serviceName + " ip : " + ip + " SSL : " + forSSL);
        }
        Object epr = null;
        EndpointReference[] eprs = new EndpointReference[1];
        String appName = "";
        String moduleName = "";
        try {
            J2EEName jName;
            WASAxis2MetaDataImpl mdi;
            if (!Axis2Utils.isThinClientEnv() && (mdi = new WASAxis2MetaDataImpl(null)).getComponentMetaData() != null && (jName = mdi.getComponentMetaData().getJ2EEName()) != null) {
                appName = jName.getApplication();
                moduleName = jName.getModule();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AppName: " + appName + ", ModuleName: " + moduleName);
            }
        }
        catch (Throwable t) {
            appName = "";
            moduleName = "";
            Object[] inserts = new Object[]{t};
            Tr.error(_tc, "caughtException", inserts);
        }
        try {
            if (ip == null) {
                boolean result = false;
                String transportEPRInIPAddr = System.getProperty("com.ibm.websphere.webservices.transportEPRInIPAddr");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "com.ibm.websphere.webservices.transportEPRInIPAddr: " + transportEPRInIPAddr);
                }
                if (JavaUtils.hasValue(transportEPRInIPAddr) && transportEPRInIPAddr.equalsIgnoreCase("yes")) {
                    result = true;
                }
                if (result) {
                    InetAddress localHost = InetAddress.getLocalHost();
                    ip = localHost.getHostAddress();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "localAddress from getLocalHost(): " + ip);
                    }
                }
                if (ip == null && (ip = InetAddress.getLocalHost().getCanonicalHostName()) == null) {
                    ip = "localhost";
                }
                if (ip != null) {
                    ip = ip.toLowerCase();
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "ip : " + ip);
                }
            }
        }
        catch (UnknownHostException ex) {
            FFDCFilter.processException((Throwable)ex, this.getClass().getName(), "660", this);
            if (_tc.isWarningEnabled()) {
                Tr.warning(_tc, JavaUtils.stackToString(ex));
            }
            ip = "localhost";
        }
        String port = associatedHttpPort;
        if (forSSL) {
            port = associatedHttpsPort;
        }
        this.contextPath = "/IBM_WS_SYS_RESPONSESERVLET";
        if (this.contextPath == null) {
            try {
                String[] array = this.servletConfig.getServletContext().getResource("/").toString().split("/");
                this.contextPath = array[array.length - 1];
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName(), "680", this);
            }
            if (this.contextPath == null) {
                this.contextPath = "/IBM_WS_SYS_RESPONSESERVLET";
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "contextPath: " + this.contextPath);
        }
        String eprString = null;
        if (ip != null) {
            eprString = forSSL ? "https://" + ip + ":" + port + this.contextPath + "/" + appName + ":" + moduleName + "/" + this.SERVICE_PATH + "/" + serviceName : "http://" + ip + ":" + port + this.contextPath + "/" + appName + ":" + moduleName + "/" + this.SERVICE_PATH + "/" + serviceName;
        } else {
            throw new AxisFault("Host address: " + ip + " has not been established yet. Cannot generate EPR.");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Returning EPR with URI: " + eprString);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.getEPRsForService()");
        }
        AsyncEPRSet.addEPRtoSet(eprString);
        eprs[0] = new EndpointReference(eprString);
        return eprs;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.doGet()...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Async response is not expected via GET method.");
        }
        resp.sendError(HttpConstants.STATUS_BAD_METHOD.getIntCode());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseServlet.doGet()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block72: {
            String hashKey2222;
            boolean exception;
            String endpoint;
            block73: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "AsyncResponseServlet.doPost()...");
                }
                MessageContext respMC = new MessageContext();
                boolean validResponse = true;
                endpoint = null;
                exception = false;
                try {
                    try {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Received message from: " + req.getRemoteAddr());
                        }
                        endpoint = req.getRequestURL().toString();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Query string from URL: " + endpoint);
                        }
                        if (endpoint != null) {
                            AxisService service = null;
                            ClassLoader cl = null;
                            ConfigurationContext configCtxt = null;
                            AsyncResponseContext rctxt = this.asrcMap.getContext(endpoint);
                            if (rctxt != null) {
                                configCtxt = rctxt.getConfCtxt();
                                service = rctxt.getAxisService();
                            } else {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Response context not in map, calling RM plugin...");
                                }
                                configCtxt = this.ccLoaderPlugin.getConfigurationContextForUnknownEPR(endpoint);
                                cl = this.ccLoaderPlugin.getClassLoaderForUnknownEPR(endpoint);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Config Context: " + configCtxt + ", " + "Axis Service: " + service + ", " + "ClassLoader: " + cl);
                            }
                            if (configCtxt != null && (cl != null || service != null)) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Handling response...");
                                }
                                respMC.setConfigurationContext(configCtxt);
                                AxisConfiguration axisConfiguration = configCtxt.getAxisConfiguration();
                                if (req.getScheme().equalsIgnoreCase("http")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("http"));
                                } else if (req.getScheme().equalsIgnoreCase("https")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("https"));
                                }
                                if (service == null) {
                                    rctxt = new HttpAsyncResponseContext(service, configCtxt, endpoint);
                                    rctxt.setClassLoader(cl);
                                }
                                this.handleWSResponse(req, res, rctxt);
                            } else {
                                validResponse = false;
                            }
                        } else {
                            validResponse = false;
                        }
                        if (!validResponse) {
                            if (_tc.isErrorEnabled()) {
                                Tr.error(_tc, "unknownAsyncRspCtxtId00", endpoint);
                            }
                            res.setStatus(400);
                            ConfigurationContext cc = ClientConfigurationFactory.newInstance().getClientConfigurationContext();
                            respMC.setConfigurationContext(cc);
                            AxisConfiguration axisConfiguration = cc.getAxisConfiguration();
                            if (req.getScheme().equalsIgnoreCase("http")) {
                                respMC.setTransportOut(axisConfiguration.getTransportOut("http"));
                            } else if (req.getScheme().equalsIgnoreCase("https")) {
                                respMC.setTransportOut(axisConfiguration.getTransportOut("https"));
                            }
                            Object[] inserts = new Object[]{endpoint};
                            String msg = NLSProvider.getNLS().getFormattedMessage("unknownAsyncRspCtxtId00", inserts, "The context ID {0} was received from an unknown asynchronous response.");
                            this.handleWSRespFault(respMC, res.getOutputStream(), new AxisFault(msg));
                        }
                    }
                    catch (AxisFault e) {
                        block70: {
                            FFDCFilter.processException((Throwable)e, this.getClass().getName(), "869", this);
                            if (_tc.isErrorEnabled()) {
                                Tr.error(_tc, JavaUtils.stackToString(e));
                            }
                            exception = true;
                            try {
                                res.setStatus(500);
                                AxisConfiguration axisConfiguration = respMC.getConfigurationContext().getAxisConfiguration();
                                if (req.getScheme().equalsIgnoreCase("http")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("http"));
                                } else if (req.getScheme().equalsIgnoreCase("https")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("https"));
                                }
                                this.handleWSRespFault(respMC, res.getOutputStream(), e);
                            }
                            catch (AxisFault e2) {
                                FFDCFilter.processException((Throwable)e2, this.getClass().getName(), "888", this);
                                if (!_tc.isErrorEnabled()) break block70;
                                Tr.error(_tc, JavaUtils.stackToString(e2));
                            }
                        }
                        Object var13_19 = null;
                        String hashKey2222 = req.getHeader("SAVECONNECTION");
                        if (hashKey2222 != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Cleaning up the connection");
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "SAVECONNECTION  key : " + hashKey2222);
                            }
                            AsyncResponseConnection rcconn = this.aRConnMap.getConnection(hashKey2222);
                            if (endpoint != null && rcconn != null) {
                                if (exception) {
                                    rcconn.disconnectConnection();
                                } else {
                                    rcconn.resetConnection();
                                }
                                this.aRConnMap.removeConnection(hashKey2222);
                            } else if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Response connection not in map");
                            }
                        }
                        if (!_tc.isEntryEnabled()) return;
                        Tr.exit(_tc, "...AsyncResponseServlet.doPost()");
                        return;
                    }
                    catch (Throwable t) {
                        block71: {
                            FFDCFilter.processException(t, this.getClass().getName(), "896", this);
                            if (_tc.isErrorEnabled()) {
                                Tr.error(_tc, JavaUtils.stackToString(t));
                            }
                            exception = true;
                            try {
                                res.setStatus(500);
                                AxisConfiguration axisConfiguration = respMC.getConfigurationContext().getAxisConfiguration();
                                if (req.getScheme().equalsIgnoreCase("http")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("http"));
                                } else if (req.getScheme().equalsIgnoreCase("https")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("https"));
                                }
                                this.handleWSRespFault(respMC, res.getOutputStream(), t);
                            }
                            catch (AxisFault e2) {
                                FFDCFilter.processException((Throwable)e2, this.getClass().getName(), "914", this);
                                if (!_tc.isErrorEnabled()) break block71;
                                Tr.error(_tc, JavaUtils.stackToString(e2));
                            }
                        }
                        Object var13_20 = null;
                        String hashKey2222 = req.getHeader("SAVECONNECTION");
                        if (hashKey2222 != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Cleaning up the connection");
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "SAVECONNECTION  key : " + hashKey2222);
                            }
                            AsyncResponseConnection rcconn = this.aRConnMap.getConnection(hashKey2222);
                            if (endpoint != null && rcconn != null) {
                                if (exception) {
                                    rcconn.disconnectConnection();
                                } else {
                                    rcconn.resetConnection();
                                }
                                this.aRConnMap.removeConnection(hashKey2222);
                            } else if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Response connection not in map");
                            }
                        }
                        if (!_tc.isEntryEnabled()) return;
                        Tr.exit(_tc, "...AsyncResponseServlet.doPost()");
                        return;
                    }
                    Object var13_18 = null;
                    hashKey2222 = req.getHeader("SAVECONNECTION");
                    if (hashKey2222 == null) break block72;
                    if (!_tc.isDebugEnabled()) break block73;
                }
                catch (Throwable throwable) {
                    Object var13_21 = null;
                    String hashKey2222 = req.getHeader("SAVECONNECTION");
                    if (hashKey2222 != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Cleaning up the connection");
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "SAVECONNECTION  key : " + hashKey2222);
                        }
                        AsyncResponseConnection rcconn = this.aRConnMap.getConnection(hashKey2222);
                        if (endpoint != null && rcconn != null) {
                            if (exception) {
                                rcconn.disconnectConnection();
                            } else {
                                rcconn.resetConnection();
                            }
                            this.aRConnMap.removeConnection(hashKey2222);
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Response connection not in map");
                        }
                    }
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "...AsyncResponseServlet.doPost()");
                    throw throwable;
                }
                Tr.debug(_tc, "Cleaning up the connection");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "SAVECONNECTION  key : " + hashKey2222);
            }
            AsyncResponseConnection rcconn = this.aRConnMap.getConnection(hashKey2222);
            if (endpoint != null && rcconn != null) {
                if (exception) {
                    rcconn.disconnectConnection();
                } else {
                    rcconn.resetConnection();
                }
                this.aRConnMap.removeConnection(hashKey2222);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Response connection not in map");
            }
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "...AsyncResponseServlet.doPost()");
    }

    protected void handleWSRespFault(MessageContext msgContext, OutputStream out, Throwable t) throws AxisFault {
        msgContext.setProperty("TRANSPORT_OUT", out);
        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, t);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Calling AxisEngine.sendFault()...");
        }
        AxisEngine.sendFault(faultContext);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Returned from AxisEngine.sendFault()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleWSResponse(HttpServletRequest request, HttpServletResponse response, AsyncResponseContext asRC) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseServlet.handleWSResponse()...");
        }
        ClassLoader previousLoader = null;
        if (asRC.getConfCtxt() != null) {
            try {
                void var15_18;
                Object sessionCtxt;
                boolean soap11 = false;
                MessageContext responseMC = new MessageContext();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting up message context...");
                }
                AxisConfiguration aConf = asRC.getConfCtxt().getAxisConfiguration();
                HttpSession session = request.getSession(false);
                if (session != null && (sessionCtxt = session.getAttribute("SessionContext")) == null) {
                    sessionCtxt = new SessionContext(null);
                    request.getSession().setAttribute("SessionContext", sessionCtxt);
                }
                if (request.getScheme().equalsIgnoreCase("http")) {
                    responseMC.setTransportIn(aConf.getTransportIn("http"));
                    responseMC.setTransportOut(aConf.getTransportOut("http"));
                }
                if (request.getScheme().equalsIgnoreCase("https")) {
                    responseMC.setTransportIn(aConf.getTransportIn("https"));
                    responseMC.setTransportOut(aConf.getTransportOut("https"));
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting incoming transport...");
                }
                responseMC.setIncomingTransportName("http");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Adding configuration context...");
                }
                responseMC.setConfigurationContext(asRC.getConfCtxt());
                responseMC.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(response));
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting service group context id...");
                }
                responseMC.setServiceGroupContextId(UUIDGenerator.getUUID());
                responseMC.setServerSide(true);
                responseMC.setProperty("TransportInURL", request.getRequestURL().toString());
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Setting up HTTP header hashMap...");
                }
                HashMap<String, String> tmpHM = new HashMap<String, String>();
                Enumeration tmpE = request.getHeaderNames();
                while (tmpE.hasMoreElements()) {
                    String value = (String)tmpE.nextElement();
                    tmpHM.put(value, request.getHeader(value));
                }
                responseMC.setProperty("TRANSPORT_HEADERS", tmpHM);
                responseMC.setProperty("SessionId", request.getSession().getId());
                responseMC.setProperty("TRANSPORT_OUT", response.getOutputStream());
                responseMC.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, request);
                String contentType = request.getContentType();
                String soapActionHeader = request.getHeader(HttpConstants.HDR_SOAPACTION.toString());
                responseMC.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, response);
                responseMC.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, this.servletConfig.getServletContext());
                previousLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(asRC.getClassLoader());
                String uri = request.getRequestURI();
                String localContextPath = asRC.getConfCtxt().getServiceContextPath();
                uri = uri.replaceAll("IBM_WS_SYS_RESPONSESERVLET/services", localContextPath);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "uri " + uri);
                }
                if (asRC.getAxisService() != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Axis Service set on message context.");
                    }
                    responseMC.setAxisService(asRC.getAxisService());
                }
                ServletInputStream servletInputStream = request.getInputStream();
                if (MessageTrace.isTraceEnabled()) {
                    try {
                        String str = new String("INBOUND_HTTP_RESPONSE");
                        LogFilterInputStream logFilterInputStream = new LogFilterInputStream(request.getInputStream(), _tc, 100000, str, contentType);
                    }
                    catch (Throwable t) {
                        Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                    }
                }
                HTTPTransportUtils.processHTTPPostRequest(responseMC, (InputStream)var15_18, response.getOutputStream(), contentType, soapActionHeader, uri);
                Object contextWritten = responseMC.getOperationContext() != null ? responseMC.getOperationContext().getProperty("RESPONSE_WRITTEN") : null;
                String responseContextType = contentType.indexOf(";") < 0 ? contentType : contentType.substring(0, contentType.indexOf(";"));
                responseContextType = responseContextType + "; charset=" + responseMC.getProperty("CHARACTER_SET_ENCODING");
                response.setContentType(responseContextType);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content type : " + response.getContentType());
                }
                if (contextWritten == null || !"true".equals(contextWritten)) {
                    response.setStatus(202);
                }
                response.setHeader("IBM-WAS-Reset-Connection", "TRUE");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Set the response header IBM-WAS-Reset-Connection to TRUE");
                }
                Object var19_22 = null;
                Thread.currentThread().setContextClassLoader(previousLoader);
                if (!_tc.isEntryEnabled()) return;
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                Thread.currentThread().setContextClassLoader(previousLoader);
                if (!_tc.isEntryEnabled()) throw throwable;
                Tr.exit(_tc, "...AsyncResponseServlet.handleWSResponse()");
                throw throwable;
            }
            Tr.exit(_tc, "...AsyncResponseServlet.handleWSResponse()");
            return;
        }
        String msg = NLSProvider.getNLS().getFormattedMessage("axisMsgCtxtNotFound00", new Object[0], "An Axis2 ConfigurationContext object was not found in the AsyncResponseContext object.");
        throw new AxisFault(msg);
    }

    public void removeCCFromRspMap(ConfigurationContext cc) {
        this.asrcMap.removeConfigCtxt(cc);
    }

    public SessionContext getSessionContext(MessageContext mc) {
        return null;
    }

    private void traceBytes(byte[] bytes, String contentType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceBytes");
        }
        if (bytes != null) {
            MessageTrace.log(MessageTrace.INBOUND_HTTP_RESPONSE, contentType, bytes);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "traceBytes");
        }
    }

    private byte[] extractRequestBytesForTrace(HttpServletRequest req, InputStream reqIs) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Start copying HTTP request to trace buffer");
        }
        byte[] reqBa = null;
        String lenStr = req.getHeader("Content-Length");
        if (lenStr != null) {
            int len;
            block13: {
                len = 0;
                try {
                    len = Integer.parseInt(lenStr);
                }
                catch (NumberFormatException e) {
                    if (!_tc.isDebugEnabled()) break block13;
                    Tr.debug(_tc, "Incoming request message to server could not be traced due to following error: " + e.toString());
                }
            }
            reqBa = new byte[len];
            int leftToRead = len;
            int offset = 0;
            while (leftToRead > 0) {
                int bytesRead = reqIs.read(reqBa, offset, leftToRead);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Trace buffer needs " + leftToRead + " bytes at offset " + offset + " got " + bytesRead + " bytes");
                }
                if (bytesRead < 0) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "End of stream with " + leftToRead + " bytes still " + "expected");
                    }
                    leftToRead = 0;
                    continue;
                }
                leftToRead -= bytesRead;
                offset += bytesRead;
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Incoming message is using chunking");
            }
            int chunksize = 1024;
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
            int totalBytesRead = 0;
            int bytesFromRead = 0;
            while (bytesFromRead >= 0) {
                byte[] chunkBA = new byte[1024];
                bytesFromRead = reqIs.read(chunkBA, 0, 1024);
                if (bytesFromRead < 0) continue;
                chunks.add(chunkBA);
                chunkSizes.add(new Integer(bytesFromRead));
                totalBytesRead += bytesFromRead;
            }
            reqBa = new byte[totalBytesRead];
            int offset = 0;
            for (int i = 0; i < chunks.size(); ++i) {
                byte[] chunk = (byte[])chunks.get(i);
                int chunkSize = (Integer)chunkSizes.get(i);
                System.arraycopy(chunk, 0, reqBa, offset, chunkSize);
                offset += chunkSize;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Done copying HTTP request to trace buffer");
        }
        return reqBa;
    }
}

