/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.channel.WSChannelManager;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.axis2.AxisFault;

public class OutboundConnectionGroup {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final TraceComponent _tc = Tr.register(OutboundConnectionGroup.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final Integer STATE_INVALID = new Integer(0);
    private static final Integer STATE_NOT_IN_USE = new Integer(1);
    private static final Integer STATE_IN_USE = new Integer(2);
    private static float ldFactor = 0.75f;
    private static int initSize = 131;
    private static WSChannelManager wMgr = null;
    private VirtualConnectionFactory vcf = null;
    private long idleTime = 5000L;
    private HashMap thePool = new HashMap(initSize, ldFactor);
    private Integer countTotalInUse = 0;
    private Vector Cleanup = new Vector();

    public OutboundConnectionGroup() {
        Long temp = null;
        try {
            temp = (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Long.getLong("com.ibm.websphere.webservices.http.connectionIdleTimeout");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        if (temp != null) {
            this.idleTime = temp * 1000L;
        }
        wMgr = WSChannelManager.getInstance();
    }

    public HTTPConnection createConnection(WSAddress addrtoConnect) throws AxisFault, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.createConnection()");
        }
        HTTPConnection wOC = null;
        String keyChainName = addrtoConnect.keyValueforPool();
        if (this.vcf == null) {
            this.vcf = wMgr.getVCFactory(addrtoConnect);
        }
        wOC = wMgr.getWSOutboundConnection(keyChainName, addrtoConnect, this.vcf);
        this.thePool.put(wOC, STATE_IN_USE);
        this.incrementTotalInUse();
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "createdOCobject " + wOC.toString() + " vcf : " + String.valueOf(this.vcf));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.createConnection()");
        }
        return wOC;
    }

    protected HTTPConnection invalidateConnection(WSAddress addrtoConnect) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        HTTPConnection wOC2 = null;
        if (this.thePool.size() > 0) {
            for (HTTPConnection wOC2 : this.thePool.keySet()) {
                if (!wOC2.getTargetAddress().equals(addrtoConnect)) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "invalidatedConnObject01 " + addrtoConnect.toString() + "  " + wOC2.toString());
                }
                this.thePool.put(wOC2, STATE_INVALID);
                break;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.invalidateConnection()");
        }
        return wOC2;
    }

    protected HTTPConnection getConnection(WSAddress addrtoConnect) throws AxisFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.getConnection()");
        }
        HTTPConnection wOC = null;
        boolean foundExpired = false;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionIdleTimeout: " + this.idleTime + " ms.");
        }
        if (this.thePool.size() > 0) {
            Iterator it = this.thePool.keySet().iterator();
            while (it.hasNext()) {
                wOC = (HTTPConnection)it.next();
                long sincelastAccess = wOC.timeFromLastAccess();
                int state = (Integer)this.thePool.get(wOC);
                if (state == STATE_INVALID) {
                    wOC = null;
                    continue;
                }
                if (sincelastAccess >= this.idleTime) {
                    if (state == STATE_NOT_IN_USE) {
                        this.Cleanup.add(wOC);
                        it.remove();
                        this.releaseResources(wOC);
                        if (_tc.isEventEnabled()) {
                            Object[] inserts = new Object[]{wOC.toString(), String.valueOf(sincelastAccess)};
                            Tr.event(_tc, "expiredOCobject", inserts);
                        }
                        foundExpired = true;
                    }
                } else if (state == STATE_NOT_IN_USE) break;
                wOC = null;
            }
            if (wOC != null) {
                wOC.updateEndpoint(addrtoConnect);
                this.thePool.put(wOC, STATE_IN_USE);
                this.incrementTotalInUse();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "existedOCobject " + wOC.toString());
                }
            }
        }
        if (foundExpired && wOC == null) {
            wOC = this.createConnection(addrtoConnect);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Found expired object, and now create a new one.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.getConnection()");
        }
        return wOC;
    }

    protected void returnInvalidConnection(HTTPConnection wOC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.returnInvalidConnection()");
        }
        try {
            this.returnConnection(wOC, true);
        }
        catch (RuntimeException re) {
            FFDCFilter.processException((Throwable)re, "com.ibm.ws.websvcs.transport.channel.OutboundConnectionGroup.returnInvalidConnection", "341", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "OutboundConnectionGroup.returnInvalidConnection() with exception " + re);
            }
            throw re;
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.returnInvalidConnection()");
        }
    }

    protected void returnConnection(HTTPConnection wOC) {
        this.returnConnection(wOC, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnConnection(HTTPConnection wOC, boolean invalidate) {
        int state;
        boolean connInPool;
        Integer stateInteger;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionGroup.returnConnection() with invalidate=" + invalidate);
        }
        if (invalidate && (stateInteger = (Integer)this.thePool.get(wOC)) != null) {
            this.thePool.put(wOC, STATE_INVALID);
        }
        boolean bl = connInPool = this.thePool.get(wOC) != null;
        if (!connInPool && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "The " + wOC + " connection was not found in the pool");
        }
        int n = state = connInPool ? (Integer)this.thePool.get(wOC) : -1;
        if (connInPool && state == STATE_INVALID) {
            this.thePool.remove(wOC);
            this.decrementTotalInUse();
        } else if (wOC.isClosed()) {
            this.thePool.remove(wOC);
            this.decrementTotalInUse();
        } else {
            this.thePool.put(wOC, STATE_NOT_IN_USE);
            this.decrementTotalInUse();
        }
        if (connInPool && state == STATE_INVALID) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "returnInvalidOCobject " + wOC.toString());
            }
            this.releaseResources(wOC);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(wOC);
            }
        } else if (wOC.isClosed() || connInPool && state == STATE_INVALID) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "returnClosedOCobject " + wOC.toString());
            }
            this.releaseResources(wOC);
            Vector vector = this.Cleanup;
            synchronized (vector) {
                this.Cleanup.add(wOC);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, "returnValidOCobject " + wOC.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionGroup.returnConnection()");
        }
    }

    protected boolean isEmpty() {
        return this.thePool.isEmpty() && this.Cleanup.isEmpty();
    }

    protected int currPoolSize() {
        return this.thePool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cleanup()");
        }
        HTTPConnection wOC2 = null;
        Vector vector = this.Cleanup;
        synchronized (vector) {
            for (HTTPConnection wOC2 : this.Cleanup) {
                this.releaseResources(wOC2);
                if (!_tc.isEventEnabled()) continue;
                Tr.event(_tc, "removeOCobject " + wOC2.toString());
            }
            this.Cleanup.clear();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cleanup()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws ChannelException, ChainException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "release()");
        }
        if (this.vcf != null) {
            VirtualConnectionFactory virtualConnectionFactory = this.vcf;
            synchronized (virtualConnectionFactory) {
                if (this.vcf != null) {
                    this.vcf.destroy();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "objectReleased " + String.valueOf(this.vcf));
                    }
                    this.vcf = null;
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "release()");
        }
    }

    public int totalInUse() {
        int result = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "totalInUse()");
        }
        Iterator it = this.thePool.values().iterator();
        while (it.hasNext()) {
            if (!((Integer)it.next()).equals(STATE_IN_USE)) continue;
            ++result;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "totalInUse()");
        }
        return result;
    }

    public boolean findUnused() {
        boolean result = false;
        HTTPConnection wOC = null;
        if (this.thePool.size() > 1) {
            Iterator it = this.thePool.keySet().iterator();
            while (it.hasNext()) {
                wOC = (HTTPConnection)it.next();
                if (!((Integer)this.thePool.get(wOC)).equals(STATE_NOT_IN_USE)) continue;
                this.Cleanup.add(wOC);
                it.remove();
                this.releaseResources(wOC);
                result = true;
                break;
            }
        }
        return result;
    }

    private void incrementTotalInUse() {
        Integer n = this.countTotalInUse;
        Integer n2 = this.countTotalInUse = Integer.valueOf(this.countTotalInUse + 1);
    }

    private void decrementTotalInUse() {
        Integer n = this.countTotalInUse;
        Integer n2 = this.countTotalInUse = Integer.valueOf(this.countTotalInUse - 1);
    }

    protected Integer getTotalInUse() {
        return this.countTotalInUse;
    }

    public boolean findSoftReference() {
        boolean result = false;
        HTTPConnection wOC = null;
        if (this.thePool.size() > 0) {
            Iterator it = this.thePool.keySet().iterator();
            while (it.hasNext()) {
                wOC = (HTTPConnection)it.next();
                if (!((Integer)this.thePool.get(wOC)).equals(STATE_NOT_IN_USE)) continue;
                this.Cleanup.add(wOC);
                it.remove();
                this.releaseResources(wOC);
                result = true;
            }
        }
        return result;
    }

    private static String getStateString(Integer state) {
        if (state == null) {
            return "MISSING";
        }
        if (state == STATE_INVALID) {
            return "INVALID";
        }
        if (state == STATE_IN_USE) {
            return "IN-USE";
        }
        if (state == STATE_NOT_IN_USE) {
            return "NOT IN-USE";
        }
        return "UNKNOWN STATE";
    }

    private void releaseResources(HTTPConnection wOC) {
        block4: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "releaseResources() " + wOC);
            }
            try {
                wOC.release(null);
            }
            catch (Throwable t) {
                if (!_tc.isDebugEnabled()) break block4;
                Tr.debug(_tc, "Exception occurred during resource release.  This is tolerated.  Processing continues. " + OutboundConnectionGroup.getException(t));
                Tr.debug(_tc, "The OutboundConnectionGroup is " + this.dump(""));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "releaseResources() ");
        }
    }

    private static String getException(Throwable t) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        t.printStackTrace(pw);
        pw.close();
        return sw.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump(String indent) {
        try {
            StringBuffer sb = new StringBuffer();
            String nl = "\n";
            sb.append(indent);
            sb.append("The Active Pool");
            sb.append(nl);
            sb.append(indent);
            sb.append("---------------");
            sb.append(nl);
            Cloneable cloneable = this.thePool;
            synchronized (cloneable) {
                for (HTTPConnection wOC : this.thePool.keySet()) {
                    Integer state = (Integer)this.thePool.get(wOC);
                    String stateString = OutboundConnectionGroup.getStateString(state);
                    sb.append(indent + "  Connection = " + wOC.toString());
                    sb.append(nl);
                    sb.append(indent + "    TargetAddress      = " + wOC.getTargetAddress());
                    sb.append(nl);
                    sb.append(indent + "    State              = " + stateString);
                    sb.append(nl);
                    sb.append(indent + "    hasBeenUsed        = " + wOC.hasbeenUsed());
                    sb.append(nl);
                    sb.append(indent + "    timeFromLastAccess = " + wOC.timeFromLastAccess());
                    sb.append(nl);
                    sb.append(indent + "    isClosed           = " + wOC.isClosed());
                    sb.append(nl);
                }
            }
            sb.append(indent);
            sb.append("---------------");
            sb.append(nl);
            sb.append("The Cleanup List");
            sb.append(nl);
            sb.append(indent);
            sb.append("---------------");
            sb.append(nl);
            cloneable = this.Cleanup;
            synchronized (cloneable) {
                for (HTTPConnection wOC : this.Cleanup) {
                    sb.append(indent + "  Connection = " + wOC.toString());
                    sb.append(nl);
                    sb.append(indent + "    TargetAddress      = " + wOC.getTargetAddress());
                    sb.append(nl);
                    sb.append(indent + "    hasBeenUsed        = " + wOC.hasbeenUsed());
                    sb.append(nl);
                    sb.append(indent + "    timeFromLastAccess = " + wOC.timeFromLastAccess());
                    sb.append(nl);
                    sb.append(indent + "    isClosed           = " + wOC.isClosed());
                    sb.append(nl);
                }
            }
            sb.append(indent);
            sb.append("---------------");
            sb.append(nl);
            return sb.toString();
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionGroup.dump", "847", this);
            return "OutboundConnectionCache Dump is Not Available";
        }
    }
}

