/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.channel.Monitor;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionGroup;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;

public final class OutboundConnectionCache {
    private static final TraceNLS nls;
    private static final TraceComponent _tc;
    private static final TraceComponent _tc2;
    private static int REFRESHTIME;
    private static final int DELAYTIME = 1000;
    private static int CONN_TIMEOUT;
    private static int WAITING_THREADS_THRESHOLD;
    private int waitingThreads = 0;
    private static int MAX_CONN;
    private ConcurrentHashMap chainlist = null;
    private Monitor monitor = Monitor.getMonitor();
    private static OutboundConnectionCache cache;
    private static int ONEWAYREFRESHTIME;
    private static Timer _timer;

    private OutboundConnectionCache() {
        _timer = new Timer(true);
        _timer.schedule((TimerTask)new CleanupTask(), 1000L, (long)REFRESHTIME);
        this.chainlist = new ConcurrentHashMap();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionTimeout: " + CONN_TIMEOUT + " ms, " + "com.ibm.websphere.webservices.http.connectionPoolCleanUpTime" + ": " + REFRESHTIME + " ms, " + "com.ibm.websphere.webservices.http.maxConnection" + ": " + MAX_CONN);
        }
    }

    public static int maxConnection() {
        return MAX_CONN;
    }

    public static int connTimeout() {
        return CONN_TIMEOUT;
    }

    public static synchronized OutboundConnectionCache getInstance() {
        if (cache == null) {
            cache = new OutboundConnectionCache();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnection findConnectionAndInvalidate(WSAddress addrtoConnect) throws AxisFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        if (_tc.isDebugEnabled()) {
            try {
                String stackFrame = OutboundConnectionCache.stackToString();
                Tr.debug(_tc, "Consider using OutboundConnectionCache.findGroupAndReturnInvalidConnection. ");
                Tr.debug(_tc, "Calling Stack: " + stackFrame);
            }
            catch (Throwable t) {
                Tr.debug(_tc, "Exception occurred while generating trace: " + t);
            }
        }
        HTTPConnection wsOC = null;
        OutboundConnectionGroup oCGroup = null;
        String keyname = addrtoConnect.keyValueforPool();
        ConcurrentHashMap concurrentHashMap = this.chainlist;
        synchronized (concurrentHashMap) {
            oCGroup = (OutboundConnectionGroup)this.chainlist.get(keyname);
            if (oCGroup != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "WSWS3540I: Key " + keyname + " found for connection table lookup: true");
                }
                wsOC = oCGroup.invalidateConnection(addrtoConnect);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        return wsOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HTTPConnection findGroupAndGetConnection(WSAddress addrtoConnect) throws AxisFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndGetConnection() WAITING_THREADS_THRESHOLD is " + WAITING_THREADS_THRESHOLD);
        }
        HTTPConnection wsOC = null;
        OutboundConnectionGroup oCGroup = null;
        String keyname = addrtoConnect.keyValueforPool();
        this.attemptNotify();
        ConcurrentHashMap concurrentHashMap = this.chainlist;
        synchronized (concurrentHashMap) {
            int totalUsed;
            int totalSize;
            block45: {
                block46: {
                    block44: {
                        totalSize = this.poolSize();
                        totalUsed = this.connectionsInUse();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "WSWS3595I: Current pool size: " + String.valueOf(totalSize) + ". Connections-in-use size: " + String.valueOf(totalUsed) + ". Configured pool size: " + String.valueOf(MAX_CONN));
                        }
                        if ((oCGroup = (OutboundConnectionGroup)this.chainlist.get(keyname)) == null) {
                            oCGroup = new OutboundConnectionGroup();
                            this.chainlist.put(keyname, oCGroup);
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, "WSWS3547I: Outbound connection group is created for key: " + keyname);
                            }
                        } else if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "WSWS3540I: Key " + keyname + " found for connection table lookup: " + "true");
                        }
                        if (MAX_CONN != 0) break block44;
                        wsOC = oCGroup.createConnection(addrtoConnect);
                        break block45;
                    }
                    int sizeForGroup = oCGroup.currPoolSize();
                    int inUseForGroup = oCGroup.getTotalInUse();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, oCGroup + " has size of " + sizeForGroup + " with " + inUseForGroup + " objects used.");
                    }
                    if (totalSize >= MAX_CONN) break block46;
                    if (totalUsed == totalSize) {
                        wsOC = oCGroup.createConnection(addrtoConnect);
                        break block45;
                    } else {
                        if (totalUsed >= totalSize) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                            throw new AxisFault(msg);
                        }
                        if (inUseForGroup > sizeForGroup) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                            throw new AxisFault(msg);
                        }
                        if (inUseForGroup < sizeForGroup || inUseForGroup == 0 && sizeForGroup == 0) {
                            wsOC = oCGroup.getConnection(addrtoConnect);
                        }
                        if (wsOC == null) {
                            wsOC = oCGroup.createConnection(addrtoConnect);
                        }
                    }
                    break block45;
                }
                if (totalSize != MAX_CONN) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                    throw new AxisFault(msg);
                }
                wsOC = oCGroup.getConnection(addrtoConnect);
                long actualWaitTime = 0L;
                long targetWaitTime = CONN_TIMEOUT;
                if (wsOC == null) {
                    if (this.purgeUnused()) {
                        wsOC = oCGroup.createConnection(addrtoConnect);
                    }
                    if (wsOC == null && WAITING_THREADS_THRESHOLD >= 0 && this.waitingThreads >= WAITING_THREADS_THRESHOLD) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "The waiting threads threshold (" + WAITING_THREADS_THRESHOLD + ") is exceeded." + "Attempting to remove a soft reference.");
                        }
                        if (this.purgeSoftReference()) {
                            wsOC = oCGroup.createConnection(addrtoConnect);
                        }
                    }
                }
                while (wsOC == null) {
                    int totalsize;
                    long start;
                    if (CONN_TIMEOUT == 0) {
                        ++this.waitingThreads;
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "WSWS3596I: Current thread: " + Thread.currentThread().toString() + " is going to wait for notification.");
                            Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                        }
                        start = System.currentTimeMillis();
                        this.monitor.enterWait(this, this.waitingThreads, totalSize, totalUsed, Thread.currentThread().toString());
                        this.chainlist.wait();
                        --this.waitingThreads;
                        actualWaitTime = System.currentTimeMillis() - start;
                        this.monitor.leaveWait(this, this.waitingThreads, totalSize, totalUsed, Thread.currentThread().toString(), actualWaitTime);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "WSWS3599I: The current thread: " + Thread.currentThread().toString() + " has been notified.");
                            Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                        }
                        if ((wsOC = oCGroup.getConnection(addrtoConnect)) == null && this.purgeUnused()) {
                            wsOC = oCGroup.createConnection(addrtoConnect);
                        }
                        if (wsOC == null && WAITING_THREADS_THRESHOLD >= 0 && this.waitingThreads >= WAITING_THREADS_THRESHOLD) {
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, "The waiting threads threshold (" + WAITING_THREADS_THRESHOLD + ") is exceeded." + "Attempting to remove a soft reference.");
                            }
                            if (this.purgeSoftReference()) {
                                wsOC = oCGroup.createConnection(addrtoConnect);
                            }
                        }
                        if (wsOC == null) {
                            totalsize = this.poolSize();
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, oCGroup + " has size of " + totalsize + " with MAX_CONN : " + MAX_CONN);
                            }
                            if (totalsize < MAX_CONN) {
                                wsOC = oCGroup.createConnection(addrtoConnect);
                            }
                        }
                        if (wsOC == null) continue;
                        break;
                    }
                    if (_tc.isEventEnabled()) {
                        Object[] inserts = new Object[]{Thread.currentThread().toString(), String.valueOf(targetWaitTime)};
                        Tr.event(_tc, "connectionWait01", inserts);
                    }
                    start = System.currentTimeMillis();
                    ++this.waitingThreads;
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "WSWS3596I: Current thread: " + Thread.currentThread().toString() + " is going to wait for notification.");
                        Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                    }
                    this.monitor.enterWait(this, this.waitingThreads, totalSize, totalUsed, Thread.currentThread().toString());
                    this.chainlist.wait(targetWaitTime);
                    --this.waitingThreads;
                    actualWaitTime = System.currentTimeMillis() - start;
                    this.monitor.leaveWait(this, this.waitingThreads, totalSize, totalUsed, Thread.currentThread().toString(), actualWaitTime);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "WSWS3599I: The current thread: " + Thread.currentThread().toString() + " has been notified.");
                        Tr.event(_tc, "The actual wait time in milliseconds for this thread is " + actualWaitTime);
                        Tr.event(_tc, "The total number of waiting threads is " + this.waitingThreads);
                    }
                    if ((wsOC = oCGroup.getConnection(addrtoConnect)) == null && this.purgeUnused()) {
                        wsOC = oCGroup.createConnection(addrtoConnect);
                    }
                    if (wsOC == null && WAITING_THREADS_THRESHOLD >= 0 && this.waitingThreads >= WAITING_THREADS_THRESHOLD) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "The waiting threads threshold (" + WAITING_THREADS_THRESHOLD + ") is exceeded." + "Attempting to remove a soft reference.");
                        }
                        if (this.purgeSoftReference()) {
                            wsOC = oCGroup.createConnection(addrtoConnect);
                        }
                    }
                    if (wsOC == null) {
                        totalsize = this.poolSize();
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, oCGroup + " has size of " + totalsize + " with MAX_CONN : " + MAX_CONN);
                        }
                        if (totalsize < MAX_CONN) {
                            wsOC = oCGroup.createConnection(addrtoConnect);
                        }
                    }
                    if (wsOC != null) break;
                    if (targetWaitTime - actualWaitTime > 0L) continue;
                    String msg = NLSProvider.getNLS().getFormattedMessage("connectionTimedOut", new Object[0], "The connection wait has timed out.");
                    throw new AxisFault(msg);
                }
            }
            if (_tc.isEventEnabled()) {
                totalSize = this.poolSize();
                totalUsed = this.connectionsInUse();
                Tr.event(_tc, "WSWS3595I: Current pool size: " + String.valueOf(totalSize) + ". Connections-in-use size: " + String.valueOf(totalUsed) + ". Configured pool size: " + String.valueOf(MAX_CONN));
            }
        }
        this.attemptNotify();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        }
        return wsOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptNotify() {
        block7: {
            try {
                ConcurrentHashMap concurrentHashMap = this.chainlist;
                synchronized (concurrentHashMap) {
                    int totalSize;
                    if (this.waitingThreads > 0 && (totalSize = this.poolSize()) < MAX_CONN) {
                        this.chainlist.notify();
                        if (_tc.isEventEnabled()) {
                            int totalUsed = this.connectionsInUse();
                            Tr.event(_tc, "Notify thread event triggered by attemptNotify.  Number of waiting threads is " + this.waitingThreads);
                            Tr.event(_tc, "WSWS3595I: Current pool size: " + totalSize + ". Connections-in-use size: " + totalUsed + ". Configured pool size: " + MAX_CONN);
                        }
                    }
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache", "585", this);
                if (!_tc2.isEventEnabled()) break block7;
                Tr.event(_tc2, "exception01 " + JavaUtils.stackToString(ex));
            }
        }
    }

    public void findGroupAndReturnInvalidConnection(HTTPConnection wOC) throws ChainException, ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndReturnInvalidConnection()");
        }
        try {
            this.findGroupAndReturnConnection(wOC, true);
        }
        catch (RuntimeException re) {
            FFDCFilter.processException((Throwable)re, "com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache.findGroupAndReturnInvalidConnection", "735", this);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnInvalidConnection() with exception " + re);
            }
            throw re;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnInvalidConnection()");
        }
    }

    public void findGroupAndReturnConnection(HTTPConnection wOC) throws ChainException, ChannelException {
        this.findGroupAndReturnConnection(wOC, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findGroupAndReturnConnection(HTTPConnection wOC, boolean invalidate) throws ChainException, ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndReturnConnection() with invalidate=" + invalidate);
        }
        String activeChainName = wOC.getTargetAddress().keyValueforPool();
        OutboundConnectionGroup ocgroup = null;
        ConcurrentHashMap concurrentHashMap = this.chainlist;
        synchronized (concurrentHashMap) {
            int totalUsed;
            int totalSize;
            if (_tc.isEventEnabled()) {
                totalSize = this.poolSize();
                totalUsed = this.connectionsInUse();
                Tr.event(_tc, "WSWS3595I: Current pool size: " + String.valueOf(totalSize) + ". Connections-in-use size: " + String.valueOf(totalUsed) + ". Configured pool size: " + String.valueOf(MAX_CONN));
            }
            if ((ocgroup = (OutboundConnectionGroup)this.chainlist.get(activeChainName)) == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "WSWS3540I: Key " + activeChainName + " found for connection table lookup: " + "false");
                }
                return;
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "WSWS3540I: Key " + activeChainName + " found for connection table lookup: " + "true");
            }
            if (!invalidate) {
                ocgroup.returnConnection(wOC);
            } else {
                ocgroup.returnInvalidConnection(wOC);
            }
            if (_tc.isEventEnabled()) {
                totalSize = this.poolSize();
                totalUsed = this.connectionsInUse();
                Tr.event(_tc, "WSWS3595I: Current pool size: " + String.valueOf(totalSize) + ". Connections-in-use size: " + String.valueOf(totalUsed) + ". Configured pool size: " + String.valueOf(MAX_CONN));
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "WSWS3598I: Notify the next waiting thread.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
            }
            if (!invalidate) {
                this.chainlist.notify();
            }
        }
    }

    private boolean purgeUnused() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeUnused()");
        }
        boolean foundUnused = false;
        Iterator it = this.chainlist.keySet().iterator();
        OutboundConnectionGroup oCG = null;
        boolean purgedOne = false;
        while (it.hasNext() && !(foundUnused = (oCG = (OutboundConnectionGroup)this.chainlist.get(it.next())).findUnused())) {
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeUnused()");
        }
        return foundUnused;
    }

    private boolean purgeSoftReference() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeSoftReference()");
        }
        boolean foundSoftReference = false;
        Iterator it = this.chainlist.keySet().iterator();
        OutboundConnectionGroup oCG = null;
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            if (oCG.currPoolSize() > oCG.totalInUse()) {
                foundSoftReference = oCG.findSoftReference();
            }
            if (!foundSoftReference) continue;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeSoftReference() = " + foundSoftReference);
        }
        return foundSoftReference;
    }

    protected int poolSize() {
        int result = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "poolSize()");
        }
        Iterator it = this.chainlist.keySet().iterator();
        OutboundConnectionGroup oCG = null;
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            result += oCG.currPoolSize();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "poolSize()");
        }
        return result;
    }

    protected int connectionsInUse() {
        int result = 0;
        OutboundConnectionGroup oCG = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "connectionsInUse()");
        }
        Iterator it = this.chainlist.keySet().iterator();
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            result += oCG.getTotalInUse().intValue();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "connectionsInUse()");
        }
        return result;
    }

    private static String stackToString() {
        return OutboundConnectionCache.stackToString(new RuntimeException());
    }

    private static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump(String indent) {
        try {
            StringBuffer sb = new StringBuffer();
            String nl = "\n";
            sb.append(indent);
            sb.append("===========================");
            sb.append(nl);
            sb.append(indent + " Connection Timeout (sec) = " + CONN_TIMEOUT);
            sb.append(nl);
            sb.append(indent + " Refresh Time (sec)       = " + REFRESHTIME);
            sb.append(nl);
            sb.append(indent + " Max Connections          = " + MAX_CONN);
            sb.append(nl);
            sb.append(indent + " WaitingThreadThreshold   = " + WAITING_THREADS_THRESHOLD);
            sb.append(nl);
            sb.append(indent + " Pool Size                = " + this.poolSize());
            sb.append(nl);
            sb.append(indent + " Connections In Use       = " + this.connectionsInUse());
            sb.append(nl);
            sb.append(indent);
            sb.append("===========================");
            sb.append(nl);
            ConcurrentHashMap concurrentHashMap = this.chainlist;
            synchronized (concurrentHashMap) {
                for (Object key : this.chainlist.keySet()) {
                    OutboundConnectionGroup ocg = (OutboundConnectionGroup)this.chainlist.get(key);
                    sb.append(indent + "  Key = " + key);
                    sb.append(nl);
                    sb.append(indent + "  OutboundConnectionGroup = " + ocg.toString());
                    sb.append(nl);
                    sb.append(ocg.dump(indent + "    "));
                    sb.append(nl);
                }
            }
            sb.append(indent);
            sb.append("===========================");
            sb.append(nl);
            return sb.toString();
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.engine.transport.channel.OutboundConnectionCache.dump", "1173", this);
            return "OutboundConnectionGroup Dump is Not Available";
        }
    }

    static {
        Exception cause;
        nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
        _tc = Tr.register(OutboundConnectionCache.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
        _tc2 = Tr.register(CleanupTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
        REFRESHTIME = 0;
        CONN_TIMEOUT = 0;
        MAX_CONN = 0;
        cache = null;
        ONEWAYREFRESHTIME = 10000;
        _timer = null;
        try {
            CONN_TIMEOUT = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionTimeout", "300")) * 1000;
                }
            });
        }
        catch (PrivilegedActionException e) {
            cause = e;
            if (e.getException() != null) {
                cause = e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caught exception: " + cause.toString() + " defaulting HTTP connection timeout");
            }
            CONN_TIMEOUT = 300000;
        }
        try {
            REFRESHTIME = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionPoolCleanUpTime", "180")) * 1000;
                }
            });
        }
        catch (PrivilegedActionException e) {
            cause = e;
            if (e.getException() != null) {
                cause = e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caught exception: " + cause.toString() + " defaulting HTTP connection " + "pool cleanup time");
            }
            REFRESHTIME = 180000;
        }
        try {
            MAX_CONN = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (int)Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.maxConnection", "50"));
                }
            });
        }
        catch (PrivilegedActionException e) {
            cause = e;
            if (e.getException() != null) {
                cause = e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caught exception: " + cause.toString() + " defaulting HTTP connection " + "pool maximum connections");
            }
            MAX_CONN = 50;
        }
        String wtt_property = "com.ibm.websphere.webservices.http.waitingThreadsThreshold";
        try {
            WAITING_THREADS_THRESHOLD = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (int)Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.waitingThreadsThreshold", "5"));
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception cause2 = e;
            if (e.getException() != null) {
                cause2 = e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caught exception: " + cause2.toString() + " defaulting HTTP connection " + "waiting threads threshold to 5");
            }
            WAITING_THREADS_THRESHOLD = 5;
        }
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                OutboundConnectionGroup ocgroup = null;
                try {
                    if (_tc2.isEntryEnabled()) {
                        Tr.entry(_tc2, "CleanupTask.run()");
                    }
                    ConcurrentHashMap concurrentHashMap = OutboundConnectionCache.this.chainlist;
                    synchronized (concurrentHashMap) {
                        if (OutboundConnectionCache.this.chainlist.size() > 0) {
                            Iterator it = OutboundConnectionCache.this.chainlist.keySet().iterator();
                            Object key = null;
                            while (it.hasNext()) {
                                key = it.next();
                                ocgroup = (OutboundConnectionGroup)OutboundConnectionCache.this.chainlist.get(key);
                                ocgroup.cleanup();
                                if (!ocgroup.isEmpty()) continue;
                                if (_tc2.isDebugEnabled()) {
                                    Tr.debug(_tc2, "OutboundConnectionGroup.isEmpty(): true");
                                }
                                ocgroup.release();
                            }
                        }
                        if (WAITING_THREADS_THRESHOLD >= 0 && OutboundConnectionCache.this.waitingThreads >= WAITING_THREADS_THRESHOLD) {
                            OutboundConnectionCache.this.attemptNotify();
                        }
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache.run", "182", this);
                    if (!_tc2.isEventEnabled()) break block10;
                    Tr.event(_tc2, "exception01 " + JavaUtils.stackToString(ex));
                }
            }
        }
    }
}

