/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache;
import java.util.HashSet;
import java.util.Set;

public final class Monitor {
    private static final TraceComponent _tc = Tr.register(Monitor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String MONITOR_DURATION_KEY = "com.ibm.websphere.webservices.http.monitorDuration";
    private int MONITOR_DURATION = 300;
    private static Monitor _singleton = null;
    private boolean inHighLoad = false;
    private double startHighLoad = 0.0;
    private double endHighLoad = 0.0;
    private double lastReport = 0.0;
    private String initialDump = null;
    private double[] d = null;
    private String[] text = null;
    private int DURATION = 0;
    private int E_NUM_THREADS = 1;
    private int E_TOTAL_INUSE = 2;
    private int E_AVG_INUSE = 3;
    private int E_MAX_INUSE = 4;
    private int E_MIN_INUSE = 5;
    private int E_TOTAL_SOFT = 6;
    private int E_AVG_SOFT = 7;
    private int E_MAX_SOFT = 8;
    private int E_MIN_SOFT = 9;
    private int E_TOTAL_WAIT_THREADS = 10;
    private int E_AVG_WAIT_THREADS = 11;
    private int E_MAX_WAIT_THREADS = 12;
    private int L_NUM_THREADS = 13;
    private int L_TOTAL_INUSE = 14;
    private int L_AVG_INUSE = 15;
    private int L_MAX_INUSE = 16;
    private int L_MIN_INUSE = 17;
    private int L_TOTAL_SOFT = 18;
    private int L_AVG_SOFT = 19;
    private int L_MAX_SOFT = 20;
    private int L_MIN_SOFT = 21;
    private int L_TOTAL_DURATION = 22;
    private int L_AVG_DURATION = 23;
    private int L_MAX_DURATION = 24;
    private int L_MIN_DURATION = 25;
    private int L_UNIQUE_THREADS = 26;
    private int L_AVG_NUMBER_WAITS = 27;
    private int L_POTENTIAL_TIME = 28;
    private int L_ESTIMATE_IDLE = 29;
    private int LAST_INDEX = 29;
    private Set uniqueThreads = new HashSet();

    public static synchronized Monitor getMonitor() {
        if (_singleton == null) {
            _singleton = new Monitor();
        }
        return _singleton;
    }

    private Monitor() {
        try {
            this.MONITOR_DURATION = Integer.valueOf(System.getProperty(MONITOR_DURATION_KEY, "300"));
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.Monitor", "62", this);
            this.MONITOR_DURATION = 300;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The Monitor is enabled. ");
            Tr.debug(_tc, "The Monitor property com.ibm.websphere.webservices.http.monitorDuration = " + this.MONITOR_DURATION);
        }
        this.d = new double[this.LAST_INDEX + 1];
        this.text = new String[this.LAST_INDEX + 1];
        this.text[this.DURATION] = "Duration of monitoring window (in ms)     = ";
        this.text[this.E_NUM_THREADS] = "Number of threads entering the wait state = ";
        this.text[this.E_TOTAL_INUSE] = null;
        this.text[this.E_AVG_INUSE] = "    Average number of in-use connections  = ";
        this.text[this.E_MAX_INUSE] = "    Maximum number of in-use connections  = ";
        this.text[this.E_MIN_INUSE] = "    Minimum number of in-use connections  = ";
        this.text[this.E_TOTAL_SOFT] = null;
        this.text[this.E_AVG_SOFT] = "    Average number of soft connections    = ";
        this.text[this.E_MAX_SOFT] = "    Maximum number of soft connections    = ";
        this.text[this.E_MIN_SOFT] = "    Minimum number of soft connections    = ";
        this.text[this.E_TOTAL_WAIT_THREADS] = null;
        this.text[this.E_AVG_WAIT_THREADS] = "    Average number of waiting threads     = ";
        this.text[this.E_MAX_WAIT_THREADS] = "    Maximum number of waiting threads     = ";
        this.text[this.L_NUM_THREADS] = "Number of threads leaving the wait state  = ";
        this.text[this.L_TOTAL_INUSE] = null;
        this.text[this.L_AVG_INUSE] = "    Average number of in-use connections  = ";
        this.text[this.L_MAX_INUSE] = "    Maximum number of in-use connections  = ";
        this.text[this.L_MIN_INUSE] = "    Minimum number of in-use connections  = ";
        this.text[this.L_TOTAL_SOFT] = null;
        this.text[this.L_AVG_SOFT] = "    Average number of soft connections    = ";
        this.text[this.L_MAX_SOFT] = "    Maximum number of soft connections    = ";
        this.text[this.L_MIN_SOFT] = "    Minimum number of soft connections    = ";
        this.text[this.L_TOTAL_DURATION] = "    Total Wait time (in ms)               = ";
        this.text[this.L_AVG_DURATION] = "    Average Wait time (in ms)             = ";
        this.text[this.L_MAX_DURATION] = "    Maxium Wait time (in ms)              = ";
        this.text[this.L_MIN_DURATION] = "    Minimum Wait time (in ms)             = ";
        this.text[this.L_UNIQUE_THREADS] = "    Number of unique threads              = ";
        this.text[this.L_AVG_NUMBER_WAITS] = "    Average number of waits per thread    = ";
        this.text[this.L_POTENTIAL_TIME] = null;
        this.text[this.L_ESTIMATE_IDLE] = "    Average percent of time in wait queue = ";
        this.reset();
    }

    public void enterWait(Object dump, int waitingThreads, int poolSize, int connectionsInUse, String threadName) {
        if (!_tc.isDebugEnabled()) {
            return;
        }
        try {
            this._enterWait(dump, waitingThreads, poolSize, connectionsInUse, threadName);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.Monitor.enterWait", "131", this);
        }
    }

    public void leaveWait(Object dump, int waitingThreads, int poolSize, int connectionsInUse, String threadName, double duration) {
        if (!_tc.isDebugEnabled()) {
            return;
        }
        try {
            this._leaveWait(dump, waitingThreads, poolSize, connectionsInUse, threadName, duration);
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.Monitor.leaveWait", "131", this);
        }
    }

    private void _enterWait(Object dump, int waitingThreads, int poolSize, int connectionsInUse, String threadName) {
        if (!this.inHighLoad) {
            this.inHighLoad = true;
            this.enterHighLoad(dump);
        }
        this.update(true, waitingThreads, poolSize, connectionsInUse, threadName, 0.0);
        double timeSinceLastReport = (double)System.currentTimeMillis() - this.lastReport;
        if (timeSinceLastReport > (double)(this.MONITOR_DURATION * 1000)) {
            this.report(dump);
        }
    }

    private void _leaveWait(Object dump, int waitingThreads, int poolSize, int connectionsInUse, String threadName, double duration) {
        if (this.inHighLoad) {
            this.update(false, waitingThreads, poolSize, connectionsInUse, threadName, duration);
        }
        if (this.inHighLoad && waitingThreads == 0) {
            this.inHighLoad = false;
            this.leaveHighLoad(dump);
        } else {
            double timeSinceLastReport = (double)System.currentTimeMillis() - this.lastReport;
            if (timeSinceLastReport > (double)(this.MONITOR_DURATION * 1000)) {
                this.report(dump);
            }
        }
    }

    private void enterHighLoad(Object dump) {
        this.reset();
        this.lastReport = this.startHighLoad = (double)System.currentTimeMillis();
        this.initialDump = this.getDump(dump);
    }

    private void leaveHighLoad(Object dump) {
        this.endHighLoad = System.currentTimeMillis();
        double duration = this.endHighLoad - this.startHighLoad;
        if (duration >= (double)(this.MONITOR_DURATION * 1000)) {
            this.report(dump);
        }
    }

    private void update(boolean isEnterWait, int waitingThreads, int poolSize, int inUse, String threadName, double duration) {
        int soft = poolSize - inUse;
        if (isEnterWait) {
            int n = this.E_NUM_THREADS;
            this.d[n] = this.d[n] + 1.0;
            int n2 = this.E_TOTAL_INUSE;
            this.d[n2] = this.d[n2] + (double)inUse;
            this.d[this.E_MAX_INUSE] = Math.max(this.d[this.E_MAX_INUSE], (double)inUse);
            this.d[this.E_MIN_INUSE] = Math.min(this.d[this.E_MIN_INUSE], (double)inUse);
            int n3 = this.E_TOTAL_SOFT;
            this.d[n3] = this.d[n3] + (double)soft;
            this.d[this.E_MAX_SOFT] = Math.max(this.d[this.E_MAX_SOFT], (double)soft);
            this.d[this.E_MIN_SOFT] = Math.min(this.d[this.E_MIN_SOFT], (double)soft);
            int n4 = this.E_TOTAL_WAIT_THREADS;
            this.d[n4] = this.d[n4] + (double)waitingThreads;
            this.d[this.E_MAX_WAIT_THREADS] = Math.max(this.d[this.E_MAX_WAIT_THREADS], (double)waitingThreads);
        } else {
            this.uniqueThreads.add(threadName);
            int n = this.L_NUM_THREADS;
            this.d[n] = this.d[n] + 1.0;
            int n5 = this.L_TOTAL_INUSE;
            this.d[n5] = this.d[n5] + (double)inUse;
            this.d[this.L_MAX_INUSE] = Math.max(this.d[this.L_MAX_INUSE], (double)inUse);
            this.d[this.L_MIN_INUSE] = Math.min(this.d[this.L_MIN_INUSE], (double)inUse);
            int n6 = this.L_TOTAL_SOFT;
            this.d[n6] = this.d[n6] + (double)soft;
            this.d[this.L_MAX_SOFT] = Math.max(this.d[this.L_MAX_SOFT], (double)soft);
            this.d[this.L_MIN_SOFT] = Math.min(this.d[this.L_MIN_SOFT], (double)soft);
            int n7 = this.L_TOTAL_DURATION;
            this.d[n7] = this.d[n7] + duration;
            this.d[this.L_MAX_DURATION] = Math.max(this.d[this.L_MAX_DURATION], duration);
            this.d[this.L_MIN_DURATION] = Math.min(this.d[this.L_MIN_DURATION], duration);
        }
    }

    private String calculateResults() {
        this.d[this.DURATION] = (double)System.currentTimeMillis() - this.startHighLoad;
        this.d[this.E_AVG_INUSE] = this.d[this.E_TOTAL_INUSE] / this.d[this.E_NUM_THREADS];
        this.d[this.E_AVG_SOFT] = this.d[this.E_TOTAL_SOFT] / this.d[this.E_NUM_THREADS];
        this.d[this.E_AVG_WAIT_THREADS] = this.d[this.E_TOTAL_WAIT_THREADS] / this.d[this.E_NUM_THREADS];
        this.d[this.L_AVG_INUSE] = this.d[this.L_TOTAL_INUSE] / this.d[this.L_NUM_THREADS];
        this.d[this.L_AVG_SOFT] = this.d[this.L_TOTAL_SOFT] / this.d[this.L_NUM_THREADS];
        this.d[this.L_AVG_DURATION] = this.d[this.L_TOTAL_DURATION] / this.d[this.L_NUM_THREADS];
        this.d[this.L_UNIQUE_THREADS] = this.uniqueThreads.size();
        this.d[this.L_AVG_NUMBER_WAITS] = this.d[this.L_NUM_THREADS] / this.d[this.L_UNIQUE_THREADS];
        this.d[this.L_POTENTIAL_TIME] = this.d[this.L_UNIQUE_THREADS] * this.d[this.DURATION];
        this.d[this.L_ESTIMATE_IDLE] = this.d[this.L_TOTAL_DURATION] / this.d[this.L_POTENTIAL_TIME] * 100.0;
        StringBuffer sb = new StringBuffer();
        String nl = "\n";
        sb.append("Monitor Report");
        sb.append("\n");
        sb.append("===================================");
        sb.append("\n");
        sb.append("Are threads still waiting ?" + this.inHighLoad);
        sb.append("\n");
        String results = "Monitor Report\n";
        for (int i = 0; i <= this.LAST_INDEX; ++i) {
            if (this.text[i] == null) continue;
            sb.append(this.text[i] + this.d[i]);
            sb.append("\n");
        }
        sb.append("===================================");
        return sb.toString();
    }

    private void reset() {
        for (int i = 0; i <= this.LAST_INDEX; ++i) {
            this.d[i] = 0.0;
        }
        this.d[this.E_MIN_INUSE] = Double.MAX_VALUE;
        this.d[this.E_MIN_SOFT] = Double.MAX_VALUE;
        this.d[this.L_MIN_INUSE] = Double.MAX_VALUE;
        this.d[this.L_MIN_SOFT] = Double.MAX_VALUE;
        this.d[this.L_MIN_DURATION] = Double.MAX_VALUE;
        this.startHighLoad = 0.0;
        this.endHighLoad = 0.0;
    }

    private String getDump(Object dump) {
        String value = "Not Available";
        try {
            if (dump != null && dump instanceof OutboundConnectionCache) {
                value = ((OutboundConnectionCache)dump).dump(" ");
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.Monitor.getDump", "428", this);
        }
        return value;
    }

    private void report(Object dump) {
        String results = this.calculateResults();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, results);
            if (dump != null && dump instanceof OutboundConnectionCache) {
                Tr.debug(_tc, "The Initial State Of The Cache ");
                Tr.debug(_tc, this.initialDump);
                Tr.debug(_tc, "The Current State Of The Cache ");
                Tr.debug(_tc, this.getDump(dump));
            }
        }
        this.lastReport = System.currentTimeMillis();
    }

    public static void main(String[] arg) throws Exception {
        long INTERVAL = 15000L;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Monitor Test ");
        }
        double start = System.currentTimeMillis();
        double duration = 0.0;
        Thread t = Thread.currentThread();
        Monitor m = Monitor.getMonitor();
        m.enterWait(null, 1, 25, 20, "A");
        Thread.sleep(INTERVAL);
        m.enterWait(null, 2, 25, 21, "B");
        Thread.sleep(INTERVAL);
        m.enterWait(null, 3, 25, 21, "D");
        Thread.sleep(INTERVAL);
        duration = (double)System.currentTimeMillis() - start;
        m.leaveWait(null, 2, 25, 21, "D", duration);
        Thread.sleep(INTERVAL);
        duration = (double)System.currentTimeMillis() - start;
        m.leaveWait(null, 1, 25, 21, "B", duration);
        Thread.sleep(INTERVAL);
        m.enterWait(null, 2, 25, 21, "C");
        duration = (double)System.currentTimeMillis() - start;
        m.leaveWait(null, 1, 25, 21, "C", duration);
        Thread.sleep(INTERVAL);
        m.enterWait(null, 2, 25, 21, "B");
        Thread.sleep(INTERVAL);
        duration = (double)System.currentTimeMillis() - start;
        m.leaveWait(null, 1, 25, 21, "B", duration);
        Thread.sleep(INTERVAL);
        duration = (double)System.currentTimeMillis() - start;
        m.leaveWait(null, 0, 25, 20, "A", duration);
    }
}

