/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.transport.AsyncResponseConnection;
import com.ibm.ws.websvcs.transport.AsyncResponseConnectionMap;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseChannel;
import com.ibm.ws.websvcs.transport.http.HttpAsyncResponseContext;
import com.ibm.ws.websvcs.transport.http.HttpReadCallback;
import com.ibm.ws.websvcs.transport.http.HttpRequestImpl;
import com.ibm.ws.websvcs.transport.http.HttpResponseImpl;
import com.ibm.ws.websvcs.transport.http.HttpWriteCallback;
import com.ibm.ws.websvcs.transport.http.UnknownEPRConfigCtxtLoaderPluginMgr;
import com.ibm.ws.websvcs.transport.http.UnknownEPRResolverPluginMgr;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;

public class AsyncInResponseConnLink
extends InboundApplicationLink
implements Runnable,
Constants {
    private static final TraceComponent _tc = Tr.register(AsyncInResponseConnLink.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private VirtualConnection _vc = null;
    private HttpInboundServiceContext httpInSC = null;
    private AsyncInResponseChannel asyncRspchannel = null;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private HttpReadCallback readCB = null;
    private HttpWriteCallback writeCB = null;
    private AsyncResponseContextMap aRCMap = null;
    private AsyncResponseConnectionMap aRConnMap = null;
    private UnknownEPRResolverPluginMgr resolverPlugin = null;
    private UnknownEPRConfigCtxtLoaderPluginMgr ccLoaderPlugin = null;

    public AsyncInResponseConnLink() {
        this.aRCMap = AsyncResponseContextMap.getInstance();
        this.aRConnMap = AsyncResponseConnectionMap.getInstance();
    }

    public AsyncInResponseConnLink(AsyncInResponseChannel c, VirtualConnection vc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel ctor... ");
        }
        this.init(c, vc);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SOAPAcceptorConnectionLink ctor");
        }
    }

    public void init(AsyncInResponseChannel c, VirtualConnection vc) {
        this.init(vc);
        this.request = new HttpRequestImpl();
        this.response = new HttpResponseImpl();
        this.readCB = new HttpReadCallback();
        this.writeCB = new HttpWriteCallback();
        this.asyncRspchannel = c;
        this.aRCMap = AsyncResponseContextMap.getInstance();
        this.aRConnMap = AsyncResponseConnectionMap.getInstance();
        this._vc = vc;
        this.resolverPlugin = new UnknownEPRResolverPluginMgr();
        this.ccLoaderPlugin = new UnknownEPRConfigCtxtLoaderPluginMgr();
        this.resolverPlugin.discoverUnknownEPRResolverPlugins();
        this.ccLoaderPlugin.discoverUnknownEPRConfigCtxtLoaderPlugins();
    }

    public void close(VirtualConnection vc, Exception e) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.close()...");
        }
        super.close(vc, e);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AsyncInResponseConnLink.close()");
        }
    }

    public void destroy(Exception e) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.destroy()..." + this);
        }
        super.destroy(e);
        this.httpInSC = null;
        if (this.asyncRspchannel != null) {
            this.asyncRspchannel.releaseConnectionLink(this);
            this.asyncRspchannel = null;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AsyncInResponseConnLink.destroy()");
        }
    }

    public HttpResponseImpl getResponse() {
        return this.response;
    }

    public HttpRequestImpl getRequest() {
        return this.request;
    }

    public AsyncInResponseChannel getChannel() {
        return this.asyncRspchannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Exception reportToCF;
        block57: {
            String hashKey;
            boolean exception;
            String endpoint;
            block58: {
                reportToCF = null;
                MessageContext respMC = new MessageContext();
                boolean validResponse = true;
                endpoint = null;
                exception = false;
                hashKey = null;
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "AsyncInResponseConnLink.run()...");
                }
                try {
                    try {
                        endpoint = this.request.getRequestURLAsString();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Received URL: " + endpoint);
                        }
                        if (endpoint != null) {
                            AxisService service = null;
                            ClassLoader cl = null;
                            ConfigurationContext configCtxt = null;
                            AsyncResponseContext rctxt = this.aRCMap.getContext(endpoint);
                            if (rctxt != null) {
                                configCtxt = rctxt.getConfCtxt();
                                service = rctxt.getAxisService();
                            } else {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Response context not in map, calling RM plugin...");
                                }
                                configCtxt = this.ccLoaderPlugin.getConfigurationContextForUnknownEPR(endpoint);
                                cl = this.ccLoaderPlugin.getClassLoaderForUnknownEPR(endpoint);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Config Context: " + configCtxt + ", " + "Axis Service: " + service + ", " + "ClassLoader: " + cl);
                            }
                            if (configCtxt != null && (cl != null || service != null)) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Handling response...");
                                }
                                hashKey = this.request.getHeader("SAVECONNECTION");
                                respMC.setConfigurationContext(configCtxt);
                                AxisConfiguration axisConfiguration = configCtxt.getAxisConfiguration();
                                if (this.request.getScheme().equalsIgnoreCase("http")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("http"));
                                } else if (this.request.getScheme().equalsIgnoreCase("https")) {
                                    respMC.setTransportOut(axisConfiguration.getTransportOut("https"));
                                }
                                if (service == null) {
                                    rctxt = new HttpAsyncResponseContext(service, configCtxt, endpoint);
                                    rctxt.setClassLoader(cl);
                                }
                                rctxt.handleRequest(this.request, this.response);
                                this.handleResponseReceived(HttpConstants.STATUS_OK.getIntCode());
                            } else {
                                validResponse = false;
                            }
                        } else {
                            validResponse = false;
                        }
                        if (!validResponse) {
                            this.handleErrorResponse(400);
                        }
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.run", "356", this);
                        Tr.error(_tc, JavaUtils.stackToString(t));
                        exception = true;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Exception. Setting response status to : 500");
                        }
                        this.handleErrorResponse(t, 500);
                        String cause = "";
                        if (t.getCause() != null) {
                            cause = "caused by \n" + t.getCause().getLocalizedMessage();
                            if (t.getCause().getCause() != null) {
                                cause = cause + "\n caused by " + t.getCause().getCause().getLocalizedMessage();
                            }
                            reportToCF = new Exception(t.getLocalizedMessage() + " : " + cause);
                        } else {
                            reportToCF = new Exception(t.getLocalizedMessage());
                        }
                        Object var13_15 = null;
                        if (hashKey != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Cleaning up the connection");
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "SAVECONNECTION  key : " + hashKey);
                            }
                            AsyncResponseConnection rcconn = this.aRConnMap.getConnection(hashKey);
                            if (endpoint != null && rcconn != null) {
                                if (exception) {
                                    rcconn.disconnectConnection();
                                } else {
                                    rcconn.resetConnection();
                                }
                                this.aRConnMap.removeConnection(hashKey);
                            } else if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Response connection not in map");
                            }
                        }
                        if (reportToCF != null) {
                            this.close(this._vc, reportToCF);
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, " Close is not called in Finally method");
                        }
                        if (!_tc.isEntryEnabled()) return;
                        Tr.exit(_tc, "AsyncInResponseConnLink.run()");
                        return;
                    }
                    Object var13_14 = null;
                    if (hashKey == null) break block57;
                    if (!_tc.isDebugEnabled()) break block58;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (hashKey != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Cleaning up the connection");
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "SAVECONNECTION  key : " + hashKey);
                        }
                        AsyncResponseConnection rcconn = this.aRConnMap.getConnection(hashKey);
                        if (endpoint != null && rcconn != null) {
                            if (exception) {
                                rcconn.disconnectConnection();
                            } else {
                                rcconn.resetConnection();
                            }
                            this.aRConnMap.removeConnection(hashKey);
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Response connection not in map");
                        }
                    }
                    if (reportToCF != null) {
                        this.close(this._vc, reportToCF);
                    } else if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, " Close is not called in Finally method");
                    }
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "AsyncInResponseConnLink.run()");
                    throw throwable;
                }
                Tr.debug(_tc, "Cleaning up the connection");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "SAVECONNECTION  key : " + hashKey);
            }
            AsyncResponseConnection rcconn = this.aRConnMap.getConnection(hashKey);
            if (endpoint != null && rcconn != null) {
                if (exception) {
                    rcconn.disconnectConnection();
                } else {
                    rcconn.resetConnection();
                }
                this.aRConnMap.removeConnection(hashKey);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Response connection not in map");
            }
        }
        if (reportToCF != null) {
            this.close(this._vc, reportToCF);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, " Close is not called in Finally method");
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "AsyncInResponseConnLink.run()");
    }

    public void ready(VirtualConnection in_VC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.ready()...");
        }
        super.init(in_VC);
        this.httpInSC = (HttpInboundServiceContext)this.getDeviceLink().getChannelAccessor();
        this.readCB.init(this, this.httpInSC, in_VC);
        this.readCB.readRequest();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "AsyncInResponseConnLink.ready()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestReady(VirtualConnection _vc, InputStream in) {
        block8: {
            block7: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "AsyncInResponseConnLink.requestReady()...");
                }
                this.writeCB.init(this, this.httpInSC);
                this.request.init(this.httpInSC, in, this.response);
                this.response.init(this, this.httpInSC, this.writeCB);
                try {
                    try {
                        ThreadPool threadPool;
                        String thdName;
                        Object zThreadPool = null;
                        if (zThreadPool != null && !(thdName = Thread.currentThread().getName()).startsWith((threadPool = (ThreadPool)zThreadPool).getName())) {
                            threadPool.execute((Runnable)this, 2);
                            Object var7_8 = null;
                            if (!_tc.isEntryEnabled()) return;
                            break block7;
                        }
                        this.run();
                        break block8;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.requestReady", "506", this);
                        Object[] inserts = new Object[]{t};
                        Tr.error(_tc, "caughtException", inserts);
                        this.handleErrorResponse(t, 404);
                        Object var7_10 = null;
                        if (!_tc.isEntryEnabled()) return;
                        Tr.exit(_tc, "AsyncInResponseConnLink.requestReady()");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "AsyncInResponseConnLink.requestReady()");
                    throw throwable;
                }
            }
            Tr.exit(_tc, "AsyncInResponseConnLink.requestReady()");
            return;
        }
        Object var7_9 = null;
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "AsyncInResponseConnLink.requestReady()");
    }

    public void handleErrorResponse(int statusCode) {
        this.handleErrorResponse(null, statusCode);
    }

    public void handleResponseReceived(int statusCode) {
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleResonseReceived()");
            }
            this.response.setStatusCode(statusCode);
            this.response.setContentType("text/html");
            String persist = System.getProperty("com.ibm.websphere.webservices.http.connectionKeepAlive");
            if (JavaUtils.hasValue(persist) && persist.equalsIgnoreCase("no")) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting Connection to close");
                }
                this.response.setHeader(HttpConstants.HDR_CONNECTION.getName(), HttpConstants.CONN_CLOSE.getName());
            }
            OutputStream os = this.response.getOutputStream();
            os.close();
            this.response.finishResponse();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleResponseReceived(). Clearing the status code");
            }
            this.response.clearStatusCode();
            this.response.setHeader("IBM-WAS-Reset-Connection", "TRUE");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Set the response header IBM-WAS-Reset-Connection to TRUE");
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.handleResponseReceived", "588", this);
            Object[] inserts = new Object[]{t};
            Tr.error(_tc, "caughtException", inserts);
        }
    }

    public void handleErrorResponse(Throwable excp, int statusCode) {
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleErrorResponse()");
            }
            this.response.setStatusCode(statusCode);
            this.response.setContentType("text/html");
            OutputStream os = this.response.getOutputStream();
            if (os != null) {
                StringBuffer buf = new StringBuffer();
                buf.append("<h2>ERROR</h2>\n");
                buf.append("<p>System error occurred while processing request URL: " + this.request.getRequestURLAsString() + "\n");
                if (excp != null) {
                    buf.append("<p>Exception is: " + excp + "\n");
                }
                os.write(buf.toString().getBytes());
                os.close();
                this.response.finishResponse();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "AsyncInResponseConnLink.handleErrorResponse(). Clearing the status code()");
            }
            this.response.clearStatusCode();
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink.handleErrorResponse", "647", this);
            Object[] inserts = new Object[]{t};
            Tr.error(_tc, "caughtException", inserts);
        }
    }
}

