/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.channel.AsyncInRespChannelFactory;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;

public class AsyncInResponseChannel
extends InboundApplicationChannel
implements Discriminator {
    private static final TraceComponent _tc = Tr.register(AsyncInResponseChannel.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String ASYNC_RESP_ACL_NAME = "SOAPACL";
    private static final byte[] ASYNC_RESP_CR_AS_BYTES = "/IBM_WS_SYS_RESPONSESERVLET".getBytes();
    private AsyncInRespChannelFactory httpAsyRpChanFactory = null;
    private AsyncResponseContextMap asyRCMap = null;
    private Class HttpInbDeviceIntf = HttpInboundServiceContext.class;
    private Class inHttpDiscrimDataType = HttpRequestMessage.class;
    private int bufferSize = 8192;
    public static final String NAME = "async-inResponse-channel";

    public AsyncInResponseChannel(ChannelData inChannData) {
        super(inChannData);
    }

    public AsyncInResponseChannel(AsyncInRespChannelFactory in_factory, ChannelData in_channData) {
        super(in_channData);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel ctor...");
        }
        this.httpAsyRpChanFactory = in_factory;
        Integer bufSize = (Integer)in_channData.getPropertyBag().get("bufferSize");
        if (bufSize != null) {
            this.bufferSize = bufSize;
            Tr.info(_tc, "bufferSize", Integer.toString(this.bufferSize));
        }
        this.asyRCMap = AsyncResponseContextMap.getInstance();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInResponseChannel ctor, bufferSize=" + this.bufferSize);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int discriminate(VirtualConnection in_VC, Object in_obj) {
        byte[] uriBytes;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.discriminate()... ", new Object[]{in_VC});
        }
        int answer = 0;
        HttpRequestMessage req = (HttpRequestMessage)in_obj;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Checking request URI: " + req.getRequestURI());
        }
        if ((uriBytes = req.getRequestURIAsByteArray()).length >= ASYNC_RESP_CR_AS_BYTES.length) {
            answer = 1;
            for (int i = 0; answer == 1 && i < ASYNC_RESP_CR_AS_BYTES.length; ++i) {
                if (uriBytes[i] == ASYNC_RESP_CR_AS_BYTES[i]) continue;
                answer = 0;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Discriminate process has yielded the following answer: " + answer);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "discriminate");
        }
        return answer;
    }

    public void cleanUpState(VirtualConnection arg0) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.cleanUpState()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.cleanUpState().");
        }
    }

    public Class getDiscriminatoryDataType() {
        return this.inHttpDiscrimDataType;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public ConnectionLink getConnectionLink(VirtualConnection in_VC) {
        ConnectionLink connLink;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.getConnectionLink()...", new Object[]{in_VC});
        }
        if ((connLink = (ConnectionLink)in_VC.getStateMap().get(ASYNC_RESP_ACL_NAME)) == null) {
            connLink = this.httpAsyRpChanFactory.getAsyInRspLnk(in_VC, this);
            in_VC.getStateMap().put(ASYNC_RESP_ACL_NAME, connLink);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.getConnectionLink()");
        }
        return connLink;
    }

    public void releaseConnectionLink(AsyncInResponseConnLink asyncInRCL) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.releaseConnectionLink()...");
        }
        this.httpAsyRpChanFactory.releaseAsyInRspLnk(asyncInRCL);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.releaseConnectionLink()");
        }
    }

    public void start() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.start()...");
        }
        if (this.asyRCMap == null) {
            throw new ChannelException("Async Response Context HashMap has not been set.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.start()");
        }
    }

    public void stop(long arg0) throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.stop()...");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.stop()");
        }
    }

    public void init() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.init()... " + this.getName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.init().");
        }
    }

    public void destroy() throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseChannel.destroy()...");
        }
        this.httpAsyRpChanFactory = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncInResponseChannel.destroy().");
        }
    }

    public Class getDeviceInterface() {
        return this.HttpInbDeviceIntf;
    }

    public void update(ChannelData inChannData) {
        super.setConfig(inChannData);
    }
}

