/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseChannel;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.base.ApplicationChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;

public class AsyncInRespChannelFactory
extends ApplicationChannelFactory {
    private static final TraceComponent _tc = Tr.register(AsyncInRespChannelFactory.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static int CONN_LINK_POOL_SIZE = Integer.getInteger("com.ibm.websphere.webservices.listenerInboundConnSize", 25);
    private ObjectPool connLnkPool = new ObjectPool("AsyncInResponseConnLink", CONN_LINK_POOL_SIZE);
    private Class[] deviceIntf = null;

    public AsyncInRespChannelFactory() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInRespChannelFactory ctor...");
        }
        this.deviceIntf = new Class[1];
        this.deviceIntf[0] = HttpInboundServiceContext.class;
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "Inbound connection link size: " + CONN_LINK_POOL_SIZE);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInRespChannelFactory ctor");
        }
    }

    protected Channel createChannel(ChannelData channeldata) throws ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInRespChannelFactory.createChannel()...");
        }
        AsyncInResponseChannel httpAsyRspChannel = null;
        httpAsyRspChannel = new AsyncInResponseChannel(this, channeldata);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInRespChannelFactory.createChannel()");
        }
        return httpAsyRspChannel;
    }

    public void init(ChannelFactoryData channFacData) throws ChannelFactoryException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInRespChannelFactory.init()...");
        }
        this.updateProperties(channFacData.getProperties());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInRespChannelFactory.init()");
        }
    }

    public void destroy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInRespChannelFactory.destroy()...");
        }
        while (this.connLnkPool.remove() != null) {
            this.connLnkPool.remove();
        }
        this.connLnkPool = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInRespChannelFactory.destroy()");
        }
    }

    public Class[] getDeviceInterface() {
        return this.deviceIntf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncInResponseConnLink getAsyInRspLnk(VirtualConnection vc, AsyncInResponseChannel httpAIRC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.getAsyInRspLnk()...");
        }
        AsyncInResponseConnLink hairc = null;
        ObjectPool objectPool = this.connLnkPool;
        synchronized (objectPool) {
            hairc = (AsyncInResponseConnLink)this.connLnkPool.remove();
        }
        if (hairc != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Re-using existing AsyncInResponseConnLink object.");
            }
            hairc.init(httpAIRC, vc);
        } else {
            hairc = new AsyncInResponseConnLink(httpAIRC, vc);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created new AsyncInResponseConnLink object.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInResponseConnLink.getAsyInRspLnk()");
        }
        return hairc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAsyInRspLnk(AsyncInResponseConnLink hairc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncInResponseConnLink.releaseAsyInRspLnk()...");
        }
        ObjectPool objectPool = this.connLnkPool;
        synchronized (objectPool) {
            this.connLnkPool.add(hairc);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncInResponseConnLink.releaseAsyInRspLnk()");
        }
    }
}

