/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.transport.AsyncResponseConnection;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import java.util.concurrent.ConcurrentHashMap;

public final class OneWayConnectionMap
implements Constants {
    private static final TraceComponent _tc = Tr.register(OneWayConnectionMap.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static ConcurrentHashMap<String, AsyncResponseConnection> hmap = null;
    private static OneWayConnectionMap onewayConnMap = null;

    private OneWayConnectionMap() {
        hmap = new ConcurrentHashMap(131, 0.75f);
    }

    public static final synchronized OneWayConnectionMap getInstance() {
        if (onewayConnMap == null) {
            onewayConnMap = new OneWayConnectionMap();
        }
        return onewayConnMap;
    }

    public synchronized void putConnection(String hashKey, AsyncResponseConnection asyRespC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OneWayConnectionMap.putConnection()...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Related objects: " + asyRespC.getConnection() + ", " + asyRespC.gethashKey());
        }
        if (!hmap.containsKey(hashKey)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Puting " + asyRespC + " in map with key: " + hashKey);
            }
            hmap.put(hashKey, asyRespC);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...OneWayConnectionMap.putConnection()");
        }
    }

    public boolean containsKey(String hashKey) {
        boolean result = false;
        if (hmap.containsKey(hashKey)) {
            result = true;
        }
        return result;
    }

    public synchronized void cleanupConnections() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OneWayConnectionMap.cleanupConnections()...");
        }
        if (hmap != null && !hmap.isEmpty()) {
            HTTPConnection co = null;
            for (String key : hmap.keySet()) {
                AsyncResponseConnection arc = hmap.get(key);
                if (arc == null) continue;
                co = arc.getConnection();
                long oneWayRecycleTime = arc.getRecycleTime();
                long sincelastAccess = co.timeFromLastAccess();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Connection last access elapsed time in ms : " + sincelastAccess + " Recycle time in ms : " + oneWayRecycleTime);
                }
                if (sincelastAccess < oneWayRecycleTime) continue;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One way connection time limit exceeded. Resetting the connection and removing key: " + key);
                }
                arc.resetConnection();
                hmap.remove(key);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...OneWayConnectionMap.cleanupConnections()");
        }
    }
}

