/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.transport.AsyncResponseConnection;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import java.util.concurrent.ConcurrentHashMap;

public final class AsyncResponseConnectionMap
implements Constants {
    private static final TraceComponent _tc = Tr.register(AsyncResponseConnectionMap.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static ConcurrentHashMap<String, AsyncResponseConnection> hmap = null;
    private static AsyncResponseConnectionMap asyncRConnMap = null;
    private static long ASYNCRESPONSEWAITTIME = 180000L;

    private AsyncResponseConnectionMap() {
        hmap = new ConcurrentHashMap(131, 0.75f);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.asyncResponseWaitTime: " + ASYNCRESPONSEWAITTIME + " ms");
        }
    }

    public static final synchronized AsyncResponseConnectionMap getInstance() {
        if (asyncRConnMap == null) {
            asyncRConnMap = new AsyncResponseConnectionMap();
        }
        return asyncRConnMap;
    }

    public synchronized void putConnection(String hashKey, AsyncResponseConnection asyRespC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseConnectionMap.putConnection()...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Related objects: " + asyRespC.getConnection() + ", " + asyRespC.gethashKey());
        }
        if (!hmap.containsKey(hashKey)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Puting " + asyRespC + " in map with key: " + hashKey);
            }
            hmap.put(hashKey, asyRespC);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseConnectionMap.putConnection()");
        }
    }

    public AsyncResponseConnection getConnection(String hashKey) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseConnectionMap.getConnection()...");
        }
        AsyncResponseConnection asyRespC = null;
        if (hmap != null && !hmap.isEmpty()) {
            asyRespC = hmap.get(hashKey);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Got " + asyRespC + " in map with key: " + hashKey);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseConnectionMap.getConnection()");
        }
        return asyRespC;
    }

    public synchronized void removeConnection(String hashKey) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseConnectionMap.removeConnection()...");
        }
        if (!hmap.isEmpty() && hmap.containsKey(hashKey)) {
            AsyncResponseConnection asyRespC = hmap.get(hashKey);
            asyRespC = hmap.remove(hashKey);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removed " + asyRespC + " in map with key: " + hashKey);
                Tr.debug(_tc, "Current map size: " + hmap.size());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseConnectionMap.removeConnection()");
        }
    }

    public synchronized boolean containsKey(String hashKey) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseConnectionMap.containsKey()...");
        }
        boolean doesContain = hmap.containsKey(hashKey);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Contains key: " + hashKey + "? " + doesContain);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseConnectionMap.containsKey()");
        }
        return doesContain;
    }

    public synchronized void removeHTTPConnection(HTTPConnection co) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseConnectionMap.removeHTTPConnection()...");
        }
        if (hmap != null && !hmap.isEmpty() && co != null) {
            for (String key : hmap.keySet()) {
                AsyncResponseConnection arc = hmap.get(key);
                if (co != arc.getConnection()) continue;
                hmap.remove(key);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Match found, removing key: " + key);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseConnectionMap.removeHTTPConnection()");
        }
    }

    public synchronized void cleanupConnections() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseConnectionMap.cleanupConnections()...");
        }
        if (hmap != null && !hmap.isEmpty()) {
            HTTPConnection co = null;
            for (String key : hmap.keySet()) {
                AsyncResponseConnection arc = hmap.get(key);
                if (arc == null) continue;
                co = arc.getConnection();
                long sincelastAccess = co.timeFromLastAccess();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Connection last access elapsed time in ms : " + sincelastAccess);
                }
                if (sincelastAccess < ASYNCRESPONSEWAITTIME) continue;
                arc.disconnectConnection();
                hmap.remove(key);
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Async Response time limit exceeded. Removing key: " + key);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseConnectionMap.cleanupConnections()");
        }
    }

    static {
        ASYNCRESPONSEWAITTIME = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.asyncResponseWaitTime", "1800")) * 1000;
    }
}

