/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.trace;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.trace.MessageTrace;
import java.io.IOException;
import java.io.OutputStream;

public class LogOutputStream
extends OutputStream {
    private byte[] temp = new byte[1];
    private boolean isDebugEnabled = false;
    private long count = 0L;
    private TraceComponent tc;
    private int BUFFER_LEN = 4096;
    private byte[] buffer = new byte[this.BUFFER_LEN];
    private int bufferIndex = 0;
    private int limit;
    private String message;
    private String contentType;

    public LogOutputStream(TraceComponent tc, int limit, String mess, String content) {
        this.isDebugEnabled = tc.isDebugEnabled();
        this.tc = tc;
        this.limit = limit;
        this.message = mess;
        this.contentType = JavaUtils.hasValue(content) ? content : new String("text/html");
    }

    public long getLength() {
        return this.count;
    }

    public void close() throws IOException {
        if (this.bufferIndex > 0) {
            MessageTrace.log(this.message, this.contentType, new String(this.buffer, 0, this.bufferIndex));
            this.bufferIndex = 0;
        }
        this.buffer = null;
        this.temp = null;
        this.tc = null;
    }

    public void flush() throws IOException {
        if (this.bufferIndex > 0) {
            MessageTrace.log(this.message, this.contentType, new String(this.buffer, 0, this.bufferIndex));
            this.bufferIndex = 0;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.count >= (long)this.limit) {
            this.count += (long)len;
            return;
        }
        if (this.count + (long)len >= (long)this.limit) {
            len = (int)((long)len - ((long)this.limit - this.count));
            this.count += (long)len;
        } else {
            this.count += (long)len;
        }
        if (this.isDebugEnabled) {
            if (len + this.bufferIndex < this.BUFFER_LEN) {
                System.arraycopy(b, off, this.buffer, this.bufferIndex, len);
                this.bufferIndex += len;
            } else {
                if (this.bufferIndex > 0) {
                    MessageTrace.log(this.message, this.contentType, new String(this.buffer, 0, this.bufferIndex));
                    this.bufferIndex = 0;
                }
                if (len + this.bufferIndex < this.BUFFER_LEN) {
                    System.arraycopy(b, off, this.buffer, this.bufferIndex, len);
                    this.bufferIndex += len;
                } else {
                    MessageTrace.log(this.message, this.contentType, new String(b, off, len));
                }
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.temp[0] = (byte)b;
        this.write(this.temp, 0, 1);
    }
}

