/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.server.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.ejbcontainer.WSEJBHandlerResolver;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSEJBHandlerResolver
implements WSEJBHandlerResolver {
    private static final TraceComponent tc = Tr.register(JAXWSEJBHandlerResolver.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public List<Class<?>> retrieveJAXWSHandlers(J2EEName j2EEName) {
        AxisService ejbService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveJAXWSHandlers, j2EEName= " + j2EEName);
        }
        ServerModuleMetaData smmd = this.getServerModuleMetaData();
        List<Class<?>> handlerClasses = null;
        if (smmd != null && (ejbService = this.getEJBService(smmd, j2EEName)) != null) {
            handlerClasses = this.getHandlerClasses(ejbService);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveJAXWSHandlers, j2EEName= " + j2EEName + ", handler class size: " + (handlerClasses == null ? 0 : handlerClasses.size()));
        }
        return handlerClasses;
    }

    AxisService getEJBService(ServerModuleMetaData smmd, J2EEName j2EEName) {
        AxisService ejbService = null;
        if (smmd.getConfigurationContext() != null && smmd.getConfigurationContext().getAxisConfiguration() != null) {
            AxisConfiguration axisConfiguration = smmd.getConfigurationContext().getAxisConfiguration();
            Parameter param = axisConfiguration.getParameter("J2EENameToServiceMap");
            if (param != null) {
                Map j2EENameMap = (Map)param.getValue();
                if (j2EENameMap != null && !j2EENameMap.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Looking for AxisService with J2EEName: " + j2EEName + " on AxisConfiguration cached map");
                    }
                } else {
                    ejbService = this.getServiceFromConfig(j2EEName, axisConfiguration);
                }
            } else {
                ejbService = this.getServiceFromConfig(j2EEName, axisConfiguration);
            }
        }
        return ejbService;
    }

    AxisService getServiceFromConfig(J2EEName j2EEName, AxisConfiguration axisConfiguration) {
        AxisService ejbService;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServiceFromConfig, j2EEName= " + j2EEName);
            }
            ejbService = null;
            boolean found = false;
            HashMap servicesMap = axisConfiguration.getServices();
            String key = j2EEName.getApplication() + j2EEName.getModule() + j2EEName.getComponent();
            if (servicesMap != null && !servicesMap.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking for AxisService with J2EEName: " + j2EEName + " on AxisConfiguration services map");
                }
                HashMap<String, AxisService> j2EENameMap = new HashMap<String, AxisService>();
                for (AxisService service : servicesMap.values()) {
                    Parameter param = service.getParameter("EJB_J2EE_NAME");
                    if (param == null || param.getValue() == null) continue;
                    J2EEName paramValue = (J2EEName)param.getValue();
                    String paramKey = paramValue.getApplication() + paramValue.getModule() + paramValue.getComponent();
                    j2EENameMap.put(paramKey, service);
                    if (found || !key.equals(paramKey)) continue;
                    ejbService = service;
                    found = true;
                }
                Parameter param = new Parameter("J2EENameToServiceMap", j2EENameMap);
                try {
                    axisConfiguration.addParameter(param);
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) break block7;
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    Tr.debug(tc, "Did not store J2EEName to AxisService map on AxisConfiguration because of the following error: " + t.toString() + "\n" + sw.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceFromConfig, j2EEName= " + j2EEName + ", service= " + ejbService);
        }
        return ejbService;
    }

    List<Class<?>> getHandlerClasses(AxisService axisService) {
        LinkedList<Class> handlerClasses = null;
        Parameter param = axisService.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        ClassLoader classLoader = axisService.getClassLoader();
        if (param != null) {
            EndpointDescription ed;
            HandlerChainsType handlerChainsType;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EndpointDescription parameter found on AxisService");
            }
            if ((handlerChainsType = (ed = (EndpointDescription)param.getValue()).getHandlerChain()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found HandlerChainsType object on EndpointDescription");
                }
                handlerClasses = new LinkedList<Class>();
                for (HandlerChainType hcType : handlerChainsType.getHandlerChain()) {
                    for (HandlerType hType : hcType.getHandler()) {
                        String msg;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding handler class: " + hType.getHandlerClass().getValue());
                        }
                        Class handlerClass = null;
                        String handlerClassName = hType.getHandlerClass().getValue();
                        try {
                            handlerClass = ClassUtils.forName(handlerClassName, false, classLoader);
                            handlerClasses.add(handlerClass);
                        }
                        catch (ClassNotFoundException cnfe) {
                            msg = NLSProvider.getNLS().getFormattedMessage("handlerLoadFail00", new Object[]{handlerClassName, cnfe}, "The {0} JAX-WS application handler class could not be loaded because of the following error: {1}.");
                            Tr.error(tc, msg);
                            cnfe.printStackTrace();
                        }
                        catch (ClassCastException classCastException) {
                            msg = NLSProvider.getNLS().getFormattedMessage("handlerLoadFail01", new Object[]{handlerClassName}, "The {0} class was specified as a JAX-WS application handler but it is not a javax.xml.ws.handler.Handler type.");
                            Tr.error(tc, msg);
                        }
                    }
                }
            }
        }
        return handlerClasses;
    }

    ServerModuleMetaData getServerModuleMetaData() {
        ServerModuleMetaData smmd;
        block3: {
            smmd = null;
            try {
                Object obj;
                WASAxis2Service service = WsServiceRegistry.getService(this, WASAxis2Service.class);
                if (service != null && (obj = service.getModuleMetaData()) != null) {
                    smmd = (ServerModuleMetaData)obj;
                }
            }
            catch (Throwable t) {
                if (!tc.isDebugEnabled()) break block3;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                Tr.debug(tc, "Could not locate ServerModuleMetaData for module because of thefollowing error: " + t.toString() + "\n" + sw.toString());
            }
        }
        return smmd;
    }
}

