/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.server.dispatcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;

public class WSEndpointUtils {
    private static final TraceComponent _tc = Tr.register(WSEndpointUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static synchronized OperationDescription getOperationDescription(MessageContext messageContext) throws Exception {
        OperationDescription[] ops;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getOperationDescription");
        }
        EndpointDescription ed = messageContext.getEndpointDescription();
        EndpointInterfaceDescription eid = ed.getEndpointInterfaceDescription();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Getting dispatchable operation for: " + messageContext.getOperationName());
        }
        if ((ops = eid.getDispatchableOperation(messageContext.getOperationName())) == null || ops.length == 0) {
            String msg = NLSProvider.getNLS().getFormattedMessage("getOperationDescFail01", new Object[]{messageContext.getOperationName()}, "An OperationDescription could not be found for the {0} operation.");
            throw new Exception(msg);
        }
        if (ops.length > 1) {
            String msg = NLSProvider.getNLS().getFormattedMessage("getOperationDescFail02", new Object[]{messageContext.getOperationName()}, "More than one OperationDescription was found for the {0} operation.");
            throw new Exception(msg);
        }
        OperationDescription op = ops[0];
        if (op == null) {
            String msg = NLSProvider.getNLS().getFormattedMessage("getOperationDescFail01", new Object[]{messageContext.getOperationName()}, "An OperationDescription could not be found for the {0} operation.");
            throw new Exception(msg);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "For wsdl:operation: " + op.getName() + " OperationDescription was " + "found for java method: " + op.getJavaMethodName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getOperationDescription");
        }
        return op;
    }

    public static synchronized void setClassLoaderOnResponse(MessageContext messageContext) {
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        messageContext.setProperty("CACHE_CLASSLOADER", cl);
    }

    public static void setClassLoaderOnThread(MessageContext messageContext) throws Exception {
        AxisService axisService = messageContext.getAxisMessageContext().getAxisService();
        J2EEName j2EEName = (J2EEName)Axis2Utils.getParameterValue(axisService, "EJB_J2EE_NAME");
        EJBContainer ejbContainer = WsServiceRegistry.getService(axisService, EJBContainer.class);
        final ClassLoader ejbClassLoader = ejbContainer.getClassLoader(j2EEName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ejbClassLoader);
                return null;
            }
        });
    }
}

