/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionUtil;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.util.HashMap;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.ServiceInstanceFactory;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServiceInstanceFactory
implements ServiceInstanceFactory {
    private static final TraceComponent _tc = Tr.register(WSServiceInstanceFactory.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static WASAxis2Service service;
    private static boolean serviceInitialized;

    @Override
    public Object createServiceInstance(MessageContext request, Class serviceClass) throws Exception {
        Object serviceInstance = null;
        if (_tc.isEntryEnabled()) {
            Tr.debug(_tc, "createServiceInstance= " + serviceClass.getName());
        }
        AxisService axisService = request.getAxisMessageContext().getAxisService();
        EndpointLifecycleManagerFactory elmf = (EndpointLifecycleManagerFactory)FactoryRegistry.getFactory(EndpointLifecycleManagerFactory.class);
        EndpointLifecycleManager elm = elmf.createEndpointLifecycleManager();
        if (Axis2Utils.getParameterValue(axisService, "EJB_J2EE_NAME") != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Getting service instance for EJB JAX-WS endpoint");
            }
            if ((serviceInstance = request.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE")) == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("ejbInvokeFail03", new Object[]{serviceClass.getName()}, "Internal error. An instance of the {0} web service implementation class could not be located.");
                throw new Exception(msg);
            }
            elm.createServiceInstance(request, serviceInstance.getClass());
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating service instance for WAR JAX-WS endpoint");
            }
            HashMap<Class<?>, InjectionTarget[]> injectionTargets = this.getInjectionTargets();
            serviceInstance = InjectionUtil.createInjectedInstance((Class)serviceClass, injectionTargets);
            request.getAxisMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WARINSTANCE", serviceInstance);
            serviceInstance = elm.createServiceInstance(request, serviceClass);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createServiceInstance, serviceClass= " + serviceClass.getName() + ", instance= " + serviceInstance);
        }
        return serviceInstance;
    }

    protected HashMap<Class<?>, InjectionTarget[]> getInjectionTargets() throws Exception {
        try {
            this.initializeService();
            if (service != null) {
                ServerModuleMetaData smmd = (ServerModuleMetaData)service.getModuleMetaData();
                if (smmd != null) {
                    HashMap injectionTargets;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found ServerModuleMetaData for WAR endpoint creation");
                    }
                    if ((injectionTargets = (HashMap)smmd.getInjectionTargets()) != null && !injectionTargets.isEmpty() && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found non-empty injection targets in module: " + smmd.getModuleName());
                    }
                    return injectionTargets;
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Injection targets cannot be found because the WASAxis2Service is not available");
            }
            return null;
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("injectionMetaDataFail", new Object[]{e}, "Internal error. Injection targets could not be retrieved due to the following error: {0}");
            throw new Exception(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeService() throws Exception {
        if (!serviceInitialized) {
            try {
                service = WsServiceRegistry.getService(this, WASAxis2Service.class);
                Object var2_1 = null;
                serviceInitialized = true;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                serviceInitialized = true;
                throw throwable;
            }
        }
    }

    static {
        serviceInitialized = false;
    }
}

