/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.policyset.WSRMProvider;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class RMPolicyTypeLoader
implements PolicyTypeLoader {
    private static final TraceComponent tc = Tr.register(RMPolicyTypeLoader.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private WSRMProvider helper;

    public RMPolicyTypeLoader() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMPolicyTypeLoader");
        }
        this.helper = new WSRMProvider();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMPolicyTypeLoader", this);
        }
    }

    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
            Tr.exit(tc, "getType", "WSReliableMessaging");
        }
        return "WSReliableMessaging";
    }

    public void init(Map properties) {
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.helper = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void load(ClassLoader sysCL, VariableExpander expander, InputStream input, PolicySetConfiguration toComplete) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "load", new Object[]{sysCL, expander, input, toComplete});
        }
        try {
            Properties policy = this.helper.getAttributes(input, null);
            if (policy == null) {
                Tr.error(tc, "INVALID_POLICY_ERROR_CWSKA0355");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "load", "null Properties - unable to read policy file");
                }
                return;
            }
            String specLevel = policy.getProperty("specLevel");
            String qos = policy.getProperty("qualityOfService");
            String inorder = policy.getProperty("inOrderDelivery");
            String useMakeCon = policy.getProperty("useMakeConnection");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "spec level=" + specLevel + ", qos=" + qos + ", inOrder=" + inorder + " useMakeConnection=" + useMakeCon);
            }
            if (specLevel.equals("1.0")) {
                toComplete.setPolicyTypeConfiguration("Sandesha2RMSpecVersion", "Spec_2005_02");
            } else {
                toComplete.setPolicyTypeConfiguration("Sandesha2RMSpecVersion", "Spec_2007_02");
            }
            toComplete.setPolicyTypeConfiguration("qualityOfService", qos);
            if (qos == null || qos.equals("unmanagedNonPersistent")) {
                if (WSRMModule.isRunningOnZOs() && !WSRMModule.isRunningInClientJVM()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "load", "IllegalStateException - Running in non-client on zOS");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_PROPERTY_ERROR_CWSKA0352", null, null));
                }
                if (WSRMModule.getClusterName() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "load", "IllegalStateException - Running in cluster without managed!");
                    }
                    Tr.error(tc, "INVALID_POLICY_ERROR_CWSKA0356");
                    throw new IllegalStateException(nls.getFormattedMessage("INVALID_POLICY_ERROR_CWSKA0356", null, null));
                }
                toComplete.setPolicyTypeConfiguration("Sandesha2StorageManager", "inmemory");
            } else {
                toComplete.setPolicyTypeConfiguration("Sandesha2StorageManager", "persistent");
            }
            toComplete.setPolicyTypeConfiguration("inOrderDelivery", inorder);
            toComplete.setPolicyTypeConfiguration("useMakeConnection", useMakeCon);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.policyset.RMPolicyTypeLoader.load", "1:176:1.22", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "load", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "load");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/policyset/RMPolicyTypeLoader.java, WAS.rm, WAS70.SERV1, cf070937.21 1.22");
        }
    }
}

