/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.mbeans.dao;

import com.ibm.websphere.websvcs.rm.MessageData;
import java.io.Serializable;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.sandesha2.RMMsgContext;

public abstract class MessageData
implements Serializable,
com.ibm.websphere.websvcs.rm.MessageData {
    public final String toAddress;
    public final String fromAddress;
    public final String replyToAddress;
    public final MessageState state;
    public final MessageData.MessageState messageState;
    public final long sequenceMessageNumber;
    public final String sequenceID;
    public final String info_soap;
    public final String info_relatesTo;
    public final String info_msgID;
    public final String info_internalSeqID;

    MessageData(RMMsgContext msgCtx, String sequenceID, String internalSequenceID, long sequenceMessageNumber, MessageState state, MessageData.MessageState messageState) {
        this.info_msgID = msgCtx.getMessageId();
        EndpointReference toEPR = msgCtx.getTo();
        this.toAddress = toEPR != null ? toEPR.getAddress() : "";
        EndpointReference replyToEPR = msgCtx.getReplyTo();
        this.replyToAddress = replyToEPR != null ? replyToEPR.getAddress() : "";
        EndpointReference fromEPR = msgCtx.getFrom();
        this.fromAddress = fromEPR != null ? fromEPR.getAddress() : "";
        RelatesTo axisRelatesTo = msgCtx.getRelatesTo();
        this.info_relatesTo = axisRelatesTo != null ? axisRelatesTo.getValue() : "";
        this.info_soap = msgCtx.getSOAPEnvelope().toString();
        this.sequenceID = sequenceID;
        this.info_internalSeqID = internalSequenceID;
        this.sequenceMessageNumber = sequenceMessageNumber;
        this.state = state;
        this.messageState = messageState;
    }

    public String toString() {
        return this.info_soap.toString();
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getReplyToAddress() {
        return this.replyToAddress;
    }

    public MessageData.MessageState getState() {
        return this.messageState;
    }

    public long getSequenceMessageNumber() {
        return this.sequenceMessageNumber;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public String getInfo_soap() {
        return this.info_soap;
    }

    public String getInfo_relatesTo() {
        return this.info_relatesTo;
    }

    public String getInfo_msgID() {
        return this.info_msgID;
    }

    public String getInfo_internalSeqID() {
        return this.info_internalSeqID;
    }

    public static class MessageState
    extends MessageData.MessageState
    implements Serializable {
        private static final long serialVersionUID = -5849351010014153373L;

        public MessageState(int state, String description, boolean is_problem_state) {
            super(state, description, is_problem_state);
        }
    }
}

