/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.mbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.rm.mbeans.AbstractWSRMMBean;
import com.ibm.ws.websvcs.rm.storage.controller.ControllableStore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WSRMApplicationMBean
extends AbstractWSRMMBean {
    private static final TraceComponent tc = Tr.register(WSRMApplicationMBean.class, "SIBWSRM", "com.ibm.ws.sib.wsrm.CWSJZMessages");
    public static final String MBEAN_TYPE = "WSRMApplicationMBean";
    public static final String WSRM_CELL_PROPERTY = "cell";
    public static final String WSRM_CLUSTER_PROPERTY = "cluster";
    public static final String WSRM_NODE_PROPERTY = "node";
    public static final String WSRM_SERVER_PROPERTY = "server";
    public static final String WSRM_APP_PROPERTY = "application";
    public static final String WSRM_APP_MODULE_PROPERTY = "application_module";
    private static HashMap<String, WSRMApplicationMBean> registeredMBeans;

    public WSRMApplicationMBean(ControllableStore store) {
        super(store, MBEAN_TYPE);
    }

    private static synchronized void eventMBeanRegistered(WSRMApplicationMBean mbean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "eventMBeanRegistered", mbean);
        }
        registeredMBeans.put(mbean.mbean_name, mbean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "eventMBeanRegistered");
        }
    }

    private static synchronized boolean applicationAlreadyHasMBeanRegistered(WSRMApplicationMBean mbean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "applicationAlreadyHasMBeanRegistered", mbean);
        }
        boolean returnValue = false;
        if (registeredMBeans.containsKey(mbean.mbean_name)) {
            returnValue = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "applicationAlreadyHasMBeanRegistered", new Boolean(returnValue));
        }
        return returnValue;
    }

    private static synchronized void eventMBeanDeRegistered(WSRMApplicationMBean mbean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "eventMBeanDeRegistered", mbean);
        }
        registeredMBeans.remove(mbean.mbean_name);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "eventMBeanDeRegistered");
        }
    }

    public static synchronized void deregisterAllMBeans() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterAllMBeans");
        }
        Collection registeredMBeansClone = ((Map)registeredMBeans.clone()).values();
        Iterator mbeans = registeredMBeansClone.iterator();
        while (mbeans.hasNext()) {
            try {
                ((WSRMApplicationMBean)mbeans.next()).deregister();
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.mbeans.WSRMApplicationMBean.deregisterAllMBeans", "1:193:1.10");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterAllMBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() throws AdminException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "register");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!WSRMApplicationMBean.applicationAlreadyHasMBeanRegistered(this)) {
                super.register();
                WSRMApplicationMBean.eventMBeanRegistered(this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "register");
        }
    }

    public void deregister() throws AdminException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deregister");
        }
        if (this.isRegistered) {
            super.deregister();
            WSRMApplicationMBean.eventMBeanDeRegistered(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deregister");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/mbeans/WSRMApplicationMBean.java, SIB.rm, WAS70.SERV1, cf070937.21 1.10");
        }
        registeredMBeans = new HashMap();
    }
}

