/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.mbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.websvcs.rm.mbeans.dao.InboundSequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.MessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.SequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import com.ibm.ws.websvcs.rm.mbeans.exceptions.WSRMMBeanException;
import com.ibm.ws.websvcs.rm.storage.controller.ControllableStore;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Locale;

public abstract class AbstractWSRMMBean {
    private static final TraceComponent tc = Tr.register(AbstractWSRMMBean.class, "SIBWSRM", "com.ibm.ws.sib.wsrm.CWSJZMessages");
    protected ControllableStore store;
    protected String mbean_name;
    protected String mbean_type;
    protected String mbean_description;
    protected boolean isRegistered = false;

    public AbstractWSRMMBean(ControllableStore store, String mbean_type) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractWSRMMBean", new Object[]{store, mbean_type});
        }
        this.store = store;
        StorageManagerDetail detail = store.getStorageManagerDetails(null);
        this.mbean_name = detail.storageManagerName;
        this.mbean_type = mbean_type;
        this.mbean_description = detail.storageManagerDescription;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractWSRMMBean", this);
        }
    }

    public synchronized void register() throws AdminException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "register");
        }
        if (!this.isRegistered) {
            MBeanFactory mbeanFactory = (MBeanFactory)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return AdminServiceFactory.getMBeanFactory();
                }
            });
            DefaultRuntimeCollaborator iCollab = new DefaultRuntimeCollaborator(this, this.mbean_name);
            String description = null;
            String configId = this.mbean_name;
            mbeanFactory.activateMBean(this.mbean_type, iCollab, configId, description, this.store.getProperties());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "registerd jmx ", new Object[]{this, this.mbean_type, iCollab, configId, description});
            }
            this.isRegistered = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "register");
        }
    }

    public synchronized void deregister() throws AdminException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deregister");
        }
        if (this.isRegistered) {
            MBeanFactory mbeanFactory = (MBeanFactory)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return AdminServiceFactory.getMBeanFactory();
                }
            });
            mbeanFactory.deactivateMBean(this.mbean_name);
            this.isRegistered = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deregister");
        }
    }

    public String getMBeanID() {
        return this.mbean_name;
    }

    public StorageManagerDetail getStorageManagerDetails() {
        return this.store.getStorageManagerDetails(Locale.getDefault());
    }

    public StorageManagerDetail getStorageManagerDetails(Locale locale) {
        return this.store.getStorageManagerDetails(locale);
    }

    public com.ibm.websphere.websvcs.rm.StorageManagerDetail getStorageManagerDetail(Locale locale) {
        return this.store.getStorageManagerDetail(locale);
    }

    public boolean hasProblemInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(true, false, null).size() > 0;
    }

    public boolean hasWarningInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(false, true, null).size() > 0;
    }

    public Collection getAllProblemInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(true, false, null);
    }

    public Collection getAllWarningInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(false, true, null);
    }

    public Collection getAllOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(false, false, null);
    }

    public boolean hasProblemOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(true, false, null).size() > 0;
    }

    public boolean hasWarningOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(false, true, null).size() > 0;
    }

    public Collection getAllProblemOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(true, false, null);
    }

    public Collection getAllWarningOutboundSequences() throws WSRMMBeanException {
        return this.store.getOutboundSequences(false, true, null);
    }

    public Collection getAllInboundSequences() throws WSRMMBeanException {
        return this.store.getInboundSequences(false, false, null);
    }

    public Collection getAllOutboundMessagesOnSequence(OutboundSequenceData data) throws WSRMMBeanException {
        return this.store.getOutboundMessagesOnSequence(data);
    }

    public Collection getAllOutboundMessagesOnSequence(com.ibm.websphere.websvcs.rm.OutboundSequenceData data) throws WSRMMBeanException {
        return this.store.getOutboundMessagesOnSequence(data);
    }

    public Collection getAllInboundMessagesOnSequence(InboundSequenceData data) throws WSRMMBeanException {
        return this.store.getInboundMessagesOnSequence(data);
    }

    public Collection getAllInboundMessagesOnSequence(com.ibm.websphere.websvcs.rm.InboundSequenceData data) throws WSRMMBeanException {
        return this.store.getInboundMessagesOnSequence(data);
    }

    public void reallocateMessagesOnOutboundSequence(OutboundSequenceData sequenceData, String newDestinationAddress) throws WSRMMBeanException {
        this.store.reallocateOutboundMessagesToNewSequence(sequenceData, newDestinationAddress);
    }

    public void reallocateMessagesOnOutboundSequence(com.ibm.websphere.websvcs.rm.OutboundSequenceData sequenceData, String newDestinationAddress) throws WSRMMBeanException {
        this.store.reallocateOutboundMessagesToNewSequence(sequenceData, newDestinationAddress);
    }

    public void deleteSequence(SequenceData sequence) throws WSRMMBeanException {
        this.store.deleteSequence(sequence);
    }

    public void deleteSequence(com.ibm.websphere.websvcs.rm.SequenceData sequence) throws WSRMMBeanException {
        this.store.deleteSequence(sequence);
    }

    public void deleteMessage(MessageData data) throws WSRMMBeanException {
        this.store.deleteMessage(data);
    }

    public void deleteMessage(com.ibm.websphere.websvcs.rm.MessageData data) throws WSRMMBeanException {
        this.store.deleteMessage(data);
    }

    public void forceDispatchOfMessagesOnInboundSequence(InboundSequenceData sequenceData) throws WSRMMBeanException {
        this.store.forceDispatchOfInboundMessages(sequenceData);
    }

    public void forceDispatchOfMessagesOnInboundSequence(com.ibm.websphere.websvcs.rm.InboundSequenceData sequenceData) throws WSRMMBeanException {
        this.store.forceDispatchOfInboundMessages(sequenceData);
    }

    public SequenceData refreshSequenceData(SequenceData data) throws WSRMMBeanException {
        return this.store.refreshSequenceData(data);
    }

    public SequenceData refreshSequenceData(com.ibm.websphere.websvcs.rm.SequenceData data) throws WSRMMBeanException {
        return this.store.refreshSequenceData(data);
    }

    public byte[][] writeMessagesToDisk(SequenceData sequenceData) throws WSRMMBeanException {
        byte[][] messages = this.store.writeOutstandingSequenceMessagesToBuffer(sequenceData);
        return messages;
    }

    public byte[][] writeMessagesToDisk(com.ibm.websphere.websvcs.rm.SequenceData sequenceData) throws WSRMMBeanException {
        byte[][] messages = this.store.writeOutstandingSequenceMessagesToBuffer(sequenceData);
        return messages;
    }

    public void closeSequence(SequenceData sequenceData) throws WSRMMBeanException {
        this.store.closeSequence(sequenceData);
    }

    public void closeSequence(com.ibm.websphere.websvcs.rm.SequenceData sequenceData) throws WSRMMBeanException {
        this.store.closeSequence(sequenceData);
    }

    public void terminateSequence(SequenceData sequenceData) throws WSRMMBeanException {
        this.store.terminateSequence(sequenceData);
    }

    public void terminateSequence(com.ibm.websphere.websvcs.rm.SequenceData sequenceData) throws WSRMMBeanException {
        this.store.terminateSequence(sequenceData);
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm/src/com/ibm/ws/websvcs/rm/mbeans/AbstractWSRMMBean.java, SIB.rm, WAS70.SERV1, cf070937.21 1.20");
        }
    }
}

