/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage.beanmanagers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.SenderBean;

public class SenderBeanMgrImpl
implements SenderBeanMgr {
    private static final TraceComponent tc = Tr.register(SenderBeanMgrImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;

    public SenderBeanMgrImpl(PersistentStorageManagerSingleton storageManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SenderBeanMgrImpl", new Object[]{storageManager});
        }
        this._storageManager = storageManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SenderBeanMgrImpl", this);
        }
    }

    public boolean delete(String messageId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", messageId);
        }
        this._storageManager.getInUseTransaction().deleteSenderBean(messageId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", Boolean.TRUE);
        }
        return true;
    }

    public SenderBean retrieve(String messageId) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", messageId);
        }
        String[] data = new String[]{this._storageManager.getWorkKey(), messageId, this._storageManager.getInUseTransaction().getSequenceToken()};
        HashMap result = this._storageManager.getCommandInvoker().retrieveSenderBean(data);
        SenderBean temp = null;
        if (result != null) {
            temp = (SenderBean)result.get(WSRMConstants.SENDER_BEAN);
            String token = (String)result.get("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(token);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", temp);
        }
        return temp;
    }

    public boolean insert(SenderBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", bean);
        }
        if (bean.getMessageID() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "insert", "SandeshaStorageException");
            }
            throw new SandeshaStorageException("Key (MessageId) is null. Cant insert.");
        }
        this._storageManager.getInUseTransaction().insertSenderBean(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert", Boolean.TRUE);
        }
        return true;
    }

    public List find(String internalSequenceID) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", internalSequenceID);
        }
        String[] data = new String[]{this._storageManager.getWorkKey(), internalSequenceID, this._storageManager.getInUseTransaction().getSequenceToken()};
        HashMap result = this._storageManager.getCommandInvoker().findSenderBeansForSequence2(data);
        List beans = null;
        if (result == null) {
            beans = this._storageManager.getCommandInvoker().findSenderBeansForSequence(data);
        } else {
            beans = (List)result.get(WSRMConstants.SENDER_BEAN);
            String token = (String)result.get("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(token);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", beans);
        }
        return beans;
    }

    public List find(SenderBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", new Object[]{bean});
        }
        Object[] properties = new Object[]{this._storageManager.getWorkKey(), bean, this._storageManager.getInUseTransaction().getSequenceToken()};
        HashMap result = this._storageManager.getCommandInvoker().findSenderBeansWithLock(properties);
        List beans = null;
        if (result == null) {
            beans = this._storageManager.getCommandInvoker().findSenderBeans(properties);
        } else {
            beans = (List)result.get(WSRMConstants.SENDER_BEAN);
            String token = (String)result.get("TOKEN");
            HashMap mappedKeys = (HashMap)result.get("MSG_CONTEXTS");
            this._storageManager.getInUseTransaction().setSequenceToken(token);
            if (mappedKeys != null) {
                for (String key : mappedKeys.keySet()) {
                    this._storageManager.addMappedKey(key, (String)mappedKeys.get(key));
                }
            }
        }
        ArrayList deletedBeans = this._storageManager.getInUseTransaction().getDeletedSenderBeans();
        if (deletedBeans != null && beans != null && beans.size() > 0) {
            Iterator iter = beans.iterator();
            while (iter.hasNext()) {
                SenderBean temp = (SenderBean)iter.next();
                if (!deletedBeans.contains(temp.getMessageID())) continue;
                iter.remove();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", beans);
        }
        return beans;
    }

    public SenderBean getNextMsgToSend(String sequenceId) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextMsgToSend", sequenceId);
        }
        HashMap<Object, String> sendingProperties = new HashMap<Object, String>();
        sendingProperties.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        sendingProperties.put(WSRMConstants.APP_KEY, this._storageManager.getApplicationInstanceKey());
        sendingProperties.put("SEQUENCEID", sequenceId);
        sendingProperties.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
        HashMap result = this._storageManager.getCommandInvoker().getNextMessageToSend(sendingProperties);
        SenderBean temp = null;
        if (result != null) {
            temp = (SenderBean)result.get(WSRMConstants.SENDER_BEAN);
            String token = (String)result.get("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(token);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextMsgToSend", temp);
        }
        return temp;
    }

    public boolean update(SenderBean bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "update", new Object[]{bean, bean.getSequenceID(), bean.getInternalSequenceID(), bean.getMessageID()});
        }
        this._storageManager.getInUseTransaction().updateSenderBean(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "update", Boolean.TRUE);
        }
        return true;
    }

    public SenderBean findUnique(SenderBean bean) throws SandeshaStorageException {
        List beans;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findUnique", bean);
        }
        if ((beans = this.find(bean)).size() > 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findUnique", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"SenderBeanMgrImpl.findUnique", "1:302:1.24"}, null));
        }
        SenderBean returnBean = null;
        if (beans.size() == 1) {
            returnBean = (SenderBean)beans.get(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findUnique", returnBean);
        }
        return returnBean;
    }

    public synchronized SenderBean retrieveFromMessageRefKey(String messageContextRefKey) {
        throw new IllegalStateException("Internal error: SenderBeanMgrImpl.retrieveFromMessageRefKey");
    }

    public SenderBean retrieve(String sequenceId, long messageNumber) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", new Object[]{sequenceId, messageNumber});
        }
        SenderBean bean = null;
        SenderBean matcher = new SenderBean();
        matcher.setSequenceID(sequenceId);
        matcher.setMessageNumber(messageNumber);
        bean = this.findUnique(matcher);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", bean);
        }
        return bean;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/beanmanagers/SenderBeanMgrImpl.java, WAS.rm, WAS70.SERV1, cf070937.21 1.26");
        }
    }
}

