/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage.beanmanagers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl;
import java.util.HashMap;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMSBeanMgrImpl
implements RMSBeanMgr {
    private static final TraceComponent tc = Tr.register(RMSBeanMgrImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;

    public RMSBeanMgrImpl(PersistentStorageManagerSingleton storageManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMSBeanMgrImpl", storageManager);
        }
        this._storageManager = storageManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMSBeanMgrImpl", this);
        }
    }

    @Override
    public boolean insert(RMSBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{bean, bean.getSequenceID(), bean.getInternalSequenceID(), bean.getCreateSeqMsgID()});
        }
        boolean result = this._storageManager.getInUseTransaction().insertRMSBean(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert", result);
        }
        return result;
    }

    @Override
    public boolean delete(String msgId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", msgId);
        }
        this._storageManager.getInUseTransaction().deleteRMSBean(msgId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", Boolean.TRUE);
        }
        return true;
    }

    @Override
    public RMSBean retrieve(String msgId) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", msgId);
        }
        HashMap<Object, String> properties = new HashMap<Object, String>();
        properties.put(WSRMConstants.RMS_BEAN, msgId);
        properties.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        properties.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
        HashMap result = this._storageManager.getCommandInvoker().retrieveRMSBean(properties);
        RMSBean resultBean = (RMSBean)result.get(WSRMConstants.RMS_BEAN);
        this._storageManager.getInUseTransaction().setSequenceToken((String)result.get("TOKEN"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", resultBean);
        }
        return resultBean;
    }

    @Override
    public boolean update(RMSBean bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "update", bean);
        }
        this._storageManager.getInUseTransaction().updateRMSBean(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "update", Boolean.TRUE);
        }
        return true;
    }

    @Override
    public List<?> find(RMSBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", new Object[]{bean.getInternalSequenceID(), bean.getSequenceID()});
        }
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put(WSRMConstants.RMS_BEAN, bean);
        properties.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        properties.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
        HashMap result = this._storageManager.getCommandInvoker().findRMSBeans(properties);
        this._storageManager.getInUseTransaction().setSequenceToken((String)result.get("TOKEN"));
        List list = (List)result.get(WSRMConstants.RMS_BEAN);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", list);
        }
        return list;
    }

    @Override
    public RMSBean findUnique(RMSBean bean) throws SandeshaStorageException {
        RMSBean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findUnique", new Object[]{bean.getInternalSequenceID(), bean.getSequenceID()});
        }
        if ((result = this._storageManager.getInUseTransaction().getRMSBean(bean)) == null) {
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            properties.put(WSRMConstants.RMS_BEAN, bean);
            properties.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
            properties.put("TOKEN", this._storageManager.getInUseTransaction().getSequenceToken());
            HashMap resultMap = this._storageManager.getCommandInvoker().findUniqueRMSBean(properties);
            if (resultMap != null) {
                TransactionImpl tran = this._storageManager.getInUseTransaction();
                tran.setSequenceToken((String)resultMap.get("TOKEN"));
                result = (RMSBean)resultMap.get(WSRMConstants.RMS_BEAN);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findUnique", result);
        }
        return result;
    }

    @Override
    public RMSBean retrieveBySequenceID(String seqId) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveBySequenceID", seqId);
        }
        RMSBean bean = null;
        RMSBean finder = new RMSBean();
        finder.setSequenceID(seqId);
        bean = this.findUnique(finder);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveBySequenceID", bean);
        }
        return bean;
    }

    @Override
    public RMSBean retrieveByInternalSequenceID(String internalSeqId) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveByInternalSequenceID", internalSeqId);
        }
        RMSBean bean = null;
        RMSBean finder = new RMSBean();
        finder.setInternalSequenceID(internalSeqId);
        bean = this.findUnique(finder);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveByInternalSequenceID", bean);
        }
        return bean;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/beanmanagers/RMSBeanMgrImpl.java, WAS.rm, WAS70.SERV1, cf070937.21 1.22");
        }
    }
}

