/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage.beanmanagers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;

public class RMDBeanMgrImpl
implements RMDBeanMgr {
    private static final TraceComponent tc = Tr.register(RMDBeanMgrImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;

    public RMDBeanMgrImpl(PersistentStorageManagerSingleton storageManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMDBeanMgrImpl", new Object[]{storageManager});
        }
        this._storageManager = storageManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMDBeanMgrImpl", this);
        }
    }

    public boolean delete(String sequenceId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", sequenceId);
        }
        this._storageManager.getInUseTransaction().deleteRMDBean(sequenceId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", Boolean.TRUE);
        }
        return true;
    }

    public RMDBean retrieve(String sequenceId) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", sequenceId);
        }
        RMDBean result = null;
        result = this._storageManager.getInUseTransaction().getRMDBean(sequenceId);
        if (result == null) {
            String token = this._storageManager.getInUseTransaction().getSequenceToken();
            HashMap<Object, String> data = new HashMap<Object, String>();
            data.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
            data.put("TOKEN", token);
            data.put("SEQUENCEID", sequenceId);
            HashMap response = this._storageManager.getCommandInvoker().retrieveRMDBean(data);
            if (response != null) {
                token = (String)response.remove("TOKEN");
                result = (RMDBean)response.remove("RMD_BEAN");
                this._storageManager.getInUseTransaction().setSequenceToken(token);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", result);
        }
        return result;
    }

    public boolean insert(RMDBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", bean);
        }
        boolean result = this._storageManager.getInUseTransaction().insertRMDBean(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert", result);
        }
        return result;
    }

    public List find(RMDBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", bean);
        }
        ArrayList beans = null;
        if (bean.getSequenceID() != null && !bean.isPollingMode()) {
            RMDBean result = this.retrieve(bean.getSequenceID());
            beans = new ArrayList();
            beans.add(result);
        } else {
            String token = this._storageManager.getInUseTransaction().getSequenceToken();
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            data.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
            data.put("TOKEN", token);
            data.put("RMD_BEAN", bean);
            HashMap response = this._storageManager.getCommandInvoker().findRMDBeans(data);
            token = (String)response.remove("TOKEN");
            this._storageManager.getInUseTransaction().setSequenceToken(token);
            beans = (ArrayList)response.remove("RMD_BEAN");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", beans);
        }
        return beans;
    }

    public boolean update(RMDBean bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "update", bean);
        }
        this._storageManager.getInUseTransaction().updateRMDBean(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "update", Boolean.TRUE);
        }
        return true;
    }

    public RMDBean findUnique(RMDBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findUnique", bean);
        }
        RMDBean result = this.retrieve(bean.getSequenceID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findUnique", result);
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/beanmanagers/RMDBeanMgrImpl.java, WAS.rm, WAS70.SERV1, cf070937.21 1.17");
        }
    }
}

