/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.UUID;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import java.io.Serializable;
import java.util.HashMap;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.sandesha2.storage.SandeshaStorageTransientException;

public class TransactionThreadMigrator
implements ThreadContextMigrator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceComponent tc = Tr.register(TransactionThreadMigrator.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    public static String TRAN_ENABLED_PROPERTY_STRING;
    private static TransactionThreadMigrator instance;
    private static HashMap threadCtxTable;

    public static synchronized TransactionThreadMigrator getInstance() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (instance == null) {
            new TransactionThreadMigrator();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionThreadMigrator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionThreadMigrator");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (instance == null) {
                threadCtxTable = new HashMap();
                instance = this;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionThreadMigrator", this);
        }
    }

    private boolean isMessageOutboundRequest(MessageContext ctx) {
        AxisOperation axisOperation;
        boolean returnValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isMessageOutboundRequest", ctx);
        }
        if (!(returnValue = this.isMessageOutboundOneWay(ctx)) && (axisOperation = ctx.getAxisOperation()) != null) {
            int mep = axisOperation.getAxisSpecificMEPConstant();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, mep + "");
            }
            if (16 == mep || 17 == mep) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, mep + "=a requesting msg");
                }
                returnValue = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isMessageOutboundRequest", returnValue);
        }
        return returnValue;
    }

    private boolean isMessageOutboundOneWay(MessageContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isMessageOutboundOneWay", ctx);
        }
        boolean returnValue = false;
        AxisOperation axisOperation = ctx.getAxisOperation();
        if (axisOperation != null) {
            int mep = axisOperation.getAxisSpecificMEPConstant();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, mep + "");
            }
            if (14 == mep) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, mep + "=outbound one way");
                }
                returnValue = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isMessageOutboundOneWay", returnValue);
        }
        return returnValue;
    }

    private boolean isUserRequestTxSend(MessageContext ctx) {
        boolean propertySet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserRequestTxSend", ctx);
        }
        Object property = ctx.getProperty(TRAN_ENABLED_PROPERTY_STRING);
        boolean bl = propertySet = Boolean.TRUE.toString().equals(property) || Boolean.TRUE.equals(property);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserRequestTxSend", propertySet);
        }
        return propertySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCurrentThreadTxContextByMsgCtx(MessageContext messageCtx, boolean assertTxPossible, boolean blockRequired) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeCurrentThreadTxContextByMsgCtx", new Object[]{messageCtx, assertTxPossible, blockRequired});
        }
        MessageContextID msgCtxID = new MessageContextID(messageCtx);
        try {
            Serializable e;
            ThreadTxContextInformation txCtxInfo = new ThreadTxContextInformation(blockRequired);
            if (assertTxPossible) {
                if (!txCtxInfo.hasStoredTxCtx()) {
                    IllegalStateException e2 = new IllegalStateException(nls.getFormattedMessage("NO_TX_CTX_CWSKA0552", new Object[]{messageCtx.getMessageID(), messageCtx.getAxisService().getName()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", e2);
                    }
                    throw e2;
                }
                if (!RMServiceConfigPlugin.isManagedQOS(messageCtx.getConfigurationContext().getAxisConfiguration())) {
                    e = new IllegalStateException(nls.getFormattedMessage("NO_TX_USING_UNMANAGED_CWSKA0553", new Object[]{messageCtx.getMessageID(), messageCtx.getAxisService().getName()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", e);
                    }
                }
            }
            e = threadCtxTable;
            synchronized (e) {
                if (txCtxInfo.hasStoredTxCtx()) {
                    if (threadCtxTable.containsKey(msgCtxID)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", "IllegalStateException");
                        }
                        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:796:1.28"}, null));
                    }
                    threadCtxTable.put(msgCtxID, txCtxInfo);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "storeCurrentThreadTxContextByMsgCtx", threadCtxTable);
                    }
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.storeCurrentThreadTxContextByMsgCtx", "1:813:1.28", this);
            AxisFault newE = new AxisFault(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:818:1.28"}, null), e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx", newE);
            }
            throw newE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeCurrentThreadTxContextByMsgCtx");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadTxContextInformation getTxCtxFromMsgCtx(MessageContext messageContext, boolean assertPresentInTable) throws AxisFault {
        MessageContextID msgCtxID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTxCtxFromMsgCtx", new Object[]{messageContext, assertPresentInTable});
        }
        if ((msgCtxID = MessageContextID.getMsgCtxIDFromMsgCtx(messageContext)) == null && assertPresentInTable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTxCtxFromMsgCtx", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:847:1.28"}, null));
        }
        ThreadTxContextInformation txInfo = null;
        HashMap hashMap = threadCtxTable;
        synchronized (hashMap) {
            txInfo = (ThreadTxContextInformation)threadCtxTable.get(msgCtxID);
            if (txInfo == null && assertPresentInTable) {
                AxisFault newE = new AxisFault(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:859:1.28"}, null), new IllegalStateException());
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTxCtxFromMsgCtx", new Object[]{newE, threadCtxTable, msgCtxID});
                }
                throw newE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTxCtxFromMsgCtx", txInfo);
        }
        return txInfo;
    }

    public void startWSRMTransactionalGet(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startWSRMTransactionalGet", config2);
        }
        if (RMServiceConfigPlugin.isManagedQOS(config2)) {
            try {
                WebSphereTransactionManager manager = TransactionManagerFactory.getTransactionManager();
                if (manager.getTransaction() == null) {
                    manager.begin();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.startWSRMTransactionalGet", "1:893:1.28", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startWSRMTransactionalGet");
        }
    }

    public ThreadTxContextInformation startWSRMTransactionalCall(boolean useApplicationTransaction) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startWSRMTransactionalCall", useApplicationTransaction);
        }
        ThreadTxContextInformation returnInfo = null;
        if (!useApplicationTransaction && !WSRMModule.isRunningInClientJVM()) {
            try {
                returnInfo = new ThreadTxContextInformation(false);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.startWSRMTransactionalCall", "1:929:1.28", this);
                AxisFault newE = new AxisFault(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:932:1.28"}, null), e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "startWSRMTransactionalCall", newE);
                }
                throw newE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startWSRMTransactionalCall", returnInfo);
        }
        return returnInfo;
    }

    public void finishWSRMTransactionalCall(ThreadTxContextInformation info) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalCall", info);
        }
        if (info != null) {
            try {
                info.loadStoredTxCtxOntoCurrentThread();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalCall", "1:968:1.28", this);
                AxisFault newE = new AxisFault(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:971:1.28"}, null), e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishWSRMTransactionalCall", newE);
                }
                throw newE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalCall");
        }
    }

    public void migrateContextToThread(MessageContext messageContext) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "migrateThreadToContext", messageContext);
            }
            if (this.isUserRequestTxSend(messageContext) && WSRMModule.isWSRMEnabledForService(messageContext.getAxisService())) {
                if (this.isMessageOutboundOneWay(messageContext)) {
                    if (!RMServiceConfigPlugin.isManagedQOS(messageContext.getAxisService().getAxisConfiguration())) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "migrateThreadToContext", "IllegalStateException");
                        }
                        throw new IllegalStateException(nls.getFormattedMessage("NO_TX_USING_UNMANAGED_CWSKA0553", new Object[]{messageContext.getMessageID(), messageContext.getAxisService().getName()}, null));
                    }
                    this.storeCurrentThreadTxContextByMsgCtx(messageContext, true, true);
                    break block9;
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "migrateThreadToContext", "IllegalStateException");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("CANNOT_SUPPORT_TX_CWSKA0551", new Object[]{messageContext.getMessageID(), messageContext.getAxisService().getName()}, null));
                }
            }
            if (WSRMModule.isWSRMEnabledForService(messageContext.getAxisService()) && this.isMessageOutboundRequest(messageContext)) {
                this.storeCurrentThreadTxContextByMsgCtx(messageContext, false, false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateThreadToContext");
        }
    }

    public void startWSRMTransactionalPut(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startWSRMTransactionalPut", messageContext);
        }
        if (this.isMessageOutboundOneWay(messageContext) && this.isUserRequestTxSend(messageContext)) {
            ThreadTxContextInformation txInfo = this.getTxCtxFromMsgCtx(messageContext, true);
            try {
                txInfo.beginTxWorkUnitIfNecessary();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.startWSRMTransactionalPut", "1:1080:1.28", this);
                AxisFault newE = new AxisFault(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:1083:1.28"}, null), e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "startWSRMTransactionalPut", newE);
                }
                throw newE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startWSRMTransactionalPut");
        }
    }

    public void finishWSRMTransactionalPut(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalPut", messageContext);
        }
        if (this.isMessageOutboundOneWay(messageContext) && this.isUserRequestTxSend(messageContext)) {
            ThreadTxContextInformation txInfo = this.getTxCtxFromMsgCtx(messageContext, true);
            try {
                txInfo.endTxWorkUnit();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalPut", "1:1111:1.28", this);
                AxisFault newE = new AxisFault(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:1114:1.28"}, null), e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishWSRMTransactionalPut", newE);
                }
                throw newE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalPut");
        }
    }

    public void finishWSRMTransactionalGet(AxisConfiguration config2) throws SandeshaStorageTransientException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalGet", config2);
        }
        if (RMServiceConfigPlugin.isManagedQOS(config2)) {
            try {
                WebSphereTransactionManager manager = TransactionManagerFactory.getTransactionManager();
                if (manager.getTransaction() != null) {
                    manager.commit();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalGet", "1:1146:1.28", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "finishWSRMTransactionalGet", e);
                }
                throw new SandeshaStorageTransientException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalGet");
        }
    }

    public void finishWSRMTransactionalGetWithRollback(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishWSRMTransactionalGetWithRollback", config2);
        }
        if (RMServiceConfigPlugin.isManagedQOS(config2)) {
            try {
                WebSphereTransactionManager manager = TransactionManagerFactory.getTransactionManager();
                if (manager.getTransaction() != null) {
                    manager.rollback();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.finishWSRMTransactionalGetWithRollback", "1:1178:1.28", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishWSRMTransactionalGetWithRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContext(MessageContext messageContext) {
        block17: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanupContext", messageContext);
            }
            if (this.isMessageOutboundOneWay(messageContext) && this.isUserRequestTxSend(messageContext)) {
                MessageContextID id = MessageContextID.getMsgCtxIDFromMsgCtx(messageContext);
                if (id != null) {
                    ThreadTxContextInformation txInfo = null;
                    HashMap hashMap = threadCtxTable;
                    synchronized (hashMap) {
                        txInfo = (ThreadTxContextInformation)threadCtxTable.remove(id);
                    }
                    if (txInfo != null) {
                        id.eraseMsgCtxIDFromMsgCtx(messageContext);
                        try {
                            txInfo.resumeTxCtxForApplication();
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.cleanupContext", "1:1217:1.28", this);
                        }
                    }
                }
            } else if (this.isMessageOutboundRequest(messageContext)) {
                try {
                    ThreadTxContextInformation txInfo = this.getTxCtxFromMsgCtx(messageContext, false);
                    if (txInfo == null) break block17;
                    txInfo.loadStoredTxCtxOntoCurrentThread();
                    HashMap hashMap = threadCtxTable;
                    synchronized (hashMap) {
                        MessageContextID id = MessageContextID.getMsgCtxIDFromMsgCtx(messageContext);
                        threadCtxTable.remove(id);
                        id.eraseMsgCtxIDFromMsgCtx(messageContext);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.cleanupContext", "1:1248:1.28", this);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContext");
        }
    }

    public void cleanupThread(MessageContext messageContext) {
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/TransactionThreadMigrator.java, WAS.rm, WAS70.SERV1, cf070937.21 1.28");
        }
        TRAN_ENABLED_PROPERTY_STRING = "enableTransactionalOneWay";
    }

    public static final class ThreadTxContextInformation {
        private static final TraceComponent tc = Tr.register(ThreadTxContextInformation.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
        static final int WORK_WAIT_TIME = 1000;
        private static TransactionManager tranManager = TransactionManagerFactory.getTransactionManager();
        private Transaction applicationTranCtx;
        private boolean blockRequiredIfWorkOutstanding = true;
        private boolean started = false;
        private boolean finished = false;

        ThreadTxContextInformation(boolean blockRequiredIfWorkOutstanding) throws SystemException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "ThreadTxContextInformation", blockRequiredIfWorkOutstanding);
            }
            this.suspendAndStoreCurrentTxContext();
            this.blockRequiredIfWorkOutstanding = blockRequiredIfWorkOutstanding;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "ThreadTxContextInformation", this);
            }
        }

        public String toString() {
            return "[ThreadTxContextInformation \n applicationTranCtx=" + this.applicationTranCtx + "\n blockRequiredIfWorkOutstanding=" + this.blockRequiredIfWorkOutstanding + "\n started=" + this.started + "\n finished=" + this.finished + "]";
        }

        synchronized void suspendAndStoreCurrentTxContext() throws SystemException {
            Transaction currentTran;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "suspendAndStoreCurrentTxContext");
            }
            if ((currentTran = tranManager.getTransaction()) != null) {
                if (this.applicationTranCtx == null) {
                    this.applicationTranCtx = tranManager.suspend();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "storing tx " + this.applicationTranCtx);
                    }
                } else {
                    if (!this.applicationTranCtx.equals(currentTran)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "suspendAndStoreCurrentTxContext", "IllegalStateException");
                        }
                        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:366:1.28"}, null));
                    }
                    tranManager.suspend();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "suspending tx " + this.applicationTranCtx);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "suspendAndStoreCurrentTxContext");
            }
        }

        synchronized boolean hasStoredTxCtx() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "hasStoredTxCtx");
                Tr.exit(tc, "hasStoredTxCtx", this.applicationTranCtx != null);
            }
            return this.applicationTranCtx != null;
        }

        void setApplicationTranRollbackOnly() throws SystemException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "setApplicationTranRollbackOnly");
            }
            if (this.hasStoredTxCtx()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "setting application tran " + this.applicationTranCtx + " as rollback only.");
                }
                this.applicationTranCtx.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setApplicationTranRollbackOnly");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void beginTxWorkUnitIfNecessary() throws SystemException, InvalidTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "beginTxWorkUnitIfNecessary");
            }
            if (this.started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "beginTxWorkUnitIfNecessary : work already started");
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "beginTxWorkUnitIfNecessary : work starting");
                }
                this.started = true;
            }
            if (this.finished) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "beginTxWorkUnitIfNecessary", "IllegalStateException - finished");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:448:1.28"}, null));
            }
            try {
                this.loadStoredTxCtxOntoCurrentThread();
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSRM work started");
                }
                this.notifyAll();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "beginTxWorkUnitIfNecessary");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void endTxWorkUnit() throws SystemException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "endTxWorkUnit");
            }
            if (!this.started) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "endTxWorkUnit", "IllegalStateException - !started");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:485:1.28"}, null));
            }
            if (this.finished) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "endTxWorkUnit", "IllegalStateException - !started");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:493:1.28"}, null));
            }
            this.finished = true;
            try {
                this.suspendAndStoreCurrentTxContext();
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSRM work finished");
                }
                this.notifyAll();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "endTxWorkUnit");
            }
        }

        synchronized void resumeTxCtxForApplication() throws SystemException, InvalidTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "resumeTxCtxForApplication");
            }
            if (this.hasStoredTxCtx() && this.blockRequiredIfWorkOutstanding && (!this.started || !this.finished)) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "blocking application for WSRM work to finish: started=" + this.started + ", finsihed=" + this.finished);
                    }
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.started || !this.finished) {
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "resumeTxCtxForApplication", "IllegalStateException");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:557:1.28"}, null));
                }
            }
            this.loadStoredTxCtxOntoCurrentThread();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resumeTxCtxForApplication");
            }
        }

        void loadStoredTxCtxOntoCurrentThread() throws SystemException, InvalidTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "loadStoredTxCtxOntoCurrentThread");
            }
            if (this.hasStoredTxCtx()) {
                Transaction existingTran = tranManager.getTransaction();
                if (existingTran != null) {
                    if (existingTran.equals(this.applicationTranCtx)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread");
                        }
                        return;
                    }
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread", "IllegalStateException");
                    }
                    throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionThreadMigrator", "1:604:1.28"}, null));
                }
                try {
                    tranManager.resume(this.applicationTranCtx);
                }
                catch (SystemException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.ThreadTxContextInformation.loadStoredTxCtxOntoCurrentThread", "1:617:1.28", this);
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread", e);
                    }
                    throw e;
                }
                catch (InvalidTransactionException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator.ThreadTxContextInformation.loadStoredTxCtxOntoCurrentThread", "1:631:1.28", this);
                    this.setApplicationTranRollbackOnly();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread", e);
                    }
                    throw e;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread");
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "no stored tx ctx loaded onto thread");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadStoredTxCtxOntoCurrentThread");
            }
        }
    }

    private static final class MessageContextID
    implements Serializable {
        public static final String msgCtxIDPropertyName = "WSRM_MsgCtxID";
        private static final long serialVersionUID = 6519853756580410627L;
        private String uuid;

        public MessageContextID(MessageContext ctx) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "MessageContextID", ctx);
            }
            this.uuid = new UUID().toString();
            ctx.setProperty(msgCtxIDPropertyName, this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "MessageContextID", this);
            }
        }

        public void eraseMsgCtxIDFromMsgCtx(MessageContext ctx) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "eraseMsgCtxIDFromMsgCtx", ctx);
            }
            ctx.setProperty(msgCtxIDPropertyName, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "eraseMsgCtxIDFromMsgCtx", ctx);
            }
        }

        public static MessageContextID getMsgCtxIDFromMsgCtx(MessageContext ctx) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getMsgCtxIDFromMsgCtx", ctx);
            }
            MessageContextID returnID = (MessageContextID)ctx.getProperty(msgCtxIDPropertyName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getMsgCtxIDFromMsgCtx", returnID);
            }
            return returnID;
        }

        public boolean equals(Object other) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "equals", other);
            }
            boolean returnValue = false;
            if (other instanceof MessageContextID && this.uuid.equals(((MessageContextID)other).uuid)) {
                returnValue = true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", returnValue);
            }
            return returnValue;
        }

        public int hashCode() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "hashCode");
            }
            int returnValue = this.uuid.hashCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "hashCode", returnValue);
            }
            return returnValue;
        }

        public String toString() {
            return "msgCtxID=" + this.uuid;
        }
    }
}

