/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.wsrm.MEConnectionProperties;
import com.ibm.ws.sib.wsrm.MEStoreConnection;
import com.ibm.ws.sib.wsrm.MEStoreConnectionFactory;
import com.ibm.ws.sib.wsrm.MEStoreConnectionListener;
import com.ibm.ws.sib.wsrm.MEStoreTransaction;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.sib.wsrm.WrappedInvokerBean;
import com.ibm.ws.sib.wsrm.exceptions.MEStoreConnectionException;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.websvcs.rm.WSRMComponentImpl;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.InvokerBeanMgrImpl;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.RMDBeanMgrImpl;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.RMSBeanMgrImpl;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.SenderBeanMgrImpl;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoader;
import com.ibm.wsspi.websvcs.policyset.PolicySetLoaderMgr;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.spi.Provider;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.Invoker;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.Sender;

public final class PersistentStorageManagerSingleton
extends WSReliableMessagingStorageManager
implements MEStoreConnectionListener {
    private static final TraceComponent tc = Tr.register(PersistentStorageManagerSingleton.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static boolean txThreadMigratorRegistered;
    private static final int ME_WAIT_INTERVAL = 120;
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int STORE_KEY_PROCESS_VALUE = 20;
    private RMSBeanMgr _rmsBeanMgr;
    private InvokerBeanMgr _invokerBeanMgr;
    private RMDBeanMgr _rmdBeanMgr;
    private SenderBeanMgr _senderBeanMgr;
    private ConcurrentHashMap<Thread, Transaction> _transactions = new ConcurrentHashMap();
    private CommandInvoker _commandInvoker;
    private MEStoreConnection _meStoreConnection;
    private String _busName = null;
    private String _messagingEngineName = null;
    private boolean _connectionOpened = false;
    private volatile boolean _initRequired = true;
    private boolean _persistentStoreChosen = false;
    private volatile boolean _initWasSuccessful = false;
    private boolean _isManagedPersistent = false;
    private SandeshaThread _sender = null;
    private SandeshaThread _invoker = null;
    private PollingManager _pollingManager;
    private ConcurrentHashMap<String, SerializedStorageEntry> _messageCtxToConfigContextMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> _storageKeysMap = new ConcurrentHashMap();
    private HashMap<Long, MEConnectionProperties> _connections = new HashMap();
    private HashMap<String, MEStoreTransaction> _meStoreTransactions = new HashMap();
    private HashMap<Thread, InvokerBean> _cachedInvokerBeans = new HashMap();
    private final long _retransmissionInterval;
    private long _removeStaleConnectionsTimeout = System.currentTimeMillis() + 60000L;
    ThreadPool _systemThreadPool = new ThreadPool("System RM Persistent store Threadpool", 1, 1);
    private ClassLoader _classLoader;
    private PolicySetLoader _psLoader;

    public PersistentStorageManagerSingleton(ConfigurationContext context) throws SandeshaException {
        super(context, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PersistentStorageManagerSingleton", context);
        }
        this._isManagedPersistent = false;
        if (RMServiceConfigPlugin.isInorder(context.getAxisConfiguration())) {
            try {
                this._invoker = (Invoker)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                            Tr.exit(tc, "run");
                        }
                        return new Invoker();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.PersistentStorageManagerSingleton", "1:325:1.67.1.10", this);
                RuntimeException e2 = new RuntimeException(e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "PersistentStorageManagerSingleton", e2);
                }
                throw e2;
            }
        }
        SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean(context.getAxisConfiguration());
        this._retransmissionInterval = policy.getRetransmissionInterval();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "PersistentStorageManagerSingleton", this);
        }
    }

    public void addStoreKeyToContext(String storeKey, MessageContext msgContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addStoreKeyToContext", new Object[]{storeKey, msgContext});
        }
        SerializedStorageEntry entry = new SerializedStorageEntry();
        entry.context = msgContext.getConfigurationContext();
        entry.msgContext = msgContext;
        OperationContext opCtx = msgContext.getOperationContext();
        if (opCtx != null) {
            MessageContext inMsgCtx = null;
            try {
                inMsgCtx = opCtx.getMessageContext("In");
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.addStoreKeyToContext", "1:368:1.67.1.10", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "addStoreKeyToContext", e);
                }
                throw new RuntimeException(e);
            }
            if (inMsgCtx != null) {
                entry.inTransportControl = inMsgCtx.getProperty("RequestResponseTransportControl");
                entry.inTransportOut = inMsgCtx.getProperty("TRANSPORT_OUT");
                entry.inTransportOutInfo = inMsgCtx.getProperty("OutTransportInfo");
            }
        }
        entry.transportControl = msgContext.getProperty("RequestResponseTransportControl");
        entry.transportOut = msgContext.getProperty("TRANSPORT_OUT");
        entry.transportOutInfo = msgContext.getProperty("OutTransportInfo");
        this._messageCtxToConfigContextMap.put(storeKey, entry);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addStoreKeyToContext", entry);
        }
    }

    private void removeStoreKeyToContext(String storageKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeStoreKeyToContext", new Object[]{storageKey});
        }
        this._messageCtxToConfigContextMap.remove(storageKey);
        this._storageKeysMap.remove(storageKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeStoreKeyToContext");
        }
    }

    private synchronized boolean initSuccessful() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initSuccessful");
            Tr.exit(tc, "initSuccessful", this._initWasSuccessful);
        }
        return this._initWasSuccessful;
    }

    private synchronized void setInitSuccessful() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setInitSuccessful");
        }
        this._initWasSuccessful = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setInitSuccessful");
        }
    }

    private void assertInitWasSuccessful() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "assertInitWasSuccessful");
        }
        if (!this.initSuccessful()) {
            if (this._persistentStoreChosen) {
                Tr.warning(tc, "ME_UNAVAILABLE_CWSKA0109", new Object[]{this._messagingEngineName, this._busName, WSRMModule.getApplicationName(this.getContext())});
                int counter = 120;
                while (!this.initSuccessful() && counter > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Sleeping waiting for Messaging Engine " + counter);
                    }
                    --counter;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.initSuccessful()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "assertInitWasSuccessful", "ME not started");
                }
                throw new IllegalStateException(nls.getFormattedMessage("ME_UNAVAILABLE_CWSKA0108", new Object[]{this._messagingEngineName, this._busName}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "assertInitWasSuccessful");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTxThreadMigratorIfNecessary() throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerTxThreadMigratorIfNecessary");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!txThreadMigratorRegistered) {
                try {
                    AxisConfiguration axisConfiguration = this.getContext().getAxisConfiguration();
                    Parameter param = axisConfiguration.getParameter("JAXWS-ThreadContextMigrator-List");
                    if (param == null || ((List)param.getValue()).isEmpty()) {
                        ThreadContextMigratorUtil.addThreadContextMigrator(this.getContext(), "JAXWS-ThreadContextMigrator-List", (ThreadContextMigrator)TransactionThreadMigrator.getInstance());
                    }
                    txThreadMigratorRegistered = true;
                }
                catch (AxisFault e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.registerTxThreadMigratorIfNecessary", "1:503:1.67.1.10", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "registerTxThreadMigratorIfNecessary", e);
                    }
                    throw new SandeshaStorageException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerTxThreadMigratorIfNecessary");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagingEngineConnectionClosed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "messagingEngineConnectionClosed");
        }
        PersistentStorageManagerSingleton persistentStorageManagerSingleton = this;
        synchronized (persistentStorageManagerSingleton) {
            this._connectionOpened = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "messagingEngineConnectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagingEngineConnectionOpened() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "messagingEngineConnectionOpened");
        }
        boolean initNeeded = false;
        PersistentStorageManagerSingleton persistentStorageManagerSingleton = this;
        synchronized (persistentStorageManagerSingleton) {
            if (!this._connectionOpened) {
                initNeeded = this._persistentStoreChosen;
                this._connectionOpened = true;
            }
        }
        if (initNeeded) {
            this.initializeStore();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "messagingEngineConnectionOpened");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeStore");
        }
        PersistentStorageManagerSingleton persistentStorageManagerSingleton = this;
        synchronized (persistentStorageManagerSingleton) {
            this._connectionOpened = true;
        }
        TransactionThreadMigrator.ThreadTxContextInformation txInfo = null;
        if (this._initRequired) {
            this._initRequired = false;
            try {
                txInfo = TransactionThreadMigrator.getInstance().startWSRMTransactionalCall(false);
                List<RMSequenceBean> resultList = this._commandInvoker.loadSequences(this.getWorkKey());
                if (resultList != null && resultList.size() > 0) {
                    for (RMSequenceBean rmBean : resultList) {
                        String securityTokenData = rmBean.getSecurityTokenData();
                        if (securityTokenData != null) {
                            IBMSecurityManager securityManager = (IBMSecurityManager)SandeshaUtil.getSecurityManager(this.getContext());
                            securityManager.initSecurityToken(securityTokenData);
                        }
                        SandeshaUtil.startWorkersForSequence(this.getContext(), rmBean);
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.entry(tc, "run", "Setting the classLoader on the threads");
                                    }
                                    if (PersistentStorageManagerSingleton.this.getInvoker() != null) {
                                        PersistentStorageManagerSingleton.this.getInvoker().setContextClassLoader(PersistentStorageManagerSingleton.this._classLoader);
                                    }
                                    PersistentStorageManagerSingleton.this.getSender().setContextClassLoader(PersistentStorageManagerSingleton.this._classLoader);
                                    PersistentStorageManagerSingleton.this.getPollingManager().setContextClassLoader(PersistentStorageManagerSingleton.this._classLoader);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.exit(tc, "run", null);
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initializeStore", "1:626:1.67.1.10", this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "initializeStore", "RuntimeException");
                            }
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initializeStore", "1:643:1.67.1.10", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initializeStore", e);
                }
                throw new RuntimeException(e);
            }
            finally {
                try {
                    TransactionThreadMigrator.getInstance().finishWSRMTransactionalCall(txInfo);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initializeStore", "1:660:1.67.1.10", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "initializeStore", e);
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeStore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistentStoreChosen(ClassLoader classLoader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "persistentStoreChosen", classLoader);
        }
        this._classLoader = classLoader;
        boolean initNeeded = false;
        PersistentStorageManagerSingleton persistentStorageManagerSingleton = this;
        synchronized (persistentStorageManagerSingleton) {
            this._persistentStoreChosen = true;
            initNeeded = this._connectionOpened;
        }
        if (initNeeded) {
            this.initializeStore();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "persistentStoreChosen");
        }
    }

    public void initStorage(AxisModule moduleDesc) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initStorage", moduleDesc);
        }
        if (this.isRunningInClientContainer()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initStorage", "no init of storage manager as in client container");
            }
            return;
        }
        if (!RMServiceConfigPlugin.isManagedQOS(this.getContext().getAxisConfiguration())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "non managed QOS - not initializing the storage manager");
            }
        } else if (!this.initSuccessful()) {
            this._isManagedPersistent = RMServiceConfigPlugin.isManagedPersistentQOS(this.getContext().getAxisConfiguration());
            this._busName = RMServiceConfigPlugin.getBusName(this.getContext().getAxisConfiguration());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "busName=", this._busName);
            }
            this._messagingEngineName = RMServiceConfigPlugin.getMessagingEngineName(this.getContext().getAxisConfiguration());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "messagingEngineName=", this._messagingEngineName);
            }
            if (this._busName == null || this._messagingEngineName == null || this._busName.equals("") || this._messagingEngineName.equals("")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bus details were not complete");
                }
                Tr.error(tc, "INCOMPELTE_BINDING_ERROR_CWSKA0102", new Object[]{this._busName, this._messagingEngineName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "initStorage", "SandeshaStorageException");
                }
                throw new SandeshaStorageException(nls.getFormattedMessage("INCOMPELTE_BINDING_ERROR_CWSKA0102", new Object[]{this._busName, this._messagingEngineName}, null));
            }
            this._commandInvoker = new CommandInvoker();
            this._rmsBeanMgr = new RMSBeanMgrImpl(this);
            this._invokerBeanMgr = new InvokerBeanMgrImpl(this);
            this._rmdBeanMgr = new RMDBeanMgrImpl(this);
            this._senderBeanMgr = new SenderBeanMgrImpl(this);
            this._systemThreadPool.setGrowAsNeeded(true);
            this._systemThreadPool.setRequestBufferExpansionLimit(Integer.MAX_VALUE);
            final String fBusName = this._busName;
            final String fMessagingEngineName = this._messagingEngineName;
            Runnable initialize = new Runnable(){

                public void run() {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    MEStoreConnectionFactory factory = MEStoreConnectionFactory.getInstance();
                    PersistentStorageManagerSingleton.this._meStoreConnection = factory.createMEStoreConnection(fBusName, fMessagingEngineName, PersistentStorageManagerSingleton.this, PersistentStorageManagerSingleton.this._connections);
                    try {
                        PersistentStorageManagerSingleton.this._meStoreConnection.initialize();
                    }
                    catch (MEStoreConnectionException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.run", "1:787:1.67.1.10", this);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                }
            };
            try {
                this._systemThreadPool.execute(initialize);
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.initStorage", "1:805:1.67.1.10", this);
            }
            this.registerMBean();
            this.registerTxThreadMigratorIfNecessary();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "init compelte");
            }
            this.setInitSuccessful();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initStorage");
        }
    }

    protected boolean isStoreBeingUsed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isStoreBeingUsed");
        }
        boolean returnValue = RMServiceConfigPlugin.isManagedQOS(this.getContext().getAxisConfiguration());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isStoreBeingUsed", returnValue);
        }
        return returnValue;
    }

    public Transaction getTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransaction");
        }
        this.assertInitWasSuccessful();
        Thread thread = Thread.currentThread();
        TransactionImpl tran = null;
        if (this._transactions.get(thread) == null) {
            this.closeStaleConnections();
            tran = new TransactionImpl(this, this._isManagedPersistent);
            this._transactions.put(thread, tran);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Warning - possible reused transaction");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransaction", tran);
        }
        return tran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStaleConnections() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "closeStaleConnections");
        }
        HashMap<Long, MEConnectionProperties> hashMap = this._connections;
        synchronized (hashMap) {
            block12: {
                if (this._connections.size() > 1 && System.currentTimeMillis() > this._removeStaleConnectionsTimeout) {
                    block11: {
                        final long currentTime = System.currentTimeMillis();
                        this._removeStaleConnectionsTimeout = currentTime + 60000L;
                        Runnable connectionCloser = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.entry(tc, "run", "Running connection closer thread");
                                }
                                HashMap connections = null;
                                HashMap hashMap = PersistentStorageManagerSingleton.this._connections;
                                synchronized (hashMap) {
                                    connections = (HashMap)PersistentStorageManagerSingleton.this._connections.clone();
                                }
                                for (Map.Entry entry : connections.entrySet()) {
                                    MEConnectionProperties props = (MEConnectionProperties)entry.getValue();
                                    long lastActivated = props.getLastActivated();
                                    if (lastActivated + 60000L >= currentTime) continue;
                                    Long key = (Long)entry.getKey();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Closing connection " + key + ", " + props.getConnection());
                                    }
                                    props.getConnection().close();
                                    HashMap hashMap2 = PersistentStorageManagerSingleton.this._connections;
                                    synchronized (hashMap2) {
                                        PersistentStorageManagerSingleton.this._connections.remove(key);
                                    }
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "run");
                                }
                            }
                        };
                        try {
                            this._systemThreadPool.execute(connectionCloser);
                        }
                        catch (InterruptedException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                            Tr.debug(tc, "Caught exception running closer thread ", e);
                        }
                    }
                    if (WSRMModule.getClusterName() != null && this._storageKeysMap.size() > 20) {
                        Runnable clusteredMsgContextDeleter = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.entry(tc, "run", "Running msgContext remover");
                                }
                                ArrayList keys = new ArrayList();
                                keys.addAll(PersistentStorageManagerSingleton.this._storageKeysMap.keySet());
                                try {
                                    HashMap<Object, Object> data = new HashMap<Object, Object>();
                                    data.put(WSRMConstants.WORK_KEY, PersistentStorageManagerSingleton.this.getWorkKey());
                                    data.put("MSG_CONTEXTS", keys);
                                    List removeKeys = PersistentStorageManagerSingleton.this.getCommandInvoker().getDeletedMessageContexts(data);
                                    if (removeKeys != null && removeKeys.size() > 0) {
                                        for (int i = 0; i < removeKeys.size(); ++i) {
                                            String key = (String)removeKeys.get(i);
                                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                                Tr.debug(tc, "Removing MessageContext with key " + key);
                                            }
                                            PersistentStorageManagerSingleton.this.removeMessageContextState(key);
                                        }
                                    }
                                    MEConnectionProperties connectionProps = null;
                                    HashMap hashMap = PersistentStorageManagerSingleton.this._connections;
                                    synchronized (hashMap) {
                                        connectionProps = (MEConnectionProperties)PersistentStorageManagerSingleton.this._connections.remove(Thread.currentThread().getId());
                                    }
                                    if (connectionProps != null) {
                                        connectionProps.getConnection().close();
                                    }
                                }
                                catch (MEStoreConnectionException e) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.run", "1:1000:1.67.1.10", this);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "run");
                                }
                            }
                        };
                        try {
                            this._systemThreadPool.execute(clusteredMsgContextDeleter);
                        }
                        catch (InterruptedException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                            Tr.debug(tc, "Caught exception running message context deleter ", e);
                        }
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeStaleConnections");
        }
    }

    protected void closeConnectionsForShutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "closeConnectionsForShutdown");
        }
        Iterator<Transaction> transactionsIterator = this._transactions.values().iterator();
        while (transactionsIterator.hasNext()) {
            try {
                transactionsIterator.next().rollback();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.closeConnectionsForShutdown", "1:1048:1.67.1.10", this);
            }
        }
        this.closeConnections();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeConnectionsForShutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnections() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "closeConnections");
        }
        HashMap<Long, MEConnectionProperties> hashMap = this._connections;
        synchronized (hashMap) {
            Iterator<MEConnectionProperties> iterator = this._connections.values().iterator();
            while (iterator.hasNext()) {
                MEConnectionProperties props = iterator.next();
                props.getConnection().close();
                iterator.remove();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeConnections");
        }
    }

    public TransactionImpl getInUseTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInUseTransaction");
        }
        this.assertInitWasSuccessful();
        TransactionImpl tran = null;
        tran = (TransactionImpl)this._transactions.get(Thread.currentThread());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInUseTransaction", tran);
        }
        return tran;
    }

    public String getApplicationInstanceKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationInstanceKey");
        }
        String appKey = this.getWorkKey() + "#" + WSRMModule.getNodeName() + "#" + WSRMModule.getServerName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationInstanceKey", appKey);
        }
        return appKey;
    }

    public RMSBeanMgr getRMSBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBeanMgr");
            Tr.exit(tc, "getRMSBeanMgr", this._rmsBeanMgr);
        }
        return this._rmsBeanMgr;
    }

    public RMDBeanMgr getRMDBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMDBeanMgr");
            Tr.exit(tc, "getRMDBeanMgr", this._rmdBeanMgr);
        }
        return this._rmdBeanMgr;
    }

    public SenderBeanMgr getSenderBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSenderBeanMgr");
            Tr.exit(tc, "getSenderBeanMgr", this._senderBeanMgr);
        }
        return this._senderBeanMgr;
    }

    public InvokerBeanMgr getInvokerBeanMgr() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvokerBeanMgr");
            Tr.exit(tc, "getInvokerBeanMgr", this._invokerBeanMgr);
        }
        return this._invokerBeanMgr;
    }

    public void storeMessageContext(String key, MessageContext msgContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeMessageContext", new Object[]{key, msgContext.getEnvelope().getHeader()});
        }
        this.assertInitWasSuccessful();
        if (key == null) {
            key = SandeshaUtil.getUUID();
        }
        this.addStoreKeyToContext(key, msgContext);
        this.getInUseTransaction().storeMessageContext(key, msgContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeMessageContext");
        }
    }

    public void updateMessageContext(String key, MessageContext msgContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageContext", new Object[]{key, msgContext.getEnvelope().getHeader()});
        }
        this.assertInitWasSuccessful();
        this.getInUseTransaction().updateMessageContext(key, msgContext);
        this._messageCtxToConfigContextMap.remove(key);
        this.addStoreKeyToContext(key, msgContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageContext");
        }
    }

    public MessageContext retrieveMessageContext(String key, ConfigurationContext configurationContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveMessageContext", new Object[]{key, configurationContext});
        }
        this.assertInitWasSuccessful();
        MessageContext result = null;
        String origStoreKey = null;
        byte[] msgContextBytes = this.getInUseTransaction().getMessageContext(key);
        if (msgContextBytes == null) {
            String[] data = new String[]{this.getWorkKey(), key};
            List commandResult = (List)((Object)this.getCommandInvoker().retrieveMessageContext(data));
            if (commandResult != null) {
                origStoreKey = (String)commandResult.get(0);
                msgContextBytes = (byte[])commandResult.get(1);
            }
            this.addMappedKey(key, origStoreKey);
        } else {
            origStoreKey = key;
        }
        if (msgContextBytes != null) {
            SerializedStorageEntry entry = null;
            entry = this._messageCtxToConfigContextMap.get(origStoreKey);
            ConfigurationContext context = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Got entry " + entry);
            }
            if (entry != null) {
                context = entry.context;
            }
            if (context == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find configuration context in map, so using one provided");
                }
                context = configurationContext;
            }
            if (entry == null || entry.msgContext == null) {
                result = this.deserializeMessageContext(msgContextBytes, context, true);
                OperationContext opCtx = result.getOperationContext();
                if (opCtx != null) {
                    MessageContext inMsgCtx = null;
                    try {
                        OperationContext operationContext;
                        String messageId = result.getMessageID();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking up OpCtx based on the relatesTo " + messageId);
                        }
                        if ((operationContext = context.getOperationContext(messageId)) == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Reregistering Op Ctx");
                            }
                            context.registerOperationContext(messageId, opCtx);
                        }
                        inMsgCtx = opCtx.getMessageContext("In");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found inMsgCtx " + inMsgCtx);
                        }
                    }
                    catch (AxisFault e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.retrieveMessageContext", "1:1315:1.67.1.10", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "retrieveMessageContext", e);
                        }
                        throw new RuntimeException(e);
                    }
                    if (inMsgCtx != null && entry != null) {
                        inMsgCtx.setProperty("RequestResponseTransportControl", entry.inTransportControl);
                        inMsgCtx.setProperty("TRANSPORT_OUT", entry.inTransportOut);
                        inMsgCtx.setProperty("OutTransportInfo", entry.inTransportOutInfo);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find OperationContext");
                }
                if (entry != null) {
                    result.setProperty("RequestResponseTransportControl", entry.transportControl);
                    result.setProperty("TRANSPORT_OUT", entry.transportOut);
                    result.setProperty("OutTransportInfo", entry.transportOutInfo);
                }
            } else {
                result = entry.msgContext;
                entry.msgContext = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String log = null;
            if (result != null && result.getEnvelope().getHeader() != null) {
                log = result.getEnvelope().getHeader().toString();
            }
            Tr.exit(tc, "retrieveMessageContext", log);
        }
        return result;
    }

    public void addMappedKey(String key, String origStoreKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addMappedKey", new Object[]{key, origStoreKey});
        }
        this._storageKeysMap.put(key, origStoreKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addMappedKey");
        }
    }

    private MessageContext deserializeMessageContext(byte[] msgContextBytes, ConfigurationContext configurationContext, boolean attemptRebuild) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deserializeMessageContext", new Object[]{configurationContext, msgContextBytes, attemptRebuild});
        }
        MessageContext messageContext = null;
        try {
            if (msgContextBytes != null) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(msgContextBytes);
                ObjectInputStream inObjStream = new ObjectInputStream(inStream);
                messageContext = (MessageContext)inObjStream.readObject();
                messageContext.activate(configurationContext);
                if (attemptRebuild && messageContext.getAxisService() == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Rebuilding MessageContext as no AxisService");
                    }
                    messageContext = this.rebuildMessageContext(messageContext, msgContextBytes, configurationContext);
                }
                inStream.close();
            }
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.deserializeMessageContext", "1:1416:1.67.1.10");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deserializeMessageContext", e);
            }
            throw new RuntimeException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionImpl", "1:1421:1.67.1.10"}, null), e);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.deserializeMessageContext", "1:1430:1.67.1.10");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deserializeMessageContext", e);
            }
            throw new RuntimeException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeMessageContext", messageContext);
        }
        return messageContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageContext rebuildMessageContext(MessageContext messageContext, byte[] msgContextBytes, ConfigurationContext configurationContext) {
        block21: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "rebuildMessageContext", new Object[]{messageContext, configurationContext});
            }
            URL wsdlLocation = (URL)messageContext.getLocalProperty("WSDL_LOCATION");
            QName serviceQName = (QName)messageContext.getLocalProperty("SERVICE_QNAME");
            String serviceClassName = (String)messageContext.getLocalProperty("SERVICE_CLASS_NAME");
            QName portQName = (QName)messageContext.getLocalProperty("PORT_QNAME");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Recovered wsdl " + wsdlLocation + " : " + serviceQName + " : " + serviceClassName + " : " + portQName);
            }
            PolicySetLoader loader = null;
            try {
                boolean portExists;
                ServiceDelegate del;
                block22: {
                    if (this._psLoader != null) {
                        loader = PolicySetLoaderMgr.setContextPolicySetLoader(this._psLoader);
                    }
                    if (serviceClassName == null) break block21;
                    Class<?> serviceClass = Thread.currentThread().getContextClassLoader().loadClass(serviceClassName);
                    ServiceDescription description = DescriptionFactory.createServiceDescription(wsdlLocation, serviceQName, serviceClass);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loaded service description " + description);
                        Tr.debug(tc, "wsdl url=" + wsdlLocation);
                        Tr.debug(tc, "sei=" + messageContext.getProperty("CLIENT_SEI_CLASS"));
                    }
                    del = (ServiceDelegate)Provider.provider().createServiceDelegate(wsdlLocation, serviceQName, serviceClass);
                    WSRMComponentImpl.getServiceDelegateList().add(del);
                    portExists = false;
                    try {
                        Iterator<QName> ports = del.getPorts();
                        while (ports.hasNext()) {
                            QName currentPortName = ports.next();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "port " + currentPortName);
                            }
                            if (!currentPortName.equals(portQName)) continue;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "port found");
                            }
                            portExists = true;
                            break;
                        }
                    }
                    catch (WebServiceException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block22;
                        Tr.debug(tc, "Caught WSException when looking for ports", (Object)e);
                    }
                }
                if (portExists) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getPort");
                    }
                    del.getPort(portQName, Thread.currentThread().getContextClassLoader().loadClass((String)messageContext.getLocalProperty("CLIENT_SEI_CLASS")));
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "add port");
                    }
                    del.addPort(portQName, (String)messageContext.getProperty("CLIENT_BINDING_ID"), (String)messageContext.getProperty("EPR_ADDR"));
                }
                messageContext = this.deserializeMessageContext(msgContextBytes, configurationContext, false);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.loadAvailableSequences", "1:1556:1.67.1.10", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught exception when trying to load a sequence", e);
                }
            }
            finally {
                if (this._psLoader != null) {
                    PolicySetLoaderMgr.setContextPolicySetLoader(loader);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rebuildMessageContext", messageContext);
        }
        return messageContext;
    }

    void removeTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTransaction");
        }
        this.assertInitWasSuccessful();
        this._transactions.remove(Thread.currentThread());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheInvokerBean(InvokerBean invokerBean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheInvokerBean");
        }
        Thread thread = Thread.currentThread();
        HashMap<Thread, InvokerBean> hashMap = this._cachedInvokerBeans;
        synchronized (hashMap) {
            this._cachedInvokerBeans.put(thread, invokerBean);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheInvokerBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokerBean getCachedInvokerBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCachedInvokerBean");
        }
        InvokerBean invokerBean = null;
        Thread thread = Thread.currentThread();
        HashMap<Thread, InvokerBean> hashMap = this._cachedInvokerBeans;
        synchronized (hashMap) {
            invokerBean = this._cachedInvokerBeans.remove(thread);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCachedInvokerBean", invokerBean);
        }
        return invokerBean;
    }

    public CommandInvoker getCommandInvoker() {
        this.assertInitWasSuccessful();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandInvoker");
            Tr.exit(tc, "getCommandInvoker", this._commandInvoker);
        }
        return this._commandInvoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MEStoreConnection getConnectionForThread() throws MEStoreConnectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConnectionForThread");
        }
        MEStoreConnection connection = null;
        Long currentThreadId = Thread.currentThread().getId();
        HashMap<Long, MEConnectionProperties> hashMap = this._connections;
        synchronized (hashMap) {
            MEConnectionProperties connectionProps = this._connections.get(currentThreadId);
            if (connectionProps == null) {
                try {
                    connection = MEStoreConnectionFactory.getInstance().createMEStoreConnection(this._busName, this._messagingEngineName, this, this._connections);
                    connection.initialize();
                    connectionProps = new MEConnectionProperties(connection);
                    this._connections.put(currentThreadId, connectionProps);
                }
                catch (MEStoreConnectionException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getConnectionForThread", e);
                    }
                    throw e;
                }
            } else {
                connection = connectionProps.getConnection();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getConnectionForThread", connection);
        }
        return connection;
    }

    public void removeMessageContext(String storageKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMessageContext", storageKey);
        }
        this.assertInitWasSuccessful();
        if (storageKey.startsWith("urn:uuid:")) {
            this.removeStoreKeyToContext(storageKey);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeMessageContext", "Ignoring message with key " + storageKey);
            }
            return;
        }
        this.removeMessageContextState(storageKey);
        this.getInUseTransaction().deleteMessageContext(storageKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMessageContext");
        }
    }

    protected void removeMessageContextState(String storageKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMessageContextState", storageKey);
        }
        String origStoreKey = null;
        origStoreKey = this._storageKeysMap.remove(storageKey);
        if (origStoreKey == null) {
            origStoreKey = storageKey;
        }
        this.removeStoreKeyToContext(origStoreKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMessageContextState");
        }
    }

    protected StorageManager getApplicationStorageManager() {
        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"PersistentStorageManagerSingleton", "1:2024:1.67.1.10"}, null));
    }

    protected String getMapKey() {
        throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"PersistentStorageManagerSingleton", "1:2031:1.67.1.10"}, null));
    }

    public synchronized StorageManagerDetail getStorageManagerDetails(Locale locale) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerDetails", locale);
        }
        String description = null;
        description = this._isManagedPersistent ? TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "MANAGED_PERSISTENT_APPLICATION_CWSKA0103", locale, new Object[]{WSRMModule.getApplicationName(this.getContext()) + "," + WSRMModule.getServerName()}, null) : TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "MANAGED_NONPERSISTENT_APPLICATION_CWSKA0104", locale, new Object[]{WSRMModule.getApplicationName(this.getContext()) + "," + WSRMModule.getServerName()}, null);
        String status = null;
        if (this._connectionOpened) {
            status = TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "STORE_STATUS_ME_UP_CWSKA0107", locale, new Object[]{this._messagingEngineName, this._busName}, null);
        } else {
            try {
                if (this._persistentStoreChosen) {
                    this.getConnectionForThread();
                }
            }
            catch (MEStoreConnectionException e) {
                // empty catch block
            }
            status = this._connectionOpened ? TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "STORE_STATUS_ME_UP_CWSKA0107", locale, new Object[]{this._messagingEngineName, this._busName}, null) : TraceNLS.getFormattedMessage("com.ibm.ws.websvcs.rm.CWSKAMessages", "STORE_STATUS_ME_DOWN_CWSKA0106", locale, new Object[]{this._messagingEngineName, this._busName}, null);
        }
        StorageManagerDetail detail = new StorageManagerDetail("meStore##" + this.getApplicationInstanceKey(), description, true, true, this._busName, this._messagingEngineName, this._connectionOpened, status);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerDetails", detail);
        }
        return detail;
    }

    public synchronized SandeshaThread getInvoker() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvoker");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvoker", this._invoker);
        }
        return this._invoker;
    }

    public SandeshaThread getSender() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSender");
        }
        if (this._sender == null) {
            try {
                this._sender = (Sender)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                            Tr.exit(tc, "run");
                        }
                        return new Sender();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.getSender", "1:2138:1.67.1.10", this);
                RuntimeException e2 = new RuntimeException(e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSender", e2);
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSender", this._sender);
        }
        return this._sender;
    }

    public PollingManager getPollingManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPollingManager");
        }
        if (this._pollingManager == null) {
            try {
                this._pollingManager = (PollingManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                            Tr.exit(tc, "run");
                        }
                        return new PollingManager();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton.getPollingManager", "1:2177:1.67.1.10", this);
                RuntimeException e2 = new RuntimeException(e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getPollingManager", e2);
                }
                throw e2;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPollingManager", this._pollingManager);
        }
        return this._pollingManager;
    }

    long getRetransmissionInterval() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRetransmissionInterval");
            Tr.exit(tc, "getRetransmissionInterval", this._retransmissionInterval);
        }
        return this._retransmissionInterval;
    }

    public boolean requiresMessageSerialization() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requiresMessageSerialization");
            Tr.exit(tc, "requiresMessageSerialization", Boolean.TRUE);
        }
        return true;
    }

    public boolean hasUserTransaction(MessageContext context) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasUserTransaction", context);
        }
        this.getInUseTransaction().startTransactionalSend(context);
        boolean result = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasUserTransaction", result);
        }
        return result;
    }

    public void setPolicySetLoader(PolicySetLoader psLoader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setPolicySetLoader", psLoader);
        }
        this._psLoader = psLoader;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setPolicySetLoader");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/PersistentStorageManagerSingleton.java, WAS.rm, WAS70.SERV1, cf070937.21 1.67.1.10");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CommandInvoker {
        public List findSenderBeansForSequence(String[] data) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("8", (Serializable)data));
        }

        public HashMap findSenderBeansForSequence2(String[] data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("21", (Serializable)data);
        }

        public Serializable retrieveMessageContext(String[] data) throws MEStoreConnectionException {
            return PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("2", (Serializable)data);
        }

        public List findSenderBeans(Object[] properties) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("4", (Serializable)properties));
        }

        public HashMap retrieveSenderBean(String[] data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("23", (Serializable)data);
        }

        public HashMap getNextMessageToSend(HashMap properties) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("22", properties);
        }

        public HashMap retrieveRMDBean(HashMap data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("7", data);
        }

        public boolean checkTransactionStatue(HashMap data) throws MEStoreConnectionException {
            return (Boolean)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("6", data);
        }

        public HashMap retrieveRMSBean(HashMap properties) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("9", properties);
        }

        public HashMap findRMSBeans(HashMap data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("10", data);
        }

        public List findInvokerBeans(Object[] commandData, boolean siTranRequired) throws MEStoreConnectionException {
            InvokerBean invokerBean;
            ArrayList returnedList = new ArrayList();
            List wrappedList = null;
            MEStoreTransaction meTran = null;
            MEStoreConnection meConn = PersistentStorageManagerSingleton.this.getConnectionForThread();
            if (meConn != null && siTranRequired) {
                meTran = meConn.createTransaction();
            }
            boolean isInvokerBean = false;
            wrappedList = (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("11", meTran, (Serializable)commandData));
            if (wrappedList.isEmpty()) {
                if (meTran != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Bean Not Adopted rollback transaction " + meTran);
                    }
                    meTran.rollback();
                }
            } else {
                Object o;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "If we've adopted DON'T WANT TO ROLLBACK " + meTran);
                }
                if ((o = wrappedList.get(0)) instanceof WrappedInvokerBean) {
                    WrappedInvokerBean wrappedBean = (WrappedInvokerBean)wrappedList.get(0);
                    if (!wrappedBean.isAdopted()) {
                        meTran.rollback();
                    } else {
                        invokerBean = wrappedBean.getInvokerBean();
                        String seqId = invokerBean.getSequenceID();
                        Long msgnum = invokerBean.getMsgNo();
                        String tranKey = seqId + ":" + msgnum;
                        PersistentStorageManagerSingleton.this._meStoreTransactions.put(tranKey, meTran);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Sequence Adoption: Storing transaction " + meTran + ", using key " + tranKey);
                        }
                    }
                } else {
                    isInvokerBean = true;
                }
            }
            if (!isInvokerBean) {
                for (WrappedInvokerBean wrappedBean : wrappedList) {
                    invokerBean = wrappedBean.getInvokerBean();
                    returnedList.add(invokerBean);
                }
            } else {
                returnedList = (ArrayList)wrappedList;
            }
            return returnedList;
        }

        public void processTransactionCommit(HashMap transactionDetails, boolean siTranRequired, boolean amDeletingInvokerBeans, InvokerBean invokerBean) throws MEStoreConnectionException {
            MEStoreConnection meConn;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "processTransactionCommit", new Object[]{transactionDetails, siTranRequired, amDeletingInvokerBeans, invokerBean});
            }
            if ((meConn = PersistentStorageManagerSingleton.this.getConnectionForThread()) != null) {
                MEStoreTransaction meTran = null;
                if (siTranRequired) {
                    meTran = meConn.createTransaction();
                    if (invokerBean != null) {
                        String seqId = invokerBean.getSequenceID();
                        Long msgnum = invokerBean.getMsgNo();
                        String tranKey = seqId + ":" + msgnum;
                        PersistentStorageManagerSingleton.this._meStoreTransactions.put(tranKey, meTran);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Storing transaction " + meTran + ", using key " + tranKey);
                        }
                    }
                } else if (amDeletingInvokerBeans) {
                    InvokerBean cachedInvokerBean = PersistentStorageManagerSingleton.this.getCachedInvokerBean();
                    if (cachedInvokerBean != null) {
                        String seqId = cachedInvokerBean.getSequenceID();
                        Long msgnum = cachedInvokerBean.getMsgNo();
                        String tranKey = seqId + ":" + msgnum;
                        MEStoreTransaction storedMETran = (MEStoreTransaction)PersistentStorageManagerSingleton.this._meStoreTransactions.remove(tranKey);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Preparing to rollback SITran: " + storedMETran);
                        }
                        if (storedMETran != null) {
                            storedMETran.rollback();
                        }
                        cachedInvokerBean = null;
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to find cached InvokerBean");
                    }
                }
                meConn.invokeCommand("1", meTran, transactionDetails);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "processTransactionCommit");
            }
        }

        public void processTransactionRollback(String sequenceToken) throws MEStoreConnectionException {
            PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("12", (Serializable)((Object)sequenceToken));
        }

        public List<RMSequenceBean> loadSequences(String workKey) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this._meStoreConnection.invokeCommand("13", (Serializable)((Object)workKey)));
        }

        public InvokerBean retrieveInvokerBean(Object[] commandData) throws MEStoreConnectionException {
            InvokerBean invokerBean = (InvokerBean)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("14", (Serializable)commandData);
            PersistentStorageManagerSingleton.this.cacheInvokerBean(invokerBean);
            return invokerBean;
        }

        public HashMap findRMDBeans(HashMap data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("15", data);
        }

        public HashMap findUniqueRMSBean(HashMap data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("16", data);
        }

        public Boolean insertInvokerBean(HashMap data) throws MEStoreConnectionException {
            return (Boolean)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("17", data);
        }

        public HashMap insertRMSBean(HashMap data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("18", data);
        }

        public HashMap insertRMDBean(HashMap data) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("19", data);
        }

        public HashMap findSenderBeansWithLock(Object[] properties) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("20", (Serializable)properties);
        }

        public HashMap getNextMessageToSend2(List properties) throws MEStoreConnectionException {
            return (HashMap)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("22", (Serializable)((Object)properties));
        }

        public void forceTransactionRollback(String sequenceToken) throws MEStoreConnectionException {
            PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("24", (Serializable)((Object)sequenceToken));
        }

        public List getDeletedMessageContexts(HashMap data) throws MEStoreConnectionException {
            return (List)((Object)PersistentStorageManagerSingleton.this.getConnectionForThread().invokeCommand("25", data));
        }
    }

    private static class SerializedStorageEntry {
        ConfigurationContext context;
        MessageContext msgContext;
        Object transportControl;
        Object transportOut;
        Object transportOutInfo;
        Object inTransportControl;
        Object inTransportOut;
        Object inTransportOutInfo;

        private SerializedStorageEntry() {
        }

        public String toString() {
            return this.context + " : " + this.transportControl + " : " + this.inTransportControl;
        }
    }
}

