/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.websvcs.rm.MessageData;
import com.ibm.websphere.websvcs.rm.OutboundSequenceData;
import com.ibm.websphere.websvcs.rm.SequenceData;
import com.ibm.websphere.websvcs.rm.StorageManagerDetail;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager;
import com.ibm.ws.websvcs.rm.impl.storage.beanmanagers.InvokerBeanMgrImpl;
import com.ibm.ws.websvcs.rm.mbeans.dao.InboundMessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.InboundSequenceData;
import com.ibm.ws.websvcs.rm.mbeans.dao.MessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.OutboundMessageData;
import com.ibm.ws.websvcs.rm.mbeans.dao.SequenceData;
import com.ibm.ws.websvcs.rm.mbeans.exceptions.WSRMMBeanException;
import com.ibm.ws.websvcs.rm.storage.controller.ControllableStore;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMBeanManager;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.Invoker;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationWSRMStoreController
implements ControllableStore {
    private static final TraceComponent tc = Tr.register(ApplicationWSRMStoreController.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static HashMap serviceClientMap;
    private WSReliableMessagingStorageManager storageManager;
    private Properties props;
    private final int MAX_SLEEP_COUNT = 5;
    private final int SLEEP_TIME = 600;

    public ApplicationWSRMStoreController(WSReliableMessagingStorageManager man) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ApplicationWSRMStoreController", man);
        }
        this.storageManager = man;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ApplicationWSRMStoreController", this);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SequenceData populateSequenceData(String internalSequenceID, boolean isOutbound, RMSequenceBean bean) throws WSRMMBeanException {
        void var4_8;
        block33: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "populateSequenceData", new Object[]{internalSequenceID, isOutbound, bean});
            }
            Object var4_4 = null;
            try {
                com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData data;
                SequenceData.SequenceState theSequenceState;
                SequenceData.SequenceState currentState;
                LinkedList<String> outgoingCompletedMessages;
                long outboundDepth;
                long highestOutMsgNumber;
                String replyToEPR;
                String acksToEPR;
                String targetEPR;
                String wsa_namespace;
                String wsrm_spec_version;
                String sequenceID;
                block35: {
                    block39: {
                        block40: {
                            block38: {
                                boolean isTerminated;
                                block37: {
                                    boolean isTerminating;
                                    block36: {
                                        sequenceID = null;
                                        sequenceID = isOutbound ? SandeshaUtil.getSequenceIDFromInternalSequenceID(internalSequenceID, this.storageManager) : internalSequenceID;
                                        wsrm_spec_version = "UNKNOWN DATA";
                                        wsa_namespace = "UNKNOWN DATA";
                                        RMSequenceBean rmBean = bean;
                                        targetEPR = "UNKNOWN DATA";
                                        if (!isOutbound) {
                                            if (rmBean == null) {
                                                rmBean = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, sequenceID);
                                            }
                                            if (rmBean != null) {
                                                targetEPR = rmBean.getReplyToEPR();
                                            }
                                        } else {
                                            if (rmBean == null) {
                                                rmBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(this.storageManager, internalSequenceID);
                                            }
                                            if (rmBean != null) {
                                                targetEPR = rmBean.getToEPR();
                                            }
                                        }
                                        if (rmBean == null) break block33;
                                        wsrm_spec_version = rmBean.getRMVersion();
                                        wsa_namespace = SpecSpecificConstants.getAddressingNamespace(SpecSpecificConstants.getRMNamespaceValue(wsrm_spec_version));
                                        acksToEPR = "UNKNOWN DATA";
                                        acksToEPR = rmBean.getAcksToEPR();
                                        replyToEPR = "UNKNOWN DATA";
                                        replyToEPR = !isOutbound ? rmBean.getToEPR() : rmBean.getReplyToEPR();
                                        if (!isOutbound) {
                                            InboundSequenceData data2;
                                            SequenceData.SequenceState theSequenceState2;
                                            SequenceData.SequenceState sequenceState;
                                            LinkedList<String> incomingCompletedMessages;
                                            long lastActivatedTime;
                                            long inboundDepth;
                                            boolean isInOrder;
                                            long highestInMsgNumber;
                                            block34: {
                                                long nextMsgNo;
                                                RMDBean rmdBean = (RMDBean)rmBean;
                                                if (rmdBean == null) break block33;
                                                highestInMsgNumber = 0L;
                                                highestInMsgNumber = rmdBean.getHighestInMessageNumber();
                                                isInOrder = false;
                                                isInOrder = SandeshaUtil.getPropertyBean(this.storageManager.getContext().getAxisConfiguration()).isInOrder();
                                                inboundDepth = 0L;
                                                if (isInOrder && (nextMsgNo = rmdBean.getNextMsgNoToProcess()) < highestInMsgNumber) {
                                                    inboundDepth = highestInMsgNumber - nextMsgNo;
                                                }
                                                lastActivatedTime = 0L;
                                                rmdBean.getLastActivatedTime();
                                                incomingCompletedMessages = new LinkedList<String>();
                                                Range[] ranges = rmdBean.getServerCompletedMessages().getRanges();
                                                for (int i = 0; i < ranges.length; ++i) {
                                                    incomingCompletedMessages.add(ranges[i].toString());
                                                }
                                                sequenceState = null;
                                                theSequenceState2 = null;
                                                boolean isClosed = rmdBean.isClosed();
                                                boolean isTerminated2 = rmdBean.isTerminated();
                                                if (isTerminated2) {
                                                    if (incomingCompletedMessages.size() != 1) {
                                                        sequenceState = InboundSequenceData.FAILED_MISSING_MSGS;
                                                        theSequenceState2 = com.ibm.websphere.websvcs.rm.InboundSequenceData.FAILED_MISSING_MSGS;
                                                        break block34;
                                                    } else {
                                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                                            Tr.exit(tc, "populateSequenceData", null);
                                                        }
                                                        return null;
                                                    }
                                                }
                                                if (isClosed) {
                                                    sequenceState = InboundSequenceData.CLOSED;
                                                    theSequenceState2 = com.ibm.websphere.websvcs.rm.InboundSequenceData.CLOSED;
                                                } else if (inboundDepth > 0L && isInOrder) {
                                                    sequenceState = InboundSequenceData.AWAITING_MSG;
                                                    theSequenceState2 = com.ibm.websphere.websvcs.rm.InboundSequenceData.AWAITING_MSG;
                                                } else {
                                                    sequenceState = InboundSequenceData.CONNECTED;
                                                    theSequenceState2 = com.ibm.websphere.websvcs.rm.InboundSequenceData.CONNECTED;
                                                }
                                            }
                                            InboundSequenceData inboundSequenceData = data2 = new InboundSequenceData(sequenceID, WSRMModule.getApplicationName(this.storageManager.getContext()), wsa_namespace, wsrm_spec_version, sequenceState, theSequenceState2, acksToEPR, targetEPR, replyToEPR, incomingCompletedMessages, inboundDepth, highestInMsgNumber, lastActivatedTime, isInOrder, null);
                                            break block33;
                                        }
                                        RMSBean rmsBean = (RMSBean)rmBean;
                                        highestOutMsgNumber = 0L;
                                        highestOutMsgNumber = rmsBean.getHighestOutMessageNumber();
                                        outboundDepth = 0L;
                                        long ackedMsgs = rmsBean.getNumberOfMessagesAcked();
                                        outboundDepth = highestOutMsgNumber - ackedMsgs;
                                        outgoingCompletedMessages = new LinkedList<String>();
                                        Range[] ranges = rmsBean.getClientCompletedMessages().getRanges();
                                        for (int i = 0; i < ranges.length; ++i) {
                                            outgoingCompletedMessages.add(ranges[i].toString());
                                        }
                                        currentState = null;
                                        theSequenceState = null;
                                        boolean isClosed = rmsBean.isClosed();
                                        boolean isClosing = rmsBean.isSequenceClosedClient();
                                        isTerminated = rmsBean.isTerminated();
                                        isTerminating = rmsBean.isTerminateAdded();
                                        if (!isClosed && !isClosing || isTerminated) break block36;
                                        currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.CLOSED;
                                        theSequenceState = OutboundSequenceData.CLOSED;
                                        break block35;
                                    }
                                    if (!isTerminating || isTerminated) break block37;
                                    currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.TERMINATING;
                                    theSequenceState = OutboundSequenceData.TERMINATING;
                                    break block35;
                                }
                                if (isTerminated) {
                                    if (outgoingCompletedMessages != null && (outgoingCompletedMessages.size() == 1 && !outgoingCompletedMessages.contains(highestOutMsgNumber) || outgoingCompletedMessages.size() > 1)) {
                                        currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.FAILED;
                                        theSequenceState = OutboundSequenceData.FAILED;
                                        break block35;
                                    } else {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                            Tr.exit(tc, "populateSequenceData", null);
                                        }
                                        return null;
                                    }
                                }
                                if (outboundDepth != 0L || highestOutMsgNumber <= 0L) break block38;
                                currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.ACTIVE;
                                theSequenceState = OutboundSequenceData.ACTIVE;
                                break block35;
                            }
                            if (highestOutMsgNumber <= 0L) break block39;
                            if (sequenceID == null) {
                                currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.ESTABLISHING;
                                theSequenceState = OutboundSequenceData.ESTABLISHING;
                            } else if (outboundDepth == 0L) {
                                currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.ACTIVE;
                                theSequenceState = OutboundSequenceData.ACTIVE;
                            }
                            long currentTime = System.currentTimeMillis();
                            long lastActivated = bean.getLastActivatedTime();
                            if (outboundDepth <= 0L || currentTime - lastActivated <= 120000L) break block40;
                            currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.REP_UNAVAILABLE;
                            theSequenceState = OutboundSequenceData.REP_UNAVAILABLE;
                            break block35;
                        }
                        if (outboundDepth > 200L) {
                            currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.ACTIVE_WARN;
                            theSequenceState = OutboundSequenceData.ACTIVE_WARN;
                            break block35;
                        } else if (currentState == null) {
                            currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.ACTIVE;
                            theSequenceState = OutboundSequenceData.ACTIVE;
                        }
                        break block35;
                    }
                    currentState = com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData.REP_UNAVAILABLE;
                    theSequenceState = OutboundSequenceData.REP_UNAVAILABLE;
                }
                com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData outboundSequenceData = data = new com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData(sequenceID, internalSequenceID, WSRMModule.getApplicationName(this.storageManager.getContext()), wsa_namespace, wsrm_spec_version, currentState, theSequenceState, acksToEPR, targetEPR, replyToEPR, outgoingCompletedMessages, outboundDepth, highestOutMsgNumber, null);
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.populateSequenceData", "1:517:1.70", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "populateSequenceData", e);
                }
                throw new WSRMMBeanException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "populateSequenceData", var4_8);
        }
        return var4_8;
    }

    @Override
    public Properties getProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties");
        }
        if (this.props == null) {
            this.props = new Properties();
            this.props.put("cell", WSRMModule.getCellName());
            String clusterName = WSRMModule.getClusterName();
            if (clusterName != null) {
                this.props.put("cluster", clusterName);
            }
            this.props.put("node", WSRMModule.getNodeName());
            this.props.put("server", WSRMModule.getServerName());
            this.props.put("application", WSRMModule.getApplicationName(this.storageManager.getContext()));
            this.props.put("application_module", WSRMModule.getApplicationModuleName(this.storageManager.getContext()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties", this.props);
        }
        return this.props;
    }

    @Override
    public Collection<com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData> getOutboundSequences(boolean errorOnly, boolean warningOnly, String applicationName) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundSequences", new Object[]{errorOnly, warningOnly, applicationName});
        }
        Transaction tran = this.createTransaction();
        LinkedList<com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData> returnData = new LinkedList<com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData>();
        try {
            RMSBeanMgr createSeqPropMgr = this.storageManager.getRMSBeanMgr();
            RMSBean outSequenceFinderBean = new RMSBean();
            List outSequences = createSeqPropMgr.find(outSequenceFinderBean);
            for (RMSBean bean : outSequences) {
                String internalSeqID = bean.getInternalSequenceID();
                com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData outboundData = (com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)this.populateSequenceData(internalSeqID, true, bean);
                boolean addSequenceToList = true;
                if (outboundData == null) {
                    addSequenceToList = false;
                }
                if ((errorOnly || warningOnly) && addSequenceToList && (!outboundData.sequenceState.is_error_state && errorOnly || !outboundData.sequenceState.is_warning_state && warningOnly)) {
                    addSequenceToList = false;
                }
                if (applicationName != null && addSequenceToList && !applicationName.equals(WSRMModule.getApplicationName(this.storageManager.getContext()))) {
                    addSequenceToList = false;
                }
                if (returnData.size() > 0) {
                    Iterator iter = returnData.iterator();
                    while (iter.hasNext() && addSequenceToList) {
                        com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData temp = (com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)iter.next();
                        if (temp.sequenceID == null || !temp.sequenceID.equals(outboundData.sequenceID) || !temp.info_internalSeqID.equals(outboundData.info_internalSeqID)) continue;
                        addSequenceToList = false;
                    }
                }
                if (!addSequenceToList) continue;
                returnData.add(outboundData);
            }
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getOutboundSequences", "1:645:1.70", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getOutboundSequences", e);
            }
            throw new WSRMMBeanException(e);
        }
        finally {
            this.completeTransaction(tran);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundSequences", returnData);
        }
        return returnData;
    }

    @Override
    public Collection getInboundSequences(boolean errorOnly, boolean warningOnly, String applicationName) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundSequences", new Object[]{errorOnly, warningOnly, applicationName});
        }
        Transaction tran = this.createTransaction();
        LinkedList<InboundSequenceData> returnData = new LinkedList<InboundSequenceData>();
        try {
            RMDBean rmdBean = new RMDBean();
            List rmdBeans = this.storageManager.getRMDBeanMgr().find(rmdBean);
            for (RMDBean bean : rmdBeans) {
                InboundSequenceData inboundData = (InboundSequenceData)this.populateSequenceData(bean.getSequenceID(), false, bean);
                boolean addSequenceToList = true;
                if (inboundData == null) {
                    addSequenceToList = false;
                }
                if ((errorOnly || warningOnly) && addSequenceToList && (!inboundData.sequenceState.is_error_state && errorOnly || !inboundData.sequenceState.is_warning_state && warningOnly)) {
                    addSequenceToList = false;
                }
                if (applicationName != null && addSequenceToList && !applicationName.equals(WSRMModule.getApplicationName(this.storageManager.getContext()))) {
                    addSequenceToList = false;
                }
                if (!addSequenceToList) continue;
                returnData.add(inboundData);
            }
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getInboundSequences", "1:725:1.70", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getInboundSequences", e);
            }
            throw new WSRMMBeanException(e);
        }
        finally {
            this.completeTransaction(tran);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundSequences", returnData);
        }
        return returnData;
    }

    @Override
    public Collection<OutboundMessageData> getOutboundMessagesOnSequence(OutboundSequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundMessagesOnSequence", sequenceData);
        }
        Transaction tran = this.createTransaction();
        LinkedList<OutboundMessageData> returnMessages = new LinkedList<OutboundMessageData>();
        try {
            String internalSeqID = sequenceData.getInfo_internalSeqID();
            TreeSet senderBeans = new TreeSet(new SenderBeanComparator());
            senderBeans.addAll(this.storageManager.getSenderBeanMgr().find(internalSeqID));
            this.completeTransaction(tran);
            tran = this.createTransaction();
            for (SenderBean bean : senderBeans) {
                if (bean.getMessageType() != 3) continue;
                String key = bean.getMessageContextRefKey();
                MessageContext msgCtx = this.storageManager.retrieveMessageContext(key, this.storageManager.getContext());
                this.completeTransaction(tran);
                tran = this.createTransaction();
                if (msgCtx == null) continue;
                RMMsgContext rmMsgCtx = null;
                try {
                    rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
                    if (rmMsgCtx.getSequence() == null) {
                        RMSBean seqbean = SandeshaUtil.getRMSBeanFromSequenceId(this.storageManager, bean.getSequenceID());
                        String namespace = null;
                        if (seqbean == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "getOutboundMessagesOnSequence", "RMSequenceBean is null");
                            }
                            throw new WSRMMBeanException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"ApplicationWSRMStoreController", "1:802:1.70"}, null));
                        }
                        String beansRMVersion = seqbean.getRMVersion();
                        if (beansRMVersion == null) {
                            beansRMVersion = "Spec_2007_02";
                        }
                        if ((namespace = SpecSpecificConstants.getRMNamespaceValue(beansRMVersion)) == null) {
                            namespace = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
                        }
                        Sequence sequence = new Sequence(namespace);
                        sequence.setMessageNumber(bean.getMessageNumber());
                        Identifier id = new Identifier(namespace);
                        String sequenceId = bean.getSequenceID();
                        if (sequenceId == null) {
                            sequenceId = "uuid:tempID";
                        }
                        id.setIndentifer(sequenceId);
                        sequence.setIdentifier(id);
                        rmMsgCtx.setSequence(sequence);
                        rmMsgCtx.addSOAPEnvelope();
                    }
                }
                catch (AxisFault e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getOutboundMessagesOnSequence", "1:842:1.70", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getOutboundMessagesOnSequence", e);
                    }
                    throw new WSRMMBeanException(e);
                }
                MessageData.MessageState state = null;
                MessageData.MessageState currentState = null;
                if (!bean.isSend()) {
                    state = OutboundMessageData.AWAITING_SEQUENCE_INITIALIZATION;
                    currentState = com.ibm.websphere.websvcs.rm.OutboundMessageData.AWAITING_SEQUENCE_INITIALIZATION;
                } else {
                    state = OutboundMessageData.SENDABLE;
                    currentState = com.ibm.websphere.websvcs.rm.OutboundMessageData.SENDABLE;
                }
                long retransmissionCount = bean.getSentCount();
                returnMessages.add(new OutboundMessageData(rmMsgCtx, sequenceData.getSequenceID(), internalSeqID, bean.getMessageNumber(), state, currentState, retransmissionCount));
            }
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getOutboundMessagesOnSequence", "1:883:1.70", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getOutboundMessagesOnSequence", e);
            }
            throw new WSRMMBeanException(e);
        }
        finally {
            this.completeTransaction(tran);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundMessagesOnSequence", returnMessages);
        }
        return returnMessages;
    }

    @Override
    public Collection<MessageData> getInboundMessagesOnSequence(com.ibm.websphere.websvcs.rm.InboundSequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundMessagesOnSequence", sequenceData);
        }
        Transaction tran = this.createTransaction();
        LinkedList<MessageData> returnMessages = new LinkedList<MessageData>();
        Invoker invoker = null;
        try {
            String sequenceID = sequenceData.getSequenceID();
            invoker = (Invoker)this.storageManager.getInvoker();
            if (invoker != null) {
                // empty if block
            }
            InvokerBean finder = new InvokerBean();
            finder.setSequenceID(sequenceID);
            List invokerBeans = this.storageManager.getInvokerBeanMgr().find(finder);
            for (InvokerBean bean : invokerBeans) {
                String key = bean.getMessageContextRefKey();
                MessageContext msgToInvoke = this.storageManager.retrieveMessageContext(key, this.storageManager.getContext());
                if (msgToInvoke == null) continue;
                RMMsgContext rmMsg = null;
                try {
                    rmMsg = MsgInitializer.initializeMessage(msgToInvoke);
                }
                catch (AxisFault e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getInboundMessagesOnSequence", "1:952:1.70", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getInboundMessagesOnSequence", e);
                    }
                    throw new WSRMMBeanException(e);
                }
                MessageData.MessageState state = InboundMessageData.AWAITING_DISPATCH_TO_APPLICATION;
                MessageData.MessageState currentState = com.ibm.websphere.websvcs.rm.InboundMessageData.AWAITING_DISPATCH_TO_APPLICATION;
                long redeliveryCount = 0L;
                returnMessages.add(new InboundMessageData(rmMsg, sequenceID, sequenceID, bean.getMsgNo(), state, currentState, redeliveryCount));
            }
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.getInboundMessagesOnSequence", "1:981:1.70", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getInboundMessagesOnSequence", e);
            }
            throw new WSRMMBeanException(e);
        }
        finally {
            this.completeTransaction(tran);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundMessagesOnSequence", returnMessages);
        }
        return returnMessages;
    }

    @Override
    public com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail getStorageManagerDetails(Locale locale) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerDetails");
        }
        com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail detail = this.storageManager.getStorageManagerDetails(locale);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerDetails", detail);
        }
        return detail;
    }

    @Override
    public StorageManagerDetail getStorageManagerDetail(Locale locale) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerDetail");
        }
        com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail detail = this.storageManager.getStorageManagerDetails(locale);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerDetail", detail);
        }
        return detail;
    }

    private Transaction createTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransaction");
            Tr.exit(tc, "createTransaction");
        }
        return this.storageManager.getTransaction();
    }

    private void completeTransaction(Transaction tran) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTransaction", tran);
        }
        if (tran != null && tran.isActive()) {
            try {
                tran.commit();
            }
            catch (SandeshaStorageException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.completeTransaction", "1:1058:1.70", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeTransaction", e);
                }
                throw new WSRMMBeanException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTransaction");
        }
    }

    private void rollbackTransaction(Transaction tran) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackTransaction", tran);
        }
        if (tran != null && tran.isActive()) {
            try {
                tran.rollback();
            }
            catch (SandeshaStorageException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.rollbackTransaction", "1:1086:1.70", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollbackTransaction", e);
                }
                throw new WSRMMBeanException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackTransaction");
        }
    }

    private ServiceClient buildServiceClientForSequence(com.ibm.websphere.websvcs.rm.SequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildServiceClientForSequence", new Object[]{sequenceData});
        }
        ServiceClient client = null;
        try {
            String wsrm_nspc;
            ConfigurationContext ctx = this.storageManager.getContext();
            client = new ServiceClient(ctx, null);
            Options options = client.getOptions();
            options.setTo(new EndpointReference(sequenceData.getTargetAddress()));
            options.setReplyTo(new EndpointReference(sequenceData.getReplyToAddress()));
            String internalSequenceID = null;
            if (sequenceData instanceof InboundSequenceData) {
                internalSequenceID = sequenceData.getSequenceID();
            } else {
                internalSequenceID = ((com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)sequenceData).info_internalSeqID;
                String sequenceKey = SandeshaUtil.getSequenceKeyFromInternalSequenceID(internalSequenceID, sequenceData.getTargetAddress());
                options.setProperty("Sandesha2SequenceKey", sequenceKey);
            }
            options.setProperty("Sandesha2InternalSequenceId", internalSequenceID);
            String spec_version = wsrm_nspc = sequenceData.getWsrm_spec_version();
            options.setProperty("Sandesha2RMSpecVersion", spec_version);
            options.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.buildServiceClientForSequence", "1:1144:1.70", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "buildServiceClientForSequence", e);
            }
            throw new WSRMMBeanException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildServiceClientForSequence", client);
        }
        return client;
    }

    @Override
    public void deleteSequence(com.ibm.websphere.websvcs.rm.SequenceData sequence) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSequence", sequence);
        }
        Transaction tran = this.createTransaction();
        try {
            String sequenceKey = null;
            if (sequence instanceof com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData) {
                sequenceKey = ((com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)sequence).info_internalSeqID;
                RMBeanManager manager = this.storageManager.getRMSBeanMgr();
                RMSBean rmsBean = new RMSBean();
                rmsBean.setInternalSequenceID(sequenceKey);
                rmsBean = manager.findUnique(rmsBean);
                if (rmsBean != null) {
                    if (rmsBean.getCreateSequenceMsgStoreKey() != null) {
                        this.storageManager.removeMessageContext(rmsBean.getCreateSequenceMsgStoreKey());
                    }
                    this.storageManager.removeMessageContext(rmsBean.getReferenceMessageStoreKey());
                    manager.delete(rmsBean.getCreateSeqMsgID());
                }
                manager = this.storageManager.getSenderBeanMgr();
                SenderBean senderBean = new SenderBean();
                senderBean.setInternalSequenceID(sequenceKey);
                List list = manager.find(senderBean);
                for (int i = 0; i < list.size(); ++i) {
                    SenderBean nextBean = (SenderBean)list.get(i);
                    manager.delete(nextBean.getMessageID());
                    this.storageManager.removeMessageContext(nextBean.getMessageContextRefKey());
                }
            } else {
                sequenceKey = sequence.getSequenceID();
                RMBeanManager manager = this.storageManager.getRMDBeanMgr();
                manager.delete(sequenceKey);
                manager = this.storageManager.getInvokerBeanMgr();
                List list = null;
                InvokerBean invokerBean = new InvokerBean();
                invokerBean.setSequenceID(sequenceKey);
                list = manager instanceof InvokerBeanMgrImpl && WSRMModule.getClusterName() != null ? ((InvokerBeanMgrImpl)manager).findAll(invokerBean) : manager.find(invokerBean);
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        InvokerBean currentInvoker = (InvokerBean)list.get(i);
                        this.storageManager.removeMessageContext(currentInvoker.getMessageContextRefKey());
                        manager.delete(currentInvoker.getMessageContextRefKey());
                    }
                }
            }
            if (tran != null && tran.isActive()) {
                tran.commit();
            }
            tran = null;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.deleteSequence", "1:1256:1.70", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteSequence", e);
            }
            throw new WSRMMBeanException(e);
        }
        finally {
            if (tran != null && tran.isActive()) {
                this.rollbackTransaction(tran);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSequence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateSequence(com.ibm.websphere.websvcs.rm.SequenceData sequenceData) throws WSRMMBeanException {
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "terminateSequence", sequenceData);
            }
            try {
                if (sequenceData instanceof com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData) {
                    ServiceClient client = this.buildServiceClientForSequence(sequenceData);
                    SandeshaClient.terminateSequence(client);
                    int sleepCount = 0;
                    do {
                        Transaction tran = null;
                        List senderBeans = null;
                        try {
                            tran = this.createTransaction();
                            SenderBean senderFinder = new SenderBean();
                            senderFinder.setInternalSequenceID(((com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)sequenceData).info_internalSeqID);
                            senderFinder.setMessageType(7);
                            senderBeans = this.storageManager.getSenderBeanMgr().find(senderFinder);
                        }
                        finally {
                            if (tran != null && tran.isActive()) {
                                tran.commit();
                            }
                        }
                        if (senderBeans.isEmpty()) {
                            client.cleanup();
                            client = null;
                            break block24;
                        }
                        ApplicationWSRMStoreController applicationWSRMStoreController = this;
                        synchronized (applicationWSRMStoreController) {
                            try {
                                this.wait(600L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    } while (++sleepCount < 5);
                    break block24;
                }
                Transaction tran = null;
                try {
                    tran = this.createTransaction();
                    ConfigurationContext context = this.storageManager.getContext();
                    if (((InboundSequenceData)sequenceData).isInOrder) {
                        TerminateManager.cleanReceivingSideAfterInvocation(sequenceData.getSequenceID(), this.storageManager);
                    }
                    TerminateManager.cleanReceivingSideOnTerminateMessage(context, sequenceData.getSequenceID(), this.storageManager);
                    RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, sequenceData.getSequenceID());
                    rmdBean.setTerminated(true);
                    rmdBean.setLastActivatedTime(System.currentTimeMillis());
                    this.storageManager.getRMDBeanMgr().update(rmdBean);
                    if (tran != null && tran.isActive()) {
                        tran.commit();
                    }
                    tran = null;
                }
                finally {
                    if (tran != null && tran.isActive()) {
                        tran.rollback();
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.terminateSequence", "1:1349:1.70", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "terminateSequence", e);
                }
                throw new WSRMMBeanException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateSequence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSequence(com.ibm.websphere.websvcs.rm.SequenceData sequenceData) throws WSRMMBeanException {
        block27: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "closeSequence", sequenceData);
            }
            try {
                if (!this.isSequenceClosingAllowed(sequenceData.getWsrm_spec_version())) {
                    WSRMMBeanException exception = new WSRMMBeanException(nls.getFormattedMessage("WRONG_SPEC_WARNING_CWSKA0510", new Object[]{sequenceData.getTargetAddress()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "closeSequenceInsideOfTransaction", exception);
                    }
                    throw exception;
                }
                if (sequenceData instanceof com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData) {
                    ServiceClient client = this.buildServiceClientForSequence(sequenceData);
                    SandeshaClient.closeSequence(client);
                    int sleepCount = 0;
                    do {
                        Transaction tran = null;
                        List senderBeans = null;
                        try {
                            tran = this.createTransaction();
                            SenderBean senderFinder = new SenderBean();
                            senderFinder.setInternalSequenceID(((com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)sequenceData).info_internalSeqID);
                            senderFinder.setMessageType(5);
                            senderBeans = this.storageManager.getSenderBeanMgr().find(senderFinder);
                        }
                        finally {
                            if (tran != null && tran.isActive()) {
                                tran.commit();
                            }
                        }
                        if (senderBeans.isEmpty()) {
                            client.cleanup();
                            client = null;
                            break block27;
                        }
                        ApplicationWSRMStoreController applicationWSRMStoreController = this;
                        synchronized (applicationWSRMStoreController) {
                            try {
                                this.wait(600L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    } while (++sleepCount < 5);
                    break block27;
                }
                Transaction tran = null;
                try {
                    tran = this.createTransaction();
                    String sequenceID = sequenceData.getSequenceID();
                    RMSBean rmBean = SandeshaUtil.getRMSBeanFromSequenceId(this.storageManager, sequenceID);
                    if (rmBean == null) {
                        RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, sequenceID);
                        rmdBean.setClosed(true);
                        this.storageManager.getRMDBeanMgr().update(rmdBean);
                    } else {
                        rmBean.setClosed(true);
                        this.storageManager.getRMSBeanMgr().update(rmBean);
                    }
                    if (tran != null && tran.isActive()) {
                        tran.commit();
                    }
                }
                finally {
                    if (tran != null && tran.isActive()) {
                        tran.rollback();
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.closeSequence", "1:1447:1.70", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeSequence", e);
                }
                throw new WSRMMBeanException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeSequence");
        }
    }

    @Override
    public byte[][] writeOutstandingSequenceMessagesToBuffer(com.ibm.websphere.websvcs.rm.SequenceData data) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeOutstandingSequenceMessagesToBuffer", data);
        }
        Collection<MessageData> messages = null;
        if (data instanceof InboundSequenceData) {
            messages = this.getInboundMessagesOnSequence((InboundSequenceData)data);
        } else if (data instanceof com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData) {
            messages = this.getOutboundMessagesOnSequence((com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)data);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "writeOutstandingSequenceMessagesToBuffer", "Sequence ID not found");
            }
            throw new WSRMMBeanException(nls.getFormattedMessage("SEQUENCE_ID_NOT_FOUND_CWSKA0071", new Object[]{data.getSequenceID()}, null));
        }
        byte[][] messageBytes = new byte[messages.size()][];
        Iterator<MessageData> it = messages.iterator();
        int messageIndex = 0;
        while (it.hasNext()) {
            MessageData message = it.next();
            messageBytes[messageIndex] = message.info_soap.toString().getBytes();
            ++messageIndex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeOutstandingSequenceMessagesToBuffer", messageBytes);
        }
        return messageBytes;
    }

    @Override
    public void forceDispatchOfInboundMessages(com.ibm.websphere.websvcs.rm.InboundSequenceData sequenceData) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "forceDispatchOfInboundMessages", sequenceData);
        }
        Transaction tran = null;
        try {
            tran = this.createTransaction();
            SandeshaClient.forceDispatchOfInboundMessages(this.storageManager.getContext(), sequenceData.getSequenceID(), true);
            this.completeTransaction(tran);
            tran = null;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.forceDispatchOfInboundMessages", "1:1524:1.70", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "forceDispatchOfInboundMessages", "WSRMMBeanException");
            }
            throw new WSRMMBeanException(e);
        }
        finally {
            if (tran != null && tran.isActive()) {
                this.rollbackTransaction(tran);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "forceDispatchOfInboundMessages");
        }
    }

    @Override
    public com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData reallocateOutboundMessagesToNewSequence(OutboundSequenceData sequenceData, String newDestinationEPR) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "reallocateOutboundMessagesToNewSequence", new Object[]{sequenceData, newDestinationEPR});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "reallocateOutboundMessagesToNewSequence", "This is currently a NO OP");
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void deleteMessage(com.ibm.websphere.websvcs.rm.MessageData msgToDelete) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
            Tr.entry(ApplicationWSRMStoreController.tc, "deleteMessage", msgToDelete);
        }
        if (msgToDelete instanceof OutboundMessageData) {
            tran = null;
            try {
                tran = this.createTransaction();
                this.storageManager.getSender().blockForPause();
                internalSequenceID = msgToDelete.getInfo_internalSeqID();
                senderFinder = new SenderBean();
                senderFinder.setInternalSequenceID(internalSequenceID);
                senderFinder.setMessageNumber(msgToDelete.getSequenceMessageNumber());
                senderBean = this.storageManager.getSenderBeanMgr().findUnique(senderFinder);
                refKey = senderBean.getMessageContextRefKey();
                this.storageManager.getSenderBeanMgr().delete(senderBean.getMessageID());
                this.storageManager.removeMessageContext(refKey);
                if (tran == null || !tran.isActive()) ** GOTO lbl69
                this.completeTransaction(tran);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.deleteMessage", "1:1751:1.70", this);
                newE = new WSRMMBeanException(e);
                if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
                    Tr.exit(ApplicationWSRMStoreController.tc, "deleteMessage", newE);
                }
                throw newE;
            }
            finally {
                if (tran != null) {
                    this.rollbackTransaction(tran);
                }
                this.storageManager.getSender().finishPause();
            }
        } else {
            sequenceID = msgToDelete.getSequenceID();
            inboundSeqData = (InboundSequenceData)this.populateSequenceData(sequenceID, false, null);
            if (inboundSeqData.isInOrder) {
                tran = this.createTransaction();
                try {
                    this.storageManager.getInvoker().blockForPause();
                    rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(this.storageManager, sequenceID);
                    currentNextMsgToProcess = rmdBean.getNextMsgNoToProcess();
                    invokerFinder = new InvokerBean();
                    invokerFinder.setSequenceID(sequenceID);
                    invokerFinder.setMsgNo(msgToDelete.getSequenceMessageNumber());
                    msgBean = this.storageManager.getInvokerBeanMgr().findUnique(invokerFinder);
                    if (msgBean != null) {
                        this.storageManager.removeMessageContext(msgBean.getMessageContextRefKey());
                        this.storageManager.getInvokerBeanMgr().delete(msgBean.getMessageContextRefKey());
                    }
                    rmdBean.setNextMsgNoToProcess(msgToDelete.getSequenceMessageNumber() + 1L);
                    if (currentNextMsgToProcess != msgToDelete.getSequenceMessageNumber()) {
                        rmdBean.getOutOfOrderRanges().addRange(new Range(1L, msgToDelete.getSequenceMessageNumber()));
                    }
                    this.storageManager.getRMDBeanMgr().update(rmdBean);
                    if (tran != null) {
                        this.completeTransaction(tran);
                        tran = null;
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController.deleteMessage", "1:1817:1.70", this);
                    newE = new WSRMMBeanException(e);
                    if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
                        Tr.exit(ApplicationWSRMStoreController.tc, "deleteMessage", newE);
                    }
                    throw newE;
                }
                finally {
                    if (tran != null) {
                        this.rollbackTransaction(tran);
                        tran = null;
                    }
                    this.storageManager.getInvoker().finishPause();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && ApplicationWSRMStoreController.tc.isEntryEnabled()) {
            Tr.exit(ApplicationWSRMStoreController.tc, "deleteMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceData refreshSequenceData(com.ibm.websphere.websvcs.rm.SequenceData data) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshSequenceData", data);
        }
        Transaction tran = null;
        SequenceData returnData = null;
        try {
            tran = this.createTransaction();
            returnData = data instanceof InboundSequenceData ? this.populateSequenceData(data.getSequenceID(), false, null) : this.populateSequenceData(((com.ibm.ws.websvcs.rm.mbeans.dao.OutboundSequenceData)data).info_internalSeqID, true, null);
        }
        finally {
            if (tran != null) {
                this.completeTransaction(tran);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshSequenceData", returnData);
        }
        return returnData;
    }

    private boolean isSequenceClosingAllowed(String specVersion) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isSequenceClosingAllowed", specVersion);
        }
        boolean returnValue = SpecSpecificConstants.isSequenceClosingAllowed(specVersion);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isSequenceClosingAllowed", returnValue);
        }
        return returnValue;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/ApplicationWSRMStoreController.java, WAS.rm, WAS70.SERV1, cf070937.21 1.70");
        }
        serviceClientMap = new HashMap();
    }

    class SenderBeanComparator
    implements Comparator {
        SenderBeanComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "compare", new Object[]{o1, o2});
            }
            if (!(o1 instanceof SenderBean) || !(o2 instanceof SenderBean)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "compare", "Comparison failed");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"ApplicationWSRMStoreController", "1:205:1.70"}, null));
            }
            SenderBean sender1 = (SenderBean)o1;
            SenderBean sender2 = (SenderBean)o2;
            int returnValue = 0;
            if (sender1.getMessageType() == sender2.getMessageType() && sender2.getMessageType() == 3) {
                int n = returnValue = sender1.getMessageNumber() - sender2.getMessageNumber() > 0L ? 1 : -1;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "compare", returnValue);
            }
            return returnValue;
        }
    }
}

