/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.sib.wsrm.exceptions.MEStoreConnectionException;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.addressing.AddressingConfigHelper;
import com.ibm.ws.websvcs.rm.impl.spi.WSRMSequencePropertiesImpl;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManager;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import com.ibm.wsspi.wsrm.WSRMSequenceManager;
import com.ibm.wsspi.wsrm.WSRMSequenceProperties;
import com.ibm.wsspi.wsrm.exceptions.WSRMErrorException;
import com.ibm.wsspi.wsrm.exceptions.WSRMNotEnabledException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceAlreadyExistsException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceClosedException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceTerminatedException;
import com.ibm.wsspi.wsrm.exceptions.WSRMSequenceUnknownException;
import com.ibm.wsspi.wsrm.exceptions.WSRMTransactionInUseException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.client.dispatch.BaseDispatch;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;

public class WSRMSequenceManagerImpl
implements WSRMSequenceManager {
    private static final TraceComponent tc = Tr.register(WSRMSequenceManagerImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final String GET_DESCRIPTOR_METHOD = "_getDescriptor";
    private static final String GET_PROXY = "getProxy";

    private TransactionThreadMigrator.ThreadTxContextInformation startTran(ServiceClient serviceClient) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startTran");
        }
        TransactionThreadMigrator.ThreadTxContextInformation info = null;
        if (RMServiceConfigPlugin.isManagedQOS(serviceClient.getServiceContext().getConfigurationContext().getAxisConfiguration())) {
            try {
                info = TransactionThreadMigrator.getInstance().startWSRMTransactionalCall(false);
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.startTran", "1:153:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "startTran", e);
                }
                throw new WSRMErrorException(e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startTran", info);
        }
        return info;
    }

    private void endTran(TransactionThreadMigrator.ThreadTxContextInformation info) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "endTran", info);
        }
        try {
            TransactionThreadMigrator.getInstance().finishWSRMTransactionalCall(info);
        }
        catch (AxisFault e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.endTran", "1:181:1.50", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "endTran", e);
            }
            throw new WSRMErrorException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "endTran");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSequence(Object clientInstance, QName portQName, String endPointUrl) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        Options clientOptions;
        ServiceClient serviceClient;
        TransactionThreadMigrator.ThreadTxContextInformation txInfo;
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "closeSequence", new Object[]{clientInstance, endPointUrl});
            }
            txInfo = null;
            try {
                RMSBean rmsBean;
                if (endPointUrl == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "closeSequence", "NullPointerException - null target uri");
                    }
                    throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
                }
                serviceClient = this.getServiceClient(clientInstance, portQName, "closeSequence");
                txInfo = this.startTran(serviceClient);
                this.checkIfRMEnabled(serviceClient);
                this.checkSequenceExists(serviceClient, endPointUrl);
                this.checkForSequenceClosedOrTerminated(serviceClient, endPointUrl, true);
                clientOptions = serviceClient.getOptions();
                clientOptions.setTo(new EndpointReference(endPointUrl));
                clientOptions.setProperty("Sandesha2SequenceKey", WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
                if (AddressingConfigHelper.isAddressingRequired(this.getPolicySetConfiguration(serviceClient.getAxisService()))) {
                    clientOptions.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
                }
                if (!"Spec_2005_02".equals((rmsBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, endPointUrl)).getRMVersion())) break block12;
                Tr.warning(tc, "WRONG_SPEC_WARNING_CWSKA0510", new String[]{endPointUrl});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeSequence");
                }
                this.endTran(txInfo);
                return;
            }
            catch (Throwable throwable) {
                this.endTran(txInfo);
                throw throwable;
            }
        }
        WSRMSequenceManagerImpl.setRMSpecVersion(serviceClient, WSRMSequenceManagerImpl.getRMSBean(serviceClient, endPointUrl), clientOptions);
        try {
            SandeshaClient.closeSequence(serviceClient);
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.closeSequence", "1:264:1.50", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "closeSequence", e);
            }
            throw new WSRMErrorException(e);
        }
        this.endTran(txInfo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "closeSequence");
        }
    }

    private PolicySetConfiguration getPolicySetConfiguration(AxisService axisService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetConfiguration", new Object[]{axisService, this});
        }
        PolicySetConfiguration policySet = null;
        if (axisService != null) {
            Parameter configParam = axisService.getParameter("WASAxis2PolicySet");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "PolicySet configParam: " + configParam);
            }
            if (configParam != null && configParam.getValue() != null) {
                policySet = (PolicySetConfiguration)configParam.getValue();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getPolicySetConfiguration", policySet);
            }
        }
        return policySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewWSRMSequence(Object clientInstance, QName portQName, WSRMSequenceProperties sequenceProperties) throws WSRMNotEnabledException, WSRMSequenceAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewWSRMSequence", new Object[]{clientInstance, sequenceProperties});
        }
        TransactionThreadMigrator.ThreadTxContextInformation txInfo = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(clientInstance, portQName, "createNewWSRMSequence");
            txInfo = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            Options clientOptions = serviceClient.getOptions();
            if (AddressingConfigHelper.isAddressingRequired(this.getPolicySetConfiguration(serviceClient.getAxisService()))) {
                clientOptions.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
            }
            if (sequenceProperties == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNewWSRMSequence", "NullPointerException");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0501", new Object[]{sequenceProperties, "createNewWSRMSequence"}, null));
            }
            WSRMSequencePropertiesImpl sequencePropertiesImpl = (WSRMSequencePropertiesImpl)sequenceProperties;
            if (sequencePropertiesImpl.getTargetEndpointUri() == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNewWSRMSequence", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            this.checkSequenceDoesntExists(serviceClient, sequencePropertiesImpl.getTargetEndpointUri());
            clientOptions.setTo(new EndpointReference(sequencePropertiesImpl.getTargetEndpointUri()));
            WSRMSequenceManagerImpl.setRMSpecVersion(serviceClient, null, clientOptions);
            if (sequencePropertiesImpl.getSOAPVersion() == 2) {
                clientOptions.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
            } else {
                clientOptions.setSoapVersionURI("http://schemas.xmlsoap.org/soap/envelope/");
            }
            if (sequencePropertiesImpl.isUsingAsyncTransport()) {
                clientOptions.setUseSeparateListener(true);
            } else {
                clientOptions.setUseSeparateListener(false);
            }
            clientOptions.setProperty("Sandesha2SequenceKey", WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            try {
                SandeshaClient.createSequence(serviceClient, sequencePropertiesImpl.getUseGeneratedOfferedSequenceId(), null);
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.createNewWSRMSequence", "1:388:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "createNewWSRMSequence", e);
                }
                throw new WSRMErrorException(e);
            }
            this.endTran(txInfo);
        }
        catch (Throwable throwable) {
            this.endTran(txInfo);
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewWSRMSequence");
        }
    }

    public WSRMSequenceProperties createNewWSRMSequenceProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewWSRMSequenceProperties");
        }
        WSRMSequencePropertiesImpl sequenceProperties = new WSRMSequencePropertiesImpl();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewWSRMSequenceProperties", sequenceProperties);
        }
        return sequenceProperties;
    }

    public void terminateSequence(Object clientInstance, QName portQName, String endPointUrl) throws WSRMNotEnabledException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateSequence", new Object[]{clientInstance, endPointUrl});
        }
        ServiceClient serviceClient = this.getServiceClient(clientInstance, portQName, "terminateSequence");
        this.terminateSequence(serviceClient, endPointUrl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateSequence");
        }
    }

    /*
     * Exception decompiling
     */
    public void terminateSequence(ServiceClient serviceClient, String endPointUrl) throws WSRMNotEnabledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean waitUntilSequenceCompleted(Object clientInstance, QName portQName, String endPointUri) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMTransactionInUseException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitUntilSequenceCompleted", new Object[]{clientInstance, portQName, endPointUri});
        }
        boolean returnVal = this.waitUntilSequenceCompleted(clientInstance, portQName, endPointUri, -1L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitUntilSequenceCompleted", returnVal);
        }
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean waitUntilSequenceCompleted(Object clientInstance, QName portQName, String endPointUri, long waitTime) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMTransactionInUseException {
        TransactionThreadMigrator.ThreadTxContextInformation txInfo;
        block29: {
            RMSBean rmsBean;
            ServiceClient serviceClient;
            block28: {
                block27: {
                    boolean infiniteWait;
                    block26: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "waitUntilSequenceCompleted", new Object[]{clientInstance, portQName, endPointUri, waitTime});
                        }
                        txInfo = null;
                        try {
                            serviceClient = this.getServiceClient(clientInstance, portQName, "waitUntilSequenceCompleted");
                            if (endPointUri == null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "waitUntilSequenceCompleted", "NullPointerException - null target uri");
                                }
                                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
                            }
                            txInfo = this.startTran(serviceClient);
                            this.checkIfRMEnabled(serviceClient);
                            this.checkSequenceExists(serviceClient, endPointUri);
                            this.checkTransactionState(serviceClient, endPointUri);
                            infiniteWait = waitTime == -1L;
                            rmsBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, endPointUri);
                            if (!rmsBean.isSequenceClosedClient() && !rmsBean.isTerminateAdded()) {
                                waitTime = this.waitForAllMessagesToBeAcked(serviceClient, rmsBean, waitTime);
                            }
                            if (infiniteWait || waitTime > 0L) break block26;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence not complete as not all messages acked");
                            }
                            boolean bl = false;
                            this.endTran(txInfo);
                            return bl;
                        }
                        catch (Throwable throwable) {
                            this.endTran(txInfo);
                            throw throwable;
                        }
                    }
                    long timeNow = System.currentTimeMillis();
                    this.terminateSequence(clientInstance, portQName, endPointUri);
                    long timeEnd = System.currentTimeMillis();
                    if (!infiniteWait) {
                        waitTime -= timeEnd - timeNow;
                    }
                    if (infiniteWait || waitTime > 0L) break block27;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence timed out terminating sequence");
                    }
                    boolean bl = false;
                    this.endTran(txInfo);
                    return bl;
                }
                Options clientOptions = serviceClient.getOptions();
                clientOptions.setTo(new EndpointReference(endPointUri));
                clientOptions.setProperty("Sandesha2SequenceKey", WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
                SandeshaClient.waitUntilSequenceCompleted(serviceClient, waitTime);
                rmsBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, endPointUri);
                if (rmsBean == null || rmsBean.isTerminated()) break block28;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence not terminated");
                }
                boolean bl = false;
                this.endTran(txInfo);
                return bl;
            }
            ConfigurationContext context = serviceClient.getServiceContext().getConfigurationContext();
            StorageManager storageManager = null;
            Transaction transaction = null;
            try {
                storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
                transaction = storageManager.getTransaction();
                storageManager.getRMSBeanMgr().delete(rmsBean.getCreateSeqMsgID());
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
                break block29;
            }
            catch (SandeshaException e) {
                FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.waitUntilSequenceCompleted", "1:691:1.50");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitUntilSequenceCompleted", e);
                }
                throw new WSRMErrorException(e);
            }
            finally {
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
            }
            {
                catch (SandeshaException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.waitUntilSequenceCompleted", "1:708:1.50", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "waitUntilSequenceCompleted", e);
                    }
                    throw new WSRMErrorException(e);
                }
            }
        }
        this.endTran(txInfo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitUntilSequenceCompleted", Boolean.TRUE);
        }
        return true;
    }

    private void checkTransactionState(ServiceClient serviceClient, String endPointUri) throws WSRMTransactionInUseException {
        ConfigurationContext context;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTransactionState", new Object[]{serviceClient, endPointUri});
        }
        if (RMServiceConfigPlugin.isManagedQOS((context = serviceClient.getServiceContext().getConfigurationContext()).getAxisConfiguration())) {
            PersistentStorageManagerSingleton storageManager = null;
            try {
                storageManager = ((PersistentStorageManager)SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration())).getSingletonInstance();
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkTransactionState", "1:762:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTransactionState", e);
                }
                throw new WSRMErrorException(e);
            }
            HashMap<Object, String> data = new HashMap<Object, String>();
            data.put(WSRMConstants.WORK_KEY, storageManager.getWorkKey());
            data.put("SEQUENCEID", endPointUri);
            boolean isTranActive = false;
            try {
                isTranActive = storageManager.getCommandInvoker().checkTransactionStatue(data);
            }
            catch (MEStoreConnectionException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkTransactionState", "1:786:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTransactionState", e);
                }
                throw new WSRMErrorException(e);
            }
            if (isTranActive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkTransactionState", "WSRMTransactionInUseException");
                }
                throw new WSRMTransactionInUseException(nls.getFormattedMessage("TRANSACTION_IN_USE_ERROR_CWSKA0504", new String[]{endPointUri}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTransactionState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAllMessagesToBeAcked(Object clientInstance, QName portQName, String endPointUri, long waitTime) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException, WSRMTransactionInUseException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAllMessagesToBeAcked", new Object[]{clientInstance, portQName, endPointUri, waitTime});
        }
        TransactionThreadMigrator.ThreadTxContextInformation txInfo = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(clientInstance, portQName, "waitUntilSequenceCompleted");
            if (endPointUri == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitForAllMessagesToBeAcked", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            txInfo = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            this.checkSequenceExists(serviceClient, endPointUri);
            this.checkForSequenceClosedOrTerminated(serviceClient, endPointUri, true);
            this.checkTransactionState(serviceClient, endPointUri);
            boolean infiniteWait = waitTime == -1L;
            RMSBean rmsBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, endPointUri);
            if (!rmsBean.isSequenceClosedClient() && !rmsBean.isTerminateAdded()) {
                waitTime = this.waitForAllMessagesToBeAcked(serviceClient, rmsBean, waitTime);
            }
            if (!infiniteWait && waitTime <= 0L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitForAllMessagesToBeAcked", "Not all messages acked");
                }
                boolean bl = false;
                this.endTran(txInfo);
                return bl;
            }
            this.endTran(txInfo);
        }
        catch (Throwable throwable) {
            this.endTran(txInfo);
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForAllMessagesToBeAcked");
        }
        return true;
    }

    public boolean waitForAllMessagesToBeAcked(Object clientInstance, QName portQName, String endPointUri) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException, WSRMTransactionInUseException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAllMessagesToBeAcked", new Object[]{clientInstance, portQName, endPointUri});
        }
        boolean result = this.waitForAllMessagesToBeAcked(clientInstance, portQName, endPointUri, -1L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForAllMessagesToBeAcked", result);
        }
        return result;
    }

    private long waitForAllMessagesToBeAcked(ServiceClient serviceClient, RMSBean rmsBean, long waitTime) {
        boolean infinite;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAllMessagesToBeAcked", new Object[]{serviceClient, rmsBean, waitTime});
        }
        long highestOutMsgKey = rmsBean.getHighestOutMessageNumber();
        long timeAtStart = System.currentTimeMillis();
        boolean bl = infinite = waitTime == -1L;
        if (highestOutMsgKey > 0L) {
            long timeNow = System.currentTimeMillis();
            long timeToComplete = timeNow + waitTime;
            boolean complete = false;
            while (!complete && (timeNow < timeToComplete || infinite)) {
                timeNow = System.currentTimeMillis();
                try {
                    RMSBean latestRMSBean = WSRMSequenceManagerImpl.getRMSBean(serviceClient, rmsBean.getToEPR());
                    RangeString rangeString = latestRMSBean.getClientCompletedMessages();
                    if (rangeString.isMessageNumberInRanges(highestOutMsgKey) && rangeString.getRanges().length == 1) {
                        complete = true;
                        continue;
                    }
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Caught an exception " + e);
                }
            }
        }
        long timeAtEnd = System.currentTimeMillis();
        if (!infinite) {
            waitTime -= timeAtEnd - timeAtStart;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForAllMessagesToBeAcked", waitTime);
        }
        return waitTime;
    }

    private ServiceClient getServiceClient(Object clientInstance, QName portQName, String method) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceClient", new Object[]{clientInstance, portQName, method});
        }
        if (clientInstance == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getServiceClient", "NullPointerException");
            }
            throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0501", new Object[]{"clientObject", method}, null));
        }
        ServiceDelegate serviceDelegate = null;
        if (clientInstance instanceof BaseDispatch) {
            serviceDelegate = ((BaseDispatch)clientInstance).getServiceDelegate();
        } else if (clientInstance instanceof BindingProvider) {
            serviceDelegate = ((BindingProvider)clientInstance).getServiceDelegate();
        } else {
            Method[] methods = clientInstance.getClass().getMethods();
            Object descriptorObject = null;
            for (int i = 0; i < methods.length && descriptorObject == null; ++i) {
                Method methodI = methods[i];
                if (!methodI.getName().equals(GET_DESCRIPTOR_METHOD)) continue;
                try {
                    descriptorObject = methodI.invoke(clientInstance, (Object[])null);
                    continue;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getServiceClient", "1:988:1.50", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getServiceClient", e);
                    }
                    throw new WSRMErrorException(nls.getFormattedMessage("UNKNOWN_DISPATCH_TYPE_ERROR_CWSKA0502", new Object[]{clientInstance.getClass()}, null));
                }
            }
            Object proxyObject = null;
            if (descriptorObject != null) {
                Method[] methods2 = descriptorObject.getClass().getMethods();
                for (int i = 0; i < methods2.length && proxyObject == null; ++i) {
                    Method methodI = methods2[i];
                    if (!methodI.getName().equals(GET_PROXY)) continue;
                    try {
                        proxyObject = methodI.invoke(descriptorObject, (Object[])null);
                        continue;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getServiceClient", "1:1025:1.50", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getServiceClient", e);
                        }
                        throw new WSRMErrorException(nls.getFormattedMessage("UNKNOWN_DISPATCH_TYPE_ERROR_CWSKA0502", new Object[]{clientInstance.getClass()}, null));
                    }
                }
            }
            if (proxyObject != null && proxyObject instanceof BindingProvider) {
                serviceDelegate = ((BindingProvider)proxyObject).getServiceDelegate();
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServiceClient", "WSRMErrorException - Unknown dispatch type");
                }
                throw new WSRMErrorException(nls.getFormattedMessage("UNKNOWN_DISPATCH_TYPE_ERROR_CWSKA0502", new Object[]{clientInstance.getClass()}, null));
            }
        }
        ServiceClient serviceClient = serviceDelegate.getServiceClient(portQName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceClient", serviceClient);
        }
        return serviceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getLastWSRMError(Object clientInstance, QName portQName, String endPointUri) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastWSRMError", new Object[]{clientInstance, portQName, endPointUri});
        }
        TransactionThreadMigrator.ThreadTxContextInformation txInfo = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(clientInstance, portQName, "getLastWSRMError");
            if (endPointUri == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMError", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            txInfo = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            this.checkSequenceExists(serviceClient, endPointUri);
            this.checkForSequenceClosedOrTerminated(serviceClient, endPointUri, true);
            Options clientOptions = serviceClient.getOptions();
            clientOptions.setTo(new EndpointReference(endPointUri));
            clientOptions.setProperty("Sandesha2SequenceKey", WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            Exception exception = null;
            try {
                exception = SandeshaClient.getLastSendError(serviceClient);
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getLastWSRMError", "1:1111:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMError", e);
                }
                throw new WSRMErrorException(e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getLastWSRMError", exception);
            }
            Exception exception2 = exception;
            this.endTran(txInfo);
            return exception2;
        }
        catch (Throwable throwable) {
            this.endTran(txInfo);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastWSRMErrorTimestamp(Object clientInstance, QName portQName, String endPointUri) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLastWSRMErrorTimestamp", new Object[]{clientInstance, portQName, endPointUri});
        }
        TransactionThreadMigrator.ThreadTxContextInformation txInfo = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(clientInstance, portQName, "getLastWSRMErrorTimestamp");
            if (endPointUri == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMErrorTimestamp", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            txInfo = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            this.checkSequenceExists(serviceClient, endPointUri);
            this.checkForSequenceClosedOrTerminated(serviceClient, endPointUri, true);
            Options clientOptions = serviceClient.getOptions();
            clientOptions.setTo(new EndpointReference(endPointUri));
            clientOptions.setProperty("Sandesha2SequenceKey", WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            long timestamp = -1L;
            try {
                timestamp = SandeshaClient.getLastSendErrorTimestamp(serviceClient);
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getLastWSRMErrorTimestamp", "1:1185:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "getLastWSRMErrorTimestamp", e);
                }
                throw new WSRMErrorException(e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getLastWSRMErrorTimestamp", timestamp);
            }
            long l = timestamp;
            this.endTran(txInfo);
            return l;
        }
        catch (Throwable throwable) {
            this.endTran(txInfo);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAcknowledgementRequest(Object clientInstance, QName portQName, String endPointUri) throws WSRMNotEnabledException, WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendAcknowledgementRequest", new Object[]{clientInstance, endPointUri});
        }
        TransactionThreadMigrator.ThreadTxContextInformation txInfo = null;
        try {
            ServiceClient serviceClient = this.getServiceClient(clientInstance, portQName, "sendAcknowledgementRequest");
            if (endPointUri == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendAcknowledgementRequest", "NullPointerException - null target uri");
                }
                throw new NullPointerException(nls.getFormattedMessage("NULL_PARAMETER_ERROR_CWSKA0503", null, null));
            }
            txInfo = this.startTran(serviceClient);
            this.checkIfRMEnabled(serviceClient);
            this.checkSequenceExists(serviceClient, endPointUri);
            this.checkForSequenceClosedOrTerminated(serviceClient, endPointUri, true);
            Options clientOptions = serviceClient.getOptions();
            clientOptions.setTo(new EndpointReference(endPointUri));
            clientOptions.setProperty("Sandesha2SequenceKey", WSRMSequenceManagerImpl.getSequenceKey(serviceClient));
            if (AddressingConfigHelper.isAddressingRequired(this.getPolicySetConfiguration(serviceClient.getAxisService()))) {
                clientOptions.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
            }
            WSRMSequenceManagerImpl.setRMSpecVersion(serviceClient, WSRMSequenceManagerImpl.getRMSBean(serviceClient, endPointUri), clientOptions);
            try {
                SandeshaClient.sendAckRequest(serviceClient);
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.sendAcknowledgementRequest", "1:1256:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendAcknowledgementRequest", e);
                }
                throw new WSRMErrorException(e);
            }
            this.endTran(txInfo);
        }
        catch (Throwable throwable) {
            this.endTran(txInfo);
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendAcknowledgementRequest");
        }
    }

    private void checkIfRMEnabled(ServiceClient serviceClient) throws WSRMNotEnabledException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfRMEnabled", serviceClient);
        }
        if (!WSRMModule.isWSRMEnabledForService(serviceClient.getAxisService())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfRMEnabled", "WSRMNotEnabledException");
            }
            throw new WSRMNotEnabledException(nls.getFormattedMessage("WSRM_NOT_ENABLED_ERROR_CWSKA0505", null, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfRMEnabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSequenceExists(ServiceClient serviceClient, String toEPR) throws WSRMSequenceUnknownException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSequenceExists", new Object[]{serviceClient, toEPR});
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        ConfigurationContext context = serviceContext.getConfigurationContext();
        String sequenceKey = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
        String internalSequenceID = SandeshaUtil.getInternalSequenceID(toEPR, sequenceKey);
        StorageManager storageManager = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceExists", "1:1336:1.50", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkSequenceExists", e);
            }
            throw new WSRMErrorException(e);
        }
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            RMSBean rmsBean = null;
            try {
                rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID);
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceExists", "1:1364:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceExists", e);
                }
                throw new WSRMErrorException(e);
            }
            if (rmsBean == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceExists", "WSRMSequenceUnknownException");
                }
                throw new WSRMSequenceUnknownException(nls.getFormattedMessage("WSRM_SEQUENCE_UNKNOWN_ERROR_CWSKA0506", new Object[]{toEPR}, null));
            }
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (SandeshaStorageException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceExists", "1:1397:1.50", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkSequenceExists", e);
                    }
                    throw new WSRMErrorException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSequenceExists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSequenceDoesntExists(ServiceClient serviceClient, String toEPR) throws WSRMSequenceAlreadyExistsException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSequenceDoesntExists", new Object[]{serviceClient, toEPR});
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        ConfigurationContext context = serviceContext.getConfigurationContext();
        String sequenceKey = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
        String internalSequenceID = SandeshaUtil.getInternalSequenceID(toEPR, sequenceKey);
        StorageManager storageManager = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceDoesntExists", "1:1449:1.50", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkSequenceDoesntExists", e);
            }
            throw new WSRMErrorException(e);
        }
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            RMSBean rmsBean = null;
            try {
                rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID);
            }
            catch (SandeshaException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceDoesntExists", "1:1475:1.50", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceDoesntExists", e);
                }
                throw new WSRMErrorException(e);
            }
            if (rmsBean != null && !rmsBean.isTerminated()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkSequenceDoesntExists", "Sequence already exists");
                }
                throw new WSRMSequenceAlreadyExistsException(nls.getFormattedMessage("WSRM_SEQUENCE_ALREADY_EXISTS_ERROR_CWSKA0509", new Object[]{toEPR}, null));
            }
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (SandeshaStorageException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkSequenceDoesntExists", "1:1508:1.50", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkSequenceDoesntExists", "WSRMErrorException");
                    }
                    throw new WSRMErrorException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSequenceDoesntExists");
        }
    }

    private void checkForSequenceClosedOrTerminated(ServiceClient serviceClient, String toEPR, boolean checkClosed) throws WSRMSequenceUnknownException, WSRMSequenceTerminatedException, WSRMSequenceClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForSequenceClosedOrTerminated", new Object[]{serviceClient, toEPR, checkClosed});
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        ConfigurationContext context = serviceContext.getConfigurationContext();
        String sequenceKey = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
        String internalSequenceID = SandeshaUtil.getInternalSequenceID(toEPR, sequenceKey);
        StorageManager storageManager = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkForSequenceClosedOrTerminated", "1:1565:1.50", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkForSequenceClosedOrTerminated", e);
            }
            throw new WSRMErrorException(e);
        }
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            if (WSRMSequenceManagerImpl.isSequenceTerminatedOrTimedOutOrClosed(internalSequenceID, storageManager, toEPR, checkClosed)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkForSequenceClosedOrTerminated", "WSRMSequenceTerminatedException");
                }
                throw new WSRMSequenceTerminatedException(nls.getFormattedMessage("WSRM_SEQUENCE_TERMINATED_ERROR_CWSKA0507", new Object[]{toEPR}, null));
            }
        }
        catch (SandeshaException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkForSequenceClosedOrTerminated", "1:1596:1.50", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "checkForSequenceClosedOrTerminated", "WSRMErrorException");
            }
            throw new WSRMErrorException(e);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.commit();
                }
                catch (SandeshaStorageException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.checkForSequenceClosedOrTerminated", "1:1616:1.50", this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkForSequenceClosedOrTerminated", e);
                    }
                    throw new WSRMErrorException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForSequenceClosedOrTerminated");
        }
    }

    private static boolean isSequenceTerminatedOrTimedOutOrClosed(String internalSequenceID, StorageManager storageManager, String toEPR, boolean checkClosed) throws WSRMSequenceUnknownException, SandeshaException, WSRMSequenceClosedException {
        RMSBean rmsBean;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isSequenceTerminatedOrTimedOutOrClosed", new Object[]{internalSequenceID});
        }
        if ((rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "WSRMSequenceUnknownException");
            }
            throw new WSRMSequenceUnknownException(nls.getFormattedMessage("WSRM_SEQUENCE_UNKNOWN_ERROR_CWSKA0506", new Object[]{toEPR}, null));
        }
        if (rmsBean.isTerminateAdded()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "Sequence terminated " + Boolean.TRUE);
            }
            return true;
        }
        if (rmsBean.isTimedOut()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "Sequence timedout " + Boolean.TRUE);
            }
            return true;
        }
        if (checkClosed && rmsBean.isClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", "Sequence closed");
            }
            throw new WSRMSequenceClosedException(nls.getFormattedMessage("WSRM_SEQUENCE_CLOSED_ERROR_CWSKA0508", new Object[]{toEPR}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isSequenceTerminatedOrTimedOutOrClosed", Boolean.FALSE);
        }
        return false;
    }

    private static final void setRMSpecVersion(ServiceClient serviceClient, RMSBean rmsBean, Options clientOptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRMSpecVersion", new Object[]{serviceClient, rmsBean, clientOptions});
        }
        AxisService service = serviceClient.getServiceContext().getAxisService();
        if (rmsBean != null) {
            clientOptions.setProperty("Sandesha2RMSpecVersion", rmsBean.getRMVersion());
        } else if (service.getAxisConfiguration().getParameter("Sandesha2RMSpecVersion") != null) {
            clientOptions.setProperty("Sandesha2RMSpecVersion", service.getAxisConfiguration().getParameter("Sandesha2RMSpecVersion").getValue());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRMSpecVersion");
        }
    }

    private static final RMSBean getRMSBean(ServiceClient serviceClient, String endPointUri) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBean");
        }
        ConfigurationContext context = serviceClient.getServiceContext().getConfigurationContext();
        RMSBean rmsBean = null;
        StorageManager storageManager = null;
        Transaction transaction = null;
        try {
            storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
            transaction = storageManager.getTransaction();
            String sequenceKey = WSRMSequenceManagerImpl.getSequenceKey(serviceClient);
            String internalSequenceId = SandeshaUtil.getInternalSequenceID(endPointUri, sequenceKey);
            rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (SandeshaException e) {
            FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getRMSBean", "1:1760:1.50");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getRMSBean", e);
            }
            throw new WSRMErrorException(e);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                }
                catch (SandeshaException e) {
                    FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl.getRMSBean", "1:1773:1.50");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getRMSBean", e);
                    }
                    throw new WSRMErrorException(e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMSBean", rmsBean);
        }
        return rmsBean;
    }

    private static String getSequenceKey(ServiceClient client) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceKey", client);
        }
        ServiceContext serviceContext = client.getServiceContext();
        ConfigurationContext context = serviceContext.getConfigurationContext();
        Parameter param = context.getAxisConfiguration().getParameter("Sandesha2SequenceKey");
        String sequenceKey = null;
        if (param != null) {
            sequenceKey = (String)param.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceKey", sequenceKey);
        }
        return sequenceKey;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/spi/WSRMSequenceManagerImpl.java, WAS.rm, WAS70.SERV1, cf070937.21 1.50");
        }
    }
}

