/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.rm.impl.security.IBMSecurityToken;
import com.ibm.ws.wssecurity.sc.util.SecureConversation;
import com.ibm.ws.wssecurity.sc.util.SecureConversationHandle;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;

public class IBMSecurityManager
extends SecurityManager {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceComponent tc = Tr.register(IBMSecurityManager.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static int MAX_SECURITY_TOKEN_ENTRIES = 50;
    public static Map<String, SecurityToken> secTokenCache = Collections.synchronizedMap(new LinkedHashMap<String, SecurityToken>(MAX_SECURITY_TOKEN_ENTRIES + 1, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<String, SecurityToken> eldest) {
            return this.size() > MAX_SECURITY_TOKEN_ENTRIES;
        }
    });
    private OMFactory factory;
    private OMNamespace secNamespace;
    private SecureConversation theConversation;

    public IBMSecurityManager(ConfigurationContext context) throws Exception {
        super(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "IBMSecurityManager", context);
        }
        try {
            this.factory = OMAbstractFactory.getOMFactory();
            this.secNamespace = this.factory.createOMNamespace("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
            this.theConversation = SecureConversationHandle.getInstance();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.IBMSecurityManager", "1:132:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "IBMSecurityManager", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "IBMSecurityManager");
        }
    }

    public void initSecurity(AxisModule moduleDesc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecurity");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initSecurity");
        }
    }

    public SecurityToken getSecurityToken(MessageContext message) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityToken(MessageContext)");
        }
        IBMSecurityToken result = null;
        try {
            SecurityContextToken token = this.theConversation.getSCToken(message);
            byte[] securityData = this.theConversation.getWSSPropertyMapByteArray(message);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Security token: " + token + ", data: " + securityData);
            }
            if (token != null) {
                result = new IBMSecurityToken(token.getIdentifier(), securityData);
            }
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getSecurityToken", "1:183:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityToken", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityToken", result);
        }
        return result;
    }

    public SecurityToken getSecurityToken(OMElement str, MessageContext message) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityToken(OMElement,MessageContext)");
        }
        IBMSecurityToken result = null;
        try {
            SecurityContextToken token = this.theConversation.getSCTokenBySecurityTokenReference(str, message);
            byte[] securityData = this.theConversation.getWSSPropertyMapByteArray(message);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Security token: " + token + ", data: " + securityData);
            }
            result = new IBMSecurityToken(token.getIdentifier(), securityData);
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getSecurityToken", "1:218:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityToken", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityToken", result);
        }
        return result;
    }

    public void initSecurityToken(String tokenData) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecurityToken", tokenData);
        }
        try {
            SecurityStringDataConverter converter = new SecurityStringDataConverter(tokenData);
            this.theConversation.restoreSCToken(converter.tokenBytes);
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.initSecurityToken", "1:291:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initSecutiryToken", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.initSecurityToken", "1:303:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "initSecutiryToken", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("INTERNAL_RM_ERROR_CWSKA0002", new Object[]{"IBMSecurityManager", "1:307:1.18", e}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initSecurityToken");
        }
    }

    public SecurityToken recoverSecurityToken(String tokenData) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverSecurityToken");
        }
        SecurityToken result = null;
        try {
            result = secTokenCache.get(tokenData);
            if (result == null) {
                SecurityStringDataConverter converter = new SecurityStringDataConverter(tokenData);
                SecurityContextToken token = this.theConversation.getSCTokenFromBytes(converter.tokenBytes);
                result = new IBMSecurityToken(token.getIdentifier(), converter.dataBytes);
                secTokenCache.put(tokenData, result);
            }
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.recoverSecurityToken", "1:335:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverSecurityToken", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.recoverSecurityToken", "1:347:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverSecurityToken", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("INTERNAL_RM_ERROR_CWSKA0002", new Object[]{"IBMSecurityManager", "1:351:1.18", e}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "recoverSecurityToken", result);
        }
        return result;
    }

    public void checkProofOfPossession(SecurityToken token, OMElement messagePart, MessageContext message) throws SandeshaException {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "checkProofOfPossession", token);
            }
            try {
                String uuid = ((IBMSecurityToken)token).getUUID();
                List signed = this.theConversation.getSignedParts(uuid, message);
                if (signed != null && signed.contains(messagePart)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Message part was signed");
                    }
                    break block10;
                }
                List encrypted = this.theConversation.getEncryptedParts(uuid, message);
                if (encrypted != null && encrypted.contains(messagePart)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Message part was encrypted");
                    }
                    break block10;
                }
                QName name = messagePart.getQName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkProofOfPossession", "No proof of possession " + name);
                }
                throw new SandeshaException(nls.getFormattedMessage("MSGPART_NOT_SECURED_CWSKA0022", new Object[]{name}, null));
            }
            catch (SoapSecurityException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.checkProofOfPossession", "1:394:1.18", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkProofOfPossession", e);
                }
                throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProofOfPossession(signed)");
        }
    }

    public OMElement createSecurityTokenReference(SecurityToken token, MessageContext message) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createSecurityTokenReference", token);
        }
        OMElement str = null;
        try {
            IBMSecurityToken ibmToken = (IBMSecurityToken)token;
            SecurityContextToken t = this.theConversation.getSCToken(ibmToken.getUUID());
            String uri = t.getIdentifier();
            String type = t.getValueType().getLocalPart();
            str = this.factory.createOMElement("SecurityTokenReference", this.secNamespace);
            OMElement ref = this.factory.createOMElement("Reference", this.secNamespace);
            OMAttribute uriAttr = this.factory.createOMAttribute("URI", null, uri);
            OMAttribute typeAttr = this.factory.createOMAttribute("ValueType", null, type);
            str.addChild(ref);
            ref.addAttribute(uriAttr);
            ref.addAttribute(typeAttr);
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.createSecurityTokenReference", "1:431:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createSecurityTokenReference", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createSecurityTokenReference", str);
        }
        return str;
    }

    public String getTokenRecoveryData(SecurityToken token) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenRecoveryData", token);
        }
        String result = null;
        try {
            IBMSecurityToken t = (IBMSecurityToken)token;
            result = (IBMSecurityManager)this.new SecurityStringDataConverter((IBMSecurityToken)t).tokenString;
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getTokenRecoveryData", "1:459:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTokenRecoveryData", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.getTokenRecoveryData", "1:471:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTokenRecoveryData", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("INTERNAL_RM_ERROR_CWSKA0002", new Object[]{"IBMSecurityManager", "1:475:1.18", e}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenRecoveryData");
        }
        return result;
    }

    public void applySecurityToken(SecurityToken token, MessageContext outMessage) throws SandeshaException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "applySecurityToken", new Object[]{token, outMessage});
        }
        try {
            IBMSecurityToken t = (IBMSecurityToken)token;
            byte[] data = t.getSecurityHashMapData();
            this.theConversation.getWSSPropertyMapFromByteArray(data, outMessage);
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.security.IBMSecurityManager.applySecurityToken", "1:501:1.18", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "applySecurityToken", e);
            }
            throw new SandeshaException(nls.getFormattedMessage("SECURITY_EXCEPTION_CWSKA0021", new Object[]{e}, null), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "applySecurityToken");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/security/IBMSecurityManager.java, WAS.rm, WAS70.SERV1, cf070937.21 1.18");
        }
    }

    private class SecurityStringDataConverter {
        final byte[] tokenBytes;
        final byte[] dataBytes;
        final String tokenString;

        SecurityStringDataConverter(String tokenString) throws IOException, ClassNotFoundException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "SecurityStringDataConverter", tokenString);
            }
            this.tokenString = tokenString;
            byte[] temp = Base64.decode(tokenString);
            ByteArrayInputStream stream = new ByteArrayInputStream(temp);
            ObjectInputStream s = new ObjectInputStream(stream);
            this.tokenBytes = (byte[])s.readObject();
            this.dataBytes = (byte[])s.readObject();
            s.close();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "SecurityStringDataConverter", new Object[]{this.tokenBytes, this.dataBytes});
            }
        }

        SecurityStringDataConverter(IBMSecurityToken t) throws IOException, SoapSecurityException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "SecurityStringDataConverter", t);
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ObjectOutputStream s = new ObjectOutputStream(stream);
            this.tokenBytes = IBMSecurityManager.this.theConversation.getSCTokenBytes(t.getUUID());
            this.dataBytes = t.getSecurityHashMapData();
            s.writeObject(this.tokenBytes);
            s.writeObject(this.dataBytes);
            s.flush();
            s.close();
            this.tokenString = Base64.encode(stream.toByteArray());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "SecurityStringDataConverter", this.tokenString);
            }
        }
    }
}

