/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.policyset.PolicySetConfigurationWrapper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class WSRMOutHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(WSRMOutHandler.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");

    public Handler.InvocationResponse invoke(MessageContext msgContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", msgContext);
        }
        Object unreliableMsgProperty = msgContext.getLocalProperty("Sandesha2UnreliableMessage");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "MessageContext property SandeshaClientConstants.UNRELIABLE_MESSAGE " + unreliableMsgProperty);
        }
        boolean resultRMIsOn = false;
        if (unreliableMsgProperty == null || "false".equals(unreliableMsgProperty)) {
            if (this.wsPolicySetRMOff(msgContext)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "turning RM off for WS-policy-RM-disabled msg" + msgContext);
                }
                msgContext.setProperty("Sandesha2UnreliableMessage", "true");
            } else {
                resultRMIsOn = true;
            }
        } else if (this.wsPolicySetRMOn(msgContext)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "turning RM on for WS-policy-RM-enabled msg" + msgContext);
            }
            msgContext.setProperty("Sandesha2UnreliableMessage", "false");
            resultRMIsOn = true;
        }
        if (resultRMIsOn) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "RM is result enabled.  Turning on AutoStartNewSequence");
            }
            msgContext.setProperty("AutoStartNewSequence", "true");
            if ("Spec_2007_02".equals(msgContext.getParameter("Sandesha2RMSpecVersion"))) {
                int mep = msgContext.getAxisOperation().getAxisSpecificMEPConstant();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "MEP : " + mep);
                }
                if (14 == mep || 16 == mep || 17 == mep) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "turning on client side addressing to support possible makeConnection");
                    }
                    msgContext.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", Handler.InvocationResponse.CONTINUE);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private PolicySetConfigurationWrapper getPSetConfigurationIfUsingWSPolicy(MessageContext msgContext) {
        Object psc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPSetConfigurationIfUsingWSPolicy", msgContext);
        }
        PolicySetConfigurationWrapper returnValue = null;
        AxisOperation axisDescription = msgContext.getAxisOperation();
        Parameter param = axisDescription.getParameter("WASAxis2PolicySet");
        if (param != null && (psc = param.getValue()) != null && psc instanceof PolicySetConfigurationWrapper) {
            returnValue = (PolicySetConfigurationWrapper)psc;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPSetConfigurationIfUsingWSPolicy", returnValue);
        }
        return returnValue;
    }

    public boolean wsPolicySetRMOn(MessageContext msgContext) {
        PolicySetConfigurationWrapper result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "wsPolicySetRMOn", msgContext);
        }
        if ((result = this.getPSetConfigurationIfUsingWSPolicy(msgContext)) != null && result.getPolicyTypeConfiguration("Sandesha2RMSpecVersion") != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "wsPolicySetRMOn", true);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "wsPolicySetRMOn", false);
        }
        return false;
    }

    public boolean wsPolicySetRMOff(MessageContext msgContext) {
        PolicySetConfigurationWrapper result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "wsPolicySetRMOff", msgContext);
        }
        if ((result = this.getPSetConfigurationIfUsingWSPolicy(msgContext)) != null && result.getPolicyTypeConfiguration("Sandesha2RMSpecVersion") == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "wsPolicySetRMOff", true);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "wsPolicySetRMOff", false);
        }
        return false;
    }
}

