/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.ws.asynchbeans.AsynchBeansService;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.ExecutionContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.sandesha2.context.ContextManager;

public class WSRMContextManager
implements ContextManager {
    private static final TraceComponent tc = Tr.register(WSRMContextManager.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private AsynchBeansService service;
    private AsynchContextDescriptor descriptor;
    private Set excludes;
    private ClassLoader classLoader;

    public WSRMContextManager(ConfigurationContext context) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "WSRMContextManager", context);
            }
            try {
                this.service = (AsynchBeansService)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                            Tr.exit(tc, "run");
                        }
                        return WsServiceRegistry.getService(this, AsynchBeansService.class);
                    }
                });
                this.descriptor = this.service.createContextDescriptor(true, new String[0]);
                this.excludes = new HashSet();
                this.excludes.add("JTA");
                this.classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                            Tr.exit(tc, "run");
                        }
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class loader found", this.classLoader);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.<init>", "1:123:1.6");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Caught exception", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSRMContextManager");
        }
    }

    public Serializable storeContext() {
        byte[] result;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "storeContext");
            }
            result = null;
            if (this.service != null) {
                try {
                    ExecutionContext context = this.service.createExecutionContext(this.descriptor, this.excludes);
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(stream);
                    out.writeObject(context);
                    out.close();
                    result = stream.toByteArray();
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.storeContext", "1:157:1.6");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Caught exception", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeContext", result);
        }
        return result;
    }

    public Runnable wrapWithContext(final Runnable work, Serializable context) {
        Runnable result;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "wrapWithContext", context);
            }
            result = work;
            if (context != null) {
                try {
                    byte[] data = (byte[])context;
                    ByteArrayInputStream stream = new ByteArrayInputStream(data);
                    ObjectInputStream in = new ObjectInputStream(stream);
                    final ExecutionContext execCtx = (ExecutionContext)in.readObject();
                    final Work wrapper = new Work(){

                        public void release() {
                        }

                        public void run() {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.entry(tc, "run");
                                    }
                                    ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Class loader found " + oldClassloader + " replacing with " + WSRMContextManager.this.classLoader);
                                    }
                                    Thread.currentThread().setContextClassLoader(WSRMContextManager.this.classLoader);
                                    work.run();
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Replacing class loader " + oldClassloader);
                                    }
                                    Thread.currentThread().setContextClassLoader(oldClassloader);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                        Tr.exit(tc, "run");
                                    }
                                    return null;
                                }
                            });
                        }
                    };
                    result = new Runnable(){

                        public void run() {
                            block4: {
                                try {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Starting user code under saved context");
                                    }
                                    execCtx.go(null, WSRMContextManager.this.descriptor, wrapper);
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Finished user code under saved context");
                                    }
                                }
                                catch (Throwable e) {
                                    FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.wrapWithContext", "1:247:1.6");
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                                    Tr.debug(tc, "Caught exception from user code", e);
                                }
                            }
                        }
                    };
                }
                catch (Exception e) {
                    FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.context.WSRMContextManager.storeContext", "1:260:1.6");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Caught exception", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapWithContext");
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/context/WSRMContextManager.java, WAS.rm, WAS70.SERV1, cf070937.21 1.6");
        }
    }
}

