/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.websvcs.rm.WSRMMetadata;
import com.ibm.ws.websvcs.rm.WSRMMetadataMgr;
import com.ibm.ws.websvcs.rm.WSRMShutdownHook;
import com.ibm.ws.websvcs.rm.impl.spi.WSRMSequenceManagerImpl;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManager;
import com.ibm.ws.websvcs.rm.mbeans.exceptions.WSRMMBeanException;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import com.ibm.ws.wssecurity.sc.util.SecureConversation;
import com.ibm.ws.wssecurity.sc.util.SecureConversationHandle;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.wsdl.codegen.extension.ModulePolicyExtension;
import org.apache.axis2.wsdl.codegen.extension.PolicyExtension;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaModule;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.policy.builders.RMAssertionBuilder;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.PropertyManager;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;

public final class WSRMModule
implements Module,
ModulePolicyExtension {
    private static final TraceComponent tc = Tr.register(WSRMModule.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    public static final String WSRM_MODULE_KEY = "_WSRM_MODULE_";
    private static final String RETRANSMISSION_PROPERTY = "WSRMRetransmissionInterval";
    public static final String STRICTLY_ENFORCE_WSRM_MODULE_FLAG = "strictlyEnforceWSRM";
    public static final String STRICTLY_ENFORCE_WSRM_SERVER_FLAG = "com.ibm.ws.websvcs.rm.strictlyEnforceWSRM";
    private static final Set<String> mandatoryRMModules;
    private boolean _isInitialized = false;
    private volatile ConfigurationContext _configContext;
    private volatile AxisModule _axisModule;
    private volatile SandeshaModule _sandesha;
    private static boolean _cellNameSet;
    private static String _cellName;
    private static String _nodeName;
    private static String _clusterName;
    private static String _serverName;
    private String _sequenceKey;
    private boolean _shutDown = false;
    private ClassLoader _classLoader;
    private ServiceClient _serviceClient;

    public static void addRMMandatoryModule(String appName, String moduleName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addRMMandatoryModule", new Object[]{appName, moduleName});
        }
        mandatoryRMModules.add(appName + "#" + moduleName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addRMMandatoryModule");
        }
    }

    public static boolean isRunningInClientJVM() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunningInClientJVM");
        }
        Boolean returnValue = null;
        try {
            returnValue = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                        Tr.exit(tc, "run");
                    }
                    return AdminServiceFactory.getAdminService() == null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.WSRMModule.isRunningInClientJVM", "1:248:1.85");
            RuntimeException e2 = new RuntimeException(e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isRunningInClientJVM", e2);
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunningInClientJVM", returnValue);
        }
        return returnValue;
    }

    public static boolean isRunningOnZOs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunningOnZOs");
        }
        Boolean returnValue = null;
        try {
            returnValue = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                        Tr.exit(tc, "run");
                    }
                    return PlatformHelperFactory.getPlatformHelper().isZOS();
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.WSRMModule.isRunningOnZOs", "1:288:1.85");
            RuntimeException e2 = new RuntimeException(e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "isRunningOnZOs", e2);
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunningOnZOs", returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static boolean isStrictlyEnforceWSRMFlagSet(String appName, String moduleName) {
        Boolean returnValue;
        block19: {
            Session session;
            ConfigService configService;
            block18: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "isStrictlyEnforceWSRMFlagSet", new Object[]{appName, moduleName});
                }
                returnValue = false;
                configService = null;
                session = null;
                if (Boolean.valueOf(System.getProperty(STRICTLY_ENFORCE_WSRM_SERVER_FLAG)).booleanValue()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Strictly enforce WSRM set as a JVM property");
                    }
                    returnValue = true;
                    break block18;
                }
                if (returnValue.booleanValue() || appName == null || moduleName == null || !mandatoryRMModules.contains(appName + "#" + moduleName)) break block18;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Module is specifically WSRM mandatory behaviour");
                }
                returnValue = true;
            }
            try {
                if (session != null) {
                    configService.discard(session);
                }
                break block19;
            }
            catch (Throwable tt) {
                FFDCFilter.processException(tt, "com.ibm.ws.websvcs.rm.WSRMModule.isStrictlyEnforceWSRMFlagSet", "1:351:1.85", tt);
                Tr.warning(tc, "CWSKA0002", new Object[]{"1:352:1.85", null, tt});
            }
            break block19;
            catch (Throwable t) {
                block20: {
                    try {
                        FFDCFilter.processException(t, "com.ibm.ws.websvcs.rm.WSRMModule.isStrictlyEnforceWSRMFlagSet", "1:335:1.85", t);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "The annotation scanning policy could not be read from the server config due to the following error: \n" + t.toString());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (session != null) {
                                configService.discard(session);
                            }
                        }
                        catch (Throwable tt) {
                            FFDCFilter.processException(tt, "com.ibm.ws.websvcs.rm.WSRMModule.isStrictlyEnforceWSRMFlagSet", "1:351:1.85", tt);
                            Tr.warning(tc, "CWSKA0002", new Object[]{"1:352:1.85", null, tt});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (session != null) {
                        configService.discard(session);
                    }
                }
                catch (Throwable tt) {
                    FFDCFilter.processException(tt, "com.ibm.ws.websvcs.rm.WSRMModule.isStrictlyEnforceWSRMFlagSet", "1:351:1.85", tt);
                    Tr.warning(tc, "CWSKA0002", new Object[]{"1:352:1.85", null, tt});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isStrictlyEnforceWSRMFlagSet", returnValue);
        }
        return returnValue;
    }

    public static boolean isWSRMMandatory(String appName, String moduleName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isWSRMMandatory", new Object[]{appName, moduleName});
        }
        boolean returnValue = WSRMModule.isStrictlyEnforceWSRMFlagSet(appName, moduleName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isWSRMMandatory", new Boolean(returnValue));
        }
        return returnValue;
    }

    public WSRMModule() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSRMModule");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                RMAssertionBuilder builder = new RMAssertionBuilder();
                AssertionBuilderFactory.registerBuilder(builder.getKnownElements()[0], builder);
                WSRMModule.this._sandesha = new SandeshaModule();
                SandeshaMessageHelper.innit();
                if (WSRMModule.isRunningInClientJVM()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding shutdown hook for client JVM");
                    }
                    WSRMShutdownHook.addModuleToShutdownList(WSRMModule.this);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run", null);
                }
                return null;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSRMModule", this);
        }
    }

    public synchronized void assertInitialized() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "assertInitialized");
        }
        if (!this._isInitialized || this._shutDown) {
            IllegalStateException e = new IllegalStateException("The WSRM module has not been initialized yet");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "assertInitialized", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "assertInitialized");
        }
    }

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{configContext, module});
        }
        this._configContext = configContext;
        this._axisModule = module;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WSRM module awaiting service config callback for init");
        }
        Parameter param = new Parameter();
        param.setName(WSRM_MODULE_KEY);
        param.setValue(this);
        configContext.getAxisConfiguration().addParameter(param);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public synchronized void doInitialization(final boolean removeUnusuedStorageManagers) throws AxisFault {
        Object e;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doInitialization", removeUnusuedStorageManagers);
        }
        if (!this._isInitialized && (e = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block27: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    try {
                        WSRMModule.this.initSandeshaModule();
                        WSRMModule.this._isInitialized = true;
                        HashMap services = WSRMModule.this._configContext.getAxisConfiguration().getServices();
                        if (services != null) {
                            for (Object o : services.values()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "axis description " + o);
                                }
                                if (!(o instanceof AxisDescription)) continue;
                                AxisDescription axisDescription = (AxisDescription)o;
                                WSRMModule.this._sandesha.engageNotify(axisDescription);
                                WSRMModule.this.setResponseAck(axisDescription);
                            }
                        }
                        boolean managedQOS = RMServiceConfigPlugin.isManagedQOS(WSRMModule.this._configContext.getAxisConfiguration());
                        AxisConfiguration description = WSRMModule.this._configContext.getAxisConfiguration();
                        Parameter parameter = description.getParameter("Sandesha2StorageManager");
                        if (parameter != null) break block27;
                        if (managedQOS) {
                            if (WSRMModule.isRunningInClientJVM()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "run", "no init of storage manager as in client container");
                                }
                                throw new SandeshaStorageException(nls.getFormattedMessage("CANNOT_ALLOW_MANAGED_STORE_ERROR_CWSKA0101", null, null));
                            }
                            parameter = new Parameter("Sandesha2StorageManager", "persistent");
                        } else {
                            parameter = new Parameter("Sandesha2StorageManager", "inmemory");
                        }
                        description.addParameter(parameter);
                        if (managedQOS) {
                            PersistentStorageManager persistentStore = (PersistentStorageManager)SandeshaUtil.getSandeshaStorageManager(WSRMModule.this._configContext, description);
                            persistentStore.persistentStoreChosen(WSRMModule.this._classLoader);
                            if (removeUnusuedStorageManagers) {
                                Parameter storeParam;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Removing InMemory StorageManager");
                                }
                                if ((storeParam = WSRMModule.this._configContext.getAxisConfiguration().getParameter("inmemory")) != null) {
                                    StorageManager store = (StorageManager)storeParam.getValue();
                                    store.shutdown();
                                    WSRMModule.this._configContext.getAxisConfiguration().removeParameter(storeParam);
                                }
                            }
                        }
                        if (RMServiceConfigPlugin.isUnManagedQOS(WSRMModule.this._configContext.getAxisConfiguration()) || !managedQOS) {
                            StorageManager store;
                            Parameter storeParam;
                            if (removeUnusuedStorageManagers) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Removing Persistent StorageManager");
                                }
                                if ((storeParam = WSRMModule.this._configContext.getAxisConfiguration().getParameter("persistent")) != null) {
                                    store = (StorageManager)storeParam.getValue();
                                    store.shutdown();
                                    WSRMModule.this._configContext.getAxisConfiguration().removeParameter(storeParam);
                                }
                            }
                            if (!RMServiceConfigPlugin.isUnManagedQOS(WSRMModule.this._configContext.getAxisConfiguration()) && !managedQOS && removeUnusuedStorageManagers) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Removing InMemory StorageManager and storage manager key as no RM");
                                }
                                if ((storeParam = WSRMModule.this._configContext.getAxisConfiguration().getParameter("inmemory")) != null) {
                                    store = (StorageManager)storeParam.getValue();
                                    store.shutdown();
                                    WSRMModule.this._configContext.getAxisConfiguration().removeParameter(storeParam);
                                }
                                WSRMModule.this._configContext.getAxisConfiguration().removeParameter(parameter);
                                Parameter bean = WSRMModule.this._configContext.getAxisConfiguration().getParameter("Sandesha2PropertyBean");
                                if (bean != null) {
                                    WSRMModule.this._configContext.getAxisConfiguration().removeParameter(bean);
                                }
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Storage Manager already available " + parameter.getValue());
                        }
                        if (WSRMModule.getClusterName() == null) break block27;
                        StorageManager store = SandeshaUtil.getSandeshaStorageManager(WSRMModule.this._configContext, description);
                        if (store instanceof PersistentStorageManager) {
                            PersistentStorageManager persistentStore = (PersistentStorageManager)SandeshaUtil.getSandeshaStorageManager(WSRMModule.this._configContext, description);
                            WSRMModule.this._sequenceKey = persistentStore.getWorkKey() + "#" + WSRMModule.getNodeName() + "#" + WSRMModule.getServerName();
                            Parameter param = new Parameter("Sandesha2SequenceKey", WSRMModule.this._sequenceKey);
                            WSRMModule.this._configContext.getAxisConfiguration().addParameter(param);
                            break block27;
                        }
                        Tr.error(tc, "INVALID_POLICY_ERROR_CWSKA0356");
                        throw new IllegalStateException(nls.getFormattedMessage("INVALID_POLICY_ERROR_CWSKA0356", null, null));
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMModule.run", "1:656:1.85", this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "run", e);
                        }
                        return e;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "run", null);
                }
                return null;
            }
        })) != null) {
            if (e instanceof AxisFault) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "doInitialization", e);
                }
                throw (AxisFault)e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "doInitialization", new Object[]{e});
            }
            RuntimeException e2 = new RuntimeException();
            if (e instanceof Exception) {
                e2 = new RuntimeException((Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "doInitialization", new Object[]{e2});
            }
            throw e2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doInitialization");
        }
    }

    ConfigurationContext getConfigurationContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigurationContext");
            Tr.exit(tc, "getConfigurationContext", this._configContext);
        }
        return this._configContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown", configurationContext);
        }
        boolean processShutdown = true;
        WSRMModule wSRMModule = this;
        synchronized (wSRMModule) {
            if (this._shutDown || !this._isInitialized) {
                processShutdown = false;
            } else {
                this._shutDown = true;
            }
        }
        if (processShutdown) {
            long waitTime = 120000L;
            if (WSRMModule.isRunningInClientJVM()) {
                this.waitUntilSequenceCompleted(waitTime);
            }
            this._sandesha.shutdown(this._configContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    public void waitUntilSequenceCompleted(long waitTime) {
        block17: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "waitUntilSequenceCompleted");
            }
            StorageManager storageManager = null;
            RMSBean rmsBean2 = new RMSBean();
            try {
                storageManager = SandeshaUtil.getSandeshaStorageManager(this._configContext, this._configContext.getAxisConfiguration());
                Transaction tran = storageManager.getTransaction();
                WSRMSequenceManagerImpl wsrmSequenceManagerImpl = new WSRMSequenceManagerImpl();
                RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
                List rmsBeanList = rmsBeanMgr.find(rmsBean2);
                tran.commit();
                for (RMSBean rmsBean2 : rmsBeanList) {
                    boolean infiniteWait;
                    boolean bl = infiniteWait = waitTime == -1L;
                    if (!rmsBean2.isSequenceClosedClient() && !rmsBean2.isTerminateAdded()) {
                        waitTime = this.waitForAllMessagesToBeAcked(rmsBean2, waitTime);
                    }
                    if (!infiniteWait && waitTime <= 0L) {
                        Tr.warning(tc, "UNACKED_MESSAGES_CWSKA0751", new Object[]{rmsBean2.getSequenceID()});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence not complete as not all messages acked");
                        }
                        return;
                    }
                    long timeNow = System.currentTimeMillis();
                    this._serviceClient = this.buildServiceClientForSequence(storageManager, rmsBean2);
                    if (this._serviceClient != null) {
                        String endPointURL = rmsBean2.getInternalSequenceID();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Terminating sequence " + rmsBean2.getSequenceID());
                        }
                        wsrmSequenceManagerImpl.terminateSequence(this._serviceClient, endPointURL);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Null ServiceClient: cannot terminate sequence " + rmsBean2.getSequenceID());
                    }
                    long timeEnd = System.currentTimeMillis();
                    if (!infiniteWait) {
                        waitTime -= timeEnd - timeNow;
                    }
                    if (!infiniteWait && waitTime <= 0L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "waitUntilSequenceCompleted", "Sequence timed out terminating sequence");
                        }
                        return;
                    }
                    tran = storageManager.getTransaction();
                    storageManager.getRMSBeanMgr().delete(rmsBean2.getCreateSeqMsgID());
                    tran.commit();
                }
            }
            catch (SandeshaException e) {
                FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.WSRMModule.waitUntilSequenceCompleted", "1:827:1.85");
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "waitUntilSequenceCompleted Exception", e.getStackTrace());
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMModule.waitUntilSequenceCompleted", "1:837:1.85", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block17;
                Tr.exit(tc, "waitUntilSequenceCompleted Exception", e.getStackTrace());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitUntilSequenceCompleted");
        }
    }

    public long waitForAllMessagesToBeAcked(RMSBean rmsBean, long waitTime) {
        boolean infinite;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForAllMessagesToBeAcked", new Object[]{rmsBean, waitTime});
        }
        long highestOutMsgKey = rmsBean.getHighestOutMessageNumber();
        long timeAtStart = System.currentTimeMillis();
        boolean bl = infinite = waitTime == -1L;
        if (highestOutMsgKey > 0L) {
            long timeNow = System.currentTimeMillis();
            long timeToComplete = timeNow + waitTime;
            boolean complete = false;
            while (!complete && (timeNow < timeToComplete || infinite)) {
                timeNow = System.currentTimeMillis();
                try {
                    RangeString rangeString = rmsBean.getClientCompletedMessages();
                    if (rangeString.isMessageNumberInRanges(highestOutMsgKey) && rangeString.getRanges().length == 1) {
                        complete = true;
                        continue;
                    }
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Caught an exception " + e);
                }
            }
        }
        long timeAtEnd = System.currentTimeMillis();
        if (!infinite) {
            waitTime -= timeAtEnd - timeAtStart;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForAllMessagesToBeAcked", waitTime);
        }
        return waitTime;
    }

    private ServiceClient buildServiceClientForSequence(StorageManager storageManager, RMSBean rmsBean) throws WSRMMBeanException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "buildServiceClientForSequence", new Object[]{storageManager, rmsBean});
        }
        ServiceClient client = null;
        AxisService axisServiceToUse = null;
        ConfigurationContext configContext = storageManager.getContext();
        try {
            String wsrm_nspc;
            HashMap services = configContext.getAxisConfiguration().getServices();
            Iterator servicesIterator = services.keySet().iterator();
            String toUrlFromBean = null;
            EndpointReference toEpr = rmsBean.getToEndpointReference();
            if (toEpr != null) {
                toUrlFromBean = toEpr.getAddress();
                if (toUrlFromBean == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "buildServiceClientForSequence", "Return null.  RMSBean.getToEndpointReference().getAddress() is null.");
                    }
                    return null;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "buildServiceClientForSequence", "Return null.  RMSBean.getToEndpointReference() is null.");
                }
                return null;
            }
            boolean serviceMatch = false;
            while (servicesIterator.hasNext()) {
                AxisService axisServiceFromMap = (AxisService)services.get(servicesIterator.next());
                Parameter parameter = axisServiceFromMap.getParameter("com.ibm.ws.websvcs.CLIENT_URL_SET");
                Set urlSet = (Set)parameter.getValue();
                for (String urlFromAxisServiceSet : urlSet) {
                    if (!toUrlFromBean.equals(urlFromAxisServiceSet)) continue;
                    if (!serviceMatch) {
                        axisServiceToUse = axisServiceFromMap;
                        serviceMatch = true;
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "buildServiceClientForSequence", "Return null.  RM cannot create a ServiceClient as more than one AxisService objects mapped to destination URL : " + toUrlFromBean);
                    }
                    return null;
                }
            }
            if (!serviceMatch) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "buildServiceClientForSequence", "Return null.  RM cannot create a ServiceClient as no AxisService objects contain URL : " + toUrlFromBean);
                }
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Building ServiceClient with AxisService : " + axisServiceToUse);
            }
            ClientConfigurationFactory.newInstance().completeAxis2Configuration(axisServiceToUse);
            client = new ServiceClient(configContext, null);
            client.setAxisService(axisServiceToUse);
            Options options = client.getOptions();
            options.setTo(new EndpointReference(toEpr.toString()));
            options.setReplyTo(new EndpointReference(rmsBean.getReplyToEndpointReference().toString()));
            String internalSequenceID = null;
            internalSequenceID = rmsBean.getInternalSequenceID();
            String sequenceKey = SandeshaUtil.getSequenceKeyFromInternalSequenceID(internalSequenceID, rmsBean.getToEndpointReference().toString());
            options.setProperty("Sandesha2SequenceKey", sequenceKey);
            options.setProperty("Sandesha2InternalSequenceId", internalSequenceID);
            String spec_version = wsrm_nspc = rmsBean.getRMVersion();
            options.setProperty("Sandesha2RMSpecVersion", spec_version);
            options.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMModule.buildServiceClientForSequence", "1:1008:1.85", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "buildServiceClientForSequence", e);
            }
            throw new WSRMMBeanException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "buildServiceClientForSequence", client);
        }
        return client;
    }

    public PolicyExtension getPolicyExtension() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyExtension");
        }
        this.assertInitialized();
        PolicyExtension returnValue = this._sandesha.getPolicyExtension();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyExtension", returnValue);
        }
        return returnValue;
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "engageNotify", new Object[]{axisDescription, this});
        }
        if (axisDescription instanceof AxisService) {
            this._classLoader = ((AxisService)axisDescription).getClassLoader();
        }
        if (!this._isInitialized) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ignoring engage notify since not initialized");
            }
        } else {
            this._sandesha.engageNotify(axisDescription);
            this.setResponseAck(axisDescription);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "engageNotify");
        }
    }

    public void applyPolicy(Policy arg0, AxisDescription arg1) {
    }

    public boolean canSupportAssertion(Assertion arg0) {
        return false;
    }

    public static boolean isWSRMEnabledForService(AxisService service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isWSRMEnabledForService", service);
        }
        boolean returnValue = true;
        Parameter rmEnabled = service.getParameter("Sandesha2UnreliableMessage");
        if (rmEnabled != null && rmEnabled.getValue().equals("true")) {
            returnValue = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isWSRMEnabledForService", returnValue);
        }
        return returnValue;
    }

    private static Server getServerObject() {
        Server server;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getServerObject");
            }
            server = null;
            try {
                final Class<Server> serviceClassF = Server.class;
                server = (Server)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                            Tr.exit(tc, "run");
                        }
                        return WsServiceRegistry.getService(this, serviceClassF);
                    }
                });
            }
            catch (Exception e) {
                if (!WSRMModule.isRunningInClientJVM()) {
                    FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.WSRMModule.getServerObject", "1:1122:1.85");
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "error looking up server ", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerObject", server);
        }
        return server;
    }

    public static synchronized String getCellName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getCellName");
        }
        if (!_cellNameSet) {
            _cellNameSet = true;
            Server server = WSRMModule.getServerObject();
            if (server != null) {
                _cellName = server.getCellName();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellName", _cellName);
        }
        return _cellName;
    }

    public static synchronized String getClusterName() {
        Server server;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterName");
        }
        if (_clusterName == null && (server = WSRMModule.getServerObject()) != null) {
            _clusterName = server.getClusterName();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterName", _clusterName);
        }
        return _clusterName;
    }

    public static synchronized String getNodeName() {
        Server server;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNodeName");
        }
        if (_nodeName == null && (server = WSRMModule.getServerObject()) != null) {
            _nodeName = server.getNodeName();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeName", _nodeName);
        }
        return _nodeName;
    }

    public static String getServerName() {
        Server server;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerName");
        }
        if (_serverName == null && (server = WSRMModule.getServerObject()) != null) {
            _serverName = server.getName();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerName", _serverName);
        }
        return _serverName;
    }

    public static String getApplicationName(ConfigurationContext configContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationName", configContext);
        }
        String applicationName = null;
        Parameter temp = configContext.getAxisConfiguration().getParameter("ApplicationName");
        if (temp != null) {
            WSRMMetadata metadata;
            applicationName = (String)temp.getValue();
            if (applicationName == null && (metadata = WSRMMetadataMgr.getMetadata()) != null) {
                applicationName = metadata.getApplicationName();
                temp.setValue(applicationName);
            }
        } else {
            applicationName = "UNKNOWN_APPLICATION";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationName", applicationName);
        }
        return applicationName;
    }

    public static String getApplicationModuleName(ConfigurationContext configContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationModuleName", configContext);
        }
        String applicationModuleName = null;
        Parameter temp = configContext.getAxisConfiguration().getParameter("ModuleName");
        if (temp != null) {
            WSRMMetadata metadata;
            applicationModuleName = (String)temp.getValue();
            if (applicationModuleName == null && (metadata = WSRMMetadataMgr.getMetadata()) != null) {
                applicationModuleName = metadata.getModuleName();
                temp.setValue(applicationModuleName);
            }
        } else {
            applicationModuleName = "UNKNOWN_APPLICATION_MODULE";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationModuleName", applicationModuleName);
        }
        return applicationModuleName;
    }

    private void initSandeshaModule() throws AxisFault {
        String value;
        Parameter propertiesFromRefReqMsg;
        String value2;
        block26: {
            Parameter parameter;
            SandeshaPolicyBean propertyBean;
            AxisConfiguration config2;
            block25: {
                block24: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "initSandeshaModule");
                    }
                    EndpointReference.addAnonymousEquivalentURI("http://docs.oasis-open.org/ws-rx/wsmc/200702/anonymous?id=");
                    config2 = this._configContext.getAxisConfiguration();
                    SandeshaPolicyBean constantPropertyBean = new SandeshaPolicyBean();
                    propertyBean = PropertyManager.loadPropertiesFromModuleDescPolicy(this._axisModule, constantPropertyBean);
                    if (propertyBean == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading properties from default values");
                        }
                        propertyBean = new SandeshaPolicyBean();
                    }
                    parameter = new Parameter();
                    parameter.setName("Sandesha2PropertyBean");
                    parameter.setValue(propertyBean);
                    config2.addParameter(parameter);
                    boolean inOrder = RMServiceConfigPlugin.isInorder(this._configContext.getAxisConfiguration());
                    propertyBean.setInOrder(inOrder);
                    if (WSRMModule.isWSRMMandatory(WSRMModule.getApplicationName(this._configContext), WSRMModule.getApplicationModuleName(this._configContext))) {
                        propertyBean.setEnforceRM(true);
                    } else {
                        propertyBean.setEnforceRM(false);
                    }
                    String property = System.getProperty(RETRANSMISSION_PROPERTY);
                    if (property != null) {
                        try {
                            Long longObj = Long.valueOf(property);
                            long longValue = longObj;
                            longValue *= 1000L;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "read JVM property WSRMRetransmissionInterval=" + longValue);
                            }
                            propertyBean.setRetransmissionInterval(longValue);
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMModule.initSandeshaModule", "1:1349:1.85", this);
                        }
                    }
                    boolean useMakeConnection = RMServiceConfigPlugin.isUseMakeConnection(this._configContext.getAxisConfiguration());
                    propertyBean.setEnableMakeConnection(useMakeConnection);
                    propertyBean.setEnableRMAnonURI(true);
                    parameter = new Parameter("Sandesha2ModuleClassLoader", this._axisModule.getModuleClassLoader());
                    config2.addParameter(parameter);
                    SandeshaUtil.setAxisModule(this._axisModule);
                    parameter = config2.getParameter("inmemory");
                    if (parameter != null) {
                        config2.removeParameter(parameter);
                    }
                    if ((parameter = config2.getParameter("persistent")) != null) {
                        config2.removeParameter(parameter);
                    }
                    try {
                        StorageManager inMemorytorageManager = SandeshaUtil.getInMemoryStorageManager(this._configContext);
                        inMemorytorageManager.initStorage(this._axisModule);
                    }
                    catch (SandeshaStorageException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMModule.initSandeshaModule", "1:1382:1.85", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block24;
                        Tr.debug(tc, "Exception", e);
                    }
                }
                if (WSRMModule.isRunningInClientJVM()) {
                    propertyBean.setPermanentStorageManagerClass("com.ibm.ws.websvcs.rm.impl.storage.InMemoryStorageManager");
                }
                try {
                    StorageManager permanentStorageManager = SandeshaUtil.getPermanentStorageManager(this._configContext);
                    permanentStorageManager.initStorage(this._axisModule);
                }
                catch (SandeshaStorageException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMModule.initSandeshaModule", "1:1401:1.85", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                    Tr.debug(tc, "Exception", e);
                }
            }
            parameter = config2.getParameter("Sandesha2SecurityManager");
            if (parameter != null) {
                config2.removeParameter(parameter);
            }
            SecurityManager util2 = SandeshaUtil.getSecurityManager(this._configContext);
            util2.initSecurity(this._axisModule);
            this._configContext.setProperty("UseAsyncOperations", Boolean.TRUE);
            this._configContext.getAxisConfiguration().addTargetResolver(new TargetResolver(){

                public void resolveTarget(MessageContext messageContext) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "resolveTarget", messageContext);
                    }
                    if (SandeshaUtil.isMessageUnreliable(messageContext)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unsetting USE_ASYNC_OPERATIONS for unreliable message");
                        }
                        messageContext.setProperty("UseAsyncOperations", Boolean.FALSE);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "resolveTarget");
                    }
                }
            });
            try {
                long secureConTimeout;
                SecureConversation theHandle = SecureConversationHandle.getInstance();
                if (theHandle != null && (secureConTimeout = theHandle.getSCTokenTimeOut(this._configContext)) > 0L) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Updating inactivity timeout to " + secureConTimeout);
                    }
                    propertyBean.setInactiveTimeoutInterval(secureConTimeout / 1000L, "seconds");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMModule.initSandeshaModule", "1:1453:1.85", this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block26;
                Tr.debug(tc, "Unable to update the SCT token timeout");
            }
        }
        Parameter propertiesFromRefMsg = this._axisModule.getParameter("propertiesToCopyFromReferenceMessage");
        if (propertiesFromRefMsg != null && (value2 = (String)propertiesFromRefMsg.getValue()) != null) {
            value2 = value2.trim();
            String[] propertyNames = value2.split(",");
            Parameter param = new Parameter();
            param.setName("propertiesToCopyFromReferenceMessageAsStringArray");
            param.setValue(propertyNames);
            this._axisModule.addParameter(param);
        }
        if ((propertiesFromRefReqMsg = this._axisModule.getParameter("propertiesToCopyFromReferenceRequestMessage")) != null && (value = (String)propertiesFromRefReqMsg.getValue()) != null) {
            value = value.trim();
            String[] propertyNames = value.split(",");
            Parameter param = new Parameter();
            param.setName("propertiesToCopyFromReferenceRequestMessageAsStringArray");
            param.setValue(propertyNames);
            this._axisModule.addParameter(param);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initSandeshaModule");
        }
    }

    private void setResponseAck(AxisDescription desc) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setResponseAck", desc);
        }
        if (desc instanceof AxisService) {
            AxisService service = (AxisService)desc;
            if (WSRMModule.isWSRMEnabledForService(service)) {
                desc.addParameter(new Parameter("DisableResponseAck", Boolean.TRUE));
            } else {
                desc.addParameter(new Parameter("DisableResponseAck", Boolean.FALSE));
            }
        } else {
            Parameter p = new Parameter("DisableResponseAck", null);
            desc.removeParameter(p);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setResponseAck");
        }
    }

    public String getSequenceKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceKey");
            Tr.exit(tc, "getSequenceKey", this._sequenceKey);
        }
        return this._sequenceKey;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/WSRMModule.java, WAS.rm, WAS70.SERV1, cf070937.21 1.85");
        }
        mandatoryRMModules = new HashSet<String>();
        _cellNameSet = false;
    }
}

