/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.wsspi.pmi.reqmetrics.PmiRmArmComponentCallback;
import com.ibm.wsspi.pmi.reqmetrics.PmiRmArmTransactionCallback;
import java.util.Properties;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public abstract class ReqMetricsHandlerBase
extends AbstractHandler
implements Handler {
    private static final TraceComponent tc = Tr.register(ReqMetricsHandlerBase.class.getName(), "pmi.rm", "com.ibm.ws.websvcs.pmi.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsHandlerBase";
    private static final String FFDC_ID_1 = "FFDC-1";
    protected static final String REQMETRICS_NS_URI = "http://websphere.ibm.com";
    protected static final String REQMETRICS_PREFIX = "reqmetrics";
    protected static final String REQMETRICS_ELEMENT = "arm_correlator";
    protected static final String REQMETRICS_ELEMENT_OLDNAME = "correlator";
    protected static final String REQMETRICS_ATTRIBUTE_ARM = "arm_correlator";
    protected static final String REQMETRICS_ATTRIBUTE_RM = "rm_correlator";
    protected static final String WS_PORT_NM = "WS_PORT_NM";
    protected static final String WS_OP_NM = "WS_OP_NM";
    protected static final String WS_TRAN_NM = "WS_TRAN_NM";
    protected static final String WS_TGT_NS = "WS_TGT_NS";
    protected static final String WS_IN_MSG_NM = "WS_IN_MSG_NM";
    protected static final String WS_TGT_ENDPOINT_ADR = "WS_TGT_E_ADR";
    protected static final String WS_PRM_Q_NM_LST = "WS_PRM_Q_NM_LST";
    protected static final String WS_SVC_REF_NM = "WS_SVC_REF_NM";
    protected static final String WS_RESP_MSG = "WS_RESP_MSG";
    protected static final String WS_WSDL_LOC = "WS_WSDL_LOC";
    protected static final String WS_SOAP_BD = "WS_SOAP_BD";
    public static final String REQMETRICS_ACTOR_URI = "reqmetricsURI";
    protected PmiReqMetricsImpl impl = PmiReqMetricsImpl.getInstance();

    protected ReqMetricsHandlerBase() {
    }

    protected Properties getContextInfo(PmiRmThreadCtx threadCtx, MessageContext msgCtx) {
        boolean trDebugEnabled = tc.isDebugEnabled();
        if (trDebugEnabled) {
            Tr.debug(tc, "getContextInfo");
        }
        try {
            byte[] armCorBytes;
            PmiRmArmComponentCallback armCompCallback;
            int contextLevel = this.impl.getTranDetailLevel((Object)threadCtx, 4);
            boolean showPrivateContent = false;
            boolean showSecureContent = false;
            ReqMetricsHandlerBase reqMetricsHandlerBase = this;
            PmiRmArmTransactionCallback armTxCallback = reqMetricsHandlerBase.impl.getArmCallback();
            if (armTxCallback != null && (armCompCallback = armTxCallback.getComponentCallback(armCorBytes = PmiRmArmWrapper.getArmCorrelator((PmiRmThreadCtx)threadCtx))) != null) {
                showPrivateContent = armCompCallback.showPrivateContent(3);
                showSecureContent = armCompCallback.showSecureContent(3);
            }
            if (trDebugEnabled) {
                Tr.debug(tc, "getContextInfo, contextLevel=" + contextLevel + ", showPrivateContent=" + showPrivateContent + ", showSecurecontent=" + showSecureContent);
            }
            if (contextLevel <= 1) {
                return null;
            }
            Properties props = this.getMetricsData(msgCtx, contextLevel, showPrivateContent && showSecureContent);
            if (trDebugEnabled) {
                Tr.debug(tc, "getContextInfo: props=" + props.toString());
            }
            return props;
        }
        catch (Exception ex) {
            FFDCFilter.processException(ex, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsHandlerBase.getContextInfo", FFDC_ID_1);
            Tr.warning(tc, "PMRM0108E", ex.toString());
            return null;
        }
    }

    protected boolean isTraceEnabled(byte[] armCorBytes) {
        boolean trDebugEnabled = tc.isDebugEnabled();
        if (!this.impl.isARMEnabled()) {
            return false;
        }
        if (armCorBytes == null) {
            if (trDebugEnabled) {
                Tr.debug(tc, "null ARM correlator bytes passed to isTraceEnabled, returns true in this case");
            }
            return true;
        }
        ReqMetricsHandlerBase reqMetricsHandlerBase = this;
        PmiRmArmTransactionCallback armTxCallback = reqMetricsHandlerBase.impl.getArmCallback();
        boolean needTransactionTrace = true;
        if (armTxCallback != null) {
            PmiRmArmComponentCallback armCompCallback = armTxCallback.getComponentCallback(armCorBytes);
            if (armCompCallback != null) {
                needTransactionTrace = armCompCallback.isTraceEnabled(3);
            }
        } else if (trDebugEnabled) {
            Tr.debug(tc, "isTraceEnabled: no PmiRmArmTransactionCallback is registered with request metrics");
        }
        if (trDebugEnabled) {
            Tr.debug(tc, "isTraceEnabled returns " + needTransactionTrace);
        }
        return needTransactionTrace;
    }

    protected abstract Properties getMetricsData(MessageContext var1, int var2, boolean var3);
}

