/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.pmi.modules.ModulePmiModule;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.pmi.PMIGlobalHandler;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;

public class PMITransportConsumerHandler
extends PMIGlobalHandler {
    private static final TraceComponent _tc = Tr.register(PMITransportConsumerHandler.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private boolean init = false;
    private WASAxis2Service service = null;

    private synchronized void initialize() throws Exception {
        if (this.init) {
            return;
        }
        this.init = true;
        try {
            this.service = (WASAxis2Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WsServiceRegistry.getService(this, WASAxis2Service.class);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public PMITransportConsumerHandler() {
        this.inboundHandler = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handler.InvocationResponse invoke(MessageContext context) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke");
        }
        try {
            block9: {
                try {
                    AxisService axisService;
                    this.initialize();
                    if (!context.isServerSide() || (axisService = context.getAxisService()) == null) break block9;
                    ServerModuleMetaData smmd = (ServerModuleMetaData)this.service.getModuleMetaData();
                    String portCompName = Axis2Utils.getPortComponentName(axisService);
                    if (smmd != null && portCompName != null) {
                        ModulePmiModule pmiModule = smmd.getPmiModule();
                        if (pmiModule != null) {
                            MessagePMIContext pmiContext = new MessagePMIContext(pmiModule, context);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Initializing PMI recording media for service: " + portCompName);
                            }
                            pmiContext.onServerReceiveRequest(context);
                            context.setProperty(MessagePMIContext.propertyName, pmiContext);
                        }
                        break block9;
                    }
                    if (!_tc.isDebugEnabled()) break block9;
                    if (smmd == null) {
                        Tr.debug(_tc, "Server Module Metadata was null.");
                    }
                    if (portCompName != null) break block9;
                    Tr.debug(_tc, "Port Component Name was null.");
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.pmi.PMITransportConsumerHandler.invoke", "115", this);
                    Object[] inserts = new Object[]{e};
                    String msg = NLSProvider.getNLS().getFormattedMessage("pmiHandlerFail00", inserts, "Error occurred while attempting to invoke the PMI Handler: {0}");
                    Tr.error(_tc, "pmiHandlerFail00", inserts);
                    throw new AxisFault(msg, e);
                }
            }
            Object var8_10 = null;
            if (!_tc.isEntryEnabled()) return Handler.InvocationResponse.CONTINUE;
            Tr.exit(_tc, "invoke");
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "invoke");
            throw throwable;
        }
    }
}

