/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiCollaboratorFactory;
import com.ibm.ws.webservices.pmi.modules.EndpointPmiModule;
import com.ibm.ws.webservices.pmi.modules.ModulePmiModule;
import com.ibm.ws.webservices.pmi.modules.ServicePmiModule;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.io.IOException;
import java.util.HashSet;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOnlyAxisOperation;

public class MessagePMIContext {
    private static final TraceComponent _tc = Tr.register(MessagePMIContext.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String propertyName = MessagePMIContext.class.getName();
    private final ModulePmiModule pmiModule;
    private final ServicePmiModule pmiService;
    private final EndpointPmiModule pmiEndpoint;
    private final String serviceName;
    private final String portName;
    private long receivedRequestTime = 0L;
    private long sentRequestTime = 0L;
    private long receivedReplyTime = 0L;
    private long sentReplyTime = 0L;
    private long requestPayloadSize = 0L;
    private long responsePayloadSize = 0L;
    private final long STATE_RECEIVE_REQUEST = 0L;
    private final long STATE_SEND_REQUEST = 1L;
    private final long STATE_RECEIVE_REPLY = 2L;
    private final long STATE_SEND_REPLY = 3L;
    private final long STATE_DONE = 4L;
    private final long NO_TIME = -1L;
    private HashSet enabledServiceCounters;
    private HashSet enabledEndpointCounters;
    private long next_state = 0L;

    public MessagePMIContext(ModulePmiModule mod, MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "MessagePMIContext.MessagePMIContext()...");
        }
        this.pmiModule = mod;
        AxisService service = msgContext.getAxisService();
        this.serviceName = Axis2Utils.getServiceQName(service).toString();
        this.portName = Axis2Utils.getPortName(service);
        this.pmiService = this.pmiModule.getService(this.serviceName);
        this.pmiEndpoint = this.pmiService.getEndpoint(this.portName);
        this.enabledServiceCounters = this.getEnabledServicePMI(service);
        this.enabledEndpointCounters = this.getEnabledEndpointPMI(service);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...MessagePMIContext.MessagePMIContext()", "service: " + this.serviceName + ", port: " + this.portName);
        }
    }

    public void onServerReceiveRequest(MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "MessagePMIContext.onServerReceiveRequest()...");
        }
        if (this.isAnyCountersEnabled()) {
            this.receivedRequestTime = System.currentTimeMillis();
            if (this.isServiceCounterEnabled(19) || this.isServiceCounterEnabled(18) || this.isEndpointCounterEnabled(36)) {
                this.requestPayloadSize = this.getRequestLength(msgContext);
            }
            this.pmiService.incRequestReceived(this.receivedRequestTime);
            this.pmiService.addRequestSize(this.receivedRequestTime, this.requestPayloadSize);
            this.pmiEndpoint.incReceived(this.receivedRequestTime);
            this.pmiEndpoint.addRequestSize(this.receivedRequestTime, this.requestPayloadSize);
        }
        this.next_state = 1L;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...MessagePMIContext.onServerReceiveRequest()");
        }
    }

    public void onServerForwardRequestToPort(MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "MessagePMIContext.onServerForwardRequestToPort()...");
        }
        if (this.isAnyCountersEnabled()) {
            this.sentRequestTime = System.currentTimeMillis();
            this.pmiService.addRequestResponseTime(this.sentRequestTime, this.sentRequestTime - this.receivedRequestTime);
            this.pmiService.incRequestDispatched(this.sentRequestTime);
            if (this.isOneway(msgContext)) {
                this.pmiService.incRequestSuccessful(this.sentRequestTime, true);
                this.pmiService.addTotalSize(this.sentRequestTime, this.requestPayloadSize);
                this.pmiEndpoint.incReceived(this.sentRequestTime, true);
            }
        }
        this.next_state = 2L;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...MessagePMIContext.onServerForwardRequestToPort()");
        }
    }

    public void onServerReceiveReplyFromPort(MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "MessagePMIContext.onServerReceiveReplyFromPort()...");
        }
        if (this.isAnyCountersEnabled()) {
            this.receivedReplyTime = System.currentTimeMillis();
            this.pmiService.addDispatchResponseTime(this.receivedReplyTime, this.receivedReplyTime - this.sentRequestTime);
        }
        this.next_state = 3L;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...MessagePMIContext.onServerReceiveReplyFromPort()");
        }
    }

    public void onServerReturnReply(MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "MessagePMIContext.onServerReturnReply()...");
        }
        if (this.isAnyCountersEnabled()) {
            this.sentReplyTime = System.currentTimeMillis();
            if (this.isServiceCounterEnabled(20) || this.isServiceCounterEnabled(18) || this.isEndpointCounterEnabled(39)) {
                this.responsePayloadSize = this.getResponseLength(msgContext);
            }
            this.pmiService.addResponseTime(this.sentReplyTime, this.sentReplyTime - this.receivedRequestTime);
            this.pmiService.addReplyResponseTime(this.sentReplyTime, this.sentReplyTime - this.receivedReplyTime);
            this.pmiService.incRequestSuccessful(this.sentReplyTime, !msgContext.isProcessingFault());
            this.pmiService.addTotalSize(this.sentReplyTime, this.requestPayloadSize + this.responsePayloadSize);
            this.pmiEndpoint.addResponseTime(this.sentReplyTime, this.sentReplyTime - this.receivedRequestTime);
            this.pmiEndpoint.incReceived(this.sentReplyTime, !msgContext.isProcessingFault());
            msgContext.setProperty("com.ibm.ws.websvcs.MESSAGE_PMI_CONTEXT", this);
        }
        this.next_state = 4L;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...MessagePMIContext.onServerReturnReply()");
        }
    }

    public void setResponseSize(long responsePayloadSize) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setResponseSize, size= " + responsePayloadSize);
        }
        this.responsePayloadSize = responsePayloadSize;
        if (this.pmiService != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting response size on PMI service");
            }
            this.pmiService.addReplySize(this.sentReplyTime, this.responsePayloadSize);
        }
        if (this.pmiEndpoint != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting response size on PMI endpoint");
            }
            this.pmiEndpoint.addResponseSize(this.sentReplyTime, this.responsePayloadSize);
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setResponseSize, size= " + responsePayloadSize);
        }
    }

    private long getRequestLength(MessageContext msgContext) {
        long reqLength = -1L;
        if (msgContext == null || msgContext.getEnvelope() == null) {
            Tr.error(_tc, "soapEnvelopeReqNull");
            return reqLength;
        }
        try {
            reqLength = msgContext.getInboundContentLength();
        }
        catch (IOException ioe) {
            Tr.error(_tc, "contentLengthFail00");
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.websvcs.pmi.MessagePMIContext", "266", this);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Length of inbound request= " + reqLength);
        }
        return reqLength;
    }

    private long getResponseLength(MessageContext msgContext) {
        if (msgContext == null || msgContext.getEnvelope() == null) {
            Tr.error(_tc, "soapEnvelopeResNull");
            return -1L;
        }
        return 0L;
    }

    private boolean isOneway(MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "MessagePMIContext.isOneway()...");
        }
        boolean oneway = false;
        if (msgContext == null) {
            return oneway;
        }
        String mep = msgContext.getAxisOperation().getMessageExchangePattern();
        oneway = mep.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/robust-in-only") || mep.equals("http://www.w3.org/2004/08/wsdl/in-only");
        oneway |= msgContext.getAxisOperation() instanceof InOnlyAxisOperation;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...MessagePMIContext.isOneway()", oneway);
        }
        return oneway;
    }

    private HashSet getEnabledServicePMI(AxisService as) {
        StatDescriptor sd;
        int[] result = new int[]{};
        String app = Axis2Utils.getApplicationName(as.getAxisConfiguration());
        String module = Axis2Utils.getModuleName(as.getAxisConfiguration());
        String service = Axis2Utils.getServiceQName(as).toString();
        PmiCollaborator impl = PmiCollaboratorFactory.getPmiCollaborator();
        StatLevelSpec[] spec = impl.getInstrumentationLevel(sd = new StatDescriptor(new String[]{"pmiWebServiceModule", app + "." + module, "pmiWebServiceService", service}), new Boolean(true));
        if (spec != null && spec.length > 0) {
            result = spec[0].getEnabled();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "MessagePMIContext.getEnabledServicePMI: " + result);
        }
        return this.convertToSet(result);
    }

    private HashSet getEnabledEndpointPMI(AxisService as) {
        StatDescriptor sd;
        int[] result = new int[]{};
        String app = Axis2Utils.getApplicationName(as.getAxisConfiguration());
        String module = Axis2Utils.getModuleName(as.getAxisConfiguration());
        String service = Axis2Utils.getServiceQName(as).toString();
        String port = Axis2Utils.getPortName(as);
        PmiCollaborator impl = PmiCollaboratorFactory.getPmiCollaborator();
        StatLevelSpec[] spec = impl.getInstrumentationLevel(sd = new StatDescriptor(new String[]{"pmiWebServiceModule", app + "." + module, "pmiWebServiceService", service, "pmiWebServiceEndpoint", port}), new Boolean(true));
        if (spec != null && spec.length > 0) {
            result = spec[0].getEnabled();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "MessagePMIContext.getEnabledEndpointPMI: " + result);
        }
        return this.convertToSet(result);
    }

    private HashSet convertToSet(int[] values) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                result.add(new Integer(values[i]));
            }
        }
        return result;
    }

    private boolean isServiceCounterEnabled(int counter) {
        return this.enabledServiceCounters.contains(new Integer(counter));
    }

    private boolean isEndpointCounterEnabled(int counter) {
        return this.enabledEndpointCounters.contains(new Integer(counter));
    }

    private boolean isAnyCountersEnabled() {
        return this.enabledEndpointCounters.size() + this.enabledServiceCounters.size() != 0;
    }
}

