/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.metadata.WASAxis2MetaDataImpl;
import java.util.HashMap;
import java.util.Map;

public class WSApplicationMetaDataHolder {
    private static final TraceComponent _tc = Tr.register(WASAxis2MetaDataImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Map<String, ServerModuleMetaData> smmdMap = new HashMap<String, ServerModuleMetaData>();
    private Map<String, String> routerModuleToEJBJarMap = new HashMap<String, String>();

    public void addServerModuleMetaData(ServerModuleMetaData smmd) {
        this.smmdMap.put(smmd.getModuleKeyName(), smmd);
    }

    public ServerModuleMetaData getAndRemoveServerModuleMetaData(String moduleName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAndRemoveServerModuleMetaData= " + moduleName);
        }
        ServerModuleMetaData smmd = this.smmdMap.remove(moduleName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAndRemoveServerModuleMetaData= " + moduleName);
        }
        return smmd;
    }

    public ServerModuleMetaData getServerModuleMetaData(String moduleName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServerModuleMetaData= " + moduleName);
        }
        ServerModuleMetaData smmd = this.smmdMap.get(moduleName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServerModuleMetaData= " + moduleName);
        }
        return smmd;
    }

    public void addRouterModuleToEJBJarMapping(String routerModuleName, String ejbJarName) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Mapping router module: " + routerModuleName + " to EJBJar " + "module: " + ejbJarName);
        }
        this.routerModuleToEJBJarMap.put(routerModuleName, ejbJarName);
    }

    public String getAndRemoveEJBJarNameFromRouterModule(String routerModuleName) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getAndRemoveEJBJarNameFromRouterModule= " + routerModuleName);
        }
        String ejbJarName = this.routerModuleToEJBJarMap.remove(routerModuleName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getAndRemoveEJBJarNameFromRouterModule= " + routerModuleName + " " + "ejbJar= " + ejbJarName);
        }
        return ejbJarName;
    }
}

