/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.websvcs.annotations.injection.ServiceRefPostProcessor;
import com.ibm.ws.websvcs.annotations.injection.WebServiceRefMetadata;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientServiceRefs {
    private static TraceComponent tc = Tr.register(ClientServiceRefs.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String moduleName;
    private ClassLoader classLoader;
    private Map<String, WebServiceRefMetadata> clientServiceRefMap = new HashMap<String, WebServiceRefMetadata>();
    private J2EEName j2EEName;
    private JaxWSCatalogAccessor catalogAccessor;

    public String getName() {
        return this.moduleName;
    }

    public void addServiceRefMetadata(WebServiceRefMetadata wsrMetadata) {
        ServiceRefPostProcessor.markCompleteness(wsrMetadata);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding client service reference to metadata map with name: " + wsrMetadata.getJndiName() + ", isComplete= " + String.valueOf(wsrMetadata.isMetadataComplete()));
        }
        this.clientServiceRefMap.put(wsrMetadata.getJndiName(), wsrMetadata);
    }

    public WebServiceRefMetadata getServiceRefMetadata(String serviceRefName) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting client service reference to metadata map with name: " + serviceRefName);
        }
        return this.clientServiceRefMap.get(serviceRefName);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean hasIncompleteRefs() {
        return !this.getIncompleteRefs().isEmpty();
    }

    public Map<String, WebServiceRefMetadata> getIncompleteRefs() {
        HashMap<String, WebServiceRefMetadata> incompleteRefMap = new HashMap<String, WebServiceRefMetadata>();
        for (String key : this.clientServiceRefMap.keySet()) {
            WebServiceRefMetadata wsrMetadata = this.clientServiceRefMap.get(key);
            if (wsrMetadata.isMetadataComplete()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found incomplete WebServiceRefMetadata with name: " + key);
            }
            incompleteRefMap.put(key, wsrMetadata);
        }
        return incompleteRefMap;
    }

    public void setIncompleteRefs(Map<String, WebServiceRefMetadata> incompleteRefs) {
        this.clientServiceRefMap.putAll(incompleteRefs);
    }

    public J2EEName getJ2EEName() {
        return this.j2EEName;
    }

    public void setJ2EEName(J2EEName name) {
        this.j2EEName = name;
    }

    public void putAll(Map<String, WebServiceRefMetadata> wsrMetadataMap) {
        this.clientServiceRefMap.putAll(wsrMetadataMap);
    }

    public Map<String, WebServiceRefMetadata> getAllServiceRefs() {
        return this.clientServiceRefMap;
    }

    public JaxWSCatalogAccessor getCatalogAccessor() {
        return this.catalogAccessor;
    }

    public void setCatalogAccessor(JaxWSCatalogAccessor catalogAccessor) {
        this.catalogAccessor = catalogAccessor;
    }
}

