/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.dispatcher;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;

public class PortComponentBasedDispatcher
extends AbstractDispatcher {
    private static final TraceComponent _tc = Tr.register(PortComponentBasedDispatcher.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private final String dispatcherName = "PortComponentBasedDispatcher";

    public AxisService findService(MessageContext mc) throws AxisFault {
        if (mc.getAxisService() != null) {
            return mc.getAxisService();
        }
        String targetService = null;
        targetService = (String)mc.getProperty("targetService");
        if (targetService == null || targetService.length() == 0) {
            return null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "targetService : " + targetService);
        }
        AxisService service = null;
        Map jmsServiceMap = (Map)mc.getConfigurationContext().getProperty("com.ibm.ws.websvcs.JMS_SERVICES_MAPPINGS");
        if (jmsServiceMap != null && (service = (AxisService)jmsServiceMap.get(targetService)) != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found AxisService (cache): " + service.getName());
            }
            return service;
        }
        AxisConfiguration ac = mc.getConfigurationContext().getAxisConfiguration();
        Iterator svcGrpIter = ac.getServiceGroups();
        if (svcGrpIter != null) {
            if (_tc.isDebugEnabled() && !svcGrpIter.hasNext()) {
                Tr.debug(_tc, "No svcGrpIter");
            }
            while (svcGrpIter.hasNext()) {
                AxisServiceGroup svcGroup = (AxisServiceGroup)svcGrpIter.next();
                Iterator svcIter = svcGroup.getServices();
                if (svcIter != null) {
                    if (_tc.isDebugEnabled() && !svcIter.hasNext()) {
                        Tr.debug(_tc, "No svcIter");
                    }
                    while (svcIter.hasNext()) {
                        service = (AxisService)svcIter.next();
                        if (service != null) {
                            String portName = Axis2Utils.getPortComponentName(service);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "AxisService : " + service + " for portName: " + portName);
                            }
                            if (portName == null || !portName.equals(targetService)) continue;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Found AxisService: " + service.getName());
                            }
                            return service;
                        }
                        if (!_tc.isDebugEnabled()) continue;
                        Tr.debug(_tc, "AxisService is null");
                    }
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "svcIter is null");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "svcGrpIter is null");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "PortComponentBasedDispatcher didn't find matching AxisService...");
        }
        return null;
    }

    public AxisOperation findOperation(AxisService arg0, MessageContext arg1) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription("PortComponentBasedDispatcher"));
    }
}

