/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.ServiceRefWSDLInfo;
import com.ibm.ws.websvcs.desc.WSClientEndpointDescriptorDBC;
import com.ibm.ws.websvcs.desc.WSClientEndpointDescriptorImpl;
import com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl;
import com.ibm.wsspi.websvcs.desc.ServiceRefInfo;
import com.ibm.wsspi.websvcs.desc.WSClientEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientServiceDescriptor;
import com.ibm.wsspi.websvcs.desc.WSClientType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSClientServiceDescriptorImpl
implements WSClientServiceDescriptor {
    private ServiceRefWSDLInfo wsdlInfo = null;
    private DescriptionBuilderComposite dbc;
    private Map<String, DescriptionBuilderComposite> dbcMap;
    private ServiceRefInfo srInfo;
    private WSModuleDescriptorImpl parent = null;
    private List<WSClientEndpointDescriptor> clientEndpoints;
    private boolean clientEndpointsBuilt;

    WSClientServiceDescriptorImpl(ServiceRefWSDLInfo srwi, ServiceRefInfo srInfo, DescriptionBuilderComposite dbc, Map<String, DescriptionBuilderComposite> dbcMap, WSModuleDescriptorImpl modDesc) {
        this.wsdlInfo = srwi;
        this.dbc = dbc;
        this.dbcMap = dbcMap;
        this.clientEndpoints = new ArrayList<WSClientEndpointDescriptor>();
        this.clientEndpointsBuilt = false;
        this.srInfo = srInfo;
        this.parent = modDesc;
    }

    @Override
    public QName getQName() {
        return this.wsdlInfo.getServiceQName();
    }

    @Override
    public Iterator getEndpoints() {
        this.buildEndpoints();
        return this.clientEndpoints.iterator();
    }

    private void buildEndpoints() {
        if (!this.clientEndpointsBuilt) {
            Service wsdlService = null;
            if (this.wsdlInfo.getServiceQName() != null) {
                wsdlService = this.wsdlInfo.getService();
            }
            if (wsdlService != null) {
                Map portMap = wsdlService.getPorts();
                if (portMap != null && !portMap.isEmpty()) {
                    for (Port port : portMap.values()) {
                        WSClientEndpointDescriptorImpl clientDesc = new WSClientEndpointDescriptorImpl(port);
                        this.clientEndpoints.add(clientDesc);
                    }
                }
            } else {
                List<MethodDescriptionComposite> mdcList = this.dbc.getMethodDescriptionsList();
                if (mdcList != null) {
                    for (MethodDescriptionComposite mdc : mdcList) {
                        String returnType = mdc.getReturnType();
                        DescriptionBuilderComposite seiDBC = this.dbcMap.get(returnType);
                        if (seiDBC == null || seiDBC.getWebServiceAnnot() == null || !seiDBC.isInterface()) continue;
                        WebServiceAnnot wsAnnot = seiDBC.getWebServiceAnnot();
                        String portName = mdc.getWebEndpointAnnot() != null ? mdc.getWebEndpointAnnot().name() : null;
                        WSClientEndpointDescriptorDBC clientDesc = new WSClientEndpointDescriptorDBC(seiDBC, portName);
                        this.clientEndpoints.add(clientDesc);
                        if (this.wsdlInfo.getServiceQName() != null || wsAnnot.targetNamespace() == null || wsAnnot.targetNamespace().length() <= 0 || wsAnnot.serviceName() == null || wsAnnot.serviceName().length() <= 0) continue;
                        QName t = new QName(wsAnnot.targetNamespace(), wsAnnot.serviceName());
                        this.wsdlInfo.setServiceQName(t);
                    }
                }
            }
            this.clientEndpointsBuilt = true;
        }
    }

    @Override
    public WSClientType getClientType() {
        return WSClientType.JAX_WS;
    }

    @Override
    public boolean isServiceRef() {
        return false;
    }

    @Override
    public ServiceRefInfo getServiceRefInfo() {
        return this.srInfo;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

