/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

public class ServiceRefWSDLInfo {
    private String wsdlLocation = null;
    private boolean resolveWSDL = false;
    private QName wsdlServiceQName = null;
    private WSModuleDescriptorImpl parent = null;
    private Service wsdlService = null;
    private WSDLLocator wsdlLocator = null;
    private WSDLReader wsdlReader = null;
    private Definition def = null;
    private static final TraceComponent _tc = Tr.register(ServiceRefWSDLInfo.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public ServiceRefWSDLInfo(String wsdlURI, boolean resolve, QName serviceQName, WSModuleDescriptorImpl modDesc) {
        this.wsdlLocation = wsdlURI;
        this.resolveWSDL = resolve;
        this.wsdlServiceQName = serviceQName;
        this.parent = modDesc;
    }

    public synchronized Service getService() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getService= " + this.parent.getModuleName());
        }
        if (this.wsdlService == null) {
            this.def = this.getWSDLDef();
            if (this.def != null) {
                this.wsdlService = this.def.getService(this.wsdlServiceQName);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getService= " + this.parent.getModuleName());
        }
        return this.wsdlService;
    }

    private synchronized Definition getWSDLDef() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getWSDLDef: module name=" + this.parent.getModuleName());
        }
        try {
            if (this.wsdlLocation != null) {
                if (this.wsdlReader == null) {
                    this.wsdlReader = this.parent.getWSDLReader();
                }
                if (this.wsdlLocator == null) {
                    this.wsdlLocator = this.parent.getWsdlLocator(this.wsdlLocation, this.resolveWSDL);
                }
                if (this.def == null && this.wsdlLocator != null && this.wsdlReader != null) {
                    this.def = this.wsdlReader.readWSDL(this.wsdlLocator);
                    if (this.def == null && _tc.isDebugEnabled()) {
                        Tr.debug(_tc, "WSDL Definition could not be loaded ");
                    }
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getWSDLDef: wsdlLocation is null, bypassing WSDL loading...");
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.desc.ServiceRefWSDLInfo.getWSDLDef", "84", this);
            Tr.error(_tc, "GetWSDLDef: An error was encountered attempting to read the wsdl for the module " + this.parent.getModuleName());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWSDLDef: module name=" + this.parent.getModuleName());
        }
        return this.def;
    }

    public QName getServiceQName() {
        return this.wsdlServiceQName;
    }

    public void setServiceQName(QName svcName) {
        this.wsdlServiceQName = svcName;
    }
}

